      page  55,120
Comment!
***********************************************************************
* TSR PROGRAM TO PUT CLOCK ON THE SCREEN--By Donald G. Davis, Denver, CO
***********************************************************************
* For full description, see accompanying CLOCK.DOC
***********************************************************************
This file was written with tabs 6 spaces long; it is best read in that mode.
Variables are in the lower part of the resident code so the first part will
be unvarying and can be used as the program's signature for installation
testing.
!
.186	;The code includes an instruction valid only on 186 or higher processor

CSEG	SEGMENT
	ASSUME	CS:CSEG,DS:CSEG

	ORG	100H	;All ".COM" programs start at address 0100H

;THIS IS THE MAIN ENTRY POINT FOR THE PROGRAM

START:	JMP	INITIALIZE	;Jump to routine that loads this program as a TSR

;Equates for shifting resident portion into Program Segment Prefix before installing
Start2 = 40h			;Final start of code (in PSP)
Repos = Start - Start2		;Distance to move code

PUNC		MACRO CHAR		;To simplify putting punctuation in displays
		MOV	AL,CHAR	;Output punctuation character
		CALL	KHAND
		ENDM

;The following code (ending in IRET) is executed 18 times per second by the
; timer-tick interrupt to display the time and/or date and sound the alarm
; notes, subject to the user's flagging by hotkeys or command-line switches.
; The change of the second is monitored so that the display updates only once
; per second (reducing the number of copies that may move down the screen
; when text is scrolled).

INT_1CH:		;Output time/date/sounds under timer-tick interrupt
	PUSHF		;Save CPU flags for INT 1CH call (NO matching POPF)!
	CALL	DWORD PTR CS:TIMEVEC ;Call old INT 1CH handler (so other progs. may use it)
	PUSHA		;Save all general registers

	TEST	BYTE PTR CS:FLAGBYTE,64	;Was Windows-DOS-enhanced version loaded?
	JZ	N2		;If not, don't try to call related code
	CALL	WIN		;Running in Windows DOS session higher than VM ID=2?
	ADD	BYTE PTR CS:ATTRIB1,BL	;Change background color attribute

N2:	CALL	HOTKEYS	;Check whether display/sound flags toggled by hotkeys
	CALL	TIMEDATE	;Get time parameters & output time and/or date to screen
	CALL	SOUND		;Play notes if any in buffer

	TEST	BYTE PTR CS:FLAGBYTE,64	;Was Windows-DOS-enhanced version loaded?
	JZ	N3		;If not, don't try to call related code
	CALL	WIN		;Running in Windows DOS session higher than VM ID=2?
	SUB	BYTE PTR CS:ATTRIB1,BL	;Restore background color attribute

N3:	POPA		;Restore general registers
	IRET		;Return from interrupt

;The following routine tests bits in the BIOS keyboard shift-status byte to
; see whether specified combinations of Shift/Alt/Ctrl are being pressed at
; the same time.  If so, the displays or sounds are toggled on/off.

HOTKEYS:
	MOV	AH,2		;Select Get-Shift-Status function
	INT	16H

	TEST	AL,10H	;Scroll Lock on?
	JNZ	NKEY		;If so, exit without acting on hotkeys

	MOV	AH,BYTE PTR CS:SHIFCHEK	;Recover previous shift status
	MOV	BYTE PTR CS:SHIFCHEK,AL	;Save present shift status byte
	CMP	AH,AL		;Has the shift status byte changed?
	JE	NKEY		;If not, exit without looking for hotkeys

	PUSH	AX
	AND	AL,101B
	CMP	AL,101B	;Ctrl and Right Shift both pressed?
	POP	AX
	JNE	TEST2
DIS1:	XOR	BYTE PTR CS:FLAGBYTE,1	;If so, toggle flag to start/stop
	TEST	BYTE PTR CS:FLAGBYTE,1	; TSR time routine
	JZ	NKEY
	CALL	CURSHIFT		;Save foreground cursor & set TSR cursor
	PUSHA
	MOV	BL,BYTE PTR CS:ATTRIB1 ;Set color attribute for blanking display window
	MOV	CX,10		;Number of times to output space
	TEST	BYTE PTR CS:FLAGBYTE,4	;Was 24-hour time in effect?
	JZ	ER		;If not, write 10 spaces
	SUB	CL,2		;If so, write 2 less
ER:	CALL	ERASE		;Blank clock or date areas if turned off
	POPA
	CALL	CURESTOR
	RET
TEST2:
	PUSH	AX
	AND	AL,110B
	CMP	AL,110B	;Ctrl and Left Shift both pressed?
	POP	AX
	JNE	TEST3
DIS2:	XOR	BYTE PTR CS:FLAGBYTE,2	;If so, toggle flag to start/stop
	TEST	BYTE PTR CS:FLAGBYTE,2	; TSR date routine
	JNZ	NKEY
	CALL	CURSAVE		;Save cursor of foreground application
	PUSHA
	XOR	DX,DX			;Set cursor row & column to zero
	CALL	CUR
	MOV	BL,BYTE PTR CS:ATTRIB3
	MOV	CX,14		;Number of times to output space
	CALL	ERASE		;Blank clock or date areas if turned off
	POPA
	CALL	CURESTOR
NKEY:	RET

TEST3:
	PUSH	AX
	AND	AL,1001B
	CMP	AL,1001B	;Alt and Right Shift both pressed?
	POP	AX
	JNE	TEST4
	XOR	BYTE PTR CS:FLAGBYTE,8	;If so, toggle flag to make/silence sounds
	CALL	CURSAVE
SMSG:	PUSHA
	MOV	DX,61
	CALL	CUR		;Set cursor position for message
	MOV	SI,OFFSET CS:SOUNDMSG	;Point SI to "SOUND" message address
	CALL	CHAROUT	;Print message to screen
	INC	SI		;Move pointer past delimiting zero in "SOUND" text
	TEST	BYTE PTR CS:FLAGBYTE,8	;Check if sounds enabled...
	JZ	ALON		;If so, finish message with " ON "
	ADD	SI,6		;If not, move pointer to " OFF" text
ALON:	CALL	CHAROUT	;Display " ON " or " OFF"
	POPA
	CALL	CURESTOR	;Restore cursor of foreground application
	RET
TEST4:
	AND	AL,1010B
	CMP	AL,1010B	;Alt and Left Shift both pressed?
	JNE	NKEY
	CALL	CURSHIFT	;Save foreground cursor & set TSR cursor
	PUSHA
	MOV	BL,BYTE PTR CS:ATTRIB1
	MOV	CX,2		;Number of times to output space
	CALL	ERASE		;Blank clock or date areas if turned off
	POPA
	CALL	CURESTOR
	XOR	BYTE PTR CS:FLAGBYTE,4	;If so, toggle flag to select 12/24-hour time
	RET

;The following code displays the time & date if the hotkey routine has not
; told it not to, after calling the subroutine that sets the notes for the
; sound routine.

TIMEDATE:
	CALL	CURSHIFT	;Get foreground cursor settings & set TSR cursor
	PUSH	BX
	PUSH	CX
	PUSH	DX

	MOV	AH,02H	;Call BIOS time-of-day function
	INT	1AH
	MOV	AH,BYTE PTR CS:TIMCHEK	;Recover previous second
	MOV	BYTE PTR CS:TIMCHEK,DH	;Save present second

	PUSHA
	CALL	NOTES		;Define notes and put in buffer
	POPA

	CMP	DH,AH 	;Has second changed?
	JNE	CONT		;If so, prepare to display time and/or date
	JMP	SKIP 		;If second unchanged, don't update time or date display

CONT:	TEST	BYTE PTR CS:FLAGBYTE,32	;Is display in graphics modes enabled?
	JZ	TIME		;If so, prepare to output time to screen
	CALL	VID		;If not, determine current video mode
	JL	TIME		;If AL less than 4, text mode; prepare to display time
	JMP	SKIP		;If AL = 4 or more, graphics mode; return without output

TIME:	TEST	BYTE PTR CS:FLAGBYTE,1	;Is time display enabled?
	JNZ	DATE		;If not, prepare to display date

	MOV	BL,BYTE PTR CS:ATTRIB1	;Load BL with time display attribute
	MOV	AL,CH		;Load AL with hour value (must be in AL for DAS manipulation)
	TEST	BYTE PTR CS:FLAGBYTE,4	;12-hour time selected?
	JNZ	OVER		;If not, skip 12-hour computations
	CMP	AL,12H	;Is the hour 12? 
	JL	AM		;If less, handle morning case
	MOV	BH,"P" 	;Put ASCII code for P in BH
	JE	OVER		;If hour 12, skip resetting to 12-hour mode
	SUB	AL,12H	;Reset by subtracting 12H from higher hour
	DAS			; and do "decimal adjust" to restore to BCD format
	JMP	SHORT	OVER	;Proceed to output characters
AM:	MOV	BH,"A"	;Put ASCII code for A in BH
	CMP	AL,0		;Is the hour zero?
	JNE	OVER		;If not, don't reset
	ADD	AL,12H	;Reset to 12
OVER:	CMP	AL,10		;Is it a double-digit hour?
	JGE	BYT1		;If not, precede with leading space
	PUSH	AX		;Save hour value
	PUNC	" "		;Output space
	POP	AX		;Restore hour value
	CALL	NIBBLEOUT	;Output BCD 1-digit hour value as decimal digits
	JMP	SHORT	COLN
BYT1:	CALL	BYTEOUT	;Output BCD 2-digit hour value to decimal digits
COLN:	PUNC	":"		;Output colon
	MOV	AL,CL 	;Load AL with minute value
	CALL	BYTEOUT	;Output BCD minute value as decimal digits
	PUNC	":"		;Output second colon
	MOV	AL,DH 	;Load AL with second value
	CALL	BYTEOUT	;Output BCD second value as decimal digits
	TEST	BYTE PTR CS:FLAGBYTE,4	;24-hour time selected?
	JNZ	DATE		;If so, skip space & "A" or "P"
	PUNC	" "		;Output space
	MOV	AL,BH 	;Output either A or P after space
	CALL	KHAND

DATE:	TEST	BYTE PTR CS:FLAGBYTE,2	;Is date hotkey flag set?
	JZ	SKIP		;If not, return without output

	MOV	AH,04H	;Call BIOS date function
	INT	1AH
	MOV	AL,BYTE PTR CS:DATCHEK	;Get previous date (initialized on startup)
	MOV	BYTE PTR CS:DATCHEK,DL	;Save present date
	CMP	AL,DL				;Has date changed?
	JE	PRINT				;If not, output date to screen
	INC	BYTE PTR CS:WEEKDAY	;If so, increment the weekday number
	CMP	BYTE PTR CS:WEEKDAY,7	;Week gone beyond Saturday?
	JL	PRINT				;If not, output date to screen
	SUB	BYTE PTR CS:WEEKDAY,7	;Reset to Sunday
PRINT:
	PUSH	CX
	PUSH	DX
	XOR	DX,DX		;Set cursor row & column to zero
	CALL	CUR
	MOV	SI,OFFSET CS:DAY	;Point SI to first day-of-week text address
	MOV	AX,4	;Multiplier to match weekday to offset of corresponding text
	MUL	BYTE PTR CS:WEEKDAY	;Leave 4 times weekday number in AL
	ADD	SI,AX		;Adjust SI 4 bytes lower for each day's text beyond Sun.
	MOV	BL,BYTE PTR CS:ATTRIB3	;Load BL with date display attribute
	CALL	CHAR		;Print text to screen
	PUNC	" "		;Display following space
	POP	DX
	POP	CX

	MOV	AL,DH		;Load AL with month value
	CALL	DCHK		;Suppress leading zero if single digit
	MOV	AL,DL		;Load AL with day value
	CALL	DCHK		;Suppress leading zero if single digit
	MOV	AL,CH		;Load AL with century value
	CALL	BYTEOUT	;Output BCD century value as decimal digits
	MOV	AL,CL 	;Load AL with year value
	CALL	BYTEOUT	;Output BCD year value as decimal digits
SKIP:	POP	DX		;Restore foreground cursor settings
	POP	CX
	POP	BX
	CALL	CURESTOR
	RET

DCHK:	CMP	AL,10		;Is it a double-digit month or day?
	JGE	BYTE1		;If so, output two digits
	CALL	NIBBLEOUT	;If not, output one
	JMP	SHORT	HYPHEN1
BYTE1:
	CALL	BYTEOUT	;Output BCD month value as decimal digits
HYPHEN1:
	PUNC	"-"		;Output hyphen
	RET

;SCREEN OUTPUT: for calls to CHAROUT, color attribute is specified by starting
; byte of text message pointed to by SI; for CHAR/NIBBLEOUT/BYTEOUT/KHAND, 
; by BL register.

;The following two routines output decimal numbers from binary-coded
; decimal input from AL, with a leading zero if under 10 and BYTEOUT
; is called, or without a leading zero if NIBBLEOUT is called.
; They were furnished me by Larry Fish of Denver, CO.

NIBBLEOUT:
		AND	AL,0FH
		OR	AL,30H
		CALL	KHAND
		RET
BYTEOUT:	PUSH	AX
		PUSH	CX
		MOV	CL,4
		SHR	AL,CL
		CALL	NIBBLEOUT
		POP	CX
		POP	AX
		CALL	NIBBLEOUT
		RET

CHAROUT:
	MOV	BL,CS:[SI] 	;Move attribute byte of message string into BL
LOOP1:
	INC	SI		;Point SI to next byte of message string
CHAR:	MOV	AL,CS:[SI]	;Move character into AL
	CMP	AL,0		;Reached delimiting zero at end of string?
	JE	DONE		;If so, return
	CALL	KHAND		;Output character to screen
	JMP	LOOP1		;Loop until finished
DONE: RET

;KHAND char. output: AL must contain char. to write; BL must contain attribute
KHAND:	PUSHA		;Save codes in calling routine
		CALL	VID	;Determine current video page
		MOV	CX,1	;Load CX with number of times to write character
		MOV	AH,9	;Select BIOS video write-char.-&-attrib. function
		INT	10H	;Write character w/selected attribute
		MOV	AH,3	;Select BIOS read-cursor-position function
		INT	10H	;Read it
		INC	DX	;Prepare to move cursor one column right
		MOV	AH,2	;Select BIOS set-cursor-position function
		INT	10H	;Move it
		POPA
		RET

ERASE:	MOV	AL," "	;Load ASCII code for space
BLANK:	CALL	KHAND
		LOOP	BLANK		;(Number of loops previously put in CX)
		RET

CUR:		MOV	AH,1		;Set cursor size to zero
		MOV	CH,20H	; by using this value in CH
		INT	10H
		CALL	VID		;Determine current video page
		MOV	AH,2		;Select set-cursor-position function
		INT	10H		;Set cursor to position previously specified in DX
		RET

;Calls to CURSAVE should be followed by PUSH BX, CX, DX to preserve the cursor
; values if these registers will be changed by the code following the call
CURSAVE:	CALL	VID		;Determine current video page
		MOV	AH,3		;Select read-cursor-position function
		INT	10H
		RET

;Calls to CURESTOR should be preceded by POP DX, CX, BX to restore the cursor
; values if these registers have been changed by the code preceding the call
CURESTOR:	MOV	AH,2
		INT	10H
		MOV	AH,1
		INT	10H
		RET

;Calls to CURSHIFT should be followed by PUSH BX, CX, DX to preserve the cursor
; values if these registers will be changed by the code following the call
CURSHIFT:	CALL	CURSAVE	;Save cursor of foreground application
		PUSHA			;Store cursor settings
		MOV	DX,70		;Set cursor row at 0 and column at 70
		TEST	BYTE PTR CS:FLAGBYTE,4	;24-hour time in effect?
		JZ	CURSET
		ADD	DL,2		;If so, start clock 2 spaces later
CURSET:	CALL	CUR		;Set new cursor position & make it invisible
		POPA			;Recover cursor settings
		RET

VID:		PUSH	AX
		MOV	AH,0FH	;Select get-current-video-mode function
		INT	10H		; to determine current video mode & page
		CMP	AL,4		;Video mode 4 or more? (used only after some calls)
		POP	AX
		RET

;ROUTINES TO GENERATE SOUNDS IN AN INTERRUPT DRIVEN ENVIRONMENT.
; All sounds are stored in the buffer using PUTSND.
; (Sections with capitalized comments from Larry Fish)

PORTB		EQU	61H	;B PORT
COMREG	EQU	43H	;COMMAND REGISTER
LATCH2	EQU	42H	;DATA LATCH

TIMCNT	DW	0	;COUNTER USED TO TIME BEEPS

NOTES:
	TEST	BYTE PTR CS:FLAGBYTE,8	;Is sound-disabling flag set?
	JZ	TIMES
	RET			;If so, return without sounding
TIMES:
	CMP	CL,0		;Is the minute zero?
	JE	TEST_A	;If so, see whether to sound on the hour
	CMP	CL,30H	;(The BCD min. is only found correctly as hex)
	JE	TEST_A	;...or the half hour
	JMP	SHORT	NONE	;If minute not zero or 30, skip sounds
TEST_A:
	CMP	DH,0		;Is second zero?
	JNE	NONE		;If not, skip sounds
	TEST	BYTE PTR CS:FLAGBYTE,16 ;Have notes already sounded during
	JZ	RING				; this second?
	RET			;If so, don't let it sound again

;Define sounds and put in buffer
RING:	MOV	DX,4		;4/18 SECOND time to sound or pause
	CMP	CL,0		;Is it the hour?
	MOV	CX,2		;Time no more than two sound loops
AGAIN:
	PUSHF			;Save zero flag setting from above CMP
	MOV	AX,1		;TURN ON SPEAKER
	MOV	BX,19000/14	;SET FREQUENCY
	CALL	PUTSND	;SOUND NOTE

	MOV	BX,19000/11	;SET FREQUENCY
	CALL	PUTSND	;SOUND NOTE

	SUB	AL,AL		;TURN OFF SPEAKER
	CALL	PUTSND	;PAUSE
	POPF			;Restore zero flag setting from above CMP
	LOOPE	AGAIN		;Repeat only on hour, not half hour

	XOR	BYTE PTR CS:FLAGBYTE,16	;Toggle flag to stop reexecuting NOTES routine
	RET
NONE: TEST	BYTE PTR CS:FLAGBYTE,16 ;When sound's run once and switched the FLAGBYTE
	JZ	MUTE		; bit 3, toggle it only if coming from next second
	XOR	BYTE PTR CS:FLAGBYTE,16 ;When sec.'s changed after sound, switch 
MUTE: RET			; flag back to enable the sounds for the next time

;SOUND SERVICE ROUTINE, MUST BE CALLED ON EVERY CLOCK TICK

SOUND:
	CMP	WORD PTR CS:TIMCNT,0	;SOUND STILL ON?
	JNZ	SNDCNT		; THEN COUNT THE TIME REMAINING

;GET THE CURRENT PENDING SOUND FROM THE BUFFER
;CARRY FLAG WILL BE SET IF NO PENDING SOUNDS
; AX=VOLUME, BX=FREQUENCY AND DX=LENGTH

	MOV	SI,WORD PTR CS:SNIRED	;GET READ POINTER
	CMP	SI,WORD PTR CS:SNIWRT	;READ=WRITE IF EMPTY
	JE	SNDEXT		;Exit if no more to read
	SHL	SI,1		;TIMES TWO, BECAUSE TWO BYTES PER ENTRY
	MOV	AX,WORD PTR CS:VOLBUF[SI]	;READ VOLUME
	MOV	BX,WORD PTR CS:FRQBUF[SI]	;READ FREQUENCY
	MOV	DX,WORD PTR CS:LENBUF[SI]	;READ LENGTH
	INC	WORD PTR CS:SNIRED		;ADVANCE POINTER
	CMP	WORD PTR CS:SNIRED,SNDSIZ	;WRAP AROUND?
	JNE	SNIN2		;SKIP IF NOT
	MOV	WORD PTR CS:SNIRED,0	;START OVER

;Start a sound, assumes AX=VOLUME, BX=FREQUENCY AND DX=LENGTH

SNIN2:
	MOV	WORD PTR CS:TIMCNT,DX	;SET SOUND LENGTH
	CMP	AL,0			;IS TONE ON OR OFF?
	JE	SNDEXT		;THEN DELAY, WITHOUT SOUND

	IN	AL,PORTB		;GET PORT VALUE
	OR	AL,03H		;ENABLE SPEAKER AND TIMER
	OUT	PORTB,AL
	MOV	AL,0B6H		;SET CHANNEL-2 FOR MODE 3
	OUT	COMREG,AL

	MOV	AX,BX			;SET FREQUENCY
	OUT	LATCH2,AL
	MOV	AL,AH
	OUT	LATCH2,AL
SNDEXT:	RET

;DECREMENT SOUND COUNT AND TURN OFF SPEAKER WHEN DONE

SNDCNT:	DEC	WORD PTR CS:TIMCNT	;COUNT CLOCK TICKS
	JNZ	SNDCT1		;EXIT IF NOT DONE

;TURN OFF SPEAKER
	IN	AL,PORTB		;GET CURRENT VALUE
	AND	AL,0FCH		;TURN OFF SPEAKER
	OUT	PORTB,AL
SNDCT1:	RET

; SOUND BUFFER ROUTINES: Pending beep information is
; stored in the buffer. Each beep is taken out of the
; buffer one-at-a-time and played. The buffer is a
; "circular" buffer so it cannot overflow.

SNDSIZ	EQU	7		;SIZE OF BUFFER

VOLBUF	DW SNDSIZ DUP(?)	;BUFFER OF VOLUMES
FRQBUF	DW SNDSIZ DUP(?)	;BUFFER OF FREQUENCIES
LENBUF	DW SNDSIZ DUP(?)	;BUFFER OF LENGTHS

SNIRED	DW	0		;READ POINTER
SNIWRT	DW	0		;WRITE POINTER
SNISTR	DW	0		;START POINTER

;PUT A SOUND IN THE BUFFER FOR PLAYING
; AX=VOLUME, BX=FREQUENCY AND DX=LENGTH
; VOLUME = 0 = No sound, Other = Sound
; The frequency is 1.19 million / FREQUENCY
; The length of the sound is LENGTH/18.2 in seconds

PUTSND:	MOV	SI,WORD PTR CS:SNIWRT	;GET WRITE POINTER
	SHL	SI,1		;TIMES TWO, BECAUSE TWO BYTE PER ENTRY
	MOV WORD PTR CS:VOLBUF[SI],AX	;STORE VOLUME
	MOV WORD PTR CS:FRQBUF[SI],BX	;STORE FREQUENCY
	MOV WORD PTR CS:LENBUF[SI],DX	;STORE LENGTH
	CALL	INCWRT		;INCREMENT WRITE POINTER
	RET

;ROUTINE TO INCREMENT WRITE POINTER AND HANDLE WRAP AROUND
;AND COLLISIONS

INCWRT:	INC	WORD PTR CS:SNIWRT	;INCREMENT WRITE POINTER
	CMP	WORD PTR CS:SNIWRT,SNDSIZ	;WRAP AROUND?
	JB	INCWT1					;SKIP IF NOT
	MOV	WORD PTR CS:SNIWRT,0		;THEN START OVER

INCWT1:	MOV	SI,WORD PTR CS:SNIWRT	;CAUGHT START POINTER?
	CMP	SI,WORD PTR CS:SNISTR
	JNE	INCWT2					;SKIP IF NOT

	INC	WORD PTR CS:SNISTR		;INCREMENT START POINTER
	CMP	WORD PTR CS:SNISTR,SNDSIZ	;WRAP AROUND?
	JB	INCWT2					;SKIP IF NOT
	MOV	WORD PTR CS:SNISTR,0		;START OVER

INCWT2:	CMP	SI,WORD PTR CS:SNIRED	;CAUGHT READ POINTER?
	JNE	INCWT3					;SKIP IF NOT

	INC	WORD PTR CS:SNIRED		;INCREMENT READ POINTER
	CMP	WORD PTR CS:SNIRED,SNDSIZ	;WRAP AROUND?
	JB	INCWT3					;SKIP IF NOT
	MOV	WORD PTR CS:SNIRED,0		;START OVER
INCWT3:	RET

;DATA FOR RESIDENT CODE.  Since the contents of registers don't survive
; between re-executions of interrupt-driven code, any values that need to be
; preserved over more than one cycle of our interrupt handlers must be kept
; in memory variables.

TIMEVEC	DD	0	;Holds original vector address for INT 1CH
FLAGBYTE	DB	0	;Byte composed of bits used to control certain operations
	; bit 0--the time hotkey toggle flag (test with 1)
	; bit	1--the date hotkey toggle flag (test with 2)
	; bit 2--the 24/12-hour format flag (test with 4)
	; bit 3--the sound hotkey flag (test with 8)
	; bit 4--flag to prevent sound from being too long (test with 16)
	; bit 5--flag to disable display in graphic modes (test with 32)
	; bit 6--flag to load version that changes color in 2nd Windows DOS box
WEEKDAY	DB	0	;Storage for current day of week
TIMCHEK	DB	0	;To save present second for time/date output control
DATCHEK	DB	0	;To save present date for day-of-week change control
SHIFCHEK	DB	0	;To save present shift state byte for hotkey operation
ATTRIB1	DB	0	;To save configurable time display color attribute
ATTRIB2	DB	0	;To save time display color attribute from last time
ATTRIB3	DB	0	;To save configurable date display color attribute
ATTRIB4	DB	0	;To save date display color attribute from last time
SOUNDMSG	DB	24H,"SOUND",0	;Storage for "SOUND" message
		DB	1CH," ON ",0	;Storage for "ON" message
		DB	62H," OFF",0	;Storage for "OFF" message
DAY	 	DB	"SUN",0,"MON",0,"TUE",0,"WED",0,"THU",0,"FRI",0,"SAT",0

ISRend1 = $ + 1	;End of resident code and data (original version)

WIN:	MOV	AX,4680H	;In Windows in real or standard mode (or DOS shell)?
	INT	2FH
	CMP	AX,0
	JE	WS		;If so, change time display color
	MOV	AX,1600H	;Windows enhanced mode running?
	INT	2FH
	CMP	AL,0		;If not, don't change time display color
	JE	W1
	CMP	AL,80H	;If not, don't change time display color
	JE	W1
WS:	MOV	AX,1683H	;Running in Windows DOS session higher than VM ID=2?
	INT	2FH
	CMP	BL,2
	JNG	W1	;If not, don't change time display color
	SUB	BL,2	;If so, and in virtual DOS machine, change background
	SHL	BL,4	; color attribute to next higher one
	RET
W1:	XOR	BL,BL
	RET

ISRend2 = $ + 1	;End of resident code and data (Win-DOS-enhanced version)

;DATA FOR TRANSIENT CODE.  Needed only for installation/removal/modification
; of resident code.

UNLOAD_MSG		DB	13,10,"CLOCK can't be uninstalled.",13,10,7
			DB	"Uninstall resident programs in reverse order.",13,10,"$"
INSTATE_MSG		DB	"NOT RESIDENT",13,10,"$"
NOT_INST_MSG	DB	13,10,"Can't uninstall CLOCK--not yet installed!",13,10,7,"$"
INSTALLED_MSG	DB	13,10,"CLOCK already installed--resetting switches and "
			DB	"parameters to new values, if any",13,10,7,"$"
ALLOCATE_MSG	DB	"Memory allocation error",13,10,7,"$"
UNINSTALL_MSG	DB	13,10,"CLOCK uninstalled",13,10,"$"
PFLAG			DB	0	;Flag whether screen output wanted
UNFLAG		DB	0	;Flag whether program is to be uninstalled
RFLAG			DB	0	;Flag whether report on resident status is wanted
CFLAG			DB	0	;Flag that a return to previous color is wanted

;Data for on/off keys message (complicated because of color changes in lines)
KEYMSG1	DB	0CH,"ͻ",0
KEYMSG2	DB	0CH,"                    ",0
KEYMSG3	DB	02H,"CLOCK on/off keys:",0
KEYMSG4	DB	0CH,"                    ",0
KEYMSG5	DB	0CH,"",0
KEYMSG6	DB	0EH," Ctrl-Right Shift, time display; Alt-Right Shift, sounds;",0
KEYMSG7	DB	0CH," ",0
KEYMSG8	DB	0CH,"",0
KEYMSG9	DB	0EH," Ctrl-Left Shift, date display; Alt-Left Shift, 12/24 hr.",0
KEYMSG10	DB	0CH," ",0
KEYMSG11	DB	0CH,"ͼ",0

MSG	DB	13,10,"Usage: CLOCK /[D] [M] [S] [T] [W] [G] [I] [C] |[R] |[U] |[?]"
 	DB	" /[n1]/[n2].",13,10,10
	DB	"D, M, S, and T change defaults of Date, 12/24 hr., Sounds, & Time displays.",13,10
	DB	"W installs a slightly larger version enhanced for Windows DOS sessions.",13,10
	DB	"G disables display in graphics modes.",13,10
	DB	"I disables installation status screen messages.",13,10
	DB	"C changes display back to color in effect before last command-line change.",13,10
	DB	"R returns exit code 0 if CLOCK not resident; 1 if resident.",13,10
	DB	"U uninstalls the program if no other TSRs have been loaded after it.",13,10
	DB	"? displays this message.",13,10,10
	DB	"n = optional color parameters between 1 and 255:",13,10
	DB	"	n1 = time display colors; n2 = date display colors.",13,10,10
	DB	"CLOCK on/off keys: Alt-Right Shift, sounds; Alt-Left Shift, 12/24 hr.;",13,10
	DB	"	Ctrl-Right Shift, time display; Ctrl-Left Shift, date display.",13,10
	DB	"	Scroll Lock on: disables preceding hotkey effects.",13,10,"$"

;Search memory for a copy of our code, to see if already installed.
;CS is segment address of the transient copy: if not installed, ES will end up
; equal to CS when the search ends after cycling through all of memory. If
; found installed, ES will store the segment address of the resident copy.

INITIALIZE:	ASSUME	DS:CSEG

		CALL	FIND			;Determine whether our signature's in memory

;Parse the command line for switches & parameters
PARSE:
	CLD			;Clear the direction flag (string operations forward)
	MOV	SI,81H	;Point SI to first parameter character
	CALL	WGET		;Get non-numeric parameter, if any
	CALL	NUMGET	;Process parameters into numeric value
	CALL	ADP1		;Store first parameter value and continue
	CALL	NUMGET	;Process parameters into numeric value
	CALL	ADP2		;Store second parameter value and continue
	JMP	INST		;Continue installation

;Get numeric parameter and convert to hex value
NUMGET:	JMP	SHORT	GETNUM	;Skip over data storage bytes

SIGN		DB	0		;Flag for handling negative numbers
NUMFLAG	DB	0		;Flag to record that a number's been found
TENBYT	DW	10		;Multiplier for higher-place digits

GETNUM:	LODSB			;Get first char. of command tail
		SUB	CX,CX		;Clear CX for following operations
		MOV	SIGN,0	;Clear sign flag
		MOV 	NUMFLAG,0	;Clear number-found flag
		CMP	AL,"-"	;Is parameter preceded by minus?
		JNE	INTIN2	;If not, skip negative-handling code
		NOT	SIGN		;Invert sign flag
INTIN1:	PUSH	CX		;Save accumulated value, if any yet
		LODSB			;Get past minus sign
		POP	CX		;Restore accumulated value
INTIN2:	CMP	AL,0DH	;Carriage return reached?
		JE	INTIN5	;If so, exit
		SUB	AL,"0"	;See if char.'s a number & convert to hex value
		JL	INTIN4	;If result negative, not number; try again
		CMP	AL,10		;If result 10 or more, not number;
		JGE	INTIN4	; try for a no. again
		INC	NUMFLAG	;Flag that a number's been found
		SUB	AH,AH		;Clear high part of AX
		XCHG	AX,CX		;Switch no. previously found (if any) with new one
		MUL	TENBYT	;Multiply previous no. by 10
		ADD	CX,AX		;Add result in AX to new no. that's now in CX
		JMP	INTIN1	;Try for another number
INTIN4:	TEST	NUMFLAG,0FFH	;Has any number been found?
		JZ	GETNUM	;If not, start over
INTIN5:	TEST	SIGN,0FFH	;Is number negative?
		JZ	INTIN3	;If not, leave alone
		NEG	CX		;If so, change to corresponding negative value
INTIN3:	MOV	AX,CX		;Store final result in AX
		DEC	SI		;Put back inside CR in case non-num. param. sought
		RET

WGET: LODSB			;Get first command-tail character
	CMP	AL,20H	;Is it a space?
	JE	WGET		;If so, loop back to check next character
	CMP	AL,09H	;Is it a tab?
	JE	WGET		;If so, loop back to check next character
	CMP	AL,"/"	;Is it a slash?
	JE	WGET		;If so, loop back to check next character
	CMP	AL,","	;Is it a comma?
	JE	WGET		;If so, loop back to check next character
	CMP	AL,"?"	;Is it a question mark?
	JE	ERR		;Output usage message and quit
	CMP	AL,0DH	;Is this the end of the line?
	JE	D9		;If so, no non-numeric switches; continue
	AND	AL,5FH	;Capitalize character if lowercase
	CMP	AL,"S"	;Is it "S"?
	JNE	D1		;If not, go on
	XOR	FLAGBYTE,8	;If so, toggle the default sounds on/off status
	JMP	WGET		;If not, check next character...
D1:	CMP	AL,"D"	; and so on until all non-numeric parameters are found
	JNE	D2
	XOR	FLAGBYTE,2	;Toggle the default date display on/off status
	JMP	WGET
D2:	CMP	AL,"M"
	JNE	D3
	XOR	FLAGBYTE,4	;Toggle the default 12/24 hour display status
	JMP	WGET
D3:	CMP	AL,"T"
	JNE	D4
	XOR	FLAGBYTE,1	;Toggle the default time display on/off status
	JMP	WGET
D4:	CMP	AL,"G"
	JNE	D5
	XOR	FLAGBYTE,32 ;Toggle the default display in text & graphics modes
	JMP	WGET
D5:	CMP	AL,"I"
	JNE	D6
	NOT	PFLAG		;Flag that some installation screen messages not wanted
	JMP	WGET
D6:	CMP	AL,"R"
	JNE	D7
	NOT	RFLAG		;Flag that a test for resident status is wanted
	JMP	WGET
D7:	CMP	AL,"C"
	JNE	D8
	NOT	CFLAG		;Flag that return to the previous color is wanted
	JMP	WGET
D8:	CMP	AL,"W"
	JNE	D9
	XOR	FLAGBYTE,64 ;Flag to load Windows-DOS-session-enhanced version
	JMP	WGET
D9:	CMP	AL,"U"
	JNE	D10
	NOT	UNFLAG	;Flag that program is to be uninstalled
	;JMP	WGET
D10:	DEC	SI		;Back up pointer to check for numeric parameters
	RET

ERR:	MOV	AH,9		;Print usage message
	MOV	DX,OFFSET MSG
	INT	21H
	MOV	AX,4C00H	;Terminate with errorlevel = 0
	INT	21H

ADP1: CMP	AX,255	;More than 1 byte in AX?
	JG	QU1		;If so, too high a parameter entered; error
	CMP	AX,0		;No numeric parameter found?
	JE	QU1		;If not, jump to search for next parameter
	MOV	ATTRIB1,AL	;If parameter value nonzero, store it
	RET
QU1:	MOV	ATTRIB1,4EH	;Load default intense-yellow-on-red attribute value
	RET

ADP2: CMP	AX,255	;More than 1 byte in AX?
	JG	QU2		;If so, too high a parameter entered; error
	CMP	AX,0		;No numeric parameter found?
	JE	QU2		;If not, jump to search for next parameter
	MOV	ATTRIB3,AL	;If parameter value nonzero, store it
	RET
QU2:	MOV	ATTRIB3,5EH	;Load default intense-yellow-on-magenta attribute value
	RET

INST:	CMP	UNFLAG,0		;Did command line have uninstall switch?
	JZ	INS1			;If not, continue
	JMP	UNINSTALL		;If so, try to uninstall
INS1:	MOV	AX,ES			;Are we already installed?
	MOV	BX,CS
	CMP	AX,BX			;If ES = CS, not installed; otherwise, installed 
	PUSHF				;Save installed status determination
	CMP	RFLAG,0		;Did command line ask for resident status?
	JE	INS2			;If not, decide whether to install nonresident
	POPF				; copy or update resident copy 
	JZ	NRES			;If ES & CS were equal, not resident
	MOV	DX,OFFSET INSTATE_MSG+4	;If ES & CS unequal, report RESIDENT
	CALL	PRINT_STRING	;Display message unless otherwise flagged
	MOV	AL,1			;Errorlevel = 1
	JMP	EXIT
NRES:	MOV	DX,OFFSET INSTATE_MSG	;If ES and CS equal, report NOT RESIDENT
	CALL	PRINT_STRING	;Display message unless otherwise flagged
	XOR	AL,AL			;Errorlevel = 0
	JMP	EXIT
INS2:	POPF
	JNZ	INS3
	JMP	INSTALL		;If not installed, install.
INS3:	
	AND	CS:FLAGBYTE,10111111B	;Preserve all bits but 6 in transient copy flags
	AND	ES:FLAGBYTE,01000000B	;Preserve only bit 6 in resident copy flags
	MOV	AL,CS:FLAGBYTE	;Combine them to set all flag bits except 6 in
	OR	ES:FLAGBYTE,AL	; resident copy to values in transient copy
; (so it won't crash by trying to call code in extended version if not loaded)

	CALL	DAYZ			;Refresh day of week and day of month stored when
	MOV	AL,CS:WEEKDAY	; installed, and move present values to resident
	MOV	ES:WEEKDAY,AL	; copy to correct weekday mismatch which may have
	MOV	AL,CS:DATCHEK	; occurred if user changed date by more than the
	MOV	ES:DATCHEK,AL	; normal 1-day increment

	CMP	CFLAG,0		;Switch set to return to color before last change?
	JNZ	C1			;If so, do that
	MOV	AL,ES:ATTRIB1	;If not, save time display color now in resident
	MOV	ES:ATTRIB2,AL	; copy in case we do that next time
	MOV	AL,CS:ATTRIB1	;Then replace that attribute with newly
	MOV	ES:ATTRIB1,AL	; requested one, as usual...
	MOV	AL,ES:ATTRIB3	;Then save date display color now in resident copy
	MOV	ES:ATTRIB4,AL
	MOV	AL,CS:ATTRIB3	;Then replace that attribute with newly
	MOV	ES:ATTRIB3,AL	; requested one, as usual...
	JMP	SHORT	C2		;And exit
C1:	MOV	AL,ES:ATTRIB2	;Recover the previous time attribute
	MOV	ES:ATTRIB1,AL	; and restore it to active status
	MOV	AL,ES:ATTRIB4	;Recover the previous date attribute
	MOV	ES:ATTRIB3,AL	; and restore it to active status
C2:	XOR	AL,AL			;Then set ERRORLEVEL of zero.
	MOV	DX,OFFSET INSTALLED_MSG
ERRX:	CALL	PRINT_STRING	;Display message unless otherwise flagged
EXIT:	MOV	AH,4CH		;Terminate.
	INT	21H

CURPOS	MACRO ROW,COL	;To simplify entry of cursor row/column data
		MOV	DH,ROW
		MOV	DL,COL
		ENDM
INSTALL:
	MOV	ES,DS:[2CH]	;Place environment segment addr. for DOS to read
	MOV	AH,49H	;Prepare to call DOS free-memory-block function
	INT	21H		;Call it to free environment memory block
	MOV	DX,OFFSET ALLOCATE_MSG
	MOV	AL,3		;Errorlevel = 3
	JC	ERRX		;If error, exit with message.

	CALL	SCRN		;Display multicolored hotkey message
	CALL	DAYZ		;Store day of week and day of month in variables

;Code to move resident code & data to lower memory space in Program Segment Prefix
	MOV	AX,CS			;Subtract specified no. of 16-byte
	SUB	AX,12			; paragraphs from code segment value and
	MOV	ES,AX			; make that ES value
	MOV	SI,OFFSET START	;Copy resident code to same offsets in
	MOV	DI,SI			; new lower segment
	TEST	FLAGBYTE,64		;Install larger version?
	JNZ	SIZ2			;If so, move more code
	MOV	CX,ISRend1 - Start	;Number of bytes to move--smaller version
	JMP	SHORT	MOR
SIZ2:	MOV	CX,ISRend2 - Start	;Number of bytes to move--larger version
MOR:	CLD
	REP MOVSB		;Copy code and data
	PUSH	ES		;Set DS to
	POP	DS		; new segment's value

	NOT	DS:BYTE PTR START[1]	;Change signature string so it can be
						; found in the installed (resident) copy

	MOV	AX,351CH	;Get vector of INT 1CH (returned in BX:ES)
	INT	21H
	MOV	WORD PTR DS:TIMEVEC,BX	;Save the address in 1st word (offset part)...
	MOV	WORD PTR DS:TIMEVEC[2],ES	; and 2nd word (seg. part) of variable
	MOV	DX,OFFSET INT_1CH	;Get addr. where keyboard int. handler will be
	MOV	AX,251CH	;Replace keyboard interrupt with our address
	INT	21H
	PUSH	CS
	POP	DS		;Restore original data segment

	MOV	DH,5		;Set cursor row
	MOV	DL,0		;Set cursor column
	XOR	BH,BH		;Set video page 0
	MOV	AH,2		;Select set-cursor-position function
	INT	10H

	TEST	FLAGBYTE,64	;Install larger version?
	JNZ	SIZ3		;If so, keep more code
	MOV	DX,(ISRend1-repos+15)/16	;# of paragraphs to keep--smaller v.
	JMP	SHORT	MOR1
SIZ3:	MOV	DX,(ISRend2-repos+15)/16	;# of paragraphs to keep--larger v.
MOR1:	MOV	AX,3100H	;Return error code of zero.
	INT	21H		;Terminate but stay resident.

;This subroutine uninstalls the resident program
UNINSTALL:
	MOV	CX,ES
	MOV	BX,CS
	CMP	CX,BX			;Are ES and CS segment vectors same?
	JNZ	MORE			;If not, program resident; continue
	MOV	DX,OFFSET NOT_INST_MSG	;If so, not resident; abort
	CALL	PRINT_STRING	;Display message unless otherwise flagged
	XOR	AL,AL			;Errorlevel = 0
	JMP	EXIT			;Exit because nothing to uninstall

MORE:	MOV	DX,OFFSET UNLOAD_MSG	;Error message if INT 9 changed.
	MOV	AX,351CH		;Get timer interrupt.
	INT	21H
	CMP	BX,OFFSET INT_1CH	;Has it been hooked by another?
	JNZ	UNINSTALL_END	;If yes, exit with error message.
	MOV	BX,ES
	CMP	BX,CX			;Is the segment vector same?
	JNZ	UNINSTALL_END	;If not, exit with error message.

	MOV	AL,ES:FLAGBYTE	;Set flags in transient copy to values in resident
	MOV	CS:FLAGBYTE,AL	; copy to blank time & date windows correctly
	MOV	AL,ES:ATTRIB1	;Set time display color in transient copy to value
	MOV	CS:ATTRIB1,AL	; in resident copy
	MOV	AL,ES:ATTRIB3	;Set date display color in transient copy to value
	MOV	CS:ATTRIB3,AL	; in resident copy
	CALL	DIS1			;Blank time window if time display was enabled
	CALL	DIS2			;Blank date window if date display was enabled

	PUSH	ES		;Save segment where resident copy is loaded
	MOV	AX,ES
	ADD	AX,12		;Restore ES address originally allocated
	MOV	ES,AX		; by DOS before code was copied to lower memory
	MOV	AH,49H	;Return memory to system pool.
	INT	21H
	MOV	DX,OFFSET ALLOCATE_MSG
	POP	ES		;Restore segment value needed to reset int. vector
	JC	UNINSTALL_END	;Display message if problem.
	MOV	DX,WORD PTR ES:TIMEVEC[0]	;Restore old INT 1CH.
	MOV	DS,WORD PTR ES:TIMEVEC[2]
	MOV	AX,251CH
	INT	21H

	PUSH	CS
	POP	DS			;Point to our data.
	MOV	DX,OFFSET UNINSTALL_MSG	;Prepare to display uninstall message.
	CALL	PRINT_STRING	;Display message unless otherwise flagged
	MOV	AL,1			;Errorlevel = 1
	NOT	ES:BYTE PTR START[1]	;Kill resident signature string so later
	JMP	EXIT				; search can't find a false copy in memory
UNINSTALL_END:
	CALL	PRINT_STRING	;Display message unless otherwise flagged
	MOV	AL,2			;Errorlevel = 2
	JMP	EXIT		;And exit.

PRINT_STRING:
	CMP	PFLAG,0	;Was no-screen-output switch in command line?
	JNE	NO_SHOW	;If so, don't print message to screen
PRINT_STRING_1:			;Display message
	MOV	AH,9		;Print string via DOS.
	INT	21H
NO_SHOW:	RET

DAYZ:	MOV	AH,2AH	;Call DOS date function (because no day-of-week
	INT	21H		; function in BIOS which is used in resident code)
	MOV	WEEKDAY,AL	;Store day of week in variable
	MOV	AH,04H	;Call BIOS date function
	INT	1AH		; (for compatibility with resident code)
	MOV	DATCHEK,DL	;Store day of month in variable

	RET

SCRN:	CMP	PFLAG,0	;Was no-screen-output switch in command line?
	JE	SCR1		;If not, print message to screen
	RET			;If so, skip message
SCR1:	MOV	AH,6			;Clear screen with scroll up function
	XOR	AL,AL
	XOR	CX,CX			;Set upper left corner of scroll window to zero
	MOV	DH, 63		;Set lower row to maximum possible text mode row
	MOV	DL,132		;Set right column to max. possible text mode col.
	MOV	BH,7			;Set blank line attribute to black
	INT	10H			;Clear screen
	CALL	CURSAVE		;Save cursor of foreground application
	PUSHA				;Store cursor values
	CURPOS	0,0		;Use macro to specify new cursor row & column
	CALL	CUR			;Set cursor position for message
	MOV	SI,OFFSET KEYMSG1	;Point SI to part of on/off keys message address
	CALL	CHAROUT		;Print message to screen
	CURPOS	1,0		;Use macro to specify new cursor row & column
	CALL	CUR			;Set cursor position for message
	MOV	SI,OFFSET KEYMSG2	;Point SI to part of on/off keys message address
	CALL	CHAROUT
	MOV	SI,OFFSET KEYMSG3	;Point SI to part of on/off keys message address
	CALL	CHAROUT		;Print message to screen
	MOV	SI,OFFSET KEYMSG4	;Point SI to part of on/off keys message address
	CALL	CHAROUT		;Print message to screen
	CURPOS	2,0		;Use macro to specify new cursor row & column
	CALL	CUR			;Set cursor position for message
	MOV	SI,OFFSET KEYMSG5	;Point SI to part of on/off keys message address
	CALL	CHAROUT		;Print message to screen
	MOV	SI,OFFSET KEYMSG6	;Point SI to part of on/off keys message address
	CALL	CHAROUT		;Print message to screen
	MOV	SI,OFFSET KEYMSG7	;Point SI to part of on/off keys message address
	CALL	CHAROUT		;Print message to screen
	CURPOS	3,0		;Use macro to specify new cursor row & column
	CALL	CUR			;Set cursor position for message
	MOV	SI,OFFSET KEYMSG8	;Point SI to part of on/off keys message address
	CALL	CHAROUT		;Print message to screen
	MOV	SI,OFFSET KEYMSG9	;Point SI to part of on/off keys message address
	CALL	CHAROUT		;Print message to screen
	MOV	SI,OFFSET KEYMSG10	;Point SI to part of on/off keys message address
	CALL	CHAROUT		;Print message to screen
	CURPOS	4,0		;Use macro to specify new cursor row & column
	CALL	CUR			;Set cursor position for message
	MOV	SI,OFFSET KEYMSG11	;Point SI to part of on/off keys message address
	CALL	CHAROUT		;Print message to screen
	POPA
	CALL SMSG			;Display sound on/off message using resident
	RET				; code's routine

FIND:	CLD				;All string operations forward.
	MOV	BX,OFFSET START[1]	;Point to start of code.
	NOT	BYTE PTR [BX]	;Change a byte so no false match
					; with transient version's signature string
	MOV	AX,CS			;Store our segment in AX
	MOV	DX,AX			;Start at our segment
NEXT_PARA:
	INC	DX			;Next paragraph.
	MOV	ES,DX
	CMP	DX,AX			;Is it our segment?
	JNE	N1			;If not, continue search
					;If we cycle back to start, no copy in memory
	NOT	BYTE PTR [BX]	;Change signature back so transient copy can't
					; leave resident signature in memory
	RET				;Not resident; go on with CS=ES
N1:	MOV	SI,BX			;Else, point to our signature
	MOV	DI,BX			; and offset of possible match
	MOV	CX,32			;Check 32 bytes for match with resident copy's
	REP	CMPSB			; signature
	JNZ	NEXT_PARA		;If no match, keep looking
					;If match, signature already in memory
	NOT	BYTE PTR [BX]	;Change signature back so transient copy can't
					; leave resident signature in memory
	RET				;Resident; go on with CS!=ES

CSEG	ENDS
	END	START