*----------------------------------------------------------------------
* SAMPLE.PRG :
* Sample program to demonstrate the use of R_ShowPCX ()
*----------------------------------------------------------------------
* The program displays a slideshow of all the PCX-files in the current
* directory.
*----------------------------------------------------------------------
* (c) 1993  Rolf van Gelder, EINDHOVEN
*----------------------------------------------------------------------
* Note: Compile with the /N switch
*       Link with the R_ShowPCX() library
*----------------------------------------------------------------------
FUNCTION SlideShow

LOCAL	aPCX   := Directory ( '*.PCX' )
LOCAL	nFiles := Len ( aPCX )
LOCAL	i
LOCAL	nRetCode

IF nFiles < 1

   Alert ( 'No PCX-files found in current directory ...' )

ELSE

   FOR i := 1 TO nFiles
      *-- Loop to process all the PCX-files found

      *-- Show next PCX-file during 3 seconds
      nRetCode := R_ShowPCX ( aPCX [i,1], { || inkey ( 3 ) } )

      IF nRetCode != 0
         *-- Oops, error detected !
         Clear
         Alert ( 'Error displaying '+aPCX [i,1]+;
            ', Errorcode: '+LTrim ( Str ( nRetCode ) ) )
      ENDIF

   NEXT

ENDIF

RETURN nil
*----------------------------------------------------------------------
