* Function: Size_file
* Author:   David Morgan
* Version:  Clipper Summer '87
*
* Copyright (c) 1989 Nantucket Corp.  All Rights Reserved.
*
* Note(s):  Given a valid file handle, returns the size of the
*           file.  Given additionally an optional number-of-bytes
*           by which to change file's size, extends or truncates
*           the file and returns the new size.
*
*           If the number of bytes is positive, the file is
*           extended; if negative, truncated.  Truncating more
*           bytes than file contains produces no error, leaves
*           filesize unchanged.  The content of extended bytes is
*           indeterminate.
*
*           Returns -1 if an error occurs.
*
*
*           "[FSEEK] method 2 can move the file pointer either
*           forward or backward from the end of the file...." 
*
*           "specifying method code 02H with an offset of 0
*           conveniently positions the file pointer at the end of
*           the file.  With method code 02H offset 0, the size of
*           the file can also be determined by examining the
*           pointer position returned by the function."
*
*           "[If FWRITE's] number of bytes to write [... is] 0,
*           the file is truncated or extened to the current file
*           pointer loaction."
*
*           - The MS-DOS Encyclopedia, Microsoft Press,
*                  pp. 1308, 1312, 1313.
*
FUNCTION Size_file
PARAMETERS hndl, how_many
PRIVATE f_ok, newsize
how_many = IIF(PCOUNT() != 2, 0, how_many)
f_ok = .T.
FSEEK(hndl,how_many,2)          && Move pointer from EOF position.
f_ok = f_ok .AND. (FERROR()=0)
FWRITE(hndl,'',0)               && Coincide EOF with new position.
f_ok = f_ok .AND. (FERROR()=0)
newsize = FSEEK(hndl,0,2)       && Measure new size.
f_ok = f_ok .AND. (FERROR()=0)
RETURN  IIF(f_ok, newsize, -1)


* Function: File_size
* Author:   David Morgan
* Version:  Clipper Summer '87
* Copyright (c) 1989 Nantucket Corp. All Rights Reserved.
*
* Note(s):  Given a valid file handle, returns the size of the
*           file, or -1 if an error occurs.
*
FUNCTION File_size
PARAMETERS hndl
PRIVATE size
size = FSEEK(hndl,0,2)
RETURN IIF(FERROR()=0, size, -1)
