* ________.PRG
* ________________ SYSTEM MAIN MENU module written by:  ____________
*     created: __/__/__
* last update: __/__/__
*
**********************************************************************
* NOTE:  This system utilizes functions from a number of libraries:  *
*                                                                    *
*              CLIPPER  -  Clipper Summer '87 Main Library           *
*              EXTEND   -  Clipper Summer '87 Extended Library       *
*                                                                    *
*        If multi-user or single-user security requirements includ-  *
*        log on/off information, include the following libraries:    *
*                                                                    *
*              NL187    -  Communication Horizon's Network Library   *
*              NLEXT87     for CLIPPER SUMMER '87                    *
*                                                                    *
* If the multi-user or security options are not required, strip out  *
* the appropriate code lines from this program and the ___INIT.PRG   *
* modules.                                                           *
*                                                                    *
*                                                                    *
* The appropriate libraries and/or functions must be present during  *
* the LINKing process or an "UNDEFINED SYMBOL" error will occur.     *
*                                                                    *
* Further note that this application is written in the CLIPPER       *
* complier SUMMER '87 version and as such must have that version of  *
* the above named libraries linked for proper operation.             *
*                                                                    *
**********************************************************************
*                                                                    *
**********************************************************************
* UDFs:                                                              *
*                                                                    *
* Custom written UDFs are in the TEM_UDFS.PRG program file.  These   *
* functions can be implemented in a couple of ways:                  *
*                                                                    *
* -  Functions that are to be used in the target application can be  *
*    inserted into the bottom of this file individually.  This saves *
*    space because only the required functions are used.  The draw-  *
*    back is some UDFs call other UDFs which means thorough testing  *
*    must be done to prevent "UNDEFINED SYMBOL" errors.              *
* -  The TEM_UDFS.PRG file can be compiled and linked into the tar-  *
*    get application as a whole.  The drawback here is more space    *
*    will be allocated for the .EXE and/or .OVL file(s).             *
*                                                                    *
* Choose either option but be aware of the consequences of each.     *
**********************************************************************
*                                                                    *
**********************************************************************
* About Color:                                                       *
*                                                                    *
* The system color assignments are set below and in the ___INIT.PRG  *
* file using the sys_color, c_scrl_box,c_goto_box,c_scrl_con, and    *
* c_scrl_bar memory variables.                                       *
**********************************************************************
*
***************************************
* Establish the operating environment *
***************************************
CLEAR ALL
CLOSE ALL
SET BELL       OFF
SET CONFIRM    ON
SET CURSOR     OFF
SET DELETED    ON
SET DELIMITER  OFF
SET ECHO       OFF
SET EXACT      OFF
SET EXCLUSIVE  ON
SET INTENSITY  ON
SET MESSAGE TO 2
SET SAFETY     OFF
SET SCOREBOARD OFF
SET TALK       OFF
SET WRAP       ON
*
*******************************************************
* Include the following statement if system requires  *
* multi-user capabilities or single-user security is  *
* to be included.                                     *
*******************************************************   
*  N_READY()               && UDF from NETLIB. Readies application for Network use
*
**************************************
* Establish System Control Variables *
**************************************
PUBLIC sys_color,sys_prn,sys_srv,menu_opt,user_name,user_level
PUBLIC c_scrl_box,c_goto_box,c_scrl_con,c_scrl_bar
PUBLIC CLIPPER,FOXBASE,is_found,key_pos,recnum,ALTERED,VER21,ok_to_srch,USE_DBF   && Required by dBDSCRL 5.5
*
STORE "" TO sys_comm,sys_user,sys_color,sys_prn,sys_srv
STORE "" TO c_scrl_box,c_goto_box,c_scrl_con,c_scrl_bar
STORE "" TO user_name,user_level,sys_dkey     
*
DO ____INIT               && Variable initialization, opening screen display
*
DO WHILE .T.
   menu_opt=1
   CLEAR
   @ 03,00 SAY REPLICATE(CHR(196),79)               && Single Top Border Line
   @ 23,00 SAY REPLICATE(CHR(196),79)               && Block Bottom Border Line
   @ 24,00 SAY sys_comm
   @ 01,00      PROMPT "_____"     MESSAGE "________________________"
   @ 01,COL()+2 PROMPT "_____"     MESSAGE "________________________"
   @ 01,COL()+2 PROMPT "_____"     MESSAGE "________________________"
   @ 01,COL()+2 PROMPT "Utilities" MESSAGE "Archiving Data, Printing, Reindexing, Security Options"
   @ 24,00 SAY sys_comm
   MENU TO menu_opt
   DO CASE
      CASE menu_opt=0
         @ 01,00
         @ 02,00
         @ 01,00      PROMPT "NO " MESSAGE "Do Not Exit System"
         @ 01,COL()+2 PROMPT "YES" MESSAGE "Exit System"
         menu_opt=1
         MENU TO menu_opt
         IF menu_opt=2
            EXIT
         ENDIF
         *
      CASE menu_opt=1
         DO ________  
         *
      CASE menu_opt=2
         DO ________  
         *
      CASE menu_opt=3
         DO ________  
         *
      CASE menu_opt=4
         DO ____UTIL
         *
   ENDCASE
   *
   ***********************************************************
   * Clear memory. As CLIPPER assigns memory to variables as *
   * they are called, and those variables are released when  *
   * RETURNing from the program that created them, "holes"   *
   * or non-contiguous blocks memory are eventually formed.  *
   * To refresh memory into contigous blocks, the following  *
   * routine has been implemented.  This is a routine sug-   *
   * gested by that ol' CLIPPER guru Stephen Straley and it  *
   * works just fine.                                        *
   *                         Gary L. Cota November 12, 1988  *
   ***********************************************************
   SAVE TO TEMPFILE
   CLEAR ALL
   RESTORE FROM TEMPFILE
   ERASE TEMPFILE.MEM
   *
ENDDO
USE ____WTFO
LOCATE FOR c_ENCRYPT(user_name,sys_dkey)=F08
REPLACE F03 WITH DATE(),F02 WITH TIME(),F01 WITH .T.
CLEAR
@ 02,01      SAY TRIM(user_name)+" logged out from the system"
@ ROW()+1,01 SAY "Login  Time:  "+DTOC(F05)+"  "+F04
@ ROW()+1,01 SAY "Logout Time:  "+DTOC(F03)+"  "+F02
CLOSE DATABASES
SET CURSOR ON
@ 22,0
QUIT
*
*
****************************
* UDFs to be inserted here *
****************************
*
*
