program EdLang;
{$M 4096,0,8000}
uses
	dos, crt, printer, FastTTT5, WinTTT5, MenuTTT5,
	KeyTTT5, ReadTTT5, StrnTTT5, MiscTTT5;

type
    LangRec=record
      Intro    : string[80];
      LangPath : string[80];
      MenuPath : string[80];
      Archives : array[1..5] of string[80];
      ArchDesc : array[1..5] of string[60];
      AccessCode : string[80];
      DisplayLines,
      DisplayCols: Byte;
      Ascii7,
      Ascii8,
      ANSI,
      Avatar,
      Vt52,
      Vt52Atari,
      Vt100,
      Iemsi,
      Naplps,
      Rip:boolean;
      dummy1,
      dummy2,
      dummy3,
      dummy4,
      dummy5:boolean;
      end;

	S13= string[13];


var
	M				: menu_record;
	InitMode,
	choice,
	retcode	: integer;
	DataFile: file of LangREc;
	done		: boolean;
	ch			: char;

	Fcolor,
	Bcolor	:byte;



const
	pad='............................................';


function strr (i:integer):string;
var b:string;
begin
  str (i,b);
  strr:=b
end;

function valu (q:string):integer;
var i,s,pu:integer;
    r:real;
begin
  valu:=0;
  if length(q)=0 then exit;
  if not (q[1] in ['0'..'9','-']) then exit;
  if length(q)>5 then exit;
  val (q,r,s);
  if s<>0 then exit;
  if (r<=32767.0) and (r>=-32767.0)
    then valu:=round(r)
end;

procedure RetCodeAction(var Active_Field, hi: byte);
{ Process keystrokes while filling out card }
begin
   Case R_Char of
		UArr,
		Mup : begin
					 Active_Field := Active_Field -1;
                if Active_Field < 1 then
						 Active_Field := hi;
                end;
		MEnter,Enter,
		MDown,
		#9, DArr : begin
                     Active_Field:=Active_Field+1;
							if Active_Field > hi then
                        Active_Field:= 1;
                     end;
      end; {case}
end;


function LeadingZero(w : Word) : String;
var
	s : String;
begin
	Str(w:0,s);
	if Length(s) = 1 then
		s := '0' + s;
	LeadingZero := s;
end;


function MakeDate(ptime:longint): String;
var
	DT: datetime;
	Ystring   : string;

begin
	Unpacktime(Ptime,DT);
	str(dt.year,Ystring);
	Ystring:=copy(ystring,3,2);
	With DT do
		MakeDate := leadingzero(Month)+'/'+leadingzero(day)+'/'+ystring;
end;

function MakeTime(ptime:longint):string;
var
   dt:datetime;
	Ystring   : string;

begin
	Unpacktime(Ptime,DT);
	With DT do
		MakeTime := leadingzero(hour)+':'+leadingzero(min);
end;


function PackDate(when:longint;d:string):longint;
var
	DT: datetime;
	code : word;
	p: longint;
begin
  Unpacktime(when,DT);
 	with DT do begin
		val(copy(d,1,2),Month,code);
		val(copy(d,4,2),Day,code);
		val('19'+copy(d,7,2),Year,code);
		end;
	PackTime(dt,p);
	PackDate:=p;
end;

function PackTheTime(when:longint;d:string):longint;
var
	DT: datetime;
	code : word;
	p: longint;
begin
  Unpacktime(when,DT);
	with DT do begin
		val(copy(d,1,2),hour,code);
		val(copy(d,4,2),min,code);
		end;
	PackTime(dt,p);
	PackTheTime:=p;
end;

procedure InputPD(x,y,f,b:byte;typ:char;var s:string);
var
   ch,sep: char;
   pos,p1,p2,p,len: byte;
begin
   TextColor(f);
   TextBackground(b);
   typ:=upcase(typ);
   ch:=#0;
   p:=x+length(s);
   pos:=x+length(s);

   if typ = 'P' then begin;
      sep:='-';
      p1:=4+x-1;
      p2:=8+x-1;
      len:=11;
      end
   else
   if typ = 'T' then begin
      sep:=':';
      p1:=3+x-1;
      len:=4;
      end


   else begin
      sep:='/';
      p1:=3+x-1;
      p2:=6+x-1;
      len:=7;
      end;
   if p>len+x then gotoXY(x+len,y)
   else gotoXY(p,y);

   repeat
      ch:=getkey;
      if ch=BackSp then begin
         if pos>x then begin
            pos:=pos-1;
				if (p-x<=len) then WriteAT(p,y,black,lightgray,' ');
            p:=p-1;
						WriteAT(p,y,white,black,' ');
            gotoXY(pos,y);
            s:=copy(s,1,pos-x-1);
            end;
         end
      else if (pos <= x+len) and ((ch>='0') and (ch<='9')) then begin
         gotoXY(pos,y);
				 writeAT(p,y,white,black,ch);
         s:=s+ch;
         inc(p);
         inc(pos);
         if (pos=p1) or (pos=p2) then begin
						WriteAT(p,y,white,black,sep);
            s:=s+sep;
            inc(pos);
            inc(p);
            gotoXY(pos,y);
            end;
         end;
   until (ch=Enter) or (ch=Uarr) or (ch=Darr) or (ch=Tab)
         or (ch=F2) or (ch=F10) or (ch=PgUp) or (ch=PgDn)
         or (ch=CtrlPgUp) or (ch=CtrlPgDn);

   R_Char:= ch;
end;

procedure InputDate(x,y,f,b:byte;var s:string);
begin
   OnCursor;
   attrib(x,y,x+7,y,f,b);
   inputPD(x,y,f,b,'D',s);
	 attrib(x,y,x+7,y,white,blue);
   OffCursor;
end;

procedure InputTime(x,y,f,b:byte;var s:string);
begin
   OnCursor;
   attrib(x,y,x+4,y,f,b);
   inputPD(x,y,f,b,'T',s);
	 attrib(x,y,x+4,y,white,blue);
   OffCursor;
end;

procedure InputPhone(x,y,f,b:byte;var s:string);
begin
   OnCursor;
   attrib(x,y,x+11,y,f,b);
   inputPD(x,y,f,b,'P',s);
	 attrib(x,y,x+11,y,white,blue);
   OffCursor;
end;



Procedure Read_Str(X,Y,L:byte; Prompt:StrScreen;
						BoxType: byte; Var Txt:string);
var
	count: byte;
	text: strscreen;
begin
   OnCursor;
	text:=txt;
	Read_String(x,y,l,prompt,boxtype,text);
	txt:=text;
	attrib(x,y,x+l,y,white,blue);
   OffCursor;
end;

Procedure Read_B(X,Y,L:byte; Prompt:StrScreen;
						BoxType: byte; Var B:byte; min,max:byte);
var
	count: byte;
	text: strscreen;
begin
	OnCursor;
	Read_Byte(x,y,l,prompt,boxtype,B,min,max);
	if b=0 then
		WriteAT(x,y,white,blue,'0');

	attrib(x,y,x+l,y,white,blue);
	OffCursor;
end;

Procedure Read_Boo(X,Y:byte; Prompt:StrScreen;
						BoxType: byte; Var B:boolean);
var
	count: byte;
	text: strscreen;
begin
	OnCursor;
  Read_YN(X,Y,Prompt,BoxType,B);

	if b=false then
		WriteAT(x,y,white,blue,'N');

	attrib(x,y,x,y,white,blue);
	OffCursor;
end;


function FileExists(f:string):boolean;
VAR
	s: SearchRec;
begin
	findfirst(f,anyfile,s);
	FileExists:= (DosError=0);
end;


function numrecs:longint;
begin
{$I-}
	reset(datafile);
	numrecs:= filesize(datafile);
	close(datafile);
{$I+}
end;


procedure SaveRecord(number: longint; var info: LangREc);
{ Append record to end of Diskfile }
begin
{  if (number>4) and limit then
     number:=4;}
  {$I-}
	reset(datafile);
	seek(datafile,NUMBER);
	write( datafile,info );
	close(datafile);
	{$I+}
end;

procedure ReadRecord(number: longint; var info: LangREc);
{ Read in a disk record }
begin
	{$I-}
	reset(datafile);
	seek(datafile,number);
  read(datafile,info);
	close(datafile);
	{$I+}
end;

procedure ClearRec(var rec: LangREc);
begin
	fillchar(rec,sizeof(rec),0);
end;

procedure GetAttribs(var rec:LangRec);
var Pos,hi:byte;
begin
  Pos:=1;
  hi:=10;
	MkWin(16,6,60,16,white,blue,1);
	FillScreen(16,7,59,16,darkgray,black,chr(177));  {draw shadow box}
	FillScreen(17,6,60,15,white,blue,' ');           {draw foreground box}

	WriteAT(16,6,white,blue,chr(177));
	WriteAT(60,16,white,blue,chr(177));


{	FillScreen(19,7,60,15,white,blue,chr(32));}

	FillScreen(17,6,60,6,white,blue,chr(223));
	FillScreen(17,9,60,9,white,blue,chr(196));
	WriteCenter(7,white,blue,'Language Object Attributes');
	WriteAT(20,10,white,blue,'8-bit ASCII       NAPLPS');
	WriteAT(20,11,white,blue,'ANSI              RIPScrip');
	WriteAT(20,12,white,blue,'Avatar            IEMSI');
	WriteAT(20,13,white,blue,'VT52              Atari');
	WriteAT(20,14,white,blue,'VT100             [EXIT]');
  with rec do repeat
    if ASCII8 then writeat(18,10,white,blue,'')
      else writeat(18,10,black,blue,'');
    if ANSI then writeat(18,11,white,blue,'')
      else writeat(18,11,black,blue,'');
    if Avatar then writeat(18,12,white,blue,'')
      else writeat(18,12,black,blue,'');
    if VT52 then writeat(18,13,white,blue,'')
      else writeat(18,13,black,blue,'');
    if VT100 then writeat(18,14,white,blue,'')
      else writeat(18,14,black,blue,'');
    if Naplps then writeat(36,10,white,blue,'')
      else writeat(36,10,black,blue,'');
    if RIp then writeat(36,11,white,blue,'')
      else writeat(36,11,black,blue,'');
    if IEMSI then writeat(36,12,white,blue,'')
      else writeat(36,12,black,blue,'');
    if VT52Atari then writeat(36,13,white,blue,'')
      else writeat(36,13,black,blue,'');
{   case Pos of
      1:WriteAt(19,10,white,blue,'');
      2:WriteAt(19,11,white,blue,'');
      3:WriteAt(19,12,white,blue,'');
      4:WriteAt(19,13,white,blue,'');
      5:WriteAt(19,14,white,blue,'');
      6:WriteAt(37,10,white,blue,'');
      7:WriteAt(37,11,white,blue,'');
      8:WriteAt(37,12,white,blue,'');
      9:writeAt(37,13,white,blue,'');
      else
      Pos:=1;
      end;
}   with rec do
      case pos of
        1:Read_Boo(18,10,'',0,ASCII8);
        2:Read_Boo(18,11,'',0,ANSI);
        3:Read_Boo(18,12,'',0,Avatar);
        4:Read_Boo(18,13,'',0,VT52);
        5:Read_Boo(18,14,'',0,VT100);
        6:Read_Boo(36,10,'',0,NAPLPS);
        7:Read_Boo(36,11,'',0,RIP);
        8:Read_Boo(36,12,'',0,IEMSI);
        9:Read_Boo(36,13,'',0,vt52Atari);
        10:r_Char:=#27;
        end;

    RetCodeAction(Pos,hi);



	until (R_Char=#27) or (R_Char=F2) or (R_Char=F10) or
			(R_Char=PgUp) or (R_Char=PgDn) or (R_Char=MEsc);
  rmwin;
end;


procedure EditRec(var rec: LangREc; recnum: longint);
{This is the record edit screen}
var
   ch: char;
	pos,hi: byte;
	datestring,timestring :string;
	d:string[8];
begin
  if Rec.Intro='' then with rec do begin
     fillchar(rec,sizeof(rec),0);
     end;

	pos:=1;
	hi:=6;

	repeat
	  with Rec do begin
		  fillscreen(29,10,59,14,blue,blue,' ');
		  writeAT(30,10,white,blue,rec.Intro);
		  writeAT(30,11,white,blue,LangPath);
		  writeAT(30,12,white,blue,MenuPath);
		  writeAT(30,13,white,blue,AccessCode);
		  writeAT(30,14,white,blue,'');
      if Ascii8 then writeat(30,14,white,blue,'ASC');
      if ANSI then writeat(34,14,white,blue,'ANS');
      if Avatar then writeat(38,14,white,blue,'AVT');
      if Iemsi then writeat(42,14,white,blue,'EMS');
      if RIP then writeat(46,14,white,blue,'RIP');
      if NAPLPS then writeat(50,14,white,blue,'NAP');
		  end;
		with rec do
			case pos of
			1: begin
					Read_Str(30,10,30,'',0,intro);
					RetCodeAction(pos,hi);
				end;
			2: begin
					Read_Str(30,11,30,'',0,LangPath);
					RetCodeAction(pos,hi);
				end;
			3: begin
					Read_Str(30,12,30,'',0,MenuPath);
					RetCodeAction(pos,hi);
				end;
			4: begin
					Read_Str(30,13,30,'',0,AccessCode);
					RetCodeAction(pos,hi);
				end;
			5: begin
          GetAttribs(Rec);
          pos:=4;
          r_Char:=' ';
          if Ascii8 then writeat(30,14,white,blue,'ASC');
          if ANSI then writeat(34,14,white,blue,'ANS');
          if Avatar then writeat(38,14,white,blue,'AVT');
          if Iemsi then writeat(42,14,white,blue,'EMS');
          if RIP then writeat(46,14,white,blue,'RIP');
          if NAPLPS then writeat(50,14,white,blue,'NAP');
          end;
      6:Pos:=1;
			end;{case}

	until (R_Char=#27) or (R_Char=F2) or (R_Char=F10) or
			(R_Char=PgUp) or (R_Char=PgDn) or (R_Char=MEsc);

end;


procedure AddRecords(recnum:longint);
var
	rec, backup: LangREc;
	s:string[11];
	done: boolean;
begin
	Fillscreen(1,1,80,25,white,blue,chr(177));
	assign(datafile,'langfile.DAT');
	if not FileExists('langfile.DAT') then begin
		{$I-}
		rewrite(datafile);
		close(datafile);
		{$I+}
		end;

	MkWin(16,6,60,16,white,blue,0);
	FillScreen(16,7,59,16,darkgray,black,chr(177));  {draw shadow box}
	FillScreen(17,6,60,15,white,blue,' ');           {draw foreground box}

	WriteAT(16,6,white,blue,chr(177));
	WriteAT(60,16,white,blue,chr(177));


{	FillScreen(19,7,60,15,white,blue,chr(32));}

	FillScreen(17,6,60,6,white,blue,chr(223));
	FillScreen(17,9,60,9,white,blue,chr(196));
{
	FillScreen(18,7,18,15,darkgray,black,chr(177));
}
	WriteCenter(7,white,blue,'Celerity Protocol Manager');
	WriteAT(18,10,white,blue,'Description');
	WriteAT(18,11,white,blue,'Language   ');
	WriteAT(18,12,white,blue,'Menu Path  ');
	WriteAT(18,13,white,blue,'Access Code');
	WriteAT(18,14,white,blue,'Attributes ');


{
	FillScreen(3,25,78,25,white,blue,' ');
}
	FillScreen(1,22,80,25,white,blue,' ');
{
  writecenter(22,white,blue,'Program: <name> or <!x> for internal (valid chars: ZYGXFA)');
  writecenter(23,white,blue,'Class: 1-Batch Upload  2-Batch Download  3-Upload  4-Download  5-Bidirectional ');
  writecenter(24,white,blue,'Parameters: %1-Port   %2-Speed   %3-Filename   %4-Estimated CPS');
}
	WriteCenter(25,white,blue,Chr(24)+Chr(25)+' keys move bar. <F2> saves,<F10> save & quit. <PgUp>,<PgDn> change record');



	done:=false;
	ClearRec(rec);
	if recnum < 0 then
		recnum:=numrecs;

	repeat
		s:=int_to_str(recnum)+'/'+int_to_str(numrecs);
		WriteCenter(8,white,blue,'  Record # '+s+'  ');

		EditRec(rec,recnum);

		case R_Char of
			F2:begin
				SaveRecord(recnum,rec);
				inc(recnum);
				ClearRec(rec);
				ReadRecord(recnum,rec);
				end;
			F10  :begin
					done:=true;                {Exit data entry}
						saveRecord(recnum,rec);
					end;
			PgDn:
				if RecNum < numrecs then begin
					SaveRecord(recnum,rec);
					inc(recnum);
					ClearRec(rec);
					ReadRecord(recnum,rec);
					end
				else begin
					sound(1400);
					delay(30);
					nosound;
					end;
			PgUp:
				if recnum > 0 then begin
					if recnum <> numrecs then
						SaveRecord(recnum,rec);

					{ else
						SaveRecord(recnum,rec); }

					dec(recnum);
					ClearRec(rec);
					ReadRecord(recnum,rec);
					end
				else begin
					sound(1400);
					delay(30);
					nosound;
					end;
			#27,
			MEsc:done:=true;

			end;{case}


	until done;
	RmWin;

end;

procedure listnodes;
var
	cnt,num,x,y:byte;
	r: LangREc;
	datestring,timestring: string;
	ch: char;
	done: boolean;

begin
	assign(datafile,'langfile.dat');
	if not FileExists('langfile.dat') then begin
		{$I-}
		rewrite(datafile);
		close(datafile);
		{$I+}
		end;
	OffCursor;
	MkWin(3,5,78,19,white,blue,219);
	writeat(4,6,white,blue,'LM8AVIRN  Description                     Access');
  writeat(4,7,white,blue,'');
	FillScreen(3,25,78,25,white,blue,' ');
	WriteCenter(25,white,blue,'Press any key for next page, <PgUp> for Previous page, <ESC> to Abort');


	num:=0;
	cnt:=1;
	done:=false;

	repeat
		while (num<numrecs) and (cnt<11) do begin
			y:=7+cnt;
			ReadRecord(num,r);
			with r do begin
        if Langpath<>'' then writeat(4,y,white,blue,'');
        if Menupath<>'' then writeat(5,y,white,blue,'');
        if Ascii8 then writeat(6,y,white,blue,'');
        if ANSI then writeat(7,y,white,blue,'');
        if Avatar then writeat(8,y,white,blue,'');
        if Iemsi then writeat(9,y,white,blue,'');
        if RIP then writeat(10,y,white,blue,'');
        if NAPLPS then writeat(11,y,white,blue,'');


				writeAT(15,y,white,blue,Intro);
        writeat(48,y,white,blue,AccessCode);

{  			writeat(56,y,white,blue,timestring);
				writeAT(64,y,white,blue,datestring);}
				end;
			inc(cnt);
			inc(num);
			end;
		ch:=getkey;
		case ch of
			#27:done:=true;
			PgUp:if num>10 then
					  num:=num-10-cnt+1
				  else
					  num:=0;
			end;{case}

		if num>=numrecs then
			done:=true
		else begin
			attrib(4,8,77,18,blue,blue);
			cnt:=1;
			end;
	until done;
	RmWin;
	OnCursor;
end;


procedure PrintNodes;
var
	cnt,size:byte;
	info:LangREc;

begin
	assign(datafile,'langfile.dat');
	if not FileExists('langfile.dat') then begin
		{$I-}
		rewrite(datafile);
		close(datafile);
		{$I+}
		end;
	reset(datafile);
	size:=filesize(datafile)-1;
	close(datafile);
	writeln(lst,'List of CelerityNet nodes');
{	for cnt:=0 to size do begin
		readrecord(cnt,info);
		write(lst,info.nodenum,'  ',copy(info.bbsname+pad,1,30),copy(info.nodepass+'          ',1,10));
		writeln(lst,'   Connected last on ',makedate(info.lastdate));
		end;
	write(lst,^L);}
end;


procedure SortNodes(which:byte);

	procedure readud(j,k: integer; var u1,u2: LangREc);
   begin
		seek(datafile,j-1);
		read(datafile,u1);
		seek(datafile,k-1);
		read(datafile,u2);
	end;

	procedure writeud(j,k: integer;u1,u2: LangREc);
   begin
		seek(datafile,j-1);
		write(datafile,u1);
		seek(datafile,k-1);
		write(datafile,u2);
	end;

var
  n,i,j,k,gap,cnt: integer;
	u1, u2: LangREc;
   sortby:char;
	item1,item2:string;
	moo:word;
	s:string;
  Count:byte;


begin
	assign(datafile,'langfile.dat');
{$I-}
	reset(datafile);
  if ioresult<>0 then exit;
{$I+}
	seek(datafile,0);
	n:=filesize(datafile);
   str(n,s);
	writeAT(30,20,white,blue,' '+s+' records sorted ');
	gap:= n div 2;
	while gap>0 do begin
		for i:=gap+1 to n do begin
			j:=i-gap;
			while (j>0) do begin
				k:=j+gap;
				readud(j,k,u1,u2);
        case which of
          1:begin
            item1:=u1.LangPath;
            item2:=u2.LangPath;
            end;
          2:begin
				    item1:=u1.MenuPath;
				    item2:=u2.MenuPath;
            end;
          3:begin
            count:=0;
            if u1.MenuPath<>'' then
              inc(count);
            if u1.LangPath<>'' then
              count:=count+2;
            item1:=strr(count);
            count:=0;
            if u2.MenuPath<>'' then
              inc(count);
            if u2.LangPath<>'' then
              count:=count+2;
            item2:=strr(count);
            end;
          end; {case}
				if item1 <= item2 then
					j:=0
				else
					writeud(j,k,u2,u1);
				j:=j-gap;
				end;
			end;
		gap:= gap div 2;
		end;
end;


Procedure Init_Vars;
var
	Y,Mo,D,DW: word;
begin

	 Menu_Set(M);
	 With M do begin
		 Heading1 := 'Celerity Language File Manager';
     Heading2 := 'v1.0 6/21/93 Brendon Woirhaye';
		 Topic[1] := ' Add/Edit Language Object';
		 Topic[2] := ' List all Objects';
     Topic[3] := ' Sort By Language Name';
     Topic[4] := ' Sort By Menu Name';
     Topic[5] := ' Sort By Type';
		 Topic[6] := ' Quit';
		 TotalPicks := 6;
		 PicksPerLine := 1;
		 AddPrefix := 4;
		 TopleftXY[1] := 0;        {auto center}
		 TopLeftXY[2] := 7;
		 BoxType := 5;
		 Margins := 5;
		 Colors[1] := white;
		 Colors[2] := lightgray;
		 Colors[3] := lightgray;
		 Colors[4] := blue;
		 Colors[5] := white;
		 AllowEsc := false;
		 end;

   with RTTT do
      begin
      WhiteSpace := ' ';
		End_Chars := [#9, UArr, DArr, Enter, F2, F10,Mup,MDown,Menter,Mesc,
						  PgUp, PgDn, CtrlPgUp, CtrlPgDn];
		AllowEsc := true;
		Fcol:=White;
		Bcol:=black;
      end;

	done:= false;

end;


begin
	InitMode:=LastMode;

	Fillscreen(1,1,80,25,white,blue,chr(177));
	Choice := 1;
	Init_Vars;
	repeat
  	Fillscreen(1,22,80,25,white,blue,chr(177));
		FillScreen(3,25,78,25,white,blue,' ');
		WriteCenter(25,white,blue,Chr(24)+Chr(25)+' keys move bar.  <Enter> selects desired option.');
		DisplayMenu(M,true,Choice,Retcode);
		case choice of
    1: AddRecords(-1);
		2: ListNodes;
		3: SortNodes(1);
    4: SortNodes(2);
    5: SortNodes(3);
		6: done:=true; {exit}
		end; {case}
	until done or (RetCode=1);

	TextMode(InitMode);
end.


