/*
**  STRECPY.C - A form of strcpy() where the result returned is the
**              NUL terminating character of the first argument. In many
**              cases this function is more efficient than the equivalent
**              strcpy, followed by strcat.
**
**  public domain by Leslie Satenstein and Thad Smith.
*/

#include <stdio.h>
#include "sniptype.h"
#include "snip_str.h"

char *_strecpy(char *target, const char *src)
{
      if (src && target)
      {
            while ((*target++ = *src++) != NUL)
                  ;
            return (--target);
      }
      else  return NULL;
}
