/*
**  WIN 32 support functions for DIRPORT.H
**
**  Public domain by Jerry Coffin
*/

#if defined(__MSDOS__) || defined(MSDOS)
 #error DirPort.c is NOT intended for DOS programs ...
#endif

#include "dirport.h"

WORD ff_date(DOSFileData *f)
{
      WORD DOS_date;
      WORD DOS_time;

      FileTimeToDosDateTime(&(f->file.ftLastWriteTime), &DOS_date, &DOS_time);

      return DOS_date;
}

WORD ff_time(DOSFileData *f)
{
      WORD DOS_date;
      WORD DOS_time;

      FileTimeToDosDateTime(&(f->file.ftLastWriteTime), &DOS_date, &DOS_time);

      return DOS_time;
}

WORD ff_yr(DOSFileData *f)
{
      SYSTEMTIME t;

      FileTimeToSystemTime(&(f->file.ftLastWriteTime), &t);

      return t.wYear;
}

WORD ff_mo(DOSFileData *f)
{
      SYSTEMTIME t;

      FileTimeToSystemTime(&(f->file.ftLastWriteTime), &t);

      return t.wMonth;
}


WORD ff_day(DOSFileData *f)
{
      SYSTEMTIME t;

      FileTimeToSystemTime(&(f->file.ftLastWriteTime), &t);

      return t.wDay;
}

WORD ff_hr(DOSFileData*f)
{
      SYSTEMTIME t;

      FileTimeToSystemTime(&(f->file.ftLastWriteTime), &t);

      return t.wHour;
}

WORD ff_min(DOSFileData *f)
{
      SYSTEMTIME t;

      FileTimeToSystemTime(&(f->file.ftLastWriteTime), &t);

      return t.wMinute;
}

WORD ff_tsec(DOSFileData *f)
{
      SYSTEMTIME t;

      FileTimeToSystemTime(&(f->file.ftLastWriteTime), &t);

      return t.wMilliseconds / 100;
}

int FIND_FIRST(char *spec, unsigned attrib, DOSFileData *ff)
{
      ff_attr(ff) = attrib | _A_ARCH;

      ff->handle = FindFirstFile(spec, &(ff->file));
      
      if ( INVALID_HANDLE_VALUE == ff->handle ) {
            return 1;
      }

      while ( 0 != (ff->file.dwFileAttributes & ~ff_attr(ff)))
      {
            if ( FALSE == FindNextFile(ff->handle, &(ff->file))) {
                  return 1;
            }
      }
      return 0;
}

int FIND_NEXT(DOSFileData *ff)
{
      do {
            if ( FALSE == FindNextFile(ff->handle, &(ff->file))) {
                  return 1;
            }

      } while ( 0 != (ff->file.dwFileAttributes & ~ff_attr(ff)));
      return 0;
}

int FIND_END(DOSFileData *ff)
{
    return (int)FindClose(ff->handle);
}
