/*
**  DELAY.C - A portable time delay compatible with Borland's, Watcom's,
**            and Symantec's delay() function.
**
**  public domain demo by Bob Stout
*/

#include <time.h>
#include "delay.h"

void delay(int msec)
{
      long t, t0 = (long)clock();

      do
      {
            t  = 1000L * (long)clock();
            t /= CLOCKS_PER_SEC;
      } while ((t - t0) < msec);
}

#ifdef TEST

#include <stdio.h>
#include <stdlib.h>

main(int argc, char *argv[])
{
      int msec;

      if (2 > argc)
      {
            puts("Usage: DELAY milliseconds");
            return EXIT_FAILURE;
      }
      msec = atoi(argv[1]);
      printf("Delaying %d milliseconds\n", msec);
      delay(msec);
      return EXIT_SUCCESS;
}

#endif /* TEST */
