;		
		page		59, 80
		title		prfifl.asm
		.286c

; Interface library for PRF (Profiling Tool)

;
; Equates relevant to cmacros.inc
;						
		.sall
?PLM		equ		0		;C calling convention
?WIN		equ		0		;not MS-Windows

		.xlist
		include		cmacros.inc
		.list						   
		.lall

sBegin		CODE
assumes		CS, CODE	
		    
;
; PRF_IsInstalled():
; Look for the string 'PRF' in the three bytes just before the interrupt
; handler address.  If the PRF is present these bytes will be set to the 
; string 'PRF', the PRF_Fn() routine will be informed of the interrupt
; to use and a non-zero value will be returned.  Otherwise, zero will be
; returned.
;

cProc		PRF_IsInstalled, <FAR, PUBLIC>, <si,di,es,bx>
ParmW		Interrupt
cBegin		
		mov	si, Interrupt		;get interrupt number
		shl	si, 1
		shl	si, 1			;make into vector pointer
		xor	ax, ax			;will be segment zero
		mov	es, ax			;use ES
		mov	bx, es:[si]		;get offset part
		mov	ax, es:2[si]		;get segment part
		mov	es, ax			;PRF code segment
		cmp	byte ptr es:[bx-11], 'P';check if first byte of "PRF"
		jne	short NotInstalled1	;not installed, then jump
		cmp	byte ptr es:[bx-10], 'R';check if second byte of "PRF"
		jne	short NotInstalled1	;not installed, then jump
		cmp	byte ptr es:[bx-9], 'F'	;check if third byte of "PRF"
		jne	short NotInstalled1	;not installed, then jump
;
; The PRF is present, link to it by setting the interrupt instruction
; used by PRF_Fn() to use the correct interrupt.
;

		mov	bx, offset Instruction1+1;address of int instruction
		mov	al, byte ptr (Interrupt);get interrupt number
		mov	byte ptr cs:[bx], al	;set interrupt instruction
		mov	ax, 1			;Ok, return value N.Z.
		jmp	short GoBack1

NotInstalled1:	xor	ax, ax			;Not Ok, return value Z.

GoBack1:		
					
cEnd

cProc		PRF_Fn, <FAR, PUBLIC>, <>
ParmW		FunctionCode
cBegin
Instruction1:	int		22h		;Program terminate.
						;This will be executed if
						;the PRF_IsInstalled() function
						;is not used before attempting
						;to access PRF functions.
cEnd

sEnd

		end

