/* DateClass / Copyright 1995 by Kai Hofmann
******* DateClass/--history-- *************************************************
*
*   NAME
*	history -- This is the development history of the Date class
*
*   VERSION
*	$VER: DateClass 33.050 (30.07.95)
*
*   HISTORY
*	26.05.1995 -	Initialization of the following class:
*			timeduration
*			Implementation of timeduration constructors,
*			operator==,operator!=,operator==,operator!=,
*			operator<,operator>,operator<=,operator>=,operator+,
*			operator-,operator+=,operator-=
*	27.05.1995 -	Initialization of the following class:
*			dateduration
*			Implementation of dateduration constructors
*	30.05.1995 -	Implementation of operator==, operator!=, operator<,
*			operator>, operator<=, operator>=, operator++,
*			operator--, operator+, operator-, operator+=,
*			operator-=, operator*, operator/, operator*=,
*			operator/= for dateduration class
*			Implementation of gethours(), getmins(), getsecs()
*			for timeduration class
*	02.06.1995 -	Fixing small bugs in timeduration constructors,
*			operator-=
*	03.06.1995 -	Implementing getdays(), getmonths(), getyears()
*			for dateduration
*			Removing one of the dateduration constructors
*			Fixing small bugs in operator<, operator>,
*			operator<=, operator>=
*	03.07.1995 -	Initialization of the following class:
*			time
*	07.07.1995 -	Initialization of the following class:
*			date
*			Implementation of time constructors,
*			gethour(), getmin(), getsec(), getzone(), getjd(),
*			operator==, operator!=, operator<, operator>,
*			operator<=, operator>=, operator-, operator+,
*			operator-, operator+=, operator-=
*			Implementation of date constructors,
*			getday(), getmonth(), getyear(), getweek(),
*			getweekday(), getjd(), getmjd(), getscaliger(),
*			operator==, operator!=, operator<, operator>,
*			operator<=, operator>=, operator==, operator!=,
*			operator<, operator>, operator<=, operator>=,
*			operator!, operator-, operator+, operator-,
*			operator+=, operator-=, operator+, operator-,
*			operator+=, operator-=, changetozone(), operator<<,
*			operator>>, operator<<=, operator>>=, operator[],
*			operator()
*			Implementation of timeduration getinsecs()
*			Implementation of dateduration getindays()
*			Optimizations
*	08.07.1995 -	Fixing bugs in time
*			operator<<, operator>>, operator<<=, operator>>=,
*			operator[], opertaor(), changetozone(), operator-,
*			operator+, operator-
*	09.07.1995 -	I found a BUG in the SAS C++ translator, and so I
*			lost all the source from the DateClass.cpp :(
*			Completely reconstructed in 8 hours!
*	10.07.1995 -	Start to writing autodocs
*	14.07.1995 -	Workaround for the SAS C++ enum problem in Date.c
*	15.07.1995 -	Continuing with writing autodocs
*	16.07.1995 -	Continuing with writing autodocs
*	17.07.1995 -	Finishing with writing autodocs
*	18.07.1995 -	Fixing conversion warnings.
*	27.07.1995 -	Correcting my rusty English in the Autodocs.
*			Implementing of timeduration operators:
*			operator*,operator/,operator*=,operator/=
*	28.07.1995 -	Shortening the year of the version-string to 95,
*			because the Amiga 'version' command is buggy!
*			Removing the changetozone() function from the time
*			class, because it's better to use the operator[].
*			Starting to write a test program.
*	29.07.1995 -	Implementing Easter()
*			Implementing of date functions:
*			getmoonage(),getmoonphase()
*			Implementing of timeduration operator:
*			operator/()
*			Implementing of dateduration operator:
*			operator/()
*	30.07.1995 -	Implementing of timeduration operator:
*			operator%()
*			Implementing of dateduration operator:
*			operator%()
*			Fixing bugs (Thanks to Christian Schaefer for spending
*			time on this class with Borland C++ 4.5)
*
******************************************************************************/

/****** DateClass/--todo-- ****************************************************
*
*   NAME
*	todo -- This is the 'To-Do' list of the Date class
*
*   TODO
*	Writing a test programm
*	Writing code for string operations/TextEngine
*	Derive a datetime class
*	Derive a datetimeduration class
*	Variable durations (2-3h)
*	Variable time points (18. or 19.3.)
*	Alternatives
*	etc. (that's top secret ;-)
*
******************************************************************************/

/****** DateClass/--compiling-- ***********************************************
*
*   NAME
*	compiling -- Specials for compiling the date class.
*
*   COMPILING
*	- Compile the date library as C++ !!!
*	- You could compile this code as normal C++
*	- _ISO8859_Latin1 should be defined if your system supports this
*	  font encoding technology!
*	- Date.h will be included automatically!
*
******************************************************************************/

/****** DateClass/--background-- **********************************************
*
*   NAME
*	DateClass -- This class was designed to help calc. cal. dates (V33)
*
*   FUNCTION
*	This class has been designed to become a useful and portable class
*	and to help developers handle calendar dates!
*
*   NOTES
*	This class is based on the date library copyrighted 1994-95 by
*	Kai Hofmann.
*
*   COPYRIGHT
*	This software is copyrighted 1995 by Kai Hofmann.
*	All rights reserved!
*
*	- Permission for COMMERCIAL USE is only given by an extra available
*	  commercial license that must be validated!
*	  Contact me directly for this license, because it will be
*	  individually handed out per your needs!
*
*	- Permission is hereby granted, without written agreement and without
*	  license, to USE this software and its documentation for any
*	  NON-COMMERCIAL purpose, provided that the above copyright notice
*	  and the following paragraph appear in all copies of this software
*	  (Non-commercial includes Giftware and Shareware!).
*
*	  You *must* include the following notice in your product and in your
*	  documentation:
*	  "This software uses the date class that is copyrighted 1994-95 by
*	   Kai Hofmann"
*
*	  You "must" send me a full version of your product at no cost
*	  including free updates!
*	  Extra money is welcome (For Bank Account see below - but *ONLY*
*	  send in DM to this Bank Account!).
*
*	- THERE IS *NO PERMISSION* GIVEN TO MODIFY THIS SOFTWARE!
*
*	  If you need only parts of this software, you should not worry,
*	  because it's the job of the optimizer from your C compiler to
*	  include only the needed parts in your executable!
*
*   DISCLAIMER
*	THERE IS NO WARRANTY FOR THE PROGRAM, TO THE EXTENT PERMITTED BY
*	APPLICABLE LAW. EXCEPT WHEN OTHERWISE STATED IN WRITING THE COPYRIGHT
*	HOLDER AND/OR OTHER PARTIES PROVIDE THE PROGRAM "AS IS" WITHOUT
*	WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT NOT
*	LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
*	A PARTICULAR PURPOSE. THE ENTIRE RISK AS TO THE QUALITY AND
*	PERFORMANCE OF THE PROGRAM IS WITH YOU. SHOULD THE PROGRAM PROVE
*	DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR OR
*	CORRECTION.
*
*	IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING
*	WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY REDISTRIBUTE
*	THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR DAMAGES,
*	INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES
*	ARISING OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING
*	BUT NOT LIMITED TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR
*	LOSSES SUSTAINED BY YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM
*	TO OPERATE WITH ANY OTHER PROGRAMS), EVEN IF SUCH HOLDER OR OTHER
*	PARTY HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
*
*	THE AUTHOR HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
*	UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
*
*   DISTRIBUTION
*	Permission is hereby granted, without written agreement and without
*	license or royalty fees, to copy and distribute this software and its
*	documentation for any purpose, provided that the above copyright
*	notice and the following paragraphs appear in all copies of this
*	software, to:
*	- All who will distribute this software for free!
*	- All free accessible INTERNET servers and PHONE boxes!
*	- All Aminet sites
*	- All SimTel sites
*	- Fred Fish for his great Amiga-Software-Library
*	- The German SAAR AG PD-Library
*	- All others who do NOT take more than $5.- for one disk that
*	  includes this software!
*	- ALL others who do NOT take more than $40.- for one CD that includes
*	  this software!
*
*   ADDITIONAL INFORMATIONS
*	I have tried to make portable/useful and I hope bugfree software
*	for eternity - but this seems to be impossible (sorry!) :)
*	So I hope you will pay a fee for this.
*
*	Kindly send US - dollars to a friend of mine in the USA who will
*	forward it to me in a timely manner.  Please send checks or money
*	orders only.
*	Contact me via email for more!
*
*   AUTHOR
*	Kai Hofmann
*	Arberger Heerstrae 92
*	28307 Bremen
*	Germany
*
*	Phone: (+49)-(0)421/480780
*	       (Remember that my parents don't speak english!)
*	EMail: i07m@zfn.uni-bremen.de
*	       i07m@informatik.uni-bremen.de
*	IRC  : PowerStat@#AmigaGer
*	WWW  : http://www.informatik.uni-bremen.de/~i07m
*
*	Bank account : 1203 7503
*	Account owner: Kai Hofmann
*	Bank code    : 290 501 01
*	Bank name    : Sparkasse in Bremen/Germany
*
*    THANKS
*	Many thanks to the following people:
*	Rita Reichl		- For correcting my rusty english (very often)
*	Christian Schaefer	- For spending time on this class with his
*				  Borland C++ 4.5 compiler
*	Jacco van Weert &
*	Frans Slothouber	- For the 'Robodoc' utility
*	James Cooper and the
*	other Amiga people at
*	SAS Intitute		- For spending their unpaid free time with
*				  continuation of the Amiga SAS C/C++
*				  support :)
*
******************************************************************************/


 #include "dateclas.h"


 /* --- timeduration ------------------------------------------------------ */

/****** DateClass/timeduration ************************************************
*
*   NAME
*	timeduration -- Class for time durations (V33)
*
*   FUNCTION
*	This class maps the concept of time durations.
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	dateduration,time,date
*
******************************************************************************/

/****i* DateClass/timeduration/struct timeduration ****************************
*
*   NAME
*	struct timeduration -- Private structure of timeduration class (V33)
*
*   SYNOPSIS
*	struct timeduration {
*			     unsigned short days,hours,mins,secs;
*			    };
*
*   FUNCTION
*	This structure holds the data of a time duration.
*
*   ELEMENTS
*	days  - Number of days in a time duration, only for overruns.
*	hours - Number of hours in a time duration.
*	mins  - Number of mins in a time duration.
*	secs  - Number of secs in a time duration.
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	timeduration(),operator==(),operator!=(),operator<(),operator>(),
*	operator<=(),operator>=(),operator+(),operator-(),operator+=(),
*	operator-=(),gethours(),getmins(),getsecs(),getinsecs(),date
*
******************************************************************************/


 timeduration::timeduration(unsigned short days, unsigned short hours, unsigned short mins, unsigned short secs)

/****i* DateClass/timeduration/timeduration() *********************************
*
*   NAME
*	timeduration() -- Private constructor of timeduration class (V33)
*
*   SYNOPSIS
*	td = timeduration(days,hours,mins,secs);
*
*	timeduration(unsigned short days, unsigned short hours,
*	    unsigned short mins, unsigned short secs);
*
*   FUNCTION
*	This is a privat constructor for the timeduration class.
*
*   INPUTS
*	days  - Days of a timeduration
*	hours - Hours of a timeduration
*	mins  - Mins of a timeduration
*	secs  - Secs of a timeduration
*
*   RESULT
*	td - Timeduration object
*
*   EXAMPLE
*	...
*	timeduration td(0,2,0,0);
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	timeduration()
*
******************************************************************************/

  {
   this->days = days;
   this->hours = hours;
   this->mins = mins;
   this->secs = secs;
  }


 timeduration::timeduration(float jd)

/****** DateClass/timeduration/timeduration() *********************************
*
*   NAME
*	timeduration() -- Constructor of timeduration class (V33)
*
*   SYNOPSIS
*	td = timeduration(jd);
*
*	timeduration(float jd);
*
*   FUNCTION
*	Constructor of the timeduration class using the JD format.
*
*   INPUTS
*	jd - Timeduration in JD format
*
*   RESULT
*	td - Timeduration object
*
*   EXAMPLE
*	...
*	timeduration td(0.5);
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	timeduration(),Date/JDToTime()
*
******************************************************************************/

  {
   this->days = 0;
   JDToTime(jd,this->hours,this->mins,this->secs);
  }


 timeduration::timeduration(double jd)

/****** DateClass/timeduration/timeduration() *********************************
*
*   NAME
*	timeduration() -- Constructor of timeduration class (V33)
*
*   SYNOPSIS
*	td = timeduration(jd);
*
*	timeduration(double jd);
*
*   FUNCTION
*	Constructor of the timeduration class using the JD format.
*
*   INPUTS
*	jd - Timeduration in JD format
*
*   RESULT
*	td - Timeduration object
*
*   EXAMPLE
*	...
*	timeduration td(0.5);
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	timeduration(),Date/JDToTime()
*
******************************************************************************/

  {
   this->days = 0;
   JDToTime((float)jd,this->hours,this->mins,this->secs);
  }


 timeduration::timeduration(unsigned short hours, unsigned short mins, unsigned short secs)

/****** DateClass/timeduration/timeduration() *********************************
*
*   NAME
*	timeduration() -- Constructor of timeduration class (V33)
*
*   SYNOPSIS
*	td = timeduration(hours=0,mins=0,secs=0);
*
*	timeduration(unsigned short hours=0, unsigned short mins=0,
*	    unsigned short secs=0);
*
*   FUNCTION
*	Constructor of the timeduration class.
*
*   INPUTS
*	hours - Hours of a timeduration
*	mins  - Mins of a timeduration
*	secs  - Secs of a timeduration
*
*   RESULT
*	td - Timeduration object
*
*   EXAMPLE
*	...
*	timeduration td(2,30,0);
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	timeduration(),Date/SecToTime()
*
******************************************************************************/

  {
   this->days = 0;
   SecToTime(TimeToSec(hours,mins,secs),this->hours,this->mins,this->secs);
   while (this->hours >= 24)
    {
     this->hours -= 24;
     this->days++;
    }
  }


 bool timeduration::operator==(const timeduration &td) const

/****** DateClass/timeduration/operator==() ***********************************
*
*   NAME
*	operator==() -- Equal operator for timeduration objects (V33)
*
*   SYNOPSIS
*	compare = ((*this) == td);
*
*	bool operator==(const timeduration &td) const;
*
*   FUNCTION
*	Compares two timeduration objects for equality.
*
*   INPUTS
*	*this - timeduration object
*	td    - timeduration object
*
*   RESULT
*	compare - Boolean result of the equal compare operation
*
*   EXAMPLE
*	...
*	if (td1 == td2)
*	  printf("==\n");
*	else
*	  printf("!=\n");
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	operator!=(),operator<(),operator>(),operator<=(),operator>=(),
*	Date/Compare2Times()
*
******************************************************************************/

  {
   return(Compare2Times(this->hours,this->mins,this->secs,td.hours,td.mins,td.secs) == 0);
  }


 bool timeduration::operator!=(const timeduration &td) const

/****** DateClass/timeduration/operator!=() ***********************************
*
*   NAME
*	operator!=() -- Unequal operator for timeduration objects (V33)
*
*   SYNOPSIS
*	compare = ((*this) != td);
*
*	bool operator!=(const timeduration &td) const;
*
*   FUNCTION
*	Compares two timeduration objects for unequality.
*
*   INPUTS
*	*this - timeduration object
*	td    - timeduration object
*
*   RESULT
*	compare - Boolean result of the unequal compare operation
*
*   EXAMPLE
*	...
*	if (td1 != td2)
*	  printf("!=\n");
*	else
*	  printf("==\n");
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	operator==(),operator<(),operator>(),operator<=(),operator>=(),
*	Date/Compare2Times()
*
******************************************************************************/

  {
   return(Compare2Times(this->hours,this->mins,this->secs,td.hours,td.mins,td.secs) != 0);
  }


 bool timeduration::operator< (const timeduration &td) const

/****** DateClass/timeduration/operator<() ************************************
*
*   NAME
*	operator<() -- Lower than operator for timeduration objects (V33)
*
*   SYNOPSIS
*	compare = ((*this) < td);
*
*	bool operator<(const timeduration &td) const;
*
*   FUNCTION
*	Compares if timeduration object 1 is lower than timeduration object 2.
*
*   INPUTS
*	*this - timeduration object
*	td    - timeduration object
*
*   RESULT
*	compare - Boolean result of the lower than compare operation
*
*   EXAMPLE
*	...
*	if (td1 < td2)
*	  printf("<\n");
*	else
*	  printf(">=\n");
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	operator==(),operator!=(),operator>(),operator<=(),operator>=(),
*	Date/Compare2Times()
*
******************************************************************************/

  {
   return(Compare2Times(this->hours,this->mins,this->secs,td.hours,td.mins,td.secs) == -1);
  }


 bool timeduration::operator> (const timeduration &td) const

/****** DateClass/timeduration/operator>() ************************************
*
*   NAME
*	operator>() -- Greater than operator for timeduration objects (V33)
*
*   SYNOPSIS
*	compare = ((*this) > td);
*
*	bool operator>(const timeduration &td) const;
*
*   FUNCTION
*	Compares if timeduration object 1 is greater than timeduration
*	object 2.
*
*   INPUTS
*	*this - timeduration object
*	td    - timeduration object
*
*   RESULT
*	compare - Boolean result of the greater than compare operation
*
*   EXAMPLE
*	...
*	if (td1 > td2)
*	  printf(">\n");
*	else
*	  printf("<=\n");
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	operator==(),operator!=(),operator<(),operator<=(),operator>=(),
*	Date/Compare2Times()
*
******************************************************************************/

  {
   return(Compare2Times(this->hours,this->mins,this->secs,td.hours,td.mins,td.secs) == 1);
  }


 bool timeduration::operator<=(const timeduration &td) const

/****** DateClass/timeduration/operator<=()
*
*   NAME
*	operator<=() -- Lower or equal operator for timeduration objects (V33)
*
*   SYNOPSIS
*	compare = ((*this) <= td);
*
*	bool operator<=(const timeduration &td) const;
*
*   FUNCTION
*	Compares if timeduration object 1 is lower or equal than timeduration
*	object 2.
*
*   INPUTS
*	*this - timeduration object
*	td    - timeduration object
*
*   RESULT
*	compare - Boolean result of the lower or equal compare operation
*
*   EXAMPLE
*	...
*	if (td1 <= td2)
*	  printf("<=\n");
*	else
*	  printf(">\n");
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	operator==(),operator!=(),operator<(),operator>(),operator>=(),
*	Date/Compare2Times()
*
******************************************************************************/

  {
   return(Compare2Times(this->hours,this->mins,this->secs,td.hours,td.mins,td.secs) <= 0);
  }


 bool timeduration::operator>=(const timeduration &td) const

/****** DateClass/timeduration/operator>=() ***********************************
*
*   NAME
*	operator>=() -- Greater or equal operator for timeduration objs (V33)
*
*   SYNOPSIS
*	compare = ((*this) >= td);
*
*	bool operator>=(const timeduration &td) const;
*
*   FUNCTION
*	Compares if timeduration object 1 is greater or equal than timeduration
*	object 2.
*
*   INPUTS
*	*this - timeduration object
*	td    - timeduration object
*
*   RESULT
*	compare - Boolean result of the greater or equal compare operation
*
*   EXAMPLE
*	...
*	if (td1 >= td2)
*	  printf(">=\n");
*	else
*	  printf("<\n");
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	operator==(),operator!=(),operator<(),operator>(),operator<=(),
*	Date/Compare2Times()
*
******************************************************************************/

  {
   return(Compare2Times(this->hours,this->mins,this->secs,td.hours,td.mins,td.secs) >= 0);
  }


 timeduration timeduration::operator+(const timeduration &td) const

/****** DateClass/timeduration/operator+() ************************************
*
*   NAME
*	operator+() -- Add operator for timeduration objects (V33)
*
*   SYNOPSIS
*	tdres = (*this) + td;
*
*	timeduration operator+(const timeduration &td) const;
*
*   FUNCTION
*	Add two timeduration objects to a new timeduration object.
*
*   INPUTS
*	*this - timeduration object
*	td    - timeduration object
*
*   RESULT
*	tdres - new timeduration object
*
*   EXAMPLE
*	...
*	tdres = td1 + td2;
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	operator-(),operator+=(),operator-=(),timeduration(),Date/TimeToSec(),
*	Date/SecToTime()
*
******************************************************************************/

  {
   unsigned short days=0,hours,mins,secs;
   unsigned long hsecs = TimeToSec(this->hours,this->mins,this->secs) + TimeToSec(td.hours,td.mins,td.secs);

   SecToTime(hsecs,hours,mins,secs);
   while (hours >= 24)
    {
     hours -= 24;
     days++;
    }
   return(timeduration(days,hours,mins,secs));
  }


 timeduration timeduration::operator-(const timeduration &td) const

/****** DateClass/timeduration/operator-() ************************************
*
*   NAME
*	operator-() -- Sub operator for timeduration objects (V33)
*
*   SYNOPSIS
*	tdres = (*this) - td;
*
*	timeduration operator-(const timeduration &td) const;
*
*   FUNCTION
*	Difference between two timeduration objects to a new timeduration
*	object.
*
*   INPUTS
*	*this - timeduration object
*	td    - timeduration object
*
*   RESULT
*	tdres - new timeduration object
*
*   EXAMPLE
*	...
*	tdres = td1 - td2;
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	operator+(),operator+=(),operator-=(),timeduration(),Date/TimeDiff()
*	Date/SecToTime()
*
******************************************************************************/

  {
   unsigned short hours,mins,secs;
   long hsecs = TimeDiff(this->hours,this->mins,this->secs,td.hours,td.mins,td.secs);

   if (hsecs < 0)
     hsecs = -hsecs;
   SecToTime(hsecs,hours,mins,secs);
   return(timeduration(hours,mins,secs));
  }


 const timeduration &timeduration::operator+=(const timeduration &td)

/****** DateClass/timeduration/operator+=() ***********************************
*
*   NAME
*	operator+=() -- Add to operator for timeduration objects (V33)
*
*   SYNOPSIS
*	(*this) += td;
*
*	const timeduration &operator+=(const timeduration &td);
*
*   FUNCTION
*	Add timeduration object 2 to timeduration object 1.
*
*   INPUTS
*	*this - timeduration object
*	td    - timeduration object
*
*   RESULT
*	*this - modified timeduration object
*
*   EXAMPLE
*	...
*	td1 += td2;
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	operator+(),operator-(),operator-=(),Date/TimeToSec(),Date/SecToTime()
*
******************************************************************************/

  {
   unsigned long hsecs = TimeToSec(this->hours,this->mins,this->secs) + TimeToSec(td.hours,td.mins,td.secs);

   SecToTime(hsecs,this->hours,this->mins,this->secs);
   while (this->hours >= 24)
    {
     this->hours -= 24;
     this->days++;
    }
   return(*this);
  }


 const timeduration &timeduration::operator-=(const timeduration &td)

/****** DateClass/timeduration/operator-=() ***********************************
*
*   NAME
*	operator-=() -- Sub from operator for timeduration objects (V33)
*
*   SYNOPSIS
*	(*this) -= td;
*
*	const timeduration &operator-=(const timeduration &td);
*
*   FUNCTION
*	Difference between two timeduration objects.
*
*   INPUTS
*	*this - timeduration object
*	td    - timeduration object
*
*   RESULT
*	*this - modified timeduration object
*
*   EXAMPLE
*	...
*	td1 -= td2;
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	operator+(),operator-(),operator+=(),Date/TimeDiff(),Date/SecToTime()
*
******************************************************************************/

  {
   long hsecs = TimeDiff(this->hours,this->mins,this->secs,td.hours,td.mins,td.secs);

   if (hsecs < 0)
     hsecs = -hsecs;
   SecToTime(hsecs,this->hours,this->mins,this->secs);
   return(*this);
  }


 timeduration timeduration::operator*(const unsigned short tdm) const

/****** DateClass/timeduration/operator*() ************************************
*
*   NAME
*	operator*() -- Multiply operator for timeduration object (V33)
*
*   SYNOPSIS
*	tdres = (*this) * tdm;
*
*	timeduration operator*(const unsigned short tdm) const;
*
*   FUNCTION
*	Muliply the timeeduration object with a constant value to a new
*	timeduration object.
*
*   INPUTS
*	*this - timeduration object
*	tdm   - Multiplication factor
*
*   RESULT
*	tdres - new timeduration object
*
*   EXAMPLE
*	...
*	tdres = td * 2;
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	operator+(),operator-(),operator+=(),operator-=(),operator/(),
*	operator*=(),operator/=(),timeduration(),Date/TimeToSec(),
*	Date/SecToTime()
*
******************************************************************************/

  {
   unsigned short days=0,hours,mins,secs;
   unsigned long hsecs = TimeToSec(this->hours,this->mins,this->secs) * tdm;

   SecToTime(hsecs,hours,mins,secs);
   while (hours >= 24)
    {
     hours -= 24;
     days++;
    }
   return(timeduration(days,hours,mins,secs));
  }


 timeduration timeduration::operator*(const unsigned int tdm) const

/****** DateClass/timeduration/operator*() ************************************
*
*   NAME
*	operator*() -- Multiply operator for timeduration object (V33)
*
*   SYNOPSIS
*	tdres = (*this) * tdm;
*
*	timeduration operator*(const unsigned int tdm) const;
*
*   FUNCTION
*	Muliply the timeeduration object with a constant value to a new
*	timeduration object.
*
*   INPUTS
*	*this - timeduration object
*	tdm   - Multiplication factor
*
*   RESULT
*	tdres - new timeduration object
*
*   EXAMPLE
*	...
*	tdres = td * 2;
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	operator+(),operator-(),operator+=(),operator-=(),operator/(),
*	operator*=(),operator/=(),timeduration(),Date/TimeToSec(),
*	Date/SecToTime()
*
******************************************************************************/

  {
   unsigned short days=0,hours,mins,secs;
   unsigned long hsecs = TimeToSec(this->hours,this->mins,this->secs) * tdm;

   SecToTime(hsecs,hours,mins,secs);
   while (hours >= 24)
    {
     hours -= 24;
     days++;
    }
   return(timeduration(days,hours,mins,secs));
  }


 timeduration timeduration::operator*(const unsigned long tdm) const

/****** DateClass/timeduration/operator*() ************************************
*
*   NAME
*	operator*() -- Multiply operator for timeduration object (V33)
*
*   SYNOPSIS
*	tdres = (*this) * tdm;
*
*	timeduration operator*(const unsigned long tdm) const;
*
*   FUNCTION
*	Muliply the timeeduration object with a constant value to a new
*	timeduration object.
*
*   INPUTS
*	*this - timeduration object
*	tdm   - Multiplication factor
*
*   RESULT
*	tdres - new timeduration object
*
*   EXAMPLE
*	...
*	tdres = td * 2;
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	operator+(),operator-(),operator+=(),operator-=(),operator/(),
*	operator*=(),operator/=(),timeduration(),Date/TimeToSec(),
*	Date/SecToTime()
*
******************************************************************************/

  {
   unsigned short days=0,hours,mins,secs;
   unsigned long hsecs = TimeToSec(this->hours,this->mins,this->secs) * tdm;

   SecToTime(hsecs,hours,mins,secs);
   while (hours >= 24)
    {
     hours -= 24;
     days++;
    }
   return(timeduration(days,hours,mins,secs));
  }


 timeduration timeduration::operator/(const unsigned short tdd) const

/****** DateClass/timeduration/operator/() ************************************
*
*   NAME
*	operator/() -- Div operator for timeduration object (V33)
*
*   SYNOPSIS
*	tdres = (*this) / tdd;
*
*	timeduration operator/(const unsigned short tdd) const;
*
*   FUNCTION
*	Devide the timeeduration object by a constant value to a new
*	timeeduration object.
*	If tdd is 0 you will get back an object with a duration of 0!
*
*   INPUTS
*	*this - timeduration object
*	tdd   - Division factor
*
*   RESULT
*	tdres - new timeduration object
*
*   EXAMPLE
*	...
*	tdres = td / 2;
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	operator+(),operator-(),operator+=(),operator-=(),operator*(),
*	operator*=(),operator/=(),timeduration(),Date/TimeToSec(),
*	Date/SecToTime()
*
******************************************************************************/

  {
   if (tdd != 0)
    {
     unsigned short hours,mins,secs;
     unsigned long hsecs = TimeToSec(this->hours,this->mins,this->secs) / tdd;

     SecToTime(hsecs,hours,mins,secs);
     return(timeduration(days,hours,mins,secs));
    }
   else
     return(timeduration(0,0,0,0));
  }


 timeduration timeduration::operator/(const unsigned int tdd) const

/****** DateClass/timeduration/operator/() ************************************
*
*   NAME
*	operator/() -- Div operator for timeduration object (V33)
*
*   SYNOPSIS
*	tdres = (*this) / tdd;
*
*	timeduration operator/(const unsigned int tdd) const;
*
*   FUNCTION
*	Devide the timeeduration object by a constant value to a new
*	timeeduration object.
*	If tdd is 0 you will get back an object with a duration of 0!
*
*   INPUTS
*	*this - timeduration object
*	tdd   - Division factor
*
*   RESULT
*	tdres - new timeduration object
*
*   EXAMPLE
*	...
*	tdres = td / 2;
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	operator+(),operator-(),operator+=(),operator-=(),operator*(),
*	operator*=(),operator/=(),timeduration(),Date/TimeToSec(),
*	Date/SecToTime()
*
******************************************************************************/

  {
   if (tdd != 0)
    {
     unsigned short hours,mins,secs;
     unsigned long hsecs = TimeToSec(this->hours,this->mins,this->secs) / tdd;

     SecToTime(hsecs,hours,mins,secs);
     return(timeduration(days,hours,mins,secs));
    }
   else
     return(timeduration(0,0,0,0));
  }


 timeduration timeduration::operator/(const unsigned long tdd) const

/****** DateClass/timeduration/operator/() ************************************
*
*   NAME
*	operator/() -- Div operator for timeduration object (V33)
*
*   SYNOPSIS
*	tdres = (*this) / tdd;
*
*	timeduration operator/(const unsigned long tdd) const;
*
*   FUNCTION
*	Devide the timeeduration object by a constant value to a new
*	timeeduration object.
*	If tdd is 0 you will get back an object with a duration of 0!
*
*   INPUTS
*	*this - timeduration object
*	tdd   - Division factor
*
*   RESULT
*	tdres - new timeduration object
*
*   EXAMPLE
*	...
*	tdres = td / 2;
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	operator+(),operator-(),operator+=(),operator-=(),operator*(),
*	operator*=(),operator/=(),timeduration(),Date/TimeToSec(),
*	Date/SecToTime()
*
******************************************************************************/

  {
   if (tdd != 0)
    {
     unsigned short hours,mins,secs;
     unsigned long hsecs = TimeToSec(this->hours,this->mins,this->secs) / tdd;

     SecToTime(hsecs,hours,mins,secs);
     return(timeduration(days,hours,mins,secs));
    }
   else
     return(timeduration(0,0,0,0));
  }


 const timeduration &timeduration::operator*=(const unsigned short tdm)

/****** DateClass/timeduration/operator*=() ***********************************
*
*   NAME
*	operator*=() -- Multiply with operator for timeduration object (V33)
*
*   SYNOPSIS
*	(*this) *= tdm;
*
*	const timeduration &operator*=(const unsigned short tdm);
*
*   FUNCTION
*	Muliply the timeduration object with a constant value.
*
*   INPUTS
*	*this - timeduration object
*	tdm   - Multiplication factor
*
*   RESULT
*	*this - Modified timeduration object
*
*   EXAMPLE
*	...
*	td *= 2;
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	operator+(),operator-(),operator+=(),operator-=(),operator*(),
*	operator/(),operator/=(),Date/TimeToSec(),Date/SecToTime()
*
******************************************************************************/

  {
   unsigned long hsecs = TimeToSec(this->hours,this->mins,this->secs) * tdm;

   SecToTime(hsecs,this->hours,this->mins,this->secs);
   while (this->hours >= 24)
    {
     this->hours -= 24;
     this->days++;
    }
   return(*this);
  }


 const timeduration &timeduration::operator*=(const unsigned int tdm)

/****** DateClass/timeduration/operator*=() ***********************************
*
*   NAME
*	operator*=() -- Multiply with operator for timeduration object (V33)
*
*   SYNOPSIS
*	(*this) *= tdm;
*
*	const timeduration &operator*=(const unsigned int tdm);
*
*   FUNCTION
*	Muliply the timeduration object with a constant value.
*
*   INPUTS
*	*this - timeduration object
*	tdm   - Multiplication factor
*
*   RESULT
*	*this - Modified timeduration object
*
*   EXAMPLE
*	...
*	td *= 2;
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	operator+(),operator-(),operator+=(),operator-=(),operator*(),
*	operator/(),operator/=(),Date/TimeToSec(),Date/SecToTime()
*
******************************************************************************/

  {
   unsigned long hsecs = TimeToSec(this->hours,this->mins,this->secs) * tdm;

   SecToTime(hsecs,this->hours,this->mins,this->secs);
   while (this->hours >= 24)
    {
     this->hours -= 24;
     this->days++;
    }
   return(*this);
  }


 const timeduration &timeduration::operator*=(const unsigned long tdm)

/****** DateClass/timeduration/operator*=() ***********************************
*
*   NAME
*	operator*=() -- Multiply with operator for timeduration object (V33)
*
*   SYNOPSIS
*	(*this) *= tdm;
*
*	const timeduration &operator*=(const unsigned long tdm);
*
*   FUNCTION
*	Muliply the timeduration object with a constant value.
*
*   INPUTS
*	*this - timeduration object
*	tdm   - Multiplication factor
*
*   RESULT
*	*this - Modified timeduration object
*
*   EXAMPLE
*	...
*	td *= 2;
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	operator+(),operator-(),operator+=(),operator-=(),operator*(),
*	operator/(),operator/=(),Date/TimeToSec(),Date/SecToTime()
*
******************************************************************************/

  {
   unsigned long hsecs = TimeToSec(this->hours,this->mins,this->secs) * tdm;

   SecToTime(hsecs,this->hours,this->mins,this->secs);
   while (this->hours >= 24)
    {
     this->hours -= 24;
     this->days++;
    }
   return(*this);
  }


 const timeduration &timeduration::operator/=(const unsigned short tdd)

/****** DateClass/timeduration/operator/=() ***********************************
*
*   NAME
*	operator/=() -- Div through operator for timeduration object (V33)
*
*   SYNOPSIS
*	(*this) /= tdd;
*
*	const timeduration &operator/=(const unsigned short tdd);
*
*   FUNCTION
*	Devide the timeduration object by a constant value.
*	If tdd is 0 you will get back an object with a duration of 0!
*
*   INPUTS
*	*this - timeduration object
*	tdd   - Division factor
*
*   RESULT
*	*this - Modified timeduration object
*
*   EXAMPLE
*	...
*	td /= 2;
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	operator+(),operator-(),operator+=(),operator-=(),operator*(),
*	operator/(),operator*=(),Date/TimeToSec(),Date/SecToTime()
*
******************************************************************************/

  {
   if (tdd != 0)
    {
     unsigned long hsecs = TimeToSec(this->hours,this->mins,this->secs) / tdd;

     SecToTime(hsecs,this->hours,this->mins,this->secs);
    }
   else
    {
     this->days = 0;
     this->hours = 0;
     this->mins = 0;
     this->secs = 0;
    }
   return(*this);
  }


 const timeduration &timeduration::operator/=(const unsigned int tdd)

/****** DateClass/timeduration/operator/=() ***********************************
*
*   NAME
*	operator/=() -- Div through operator for timeduration object (V33)
*
*   SYNOPSIS
*	(*this) /= tdd;
*
*	const timeduration &operator/=(const unsigned int tdd);
*
*   FUNCTION
*	Devide the timeduration object by a constant value.
*	If tdd is 0 you will get back an object with a duration of 0!
*
*   INPUTS
*	*this - timeduration object
*	tdd   - Division factor
*
*   RESULT
*	*this - Modified timeduration object
*
*   EXAMPLE
*	...
*	td /= 2;
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	operator+(),operator-(),operator+=(),operator-=(),operator*(),
*	operator/(),operator*=(),Date/TimeToSec(),Date/SecToTime()
*
******************************************************************************/

  {
   if (tdd != 0)
    {
     unsigned long hsecs = TimeToSec(this->hours,this->mins,this->secs) / tdd;

     SecToTime(hsecs,this->hours,this->mins,this->secs);
    }
   else
    {
     this->days = 0;
     this->hours = 0;
     this->mins = 0;
     this->secs = 0;
    }
   return(*this);
  }


 const timeduration &timeduration::operator/=(const unsigned long tdd)

/****** DateClass/timeduration/operator/=() ***********************************
*
*   NAME
*	operator/=() -- Div through operator for timeduration object (V33)
*
*   SYNOPSIS
*	(*this) /= tdd;
*
*	const timeduration &operator/=(const unsigned long tdd);
*
*   FUNCTION
*	Devide the timeduration object by a constant value.
*	If tdd is 0 you will get back an object with a duration of 0!
*
*   INPUTS
*	*this - timeduration object
*	tdd   - Division factor
*
*   RESULT
*	*this - Modified timeduration object
*
*   EXAMPLE
*	...
*	td /= 2;
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	operator+(),operator-(),operator+=(),operator-=(),operator*(),
*	operator/(),operator*=(),Date/TimeToSec(),Date/SecToTime()
*
******************************************************************************/

  {
   if (tdd != 0)
    {
     unsigned long hsecs = TimeToSec(this->hours,this->mins,this->secs) / tdd;

     SecToTime(hsecs,this->hours,this->mins,this->secs);
    }
   else
    {
     this->days = 0;
     this->hours = 0;
     this->mins = 0;
     this->secs = 0;
    }
   return(*this);
  }


 unsigned long timeduration::operator/(const timeduration &td) const

/****** DateClass/timeduration/operator/() ************************************
*
*   NAME
*	operator/() -- Div operator for timeduration object (V33)
*
*   SYNOPSIS
*	tdf = (*this) / td;
*
*	unsigned long operator/(const timeduration &td) const;
*
*   FUNCTION
*	Devide the timeduration object by another timeduration object
*	to the devision factor.
*
*   INPUTS
*	*this - timeduration object
*	td    - timeduration object
*
*   RESULT
*	tdf - Devision factor
*
*   EXAMPLE
*	...
*	tdf = td1 / td2;
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	operator+(),operator-(),operator+=(),operator-=(),operator*(),
*	operator*=(),operator/=(),operator%(),Date/TimeToSec()
*
******************************************************************************/

  {
   if ((*this) >= td)
     return(TimeToSec(this->hours,this->mins,this->secs) / TimeToSec(td.hours,td.mins,td.secs));
   else
     return(TimeToSec(td.hours,td.mins,td.secs) / TimeToSec(this->hours,this->mins,this->secs));
  }


 unsigned long timeduration::operator%(const timeduration &td) const

/****** DateClass/timeduration/operator%() ************************************
*
*   NAME
*	operator%() -- Modulo operator for timeduration object (V33)
*
*   SYNOPSIS
*	tdf = (*this) % td;
*
*	unsigned long operator%(const timeduration &td) const;
*
*   FUNCTION
*	Modulo devide the timeduration object by another timeduration object
*	to the modulo factor.
*
*   INPUTS
*	*this - timeduration object
*	td    - timeduration object
*
*   RESULT
*	tdf - Modulo factor
*
*   EXAMPLE
*	...
*	tdf = td1 % td2;
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	operator+(),operator-(),operator+=(),operator-=(),operator*(),
*	operator/(),operator*=(),operator/=(),Date/TimeToSec()
*
******************************************************************************/

  {
   if ((*this) >= td)
     return(TimeToSec(this->hours,this->mins,this->secs) % TimeToSec(td.hours,td.mins,td.secs));
   else
     return(TimeToSec(td.hours,td.mins,td.secs) % TimeToSec(this->hours,this->mins,this->secs));
  }


 unsigned short timeduration::gethours(void) const

/****** DateClass/timeduration/gethours() *************************************
*
*   NAME
*	gethours() -- Get hours of timeduration object (V33)
*
*   SYNOPSIS
*	hours = (*this).gethours();
*
*	unsigned short gethours(void) const;
*
*   FUNCTION
*	Gets the number of hours from the timeduration object.
*
*   INPUTS
*	*this - timeduration object
*
*   RESULT
*	hours - Hours of the timeduration object
*
*   EXAMPLE
*	...
*	hours = td.gethours();
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	getmins(),getsecs(),getinsecs()
*
******************************************************************************/

  {
   return(this->hours);
  }


 unsigned short timeduration::getmins(void) const

/****** DateClass/timeduration/getmins() **************************************
*
*   NAME
*	getmins() -- Get mins of timeduration object (V33)
*
*   SYNOPSIS
*	mins = (*this).getmins();
*
*	unsigned short getmins(void) const;
*
*   FUNCTION
*	Gets the number of minutes from the timeduration object.
*
*   INPUTS
*	*this - timeduration object
*
*   RESULT
*	mins - Minutes of the timeduration object
*
*   EXAMPLE
*	...
*	mins = td.getmins();
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	gethours(),getsecs(),getinsecs()
*
******************************************************************************/

  {
   return(this->mins);
  }


 unsigned short timeduration::getsecs(void) const

/****** DateClass/timeduration/getsecs() **************************************
*
*   NAME
*	getsecs() -- Get secs of timeduration object (V33)
*
*   SYNOPSIS
*	secs = (*this).getsecs();
*
*	unsigned short getsecs(void) const;
*
*   FUNCTION
*	Gets the number of seconds from the timeduration object.
*
*   INPUTS
*	*this - timeduration object
*
*   RESULT
*	secs - Seconds of the timeduration object
*
*   EXAMPLE
*	...
*	secs = td.getsecs();
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	gethours(),getmins(),getinsecs()
*
******************************************************************************/

  {
   return(this->secs);
  }


 unsigned long timeduration::getinsecs(void) const

/****** DateClass/timeduration/getinsecs() ************************************
*
*   NAME
*	getinsecs() -- Get timeduration in secs of timeduration object (V33)
*
*   SYNOPSIS
*	secs = (*this).getinsecs();
*
*	unsigned long getinsecs(void) const;
*
*   FUNCTION
*	Gets duration of the timeduration object in seconds.
*
*   INPUTS
*	*this - timeduration object
*
*   RESULT
*	secs - Timeduration of the timeduration object in seconds.
*
*   EXAMPLE
*	...
*	secs = td.getinsecs();
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	gethours(),getmins(),getsecs(),Date/TimeToSec()
*
******************************************************************************/

  {
   return(TimeToSec(this->hours,this->mins,this->secs));
  }

 /* --- dateduration ------------------------------------------------------ */

/****** DateClass/dateduration ************************************************
*
*   NAME
*	dateduration -- Class for date durations (V33)
*
*   FUNCTION
*	This class maps the concept of date durations.
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	timeduration,time,date
*
******************************************************************************/

/****i* DateClass/dateduration/struct dateduration ****************************
*
*   NAME
*	struct dateduration -- Private structure of dateduration class (V33)
*
*   SYNOPSIS
*	struct dateduration {
*			     unsigned long days;
*			     unsigned short months,years;
*			    };
*
*   FUNCTION
*	This structure holds the data of a date duration.
*
*   ELEMENTS
*	days   - Number of days in a date duration.
*	months - Number of months in a date duration.
*	years  - Number of years in a date duration.
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	dateduration(),operator==(),operator!=(),operator<(),operator>(),
*	operator<=(),operator>=(),operator++(),operator++(int),operator--(),
*	operator--(int),operator+(),operator-(),operator+=(),operator-=(),
*	operator*(),operator/(),operator*=(),operator/(),getdays(),getmonths(),
*	getyears(),getindays(),date
*
******************************************************************************/


 dateduration::dateduration(unsigned long days, unsigned short months, unsigned short years)

/****** DateClass/dateduration/dateduration() *********************************
*
*   NAME
*	dateduration() -- Constructor of dateduration class (V33)
*
*   SYNOPSIS
*	dd = dateduration(days=0,months=0,years=0);
*
*	dateduration(unsigned long days=0, unsigned short months=0,
*	    unsigned short years=0);
*
*   FUNCTION
*	Constructor of the dateduration class.
*
*   INPUTS
*	days   - Days of a dateduration
*	months - Months of a dateduration
*	years  - Years of a dateduration
*
*   RESULT
*	dd - Dateduration object
*
*   EXAMPLE
*	...
*	dateduration dd1(14,0,0);
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*
*
******************************************************************************/

  {
   this->days = days;
   this->months = months;
   this->years = years;
  }


 bool dateduration::operator==(const dateduration &dd) const

/****** DateClass/dateduration/operator==() ***********************************
*
*   NAME
*	operator==() -- Equal operator for dateduration objects (V33)
*
*   SYNOPSIS
*	compare = ((*this) == dd);
*
*	bool operator==(const dateduration &dd) const;
*
*   FUNCTION
*	Compares two dateduration objects for equality.
*
*   INPUTS
*	*this - dateduration object
*	dd    - dateduration object
*
*   RESULT
*	compare - Boolean result of the equal compare operation
*
*   EXAMPLE
*	...
*	if (dd1 == dd2)
*	  printf("==\n");
*	else
*	  printf("!=\n");
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	operator!=(),operator<(),operator>(),operator<=(),operator>=()
*
******************************************************************************/

  {
   return((this->days == dd.days) && (this->months == dd.months) && (this->years == dd.years));
  }


 bool dateduration::operator!=(const dateduration &dd) const

/****** DateClass/dateduration/operator!=() ***********************************
*
*   NAME
*	operator!=() -- Unequal operator for dateduration objects (V33)
*
*   SYNOPSIS
*	compare = ((*this) != dd);
*
*	bool operator!=(const dateduration &dd) const;
*
*   FUNCTION
*	Compares two dateduration objects for unequality.
*
*   INPUTS
*	*this - dateduration object
*	dd    - dateduration object
*
*   RESULT
*	compare - Boolean result of the unequal compare operation
*
*   EXAMPLE
*	...
*	if (dd1 != dd2)
*	  printf("!=\n");
*	else
*	  printf("==\n");
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	operator==(),operator<(),operator>(),operator<=(),operator>=()
*
******************************************************************************/

  {
   return((this->days != dd.days) || (this->months != dd.months) || (this->years != dd.years));
  }


 bool dateduration::operator< (const dateduration &dd) const

/****** DateClass/dateeduration/operator<() ***********************************
*
*   NAME
*	operator<() -- Lower than operator for dateduration objects (V33)
*
*   SYNOPSIS
*	compare = ((*this) < dd);
*
*	bool operator<(const dateduration &dd) const;
*
*   FUNCTION
*	Compares if dateduration object 1 is lower than dateduration object 2.
*
*   INPUTS
*	*this - dateduration object
*	dd    - dateduration object
*
*   RESULT
*	compare - Boolean result of the lower than compare operation
*
*   EXAMPLE
*	...
*	if (dd1 < dd2)
*	  printf("<\n");
*	else
*	  printf(">=\n");
*	...
*
*   NOTES
*	A month will be calculated as 30 days, a year as 365 days.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	operator==(),operator!=(),operator>(),operator<=(),operator>=()
*
******************************************************************************/

  {
   return((this->days + this->months*30 + this->years*365) < (dd.days + dd.months*30 + dd.years*365));
  }


 bool dateduration::operator> (const dateduration &dd) const

/****** DateClass/dateduration/operator>() ************************************
*
*   NAME
*	operator>() -- Greater than operator for dateduration objects (V33)
*
*   SYNOPSIS
*	compare = ((*this) > dd);
*
*	bool operator>(const dateduration &dd) const;
*
*   FUNCTION
*	Compares if dateduration object 1 is greater than dateduration
*	object 2.
*
*   INPUTS
*	*this - dateduration object
*	dd    - dateduration object
*
*   RESULT
*	compare - Boolean result of the greater than compare operation
*
*   EXAMPLE
*	...
*	if (dd1 > dd2)
*	  printf(">\n");
*	else
*	  printf("<=\n");
*	...
*
*   NOTES
*	A month will be calculated as 30 days, a year as 365 days.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	operator==(),operator!=(),operator<(),operator<=(),operator>=()
*
******************************************************************************/

  {
   return((this->days + this->months*30 + this->years*365) > (dd.days + dd.months*30 + dd.years*365));
  }


 bool dateduration::operator<=(const dateduration &dd) const

/****** DateClass/dateduration/operator<=() ***********************************
*
*   NAME
*	operator<=() -- Lower or equal operator for dateduration objects (V33)
*
*   SYNOPSIS
*	compare = ((*this) <= dd);
*
*	bool operator<=(const dateduration &dd) const;
*
*   FUNCTION
*	Compares if dateduration object 1 is lower or equal than dateduration
*	object 2.
*
*   INPUTS
*	*this - dateduration object
*	dd    - dateduration object
*
*   RESULT
*	compare - Boolean result of the lower or equal compare operation
*
*   EXAMPLE
*	...
*	if (dd1 <= dd2)
*	  printf("<=\n");
*	else
*	  printf(">\n");
*	...
*
*   NOTES
*	A month will be calculated as 30 days, a year as 365 days.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	operator==(),operator!=(),operator<(),operator>(),operator>=()
*
******************************************************************************/

  {
   return((this->days + this->months*30 + this->years*365) <= (dd.days + dd.months*30 + dd.years*365));
  }


 bool dateduration::operator>=(const dateduration &dd) const

/****** DateClass/dateduration/operator>=() ***********************************
*
*   NAME
*	operator>=() -- Greater or equal operator for dateduration objs (V33)
*
*   SYNOPSIS
*	compare = ((*this) >= dd);
*
*	bool operator>=(const dateduration &dd) const;
*
*   FUNCTION
*	Compares if dateduration object 1 is greater or equal than dateduration
*	object 2.
*
*   INPUTS
*	*this - dateduration object
*	dd    - dateduration object
*
*   RESULT
*	compare - Boolean result of the greater or equal compare operation
*
*   EXAMPLE
*	...
*	if (dd1 >= dd2)
*	  printf(">=\n");
*	else
*	  printf("<\n");
*	...
*
*   NOTES
*	A month will be calculated as 30 days, a year as 365 days.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	operator==(),operator!=(),operator<(),operator>(),operator<=()
*
******************************************************************************/

  {
   return((this->days + this->months*30 + this->years*365) >= (dd.days + dd.months*30 + dd.years*365));
  }


 dateduration dateduration::operator++()

/****** DateClass/dateduration/operator++() ***********************************
*
*   NAME
*	operator++() -- Increment operator for dateduration object (V33)
*
*   SYNOPSIS
*	dd++;
*
*	dateduration operator++();
*
*   FUNCTION
*	Increments the dateduration object by one day.
*
*   INPUTS
*	*this - dateduration object
*
*   RESULT
*	*this - modified dateduration object
*
*   EXAMPLE
*	...
*	dd++;
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	operator++(int),operator--(),operator--(int)
*
******************************************************************************/

  {
   dateduration tmp = *this;

   this->days++;
   return(tmp);
  }


 dateduration dateduration::operator++(int)

/****** DateClass/dateduration/operator++(int) ********************************
*
*   NAME
*	operator++() -- Increment operator for dateduration object (V33)
*
*   SYNOPSIS
*	++dd;
*
*	dateduration operator++(int);
*
*   FUNCTION
*	Increments the dateduration object by one day.
*
*   INPUTS
*	*this - dateduration object
*
*   RESULT
*	*this - modified dateduration object
*
*   EXAMPLE
*	...
*	++dd;
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	operator++(),operator--(),operator--(int)
*
******************************************************************************/

  {
   this->days++;
   return(*this);
  }


 dateduration dateduration::operator--()

/****** DateClass/dateduration/operator--() ***********************************
*
*   NAME
*	operator--() -- Decrement operator for dateduration object (V33)
*
*   SYNOPSIS
*	dd--;
*
*	dateduration operator--();
*
*   FUNCTION
*	Decrements the dateduration object by one day.
*
*   INPUTS
*	*this - dateduration object
*
*   RESULT
*	*this - modified dateduration object
*
*   EXAMPLE
*	...
*	dd--;
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	operator++(),operator++(int),operator--(int)
*
******************************************************************************/

  {
   dateduration tmp = *this;

   if (this->days > 0)
     this->days--;
   return(tmp);
  }


 dateduration dateduration::operator--(int)

/****** DateClass/dateduration/operator--(int) ********************************
*
*   NAME
*	operator--() -- Decrement operator for dateduration object (V33)
*
*   SYNOPSIS
*	--dd;
*
*	dateduration operator--(int);
*
*   FUNCTION
*	Decrements the dateduration object by one day.
*
*   INPUTS
*	*this - dateduration object
*
*   RESULT
*	*this - modified dateduration object
*
*   EXAMPLE
*	...
*	--dd;
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	operator++(),operator++(int),operator--()
*
******************************************************************************/

  {
   if (this->days > 0)
     this->days--;
   return(*this);
  }


 dateduration dateduration::operator+(const dateduration &dd) const

/****** DateClass/dateduration/operator+() ************************************
*
*   NAME
*	operator+() -- Add operator for dateduration objects (V33)
*
*   SYNOPSIS
*	ddres = (*this) + dd;
*
*	dateduration operator+(const dateduration &dd) const;
*
*   FUNCTION
*	Add two dateduration objects to a new dateduration object.
*
*   INPUTS
*	*this - dateduration object
*	dd    - dateduration object
*
*   RESULT
*	ddres - new dateduration object
*
*   EXAMPLE
*	...
*	ddres = dd1 + dd2;
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	operator-(),operator+=(),operator-=(),operator*(),operator/(),
*	operator*=(),operator/=(),dateduration()
*
******************************************************************************/

  {
   return(dateduration(this->days+dd.days,this->months+dd.months,this->years+dd.years));
  }


 dateduration dateduration::operator-(const dateduration &dd) const

/****** DateClass/dateduration/operator-() ************************************
*
*   NAME
*	operator-() -- Sub operator for dateduration objects (V33)
*
*   SYNOPSIS
*	ddres = (*this) - dd;
*
*	dateduration operator-(const dateduration &dd) const;
*
*   FUNCTION
*	Subtract dateduration object 2 from dateduration object 1 to a new
*	dateduration object.
*	If object 2 is greater than object 1 you get back an object with a
*	duration of 0!
*
*   INPUTS
*	*this - dateduration object
*	dd    - dateduration object
*
*   RESULT
*	ddres - new dateduration object
*
*   EXAMPLE
*	...
*	ddres = dd1 - dd2;
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	operator+(),operator+=(),operator-=(),operator*(),operator/(),
*	operator*=(),operator/=(),dateduration()
*
******************************************************************************/

  {
   if ((this->days < dd.days) || (this->months < dd.months) || (this->years < dd.years))
     return(dateduration(0,0,0));
   else
     return(dateduration(this->days-dd.days,this->months-dd.months,this->years-dd.years));
  }


 const dateduration &dateduration::operator+=(const dateduration &dd)

/****** DateClass/dateduration/operator+=() ***********************************
*
*   NAME
*	operator+=() -- Add to operator for dateduration objects (V33)
*
*   SYNOPSIS
*	(*this) += dd;
*
*	const dateduration &operator+=(const dateduration &dd);
*
*   FUNCTION
*	Add dateduration object 2 to dateduration object 1.
*
*   INPUTS
*	*this - dateduration object
*	dd    - dateduration object
*
*   RESULT
*	*this - modified dateduration object
*
*   EXAMPLE
*	...
*	dd1 += dd2;
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	operator+(),operator-(),operator-=(),operator*(),operator/(),
*	operator*=(),operator/=()
*
******************************************************************************/

  {
   this->days += dd.days;
   this->months += dd.months;
   this->years += dd.years;
   return(*this);
  }


 const dateduration &dateduration::operator-=(const dateduration &dd)

/****** DateClass/dateduration/operator-=() ***********************************
*
*   NAME
*	operator-=() -- Sub from operator for dateduration objects (V33)
*
*   SYNOPSIS
*	(*this) -= dd;
*
*	const dateduration &operator-=(const dateduration &dd);
*
*   FUNCTION
*	Subtract dateduration object 2 from dateduration object 1.
*	If object 2 is greater than object 1 you get back an object with a
*	duration of 0!
*
*   INPUTS
*	*this - dateduration object
*	dd    - dateduration object
*
*   RESULT
*	*this - modified dateduration object
*
*   EXAMPLE
*	...
*	dd1 -= dd2;
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	operator+(),operator-(),operator+=(),operator*(),operator/(),
*	operator*=(),operator/=()
*
******************************************************************************/

  {
   if ((this->days < dd.days) || (this->months < dd.months) || (this->years < dd.years))
    {
     this->days = 0;
     this->months = 0;
     this->years = 0;
    }
   else
    {
     this->days -= dd.days;
     this->months -= dd.months;
     this->years -= dd.years;
    }
   return(*this);
  }


 dateduration dateduration::operator*(const unsigned short ddm) const

/****** DateClass/dateduration/operator*() ************************************
*
*   NAME
*	operator*() -- Multiply operator for dateduration object (V33)
*
*   SYNOPSIS
*	ddres = (*this) * ddm;
*
*	dateduration operator*(const unsigned short ddm) const;
*
*   FUNCTION
*	Muliply the dateduration object with a constant value to a new
*	dateduration object.
*
*   INPUTS
*	*this - dateduration object
*	ddm   - Multiplication factor
*
*   RESULT
*	ddres - New dateduration object
*
*   EXAMPLE
*	...
*	ddres = dd * 2;
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	operator+(),operator-(),operator+=(),operator-=(),operator/(),
*	operator*=(),operator/=(),dateduration()
*
******************************************************************************/

  {
   return(dateduration(this->days*ddm,this->months*ddm,this->years*ddm));
  }


 dateduration dateduration::operator*(const unsigned int ddm) const

/****** DateClass/dateduration/operator*() ************************************
*
*   NAME
*	operator*() -- Multiply operator for dateduration object (V33)
*
*   SYNOPSIS
*	ddres = (*this) * ddm;
*
*	dateduration operator*(const unsigned int ddm) const;
*
*   FUNCTION
*	Muliply the dateduration object with a constant value to a new
*	dateduration object.
*
*   INPUTS
*	*this - dateduration object
*	ddm   - Multiplication factor
*
*   RESULT
*	ddres - New dateduration object
*
*   EXAMPLE
*	...
*	ddres = dd * 2;
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	operator+(),operator-(),operator+=(),operator-=(),operator/(),
*	operator*=(),operator/=(),dateduration()
*
******************************************************************************/

  {
   return(dateduration(this->days*ddm,this->months*ddm,this->years*ddm));
  }


 dateduration dateduration::operator*(const unsigned long ddm) const

/****** DateClass/dateduration/operator*() ************************************
*
*   NAME
*	operator*() -- Multiply operator for dateduration object (V33)
*
*   SYNOPSIS
*	ddres = (*this) * ddm;
*
*	dateduration operator*(const unsigned long ddm) const;
*
*   FUNCTION
*	Muliply the dateduration object with a constant value to a new
*	dateduration object.
*
*   INPUTS
*	*this - dateduration object
*	ddm   - Multiplication factor
*
*   RESULT
*	ddres - New dateduration object
*
*   EXAMPLE
*	...
*	ddres = dd * 2;
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	operator+(),operator-(),operator+=(),operator-=(),operator/(),
*	operator*=(),operator/=(),dateduration()
*
******************************************************************************/

  {
   return(dateduration(this->days*ddm,(short)(this->months*ddm),(short)(this->years*ddm)));
  }


 dateduration dateduration::operator/(const unsigned short ddd) const

/****** DateClass/dateduration/operator/() ************************************
*
*   NAME
*	operator/() -- Div operator for dateduration object (V33)
*
*   SYNOPSIS
*	ddres = (*this) / ddd;
*
*	dateduration operator/(const unsigned short ddd) const;
*
*   FUNCTION
*	Devide the dateduration object by a constant value to a new
*	dateduration object.
*	If ddd is 0 you will get back an object with a duration of 0!
*
*   INPUTS
*	*this - dateduration object
*	ddd   - Division factor
*
*   RESULT
*	ddres - New dateduration object
*
*   EXAMPLE
*	...
*	ddres = dd / 2;
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	operator+(),operator-(),operator+=(),operator-=(),operator*(),
*	operator*=(),operator/=(),dateduration()
*
******************************************************************************/

  {
   if (ddd != 0)
     return(dateduration(this->days/ddd,this->months/ddd,this->years/ddd));
   else
     return(dateduration(0,0,0));
  }


 dateduration dateduration::operator/(const unsigned int ddd) const

/****** DateClass/dateduration/operator/() ************************************
*
*   NAME
*	operator/() -- Div operator for dateduration object (V33)
*
*   SYNOPSIS
*	ddres = (*this) / ddd;
*
*	dateduration operator/(const unsigned int ddd) const;
*
*   FUNCTION
*	Devide the dateduration object by a constant value to a new
*	dateduration object.
*	If ddd is 0 you will get back an object with a duration of 0!
*
*   INPUTS
*	*this - dateduration object
*	ddd   - Division factor
*
*   RESULT
*	ddres - New dateduration object
*
*   EXAMPLE
*	...
*	ddres = dd / 2;
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	operator+(),operator-(),operator+=(),operator-=(),operator*(),
*	operator*=(),operator/=(),dateduration()
*
******************************************************************************/

  {
   if (ddd != 0)
     return(dateduration(this->days/ddd,this->months/ddd,this->years/ddd));
   else
     return(dateduration(0,0,0));
  }


 dateduration dateduration::operator/(const unsigned long ddd) const

/****** DateClass/dateduration/operator/() ************************************
*
*   NAME
*	operator/() -- Div operator for dateduration object (V33)
*
*   SYNOPSIS
*	ddres = (*this) / ddd;
*
*	dateduration operator/(const unsigned long ddd) const;
*
*   FUNCTION
*	Devide the dateduration object by a constant value to a new
*	dateduration object.
*	If ddd is 0 you will get back an object with a duration of 0!
*
*   INPUTS
*	*this - dateduration object
*	ddd   - Division factor
*
*   RESULT
*	ddres - New dateduration object
*
*   EXAMPLE
*	...
*	ddres = dd / 2;
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	operator+(),operator-(),operator+=(),operator-=(),operator*(),
*	operator*=(),operator/=(),dateduration()
*
******************************************************************************/

  {
   if (ddd != 0)
     return(dateduration(this->days/ddd,(short)(this->months/ddd),(short)(this->years/ddd)));
   else
     return(dateduration(0,0,0));
  }


 const dateduration &dateduration::operator*=(const unsigned short ddm)

/****** DateClass/dateduration/operator*=() ***********************************
*
*   NAME
*	operator*=() -- Multiply with operator for dateduration object (V33)
*
*   SYNOPSIS
*	(*this) *= ddm;
*
*	const dateduration &operator*=(const unsigned short ddm);
*
*   FUNCTION
*	Muliply the dateduration object with a constant value.
*
*   INPUTS
*	*this - dateduration object
*	ddm   - Multiplication factor
*
*   RESULT
*	*this - Modified dateduration object
*
*   EXAMPLE
*	...
*	dd *= 2;
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	operator+(),operator-(),operator+=(),operator-=(),operator*(),
*	operator/(),operator/=()
*
******************************************************************************/

  {
   this->days *= ddm;
   this->months *= ddm;
   this->years *= ddm;
   return(*this);
  }


 const dateduration &dateduration::operator*=(const unsigned int ddm)

/****** DateClass/dateduration/operator*=() ***********************************
*
*   NAME
*	operator*=() -- Multiply with operator for dateduration object (V33)
*
*   SYNOPSIS
*	(*this) *= ddm;
*
*	const dateduration &operator*=(const unsigned int ddm);
*
*   FUNCTION
*	Muliply the dateduration object with a constant value.
*
*   INPUTS
*	*this - dateduration object
*	ddm   - Multiplication factor
*
*   RESULT
*	*this - Modified dateduration object
*
*   EXAMPLE
*	...
*	dd *= 2;
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	operator+(),operator-(),operator+=(),operator-=(),operator*(),
*	operator/(),operator/=()
*
******************************************************************************/

  {
   this->days *= ddm;
   this->months *= ddm;
   this->years *= ddm;
   return(*this);
  }


 const dateduration &dateduration::operator*=(const unsigned long ddm)

/****** DateClass/dateduration/operator*=() ***********************************
*
*   NAME
*	operator*=() -- Multiply with operator for dateduration object (V33)
*
*   SYNOPSIS
*	(*this) *= ddm;
*
*	const dateduration &operator*=(const unsigned long ddm);
*
*   FUNCTION
*	Muliply the dateduration object with a constant value.
*
*   INPUTS
*	*this - dateduration object
*	ddm   - Multiplication factor
*
*   RESULT
*	*this - Modified dateduration object
*
*   EXAMPLE
*	...
*	dd *= 2;
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	operator+(),operator-(),operator+=(),operator-=(),operator*(),
*	operator/(),operator/=()
*
******************************************************************************/

  {
   this->days *= ddm;
   this->months *= (int)ddm;
   this->years *= (int)ddm;
   return(*this);
  }


 const dateduration &dateduration::operator/=(const unsigned short ddd)

/****** DateClass/dateduration/operator/=() ***********************************
*
*   NAME
*	operator/=() -- Div through operator for dateduration object (V33)
*
*   SYNOPSIS
*	(*this) /= ddd;
*
*	const dateduration &operator/=(const unsigned short ddd);
*
*   FUNCTION
*	Devide the dateduration object by a constant value.
*	If ddd is 0 you will get back an object with a duration of 0!
*
*   INPUTS
*	*this - dateduration object
*	ddd   - Division factor
*
*   RESULT
*	*this - Modified dateduration object
*
*   EXAMPLE
*	...
*	dd /= 2;
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	operator+(),operator-(),operator+=(),operator-=(),operator*(),
*	operator/(),operator*=()
*
******************************************************************************/

  {
   if (ddd != 0)
    {
     this->days /= ddd;
     this->months /= ddd;
     this->years /= ddd;
    }
   else
    {
     this->days = 0;
     this->months = 0;
     this->years = 0;
    }
   return(*this);
  }


 const dateduration &dateduration::operator/=(const unsigned int ddd)

/****** DateClass/dateduration/operator/=() ***********************************
*
*   NAME
*	operator/=() -- Div through operator for dateduration object (V33)
*
*   SYNOPSIS
*	(*this) /= ddd;
*
*	const dateduration &operator/=(const unsigned int ddd);
*
*   FUNCTION
*	Devide the dateduration object by a constant value.
*	If ddd is 0 you will get back an object with a duration of 0!
*
*   INPUTS
*	*this - dateduration object
*	ddd   - Division factor
*
*   RESULT
*	*this - Modified dateduration object
*
*   EXAMPLE
*	...
*	dd /= 2;
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	operator+(),operator-(),operator+=(),operator-=(),operator*(),
*	operator/(),operator*=()
*
******************************************************************************/

  {
   if (ddd != 0)
    {
     this->days /= ddd;
     this->months /= ddd;
     this->years /= ddd;
    }
   else
    {
     this->days = 0;
     this->months = 0;
     this->years = 0;
    }
   return(*this);
  }


 const dateduration &dateduration::operator/=(const unsigned long ddd)

/****** DateClass/dateduration/operator/=() ***********************************
*
*   NAME
*	operator/=() -- Div through operator for dateduration object (V33)
*
*   SYNOPSIS
*	(*this) /= ddd;
*
*	const dateduration &operator/=(const unsigned long ddd);
*
*   FUNCTION
*	Devide the dateduration object by a constant value.
*	If ddd is 0 you will get back an object with a duration of 0!
*
*   INPUTS
*	*this - dateduration object
*	ddd   - Division factor
*
*   RESULT
*	*this - Modified dateduration object
*
*   EXAMPLE
*	...
*	dd /= 2;
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	operator+(),operator-(),operator+=(),operator-=(),operator*(),
*	operator/(),operator*=()
*
******************************************************************************/

  {
   if (ddd != 0)
    {
     this->days /= ddd;
     this->months /= (int)ddd;
     this->years /= (int)ddd;
    }
   else
    {
     this->days = 0;
     this->months = 0;
     this->years = 0;
    }
   return(*this);
  }


 unsigned long dateduration::operator/(const dateduration &dd) const

/****** DateClass/dateduration/operator/() ************************************
*
*   NAME
*	operator/() -- Div operator for dateduration object (V33)
*
*   SYNOPSIS
*	ddf = (*this) / dd;
*
*	unsigned long operator/(const dateduration &dd) const;
*
*   FUNCTION
*	Devide the dateduration object by another dateduration object
*	to the devision factor.
*
*   INPUTS
*	*this - dateduration object
*	dd    - dateduration object
*
*   RESULT
*	ddf - Division factor
*
*   EXAMPLE
*	...
*	ddf = dd1 / dd2;
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	operator+(),operator-(),operator+=(),operator-=(),operator*(),
*	operator*=(),operator/=(),operator%()
*
******************************************************************************/

  {
   if ((*this) >= dd)
     return((this->days + this->months * 30 + this->years * 365) / (dd.days + dd.months * 30 + dd.years * 365));
   else
     return((dd.days + dd.months * 30 + dd.years * 365) / (this->days + this->months * 30 + this->years * 365));
  }


 unsigned long dateduration::operator%(const dateduration &dd) const

/****** DateClass/dateduration/operator%() ************************************
*
*   NAME
*	operator%() -- Modulo operator for dateduration object (V33)
*
*   SYNOPSIS
*	ddf = (*this) % dd;
*
*	unsigned long operator%(const dateduration &dd) const;
*
*   FUNCTION
*	Modulo devide the dateduration object by another dateduration object
*	to the modulo factor.
*
*   INPUTS
*	*this - dateduration object
*	dd    - dateduration object
*
*   RESULT
*	ddf - Modulo factor
*
*   EXAMPLE
*	...
*	ddf = dd1 % dd2;
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	operator+(),operator-(),operator+=(),operator-=(),operator*(),
*	operator/(),operator*=(),operator/=()
*
******************************************************************************/

  {
   if ((*this) >= dd)
     return((this->days + this->months * 30 + this->years * 365) % (dd.days + dd.months * 30 + dd.years * 365));
   else
     return((dd.days + dd.months * 30 + dd.years * 365) % (this->days + this->months * 30 + this->years * 365));
  }


 unsigned long dateduration::getdays(void) const

/****** DateClass/dateduration/getdays() **************************************
*
*   NAME
*	getdays() -- Get days of dateduration object (V33)
*
*   SYNOPSIS
*	days = (*this).getdays();
*
*	unsigned long getdays(void) const;
*
*   FUNCTION
*	Gets the number of days from the dateduration object.
*
*   INPUTS
*	*this - dateduration object
*
*   RESULT
*	days - Days of the dateduration object
*
*   EXAMPLE
*	...
*	days = dd.getdays();
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	getmonths(),getyears(),getindays()
*
******************************************************************************/

  {
   return(this->days);
  }


 unsigned short dateduration::getmonths(void) const

/****** DateClass/dateduration/getmonths() ************************************
*
*   NAME
*	getmonths() -- Get months of dateduration object (V33)
*
*   SYNOPSIS
*	months = (*this).getmonths();
*
*	unsigned short getmonths(void) const;
*
*   FUNCTION
*	Gets the number of months from the dateduration object.
*
*   INPUTS
*	*this - dateduration object
*
*   RESULT
*	months - Months of the dateduration object
*
*   EXAMPLE
*	...
*	months = dd.getmonths();
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	getdays(),getyears(),getindays()
*
******************************************************************************/

  {
   return(this->months);
  }


 unsigned short dateduration::getyears(void) const

/****** DateClass/dateduration/getyears() *************************************
*
*   NAME
*	getyears() -- Get years of dateduration object (V33)
*
*   SYNOPSIS
*	years = (*this).getyears();
*
*	unsigned short getyears(void) const;
*
*   FUNCTION
*	Gets the number of years from the dateduration object.
*
*   INPUTS
*	*this - dateduration object
*
*   RESULT
*	years - Years of the dateduration object
*
*   EXAMPLE
*	...
*	years = dd.getyears();
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	getdays(),getmonths(),getindays()
*
******************************************************************************/

  {
   return(this->years);
  }


 unsigned long dateduration::getindays(void) const

/****** DateClass/dateduration/getindays() ************************************
*
*   NAME
*	getindays() -- Get dateduration in days of dateduration object (V33)
*
*   SYNOPSIS
*	days = (*this).getindays();
*
*	unsigned long getindays(void) const;
*
*   FUNCTION
*	Gets duration of the dateduration object in days.
*
*   INPUTS
*	*this - dateduration object
*
*   RESULT
*	days - Dateduration of the datedurationobject in days
*
*   EXAMPLE
*	...
*	days = dd.getindays();
*	...
*
*   NOTES
*	A month will be calculated as 30 days, a year as 365 days.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	getdays(),getmonths(),getyears()
*
******************************************************************************/

  {
   return(this->days + this->months * 30 + this->years * 365);
  }

 /* --- time -------------------------------------------------------------- */

/****** DateClass/time ********************************************************
*
*   NAME
*	time -- Class for times. (V33)
*
*   FUNCTION
*	This class maps 24h times.
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	timeduration,dateduration,date
*
******************************************************************************/

/****i* DateClass/time/struct time ********************************************
*
*   NAME
*	struct time -- Private structure of time class (V33)
*
*   SYNOPSIS
*	struct time {
*		     unsigned short hour,min,sec;
*		     short zone;
*		    };
*
*   FUNCTION
*	This structure holds the data of a 24h time for a special time zone.
*
*   ELEMENTS
*	hour - Hour of the time.
*	min  - Minute of the time.
*	sec  - Second of the time.
*	zone - Time zone of the time.
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	time(),operator==(),operator!=(),operator<(),operator>(),
*	operator<=(),operator>=(),operator+(),operator-(),operator+=(),
*	operator-=(),operator<<(),operator>>(),operator<<=(),operator>>=(),
*	operator[](),operator()(),gethour(),getmin(),getsec(),getzone(),
*	getjd(),date
*
******************************************************************************/


  time::time(float jd, short zone)

/****** DateClass/time/time() *************************************************
*
*   NAME
*	time() -- Constructor of time class (V33)
*
*   SYNOPSIS
*	t = time(jd,zone=0);
*
*	time(float jd, short zone = 0);
*
*   FUNCTION
*	Constructor of the time class using the JD format.
*
*   INPUTS
*	jd    - Time in JD format
*	zone  - Timezone of the time
*
*   RESULT
*	t - Time object
*
*   EXAMPLE
*	...
*	time t(0.5,2);
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	time(),Date/JDToTime()
*
******************************************************************************/

  {
   if ((zone >= -12) && (zone <= 12))
    {
     this->zone = zone;
     JDToTime(jd,this->hour,this->min,this->sec);
    }
   else
    {
     this->hour = 0;
     this->min = 0;
     this->sec = 0;
     this->zone = 0;
    }
  }


  time::time(double jd, short zone)

/****** DateClass/time/time() *************************************************
*
*   NAME
*	time() -- Constructor of time class (V33)
*
*   SYNOPSIS
*	t = time(jd,zone=0);
*
*	time(double jd, short zone = 0);
*
*   FUNCTION
*	Constructor of the time class using the JD format.
*
*   INPUTS
*	jd    - Time in JD format
*	zone  - Timezone of the time
*
*   RESULT
*	t - Time object
*
*   EXAMPLE
*	...
*	time t(0.5,2);
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	time(),Date/JDToTime()
*
******************************************************************************/

  {
   if ((zone >= -12) && (zone <= 12))
    {
     this->zone = zone;
     JDToTime((float)jd,this->hour,this->min,this->sec);
    }
   else
    {
     this->hour = 0;
     this->min = 0;
     this->sec = 0;
     this->zone = 0;
    }
  }


 time::time(unsigned short hour, unsigned short min, unsigned short sec, short zone)

/****** DateClass/time/time() *************************************************
*
*   NAME
*	time() -- Constructor of time class (V33)
*
*   SYNOPSIS
*	t = time(hour=0,min=0,sec=0,zone=0);
*
*	time(unsigned short hour=0, unsigned short min=0, unsigned short sec=0,
*	    short zone=0);
*
*   FUNCTION
*	Constructor of the time class.
*
*   INPUTS
*	hour  - Hour of time
*	min   - Min of time
*	sec   - Sec of time
*	zone  - Timezone of time
*
*   RESULT
*	t - Time object
*
*   EXAMPLE
*	...
*	time t(12,1,58,2);
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	time()
*
******************************************************************************/

  {
   if ((zone >= -12) && (zone <= 12))
    {
     this->hour = hour;
     this->min = min;
     this->sec = sec;
     this->zone = zone;
    }
   else
    {
     this->hour = 0;
     this->min = 0;
     this->sec = 0;
     this->zone = 0;
    }
  }


 bool time::operator==(time t) const

/****** DateClass/time/operator==() *******************************************
*
*   NAME
*	operator==() -- Equal operator for time objects (V33)
*
*   SYNOPSIS
*	compare = ((*this) == t);
*
*	bool operator==(time t) const;
*
*   FUNCTION
*	Compares two time objects for equality.
*
*   INPUTS
*	*this - time object
*	t     - time object
*
*   RESULT
*	compare - Boolean result of the equal compare operation
*
*   EXAMPLE
*	...
*	if (t1 == t2)
*	  printf("==\n");
*	else
*	  printf("!=\n");
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	operator!=(),operator<(),operator>(),operator<=(),operator>=(),
*	operator[](),Date/Compare2Times()
*
******************************************************************************/

  {
   if (this->zone != t.zone)
     t[this->zone];
   return(Compare2Times(this->hour,this->min,this->sec,t.hour,t.min,t.sec) == 0);
  }


 bool time::operator!=(time t) const

/****** DateClass/time/operator!=() *******************************************
*
*   NAME
*	operator!=() -- Unequal operator for time objects (V33)
*
*   SYNOPSIS
*	compare = ((*this) != t);
*
*	bool operator!=(time t) const;
*
*   FUNCTION
*	Compares two time objects for unequality.
*
*   INPUTS
*	*this - time object
*	t     - time object
*
*   RESULT
*	compare - Boolean result of the unequal compare operation
*
*   EXAMPLE
*	...
*	if (t1 != t2)
*	  printf("!=\n");
*	else
*	  printf("==\n");
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	operator==(),operator<(),operator>(),operator<=(),operator>=(),
*	operator[](),Date/Compare2Times()
*
******************************************************************************/

  {
   if (this->zone != t.zone)
     t[this->zone];
   return(Compare2Times(this->hour,this->min,this->sec,t.hour,t.min,t.sec) != 0);
  }


 bool time::operator< (time t) const

/****** DateClass/time/operator<() ********************************************
*
*   NAME
*	operator<() -- Lower than operator for time objects (V33)
*
*   SYNOPSIS
*	compare = ((*this) < t);
*
*	bool operator<(time t) const;
*
*   FUNCTION
*	Compares if time object 1 is lower than time object 2.
*
*   INPUTS
*	*this - time object
*	t     - time object
*
*   RESULT
*	compare - Boolean result of the lower than compare operation
*
*   EXAMPLE
*	...
*	if (t1 < t2)
*	  printf("<\n");
*	else
*	  printf(">=\n");
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	operator==(),operator!=(),operator>(),operator<=(),operator>=(),
*	operator[](),Date/Compare2Times()
*
******************************************************************************/

  {
   if (this->zone != t.zone)
     t[this->zone];
   return(Compare2Times(this->hour,this->min,this->sec,t.hour,t.min,t.sec) == -1);
  }


 bool time::operator> (time t) const

/****** DateClass/time/operator>() ********************************************
*
*   NAME
*	operator>() -- Greater than operator for time objects (V33)
*
*   SYNOPSIS
*	compare = ((*this) > t);
*
*	bool operator>(time t) const;
*
*   FUNCTION
*	Compares if time object 1 is greater than time object 2.
*
*   INPUTS
*	*this - time object
*	t     - time object
*
*   RESULT
*	compare - Boolean result of the greater than compare operation
*
*   EXAMPLE
*	...
*	if (t1 > t2)
*	  printf(">\n");
*	else
*	  printf("<=\n");
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	operator==(),operator!=(),operator<(),operator<=(),operator>=(),
*	operator[](),Date/Compare2Times()
*
******************************************************************************/

  {
   if (this->zone != t.zone)
     t[this->zone];
   return(Compare2Times(this->hour,this->min,this->sec,t.hour,t.min,t.sec) == 1);
  }


 bool time::operator<=(time t) const

/****** DateClass/time/operator<=() *******************************************
*
*   NAME
*	operator<=() -- Lower or equal operator for time objects (V33)
*
*   SYNOPSIS
*	compare = ((*this) <= t);
*
*	bool operator<=(time t) const;
*
*   FUNCTION
*	Compares if time object 1 is lower or equal than time object 2.
*
*   INPUTS
*	*this - time object
*	t     - time object
*
*   RESULT
*	compare - Boolean result of the lower or equal compare operation
*
*   EXAMPLE
*	...
*	if (t1 <= t2)
*	  printf("<=\n");
*	else
*	  printf(">\n");
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	operator==(),operator!=(),operator<(),operator>(),operator>=(),
*	operator[](),Date/Compare2Times()
*
******************************************************************************/

  {
   if (this->zone != t.zone)
     t[this->zone];
   return(Compare2Times(this->hour,this->min,this->sec,t.hour,t.min,t.sec) <= 0);
  }


 bool time::operator>=(time t) const

/****** DateClass/time/operator>=() *******************************************
*
*   NAME
*	operator>=() -- Greater or equal operator for time objects (V33)
*
*   SYNOPSIS
*	compare = ((*this) >= t);
*
*	bool operator>=(time t) const;
*
*   FUNCTION
*	Compares if time object 1 is greater or equal than time object 2.
*
*   INPUTS
*	*this - time object
*	t     - time object
*
*   RESULT
*	compare - Boolean result of the greater or equal compare operation
*
*   EXAMPLE
*	...
*	if (t1 >= t2)
*	  printf(">=\n");
*	else
*	  printf("<\n");
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	operator==(),operator!=(),operator<(),operator>(),operator<=(),
*	operator[](),Date/Compare2Times()
*
******************************************************************************/

  {
   if (this->zone != t.zone)
     t[this->zone];
   return(Compare2Times(this->hour,this->min,this->sec,t.hour,t.min,t.sec) >= 0);
  }


 timeduration time::operator-(time t) const

/****** DateClass/time/operator-() ********************************************
*
*   NAME
*	operator-() -- Sub operator for time objects (V33)
*
*   SYNOPSIS
*	td = (*this) - t;
*
*	timeduration operator-(time t) const;
*
*   FUNCTION
*	Subtract time object 2 from time object 1 to a new timeduration object.
*
*   INPUTS
*	*this - time object
*	t     - time object
*
*   RESULT
*	td - New timeduration object
*
*   EXAMPLE
*	...
*	td = t1 - t2;
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	operator+(),operator-(),timeduration(),operator[](),Date/TimeDiff(),
*	Date/SecToTime()
*
******************************************************************************/

  {
   unsigned short hours,mins,secs;
   long hsecs;

   if (this->zone != t.zone)
     t[this->zone];
   hsecs = TimeDiff(this->hour,this->min,this->sec,t.hour,t.min,t.sec);
   if (hsecs < 0)
     hsecs = -hsecs;
   SecToTime(hsecs,hours,mins,secs);
   return(timeduration(hours,mins,secs));
  }


 time time::operator+(const timeduration &td) const

/****** DateClass/time/operator+() ********************************************
*
*   NAME
*	operator+() -- Add operator for time and timeduration objects (V33)
*
*   SYNOPSIS
*	t = (*this) + td;
*
*	time operator+(const timeduration &td) const;
*
*   FUNCTION
*	Add a time object and a timeduration object to a new time object.
*
*   INPUTS
*	*this - time object
*	td    - timeduration object
*
*   RESULT
*	t - New time object
*
*   EXAMPLE
*	...
*	t1 = t2 + td;
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	operator-(),operator+=(),operator-=(),time(),timeduration/getinsecs(),
*	Date/DiffTime()
*
******************************************************************************/

  {
   unsigned short hour,min,sec;

   DiffTime(this->hour,this->min,this->sec,-td.getinsecs(),hour,min,sec);
   return(time(hour,min,sec));
  }


 time time::operator-(const timeduration &td) const

/****** DateClass/time/operator-() ********************************************
*
*   NAME
*	operator-() -- Sub operator for time and timeduration objects (V33)
*
*   SYNOPSIS
*	t = (*this) - td;
*
*	time operator-(const timeduration &td) const;
*
*   FUNCTION
*	Subtract a timeduration object from a time object to a new time object.
*
*   INPUTS
*	*this - time object
*	td    - timeduration object
*
*   RESULT
*	t - New time object
*
*   EXAMPLE
*	...
*	t1 = t2 - td;
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	operator+(),operator+=(),operator-=(),time(),timeduration/getinsecs(),
*	Date/DiffTime(),
*
******************************************************************************/

  {
   unsigned short hour,min,sec;

   DiffTime(this->hour,this->min,this->sec,-td.getinsecs(),hour,min,sec);
   return(time(hour,min,sec));
  }


 const time &time::operator+=(const timeduration &td)

/****** DateClass/time/operator+=() *******************************************
*
*   NAME
*	operator+=() -- Add to operator for time and timeduration objects (V33)
*
*   SYNOPSIS
*	(*this) += td;
*
*	const time &operator+=(const timeduration &td);
*
*   FUNCTION
*	Add a timeduration object to a time object.
*
*   INPUTS
*	*this - time object
*	td    - timeduration object
*
*   RESULT
*	*this - Modified time object
*
*   EXAMPLE
*	...
*	t += td;
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	operator+(),operator-(),operator-=(),timeduration/getinsecs(),
*	Date/DiffTime()
*
******************************************************************************/

  {
   DiffTime(this->hour,this->min,this->sec,td.getinsecs(),this->hour,this->min,this->sec);
   return(*this);
  }


 const time &time::operator-=(const timeduration &td)

/****** DateClass/time/operator-=() *******************************************
*
*   NAME
*	operator-=() -- Sub from operator for time and timeduration objs (V33)
*
*   SYNOPSIS
*	(*this) -= td;
*
*	const time &operator-=(const timeduration &td);
*
*   FUNCTION
*	Subtract a timeduration object from a time object.
*
*   INPUTS
*	*this - time object
*	td    - timeduration object
*
*   RESULT
*	*this - Modified time object
*
*   EXAMPLE
*	...
*	t -= td;
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	operator+(),operator-(),operator+=(),timeduration/getinsecs(),
*	Date/DiffTime()
*
******************************************************************************/

  {
   DiffTime(this->hour,this->min,this->sec,-td.getinsecs(),this->hour,this->min,this->sec);
   return(*this);
  }


 time time::operator<<(const unsigned short subzone) const

/****** DateClass/time/operator<<() *******************************************
*
*   NAME
*	operator<<() -- Decrement timezone operator for time object (V33)
*
*   SYNOPSIS
*	t = (*this) << subzone;
*
*	time operator<<(const unsigned short subzone) const;
*
*   FUNCTION
*	Decrement the timezone of a time object to a new time object.
*
*   INPUTS
*	*this   - time object
*	subzone - Subtract this value from the actual timezone
*
*   RESULT
*	t - New time object
*
*   EXAMPLE
*	...
*	t1 = t2 << 2;
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	operator>>(),operator<<=(),operator>>=(),operator[](),operator()(),
*	time(),Date/DiffTime()
*
******************************************************************************/

  {
   unsigned short hour,min,sec;

   if ((this->zone - (short)subzone) >= -12)
    {
     DiffTime(this->hour,this->min,this->sec,-subzone*3600,hour,min,sec);
     return(time(hour,min,sec,this->zone-subzone));
    }
   else
     return(time(0,0,0,0));
  }


 time time::operator>>(const unsigned short addzone) const

/****** DateClass/time/operator>>() *******************************************
*
*   NAME
*	operator>>() -- Increment timezone operator for time object (V33)
*
*   SYNOPSIS
*	t = (*this) >> addzone;
*
*	time operator>>(const unsigned short addzone) const;
*
*   FUNCTION
*	Increment the timezone of a time object to a new time object.
*
*   INPUTS
*	*this   - time object
*	addzone - Add this value to the actual timezone
*
*   RESULT
*	t - New time object
*
*   EXAMPLE
*	...
*	t1 = t2 >> 2;
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	operator<<(),operator<<=(),operator>>=(),operator[](),operator()(),
*	time(),Date/DiffTime()
*
******************************************************************************/

  {
   unsigned short hour,min,sec;

   if ((this->zone + addzone) <= 12)
    {
     DiffTime(this->hour,this->min,this->sec,addzone*3600,hour,min,sec);
     return(time(hour,min,sec,this->zone+addzone));
    }
   else
     return(time(0,0,0,0));
  }


 const time &time::operator<<=(const unsigned short subzone)

/****** DateClass/time/operator<<=() ******************************************
*
*   NAME
*	operator<<=() -- Decrement timezone operator for time object (V33)
*
*   SYNOPSIS
*	(*this) <<= subzone;
*
*	const time &operator<<=(const unsigned short subzone);
*
*   FUNCTION
*	Decrement the timezone of a time object.
*
*   INPUTS
*	*this   - time object
*	subzone - Subtract this value from the actual timezone
*
*   RESULT
*	*this - Modified time object
*
*   EXAMPLE
*	...
*	t <<= 2;
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	operator<<(),operator>>(),operator>>=(),operator[](),operator()(),
*	Date/DiffTime()
*
******************************************************************************/

  {
   if ((this->zone - (short)subzone) >= -12)
    {
     DiffTime(this->hour,this->min,this->sec,-subzone*3600,this->hour,this->min,this->sec);
     this->zone -= subzone;
    }
   return(*this);
  }


 const time &time::operator>>=(const unsigned short addzone)

/****** DateClass/time/operator>>=() ******************************************
*
*   NAME
*	operator>>=() -- Increment timezone operator for time object (V33)
*
*   SYNOPSIS
*	(*this) >>= addzone;
*
*	const time &operator>>=(const unsigned short addzone);
*
*   FUNCTION
*	Increment the timezone of a time object.
*
*   INPUTS
*	*this   - time object
*	addzone - Add this value to the actual timezone
*
*   RESULT
*	*this - Modified time object
*
*   EXAMPLE
*	...
*	t >>= 2;
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	operator<<(),operator>>(),operator<<=(),operator[](),operator()(),
*	Date/DiffTime()
*
******************************************************************************/

  {
   if ((this->zone + addzone) <= 12)
    {
     DiffTime(this->hour,this->min,this->sec,addzone*3600,this->hour,this->min,this->sec);
     this->zone += addzone;
    }
   return(*this);
  }


 const time &time::operator[](const short zone) // t1[-5] = time(18,0,0,+3)

/****** DateClass/time/operator[]() *******************************************
*
*   NAME
*	operator[]() -- Change to timezone operator for time object (V33)
*
*   SYNOPSIS
*	(*this) = (*this)[zone];
*
*	const time &operator[](const short zone);
*
*   FUNCTION
*	Change the timezone of a time object to another timezone.
*
*   INPUTS
*	*this - time object
*	zone  - Add this value to the actual timezone
*
*   RESULT
*	*this - Modified time object
*
*   EXAMPLE
*	...
*	t[2];
*	t1 = t2[2];
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	operator<<(),operator>>(),operator<<=(),operator>>=(),operator()(),
*	Date/DiffTime()
*
******************************************************************************/

  {
   if ((zone >= -12) && (zone <= 12) && (zone != this->zone))
    {
     DiffTime(this->hour,this->min,this->sec,(zone-this->zone)*3600,this->hour,this->min,this->sec);
     this->zone = zone;
    }
   return(*this);
  }


 time time::operator()(const short zone) const

/****** DateClass/time/operator()() *******************************************
*
*   NAME
*	operator()() -- Calc. to new timezone operator for time object (V33)
*
*   SYNOPSIS
*	t = (*this)(zone);
*
*	time operator()(const short zone) const;
*
*   FUNCTION
*	Change the timezone of a time object to a new time object with another
*	timezone
*
*   INPUTS
*	*this - time object
*	zone  - Add this value to the actual timezone
*
*   RESULT
*	t - New time object
*
*   EXAMPLE
*	...
*	t1 = t2(2);
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	operator<<(),operator>>(),operator<<=(),operator>>=(),operator[](),
*	time(),Date/DiffTime()
*
******************************************************************************/

  {
   unsigned short hour=0,min=0,sec=0;

   if ((zone >= -12) && (zone <= 12))
     DiffTime(this->hour,this->min,this->sec,(zone-this->zone)*3600,hour,min,sec);
   return(time(hour,min,sec,zone));
  }


 unsigned short time::gethour(void) const

/****** DateClass/time/gethour() **********************************************
*
*   NAME
*	gethour() -- Get hour of time object (V33)
*
*   SYNOPSIS
*	hour = (*this).gethour();
*
*	unsigned short gethour(void) const;
*
*   FUNCTION
*	Get the hour from the time object.
*
*   INPUTS
*	*this - time object
*
*   RESULT
*	hour - Hour of the time object
*
*   EXAMPLE
*	...
*	hour = t.gethour();
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	getmin(),getsec(),getzone(),getjd()
*
******************************************************************************/

  {
   return(this->hour);
  }


 unsigned short time::getmin(void) const

/****** DateClass/time/getmin() ***********************************************
*
*   NAME
*	getmin() -- Get min of time object (V33)
*
*   SYNOPSIS
*	min = (*this).getmin();
*
*	unsigned short getmin(void) const;
*
*   FUNCTION
*	Get the minute from the time object.
*
*   INPUTS
*	*this - time object
*
*   RESULT
*	min - Minute of the time object
*
*   EXAMPLE
*	...
*	min = t.getmin();
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	gethour(),getsec(),getzone(),getjd()
*
******************************************************************************/

  {
   return(this->min);
  }


 unsigned short time::getsec(void) const

/****** DateClass/time/getsec() ***********************************************
*
*   NAME
*	getsec() -- Get sec of time object (V33)
*
*   SYNOPSIS
*	sec = (*this).getsec();
*
*	unsigned short getsec(void) const;
*
*   FUNCTION
*	Get the second from the time object.
*
*   INPUTS
*	*this - time object
*
*   RESULT
*	sec - Second of the time object
*
*   EXAMPLE
*	...
*	sec = t.getsec();
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	gethour(),getmin(),getzone(),getjd()
*
******************************************************************************/

  {
   return(this->sec);
  }


 short time::getzone(void) const

/****** DateClass/time/getzone() **********************************************
*
*   NAME
*	getzone() -- Get timezone of time object (V33)
*
*   SYNOPSIS
*	zone = (*this).getzone();
*
*	short getzone(void) const;
*
*   FUNCTION
*	Get the timezone from the time object.
*
*   INPUTS
*	*this - time object
*
*   RESULT
*	zone - Timezone of the time object
*
*   EXAMPLE
*	...
*	zone = t.getzone();
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	gethour(),getmin(),getsec(),getjd()
*
******************************************************************************/

  {
   return(this->zone);
  }


 float time::getjd(void) const

/****** DateClass/time/getjd() ************************************************
*
*   NAME
*	getjd() -- Get time in JD format from time object (V33)
*
*   SYNOPSIS
*	jd = (*this).getjd();
*
*	float getjd(void) const;
*
*   FUNCTION
*	Get the time in JD format from the time object.
*
*   INPUTS
*	*this - time object
*
*   RESULT
*	jd - Time of the time object in JD format
*
*   EXAMPLE
*	...
*	jd = t.getjd();
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	gethour(),getmin(),getsec(),getzone(),Date/TimeToJD()
*
******************************************************************************/

  {
   return(TimeToJD(this->hour,this->min,this->sec));
  }

 /* --- date -------------------------------------------------------------- */

/****** DateClass/date ********************************************************
*
*   NAME
*	date -- Class for dates. (V33)
*
*   FUNCTION
*	This class maps dates.
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	timeduration,dateduration,time
*
******************************************************************************/

/****i* DateClass/date/struct date ********************************************
*
*   NAME
*	struct date -- Private structure of date class (V33)
*
*   SYNOPSIS
*	struct date {
*		     unsigned short day,month;
*		     int year;
*		    };
*
*   FUNCTION
*	This structure holds the data of a date.
*
*   ELEMENTS
*	day   - Day of the date.
*	month - Month of the date.
*	year  - Year of the date.
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	date(),operator==(),operator!=(),operator<(),operator>(),
*	operator<=(),operator>=(),operator!(),operator+(),operator-(),
*	operator+=(),operator-=(),operator++(),operator++(int),operator--(),
*	operator--(int),getday(),getmonth(),getyear(),getweek(),getweekday(),
*	getjd(),getmjd(),getscaliger(),date
*
******************************************************************************/


 date::date(unsigned long jd)

/****** DateClass/date/date() *************************************************
*
*   NAME
*	date() -- Constructor of date class (V33)
*
*   SYNOPSIS
*	d = date(jd);
*
*	date(unsigned long jd);
*
*   FUNCTION
*	Constructor of the date class for JD format.
*
*   INPUTS
*	jd - Date in JD format
*
*   RESULT
*	d - Date object
*
*   EXAMPLE
*	...
*	date d(2449354);
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	date(),Date/JDToHeis()
*
******************************************************************************/

  {
   JDToHeis(jd,this->day,this->month,this->year);
  }


 date::date(unsigned short day, unsigned short month, int year)

/****** DateClass/date/date() *************************************************
*
*   NAME
*	date() -- Constructor of date class (V33)
*
*   SYNOPSIS
*	d = date(day,month,year);
*
*	date(unsigned short day, unsigned short month, int year);
*
*   FUNCTION
*	Constructor of the date class.
*
*   INPUTS
*	day   - Day of date
*	month - Month of date
*	year  - Year of date
*
*   RESULT
*	d - Date object
*
*   EXAMPLE
*	...
*	date d(17,7,1995);
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	date()
*
******************************************************************************/

  {
   this->day = day;
   this->month = month;
   this->year = year;
  }


 bool date::operator==(const date &d) const

/****** DateClass/date/operator==() *******************************************
*
*   NAME
*	operator==() -- Equal operator for date objects (V33)
*
*   SYNOPSIS
*	compare = ((*this) == d);
*
*	bool operator==(const date &d) const;
*
*   FUNCTION
*	Compares two date objects for equality.
*
*   INPUTS
*	*this - date object
*	d     - date object
*
*   RESULT
*	compare - Boolean result of the equal compare operation
*
*   EXAMPLE
*	...
*	if (d1 == d2)
*	  printf("==\n");
*	else
*	  printf("!=\n");
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	operator!=(),operator<(),operator>(),operator<=(),operator>=(),
*	Date/Compre2Dates()
*
******************************************************************************/

  {
   return(Compare2Dates(this->day,this->month,this->year,d.day,d.month,d.year) == 0);
  }


 bool date::operator!=(const date &d) const

/****** DateClass/date/operator!=() *******************************************
*
*   NAME
*	operator!=() -- Unequal operator for date objects (V33)
*
*   SYNOPSIS
*	compare = ((*this) != d);
*
*	bool operator!=(const date &d) const;
*
*   FUNCTION
*	Compares two date objects for unequality.
*
*   INPUTS
*	*this - date object
*	d     - date object
*
*   RESULT
*	compare - Boolean result of the unequal compare operation
*
*   EXAMPLE
*	...
*	if (d1 != d2)
*	  printf("!=\n");
*	else
*	  printf("==\n");
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	operator==(),operator<(),operator>(),operator<=(),operator>=(),
*	Date/Compare2Dates()
*
******************************************************************************/

  {
   return(Compare2Dates(this->day,this->month,this->year,d.day,d.month,d.year) != 0);
  }


 bool date::operator< (const date &d) const

/****** DateClass/date/operator<() ********************************************
*
*   NAME
*	operator<() -- Lower than operator for date objects (V33)
*
*   SYNOPSIS
*	compare = ((*this) < d);
*
*	bool operator<(const date &d) const;
*
*   FUNCTION
*	Compares if date object 1 is lower than date object 2.
*
*   INPUTS
*	*this - date object
*	d     - date object
*
*   RESULT
*	compare - Boolean result of the lower than compare operation
*
*   EXAMPLE
*	...
*	if (d1 < d2)
*	  printf("<\n");
*	else
*	  printf(">=\n");
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	operator==(),operator!=(),operator>(),operator<=(),operator>=(),
*	Date/Compare2Dates()
*
******************************************************************************/

  {
   return(Compare2Dates(this->day,this->month,this->year,d.day,d.month,d.year) == -1);
  }


 bool date::operator> (const date &d) const

/****** DateClass/date/operator>() ********************************************
*
*   NAME
*	operator>() -- Greater than operator for date objects (V33)
*
*   SYNOPSIS
*	compare = ((*this) > d);
*
*	bool operator>(const date &d) const;
*
*   FUNCTION
*	Compares if date object 1 is greater than date object 2.
*
*   INPUTS
*	*this - date object
*	d     - date object
*
*   RESULT
*	compare - Boolean result of the greater than compare operation
*
*   EXAMPLE
*	...
*	if (d1 > d2)
*	  printf(">\n");
*	else
*	  printf("<=\n");
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	operator==(),operator!=(),operator<(),operator<=(),operator>=(),
*	Date/Compare2Dates()
*
******************************************************************************/

  {
   return(Compare2Dates(this->day,this->month,this->year,d.day,d.month,d.year) == 1);
  }


 bool date::operator<=(const date &d) const

/****** DateClass/date/operator<=() *******************************************
*
*   NAME
*	operator<=() -- Lower or equal operator for date objects (V33)
*
*   SYNOPSIS
*	compare = ((*this) <= d);
*
*	bool operator<=(const date &d) const;
*
*   FUNCTION
*	Compares if date object 1 is lower or equal than date object 2.
*
*   INPUTS
*	*this - date object
*	d     - date object
*
*   RESULT
*	compare - Boolean result of the lower or equal compare operation
*
*   EXAMPLE
*	...
*	if (d1 <= d2)
*	  printf("<=\n");
*	else
*	  printf(">\n");
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	operator==(),operator!=(),operator<(),operator>(),operator>=().
*	Date/Compare2Dates()
*
******************************************************************************/

  {
   return(Compare2Dates(this->day,this->month,this->year,d.day,d.month,d.year) <= 0);
  }


 bool date::operator>=(const date &d) const

/****** DateClass/date/operator>=() *******************************************
*
*   NAME
*	operator>=() -- Greater or equal operator for date objects (V33)
*
*   SYNOPSIS
*	compare = ((*this) >= d);
*
*	bool operator>=(const date &d) const;
*
*   FUNCTION
*	Compares if date object 1 is greater or equal than date object 2.
*
*   INPUTS
*	*this - date object
*	d     - date object
*
*   RESULT
*	compare - Boolean result of the greater or equal compare operation
*
*   EXAMPLE
*	...
*	if (d1 >= d2)
*	  printf(">=\n");
*	else
*	  printf("<\n");
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	operator==(),operator!=(),operator<(),operator>(),operator<=(),
*	Date/Compare2Dates()
*
******************************************************************************/

  {
   return(Compare2Dates(this->day,this->month,this->year,d.day,d.month,d.year) >= 0);
  }


 bool date::operator==(const Weekdays wd) const

/****** DateClass/date/operator==() *******************************************
*
*   NAME
*	operator==() -- Equal operator for date object and weekday (V33)
*
*   SYNOPSIS
*	compare = ((*this) == wd);
*
*	bool operator==(const Weekdays wd) const;
*
*   FUNCTION
*	Compares if the date object is equal to a weekday.
*
*   INPUTS
*	*this - date object
*	wd    - Weekday
*
*   RESULT
*	compare - Boolean result of the equal compare operation
*
*   EXAMPLE
*	...
*	if (d1 == wd)
*	  printf("==\n");
*	else
*	  printf("!=\n");
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	operator!=(),operator<(),operator>(),operator<=(),operator>=(),
*	Date/HeisWeekday()
*
******************************************************************************/

  {
   return(HeisWeekday(this->day,this->month,this->year) == wd);
  }


 bool date::operator!=(const Weekdays wd) const

/****** DateClass/date/operator!=() *******************************************
*
*   NAME
*	operator!=() -- Unequal operator for date object and weekday (V33)
*
*   SYNOPSIS
*	compare = ((*this) != wd);
*
*	bool operator!=(const Weekdays wd) const;
*
*   FUNCTION
*	Compares if the date object is unequal to a weekday.
*
*   INPUTS
*	*this - date object
*	wd    - Weekday
*
*   RESULT
*	compare - Boolean result of the unequal compare operation
*
*   EXAMPLE
*	...
*	if (d1 != wd)
*	  printf("!=\n");
*	else
*	  printf("==\n");
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	operator==(),operator<(),operator>(),operator<=(),operator>=(),
*	Date/HeisWeekday()
*
******************************************************************************/

  {
   return(HeisWeekday(this->day,this->month,this->year) != wd);
  }


 bool date::operator< (const Weekdays wd) const

/****** DateClass/date/operator<() ********************************************
*
*   NAME
*	operator<() -- Lower than operator for date object and weekday (V33)
*
*   SYNOPSIS
*	compare = ((*this) < wd);
*
*	bool operator< (const Weekdays wd) const;
*
*   FUNCTION
*	Compares if the date object is lower than a weekday.
*
*   INPUTS
*	*this - date object
*	wd    - Weekday
*
*   RESULT
*	compare - Boolean result of the lower than compare operation
*
*   EXAMPLE
*	...
*	if (d1 < wd)
*	  printf("<\n");
*	else
*	  printf(">=\n");
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	operator==(),operator!=(),operator>(),operator<=(),operator>=(),
*	Date/HeisWeekday()
*
******************************************************************************/

  {
   return(HeisWeekday(this->day,this->month,this->year) < wd);
  }


 bool date::operator> (const Weekdays wd) const

/****** DateClass/date/operator>() ********************************************
*
*   NAME
*	operator>() -- Greater than operator for date object and weekday (V33)
*
*   SYNOPSIS
*	compare = ((*this) > wd);
*
*	bool operator> (const Weekdays wd) const;
*
*   FUNCTION
*	Compares if the date objects is greater than a weekday.
*
*   INPUTS
*	*this - date object
*	wd    - Weekday
*
*   RESULT
*	compare - Boolean result of the greater than compare operation
*
*   EXAMPLE
*	...
*	if (d1 > wd)
*	  printf(">\n");
*	else
*	  printf("<=\n");
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	operator==(),operator!=(),operator<(),operator<=(),operator>=(),
*	Date/HeisWeekday()
*
******************************************************************************/

  {
   return(HeisWeekday(this->day,this->month,this->year) > wd);
  }


 bool date::operator<=(const Weekdays wd) const

/****** DateClass/date/operator<=() *******************************************
*
*   NAME
*	operator<=() -- Lower or equal operator for date obj. and weekday (V33)
*
*   SYNOPSIS
*	compare = ((*this) <= wd);
*
*	bool operator<=(const Weekdays wd) const;
*
*   FUNCTION
*	Compares if the date object is lower or equal to a weekday.
*
*   INPUTS
*	*this - date object
*	wd    - Weekday
*
*   RESULT
*	compare - Boolean result of the lower or equal compare operation
*
*   EXAMPLE
*	...
*	if (d1 <= wd)
*	  printf("<=\n");
*	else
*	  printf(">\n");
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	operator==(),operator!=(),operator<(),operator>(),operator>=(),
*	Date/HeisWeekday()
*
******************************************************************************/

  {
   return(HeisWeekday(this->day,this->month,this->year) <= wd);
  }


 bool date::operator>=(const Weekdays wd) const

/****** DateClass/date/operator>=() *******************************************
*
*   NAME
*	operator>=() -- Greater or equal oper. for date obj. and weekday (V33)
*
*   SYNOPSIS
*	compare = ((*this) >= wd);
*
*	bool operator>=(const Weekdays wd) const;
*
*   FUNCTION
*	Compares if the date object is greater or equal to a weekday.
*
*   INPUTS
*	*this - date object
*	wd    - Weekday
*
*   RESULT
*	compare - Boolean result of the greater or equal compare operation
*
*   EXAMPLE
*	...
*	if (d1 >= wd)
*	  printf(">=\n");
*	else
*	  printf("<\n");
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	operator==(),operator!=(),operator<(),operator>(),operator<=(),
*	Date/HeisWeekday()
*
******************************************************************************/

  {
   return(HeisWeekday(this->day,this->month,this->year) >= wd);
  }


 bool date::operator!() const

/****** DateClass/date/operator!() ********************************************
*
*   NAME
*	operator!() -- Leapyear operator for date object(V33)
*
*   SYNOPSIS
*	leapyear = !((*this));
*
*	bool operator!() const;
*
*   FUNCTION
*	Checks if the year of the date object is a leap year.
*
*   INPUTS
*	*this - date object
*
*
*   RESULT
*	leapyear - Boolean, TRUE if the year of the date object is a leapyear,
*	    FALSE if it is a normal year.
*
*   EXAMPLE
*	...
*	if (!d)
*	  printf("leap year\n");
*	else
*	  printf("normal year\n");
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	Date/HeisLeapYear()
*
******************************************************************************/

  {
   return(HeisLeapYear(this->year));
  }


 dateduration date::operator-(const date &d) const

/****** DateClass/date/operator-() ********************************************
*
*   NAME
*	operator-() -- Sub operator for date objects (V33)
*
*   SYNOPSIS
*	dd = (*this) - d;
*
*	dateduration operator-(const date &d) const;
*
*   FUNCTION
*	Subtract date object 2 from date object 1 to a new dateduration object.
*
*   INPUTS
*	*this - date object
*	d     - date object
*
*   RESULT
*	dd - New dateduration object
*
*   EXAMPLE
*	...
*	dd = d1 - d2;
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	operator+(),operator-(),dateduration(),Date/HeisDayDiff()
*
******************************************************************************/

  {
   long days = HeisDayDiff(this->day,this->month,this->year,d.day,d.month,d.year);

   if (days < 0)
     days = -days;
   return(dateduration(days));
  }


 date date::operator+(const dateduration &dd) const

/****** DateClass/date/operator+() ********************************************
*
*   NAME
*	operator+() -- Add operator for date and dateduration objects (V33)
*
*   SYNOPSIS
*	d = (*this) + dd;
*
*	date operator+(const dateduration &dd) const;
*
*   FUNCTION
*	Add a date object and a dateduration object to a new date object.
*
*   INPUTS
*	*this - date object
*	dd    - dateduration object
*
*   RESULT
*	d - New date object
*
*   EXAMPLE
*	...
*	d1 = d2 + dd;
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	The dateduration may not be longer (in days) than an integer value!
*
*   SEE ALSO
*	operator-(),operator+=(),operator-=(),date(),dateduration/getindays(),
*	Date/HeisDiffDate()
*
******************************************************************************/

  {
   unsigned short day,month;
   int year;

   HeisDiffDate(this->day,this->month,this->year,(int)dd.getindays(),day,month,year);
   return(date(day,month,year));
  }


 date date::operator-(const dateduration &dd) const

/****** DateClass/date/operator-() ********************************************
*
*   NAME
*	operator-() -- Sub operator for date and dateduration objects (V33)
*
*   SYNOPSIS
*	d = (*this) - dd;
*
*	date operator-(const dateduration &dd) const;
*
*   FUNCTION
*	Subtract a dateduration object from a date object to a new date object.
*
*   INPUTS
*	*this - date object
*	dd    - dateduration object
*
*   RESULT
*	d     - New date object
*
*   EXAMPLE
*	...
*	d1 = d2 - dd;
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	The dateduration may not be longer (in days) than an integer value!
*
*   SEE ALSO
*	operator+(),operator+=(),operator-=(),date(),dateduration/getindays(),
*	Date/HeisDiffDate()
*
******************************************************************************/

  {
   unsigned short day,month;
   int year;

   HeisDiffDate(this->day,this->month,this->year,(int)-dd.getindays(),day,month,year);
   return(date(day,month,year));
  }


 const date &date::operator+=(const dateduration &dd)

/****** DateClass/date/operator+=() *******************************************
*
*   NAME
*	operator+=() -- Add to operator for date and dateduration objects (V33)
*
*   SYNOPSIS
*	(*this) += dd;
*
*	const date &operator+=(const dateduration &dd);
*
*   FUNCTION
*	Add a dateduration object to a date object.
*
*   INPUTS
*	*this - date object
*	dd    - dateduration object
*
*   RESULT
*	*this - Modified date object
*
*   EXAMPLE
*	...
*	d += dd;
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	The dateduration may not be longer (in days) than an integer value!
*
*   SEE ALSO
*	operator+(),operator-(),operator-=(),dateduration/getindays(),
*	Date/HeisDiffDate()
*
******************************************************************************/

  {
   HeisDiffDate(this->day,this->month,this->year,(int)dd.getindays(),this->day,this->month,this->year);
   return(*this);
  }


 const date &date::operator-=(const dateduration &dd)

/****** DateClass/date/operator-=() *******************************************
*
*   NAME
*	operator-=() -- Sub from operator for date and dateduration objs (V33)
*
*   SYNOPSIS
*	(*this) -= dd;
*
*	const date &operator-=(const dateduration &dd);
*
*   FUNCTION
*	Subtract a dateduration object from a date object.
*
*   INPUTS
*	*this - date object
*	dd    - dateduration object
*
*   RESULT
*	*this - Modified date object
*
*   EXAMPLE
*	...
*	d -= dd;
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	The dateduration may not be longer (in days) than an integer value!
*
*   SEE ALSO
*	operator+(),operator-(),operator+=(),dateduration/getindays(),
*	Date/HeisDiffDate()
*
******************************************************************************/

  {
   HeisDiffDate(this->day,this->month,this->year,(int)-dd.getindays(),this->day,this->month,this->year);
   return(*this);
  }


 date date::operator+(const Weekdays wd) const

/****** DateClass/date/operator+() ********************************************
*
*   NAME
*	operator+() -- Add operator for date object and weekday (V33)
*
*   SYNOPSIS
*	d = (*this) + wd;
*
*	date operator+(const Weekdays wd) const;
*
*   FUNCTION
*	Gives you the next date, that is the specified weekday (could be the
*	same date!).
*
*   INPUTS
*	*this - date object
*	wd    - Weekday
*
*   RESULT
*	d - New date object
*
*   EXAMPLE
*	...
*	d1 = d2 + wd;
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	operator-(),operator+=(),operator-=(),date(),
*	Date/HeisDaysAfterWeekday(),Date/HeisDiffDate()
*
******************************************************************************/

  {
   unsigned short day,month,days=HeisDaysAfterWeekday(this->day,this->month,this->year,wd);
   int year;

   HeisDiffDate(this->day,this->month,this->year,days,day,month,year);
   return(date(day,month,year));
  }


 date date::operator-(const Weekdays wd) const

/****** DateClass/date/operator-() ********************************************
*
*   NAME
*	operator-() -- Sub operator for date object and weekday (V33)
*
*   SYNOPSIS
*	d = (*this) - wd;
*
*	date operator-(const Weekdays wd) const;
*
*   FUNCTION
*	Gives you the last date, that is the specified weekday (could be the
*	same date!).
*
*   INPUTS
*	*this - date object
*	wd    - Weekday
*
*   RESULT
*	d - New date object
*
*   EXAMPLE
*	...
*	d1 = d2 - wd;
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	operator+(),operator+=(),operator-=(),date(),
*	Date/HeisDaysBeforeWeekday(),Date/HeisDiffDate()
*
******************************************************************************/

  {
   unsigned short day,month,days=HeisDaysBeforeWeekday(this->day,this->month,this->year,wd);
   int year;

   HeisDiffDate(this->day,this->month,this->year,-days,day,month,year);
   return(date(day,month,year));
  }


 const date &date::operator+=(const Weekdays wd)

/****** DateClass/date/operator+=() *******************************************
*
*   NAME
*	operator+=() -- Add to operator for date object and weekday (V33)
*
*   SYNOPSIS
*	(*this) += wd;
*
*	const date &operator+=(const Weekdays wd);
*
*   FUNCTION
*	Corrects the date object to the next date that is the specified weekday
*	(could be the same date!).
*
*   INPUTS
*	*this - date object
*	wd    - Weekday
*
*   RESULT
*	*this - Modified date object
*
*   EXAMPLE
*	...
*	d += wd;
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	operator+(),operator-(),operator-=(),Date/HeisDaysAfterWeekday(),
*	Date/HeisDiffDate()
*
******************************************************************************/

  {
   unsigned days=HeisDaysAfterWeekday(this->day,this->month,this->year,wd);

   HeisDiffDate(this->day,this->month,this->year,days,this->day,this->month,this->year);
   return(*this);
  }


 const date &date::operator-=(const Weekdays wd)

/****** DateClass/date/operator-=() *******************************************
*
*   NAME
*	operator-=() -- Sub from operator for date object and weekday (V33)
*
*   SYNOPSIS
*	(*this) -= wd;
*
*	const date &operator-=(const Weekdays wd);
*
*   FUNCTION
*	Corrects the date object to the last date that is the specified weekday
*	(could be the same date!).
*
*   INPUTS
*	*this - date object
*	wd    - Weekday
*
*   RESULT
*	*this - Modified date object
*
*   EXAMPLE
*	...
*	d -= wd;
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	operator+(),operator-(),operator+=(),Date/HeisDaysBeforeWeekday(),
*	Date/HeisDiffDate()
*
******************************************************************************/

  {
   unsigned days=HeisDaysBeforeWeekday(this->day,this->month,this->year,wd);

   HeisDiffDate(this->day,this->month,this->year,-days,this->day,this->month,this->year);
   return(*this);
  }


 date date::operator++()

/****** DateClass/date/operator++() *******************************************
*
*   NAME
*	operator++() -- Increment operator for date object (V33)
*
*   SYNOPSIS
*	d++;
*
*	date operator++();
*
*   FUNCTION
*	Increments the date object by one day.
*
*   INPUTS
*	*this - date object
*
*   RESULT
*	*this - Modified date object
*
*   EXAMPLE
*	...
*	d++;
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	operator++(int),operator--(),operator--(int),Date/HeisDiffDate()
*
******************************************************************************/

  {
   date tmp = *this;

   HeisDiffDate(this->day,this->month,this->year,1,this->day,this->month,this->year);
   return(tmp);
  }


 date date::operator++(int)

/****** DateClass/date/operator++(int) ****************************************
*
*   NAME
*	operator++(int) -- Increment operator for date object (V33)
*
*   SYNOPSIS
*	++d;
*
*	date operator++(int);
*
*   FUNCTION
*	Increments the date object by one day.
*
*   INPUTS
*	*this - date object
*
*   RESULT
*	*this - Modified date object
*
*   EXAMPLE
*	...
*	++d;
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	operator++(),operator--(),operator--(int),Date/HeisDiffDate()
*
******************************************************************************/

  {
   HeisDiffDate(this->day,this->month,this->year,1,this->day,this->month,this->year);
   return(*this);
  }


 date date::operator--()

/****** DateClass/date/operator--() *******************************************
*
*   NAME
*	operator--() -- Decrement operator for date object (V33)
*
*   SYNOPSIS
*	d--;
*
*	date operator--();
*
*   FUNCTION
*	Decrements the date object by one day.
*
*   INPUTS
*	*this - date object
*
*   RESULT
*	*this - Modified date object
*
*   EXAMPLE
*	...
*	dd--;
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	operator++(),operator++(int),operator--(int),Date/HeisDiffDate()
*
******************************************************************************/

  {
   date tmp = *this;

   HeisDiffDate(this->day,this->month,this->year,-1,this->day,this->month,this->year);
   return(tmp);
  }


 date date::operator--(int)

/****** DateClass/date/operator--(int) ****************************************
*
*   NAME
*	operator--(int) -- Decrement operator for date object (V33)
*
*   SYNOPSIS
*	--d;
*
*	date operator--(int);
*
*   FUNCTION
*	Decrements the date object by one day.
*
*   INPUTS
*	*this - date object
*
*   RESULT
*	*this - Modified date object
*
*   EXAMPLE
*	...
*	--d;
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	operator++(),operator++(int),operator--(),Date/HeisDiffDate()
*
******************************************************************************/

  {
   HeisDiffDate(this->day,this->month,this->year,-1,this->day,this->month,this->year);
   return(*this);
  }


 unsigned short date::getday(void) const

/****** DateClass/date/getday() ***********************************************
*
*   NAME
*	getday() -- Get day of date object (V33)
*
*   SYNOPSIS
*	day = (*this).getday();
*
*	unsigned short getday(void) const;
*
*   FUNCTION
*	Get the day from the date object.
*
*   INPUTS
*	*this - date object
*
*   RESULT
*	day - Day of the date object
*
*   EXAMPLE
*	...
*	day = d.getday();
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	getmonth(),getyear(),getweek(),getweekday(),getjd(),getmjd(),
*	getscaliger()
*
******************************************************************************/

  {
   return(this->day);
  }


 unsigned short date::getmonth(void) const

/****** DateClass/date/getmonth() *********************************************
*
*   NAME
*	getmonth() -- Get month of date object (V33)
*
*   SYNOPSIS
*	month = (*this).getmonth();
*
*	unsigned short getmonth(void) const;
*
*   FUNCTION
*	Get the month from the date object.
*
*   INPUTS
*	*this - date object
*
*   RESULT
*	month - Month of the date object
*
*   EXAMPLE
*	...
*	month = d.getmonth();
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	getday(),getyear(),getweek(),getweekday(),getjd(),getmjd(),
*	getscaliger()
*
******************************************************************************/

  {
   return(this->month);
  }


 int date::getyear(void) const

/****** DateClass/date/getyear() **********************************************
*
*   NAME
*	getyear() -- Get year of date object (V33)
*
*   SYNOPSIS
*	year = (*this).getyear();
*
*	int getyear(void) const;
*
*   FUNCTION
*	Get the year from the date object.
*
*   INPUTS
*	*this - date object
*
*   RESULT
*	year - Year of the date object
*
*   EXAMPLE
*	...
*	year = d.getyear();
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	getday(),getmonth(),getweek(),getweekday(),getjd(),getmjd(),
*	getscaliger()
*
******************************************************************************/

  {
   return(this->year);
  }


 unsigned short date::getweek(void) const

/****** DateClass/date/getweek() **********************************************
*
*   NAME
*	getweek() -- Get week of date object (V33)
*
*   SYNOPSIS
*	week = (*this).getweek();
*
*	unsigned short getweek(void) const;
*
*   FUNCTION
*	Get the week from the date object.
*
*   INPUTS
*	*this - date object
*
*   RESULT
*	week - Week of the date object
*
*   EXAMPLE
*	...
*	week = d.getweek();
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	getday(),getmonth(),getyear(),getweekday(),getjd(),getmjd(),
*	getscaliger(),Date/HeisWeek()
*
******************************************************************************/

  {
   return(HeisWeek(this->day,this->month,this->year));
  }


 Weekdays date::getweekday(void) const

/****** DateClass/date/getweekday() *******************************************
*
*   NAME
*	getweekday() -- Get weekday of date object (V33)
*
*   SYNOPSIS
*	weekday = (*this).getweekday();
*
*	Weekdays getweekday(void) const;
*
*   FUNCTION
*	Get the weekday from the date object.
*
*   INPUTS
*	*this - date object
*
*   RESULT
*	weekday - Weekday of the date object
*
*   EXAMPLE
*	...
*	wd = d.getweekday();
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	getday(),getmonth(),getyear(),getweek(),getjd(),getmjd(),
*	getscaliger(),Date/HeisWeekday()
*
******************************************************************************/

  {
   return(HeisWeekday(this->day,this->month,this->year));
  }


 unsigned long date::getjd(void) const

/****** DateClass/date/getjd() ************************************************
*
*   NAME
*	getjd() -- Get date in JD format from date object (V33)
*
*   SYNOPSIS
*	jd = (*this).getjd();
*
*	unsigned long getjd(void) const;
*
*   FUNCTION
*	Get the date from the date object in JD format.
*
*   INPUTS
*	*this - date object
*
*   RESULT
*	jd - Date of the date object in JD format
*
*   EXAMPLE
*	...
*	jd = d.getjd();
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	getday(),getmonth(),getyear(),getweek(),getweekday(),getmjd(),
*	getscaliger(),Date/HeisToJD()
*
******************************************************************************/

  {
   return(HeisToJD(this->day,this->month,this->year));
  }


 unsigned long date::getmjd(void) const

/****** DateClass/date/getmjd() ***********************************************
*
*   NAME
*	getmjd() -- Get date in MJD format from date object (V33)
*
*   SYNOPSIS
*	mjd = (*this).getmjd();
*
*	unsigned long getmjd(void) const;
*
*   FUNCTION
*	Get the date from the date object in MJD format.
*
*   INPUTS
*	*this - date object
*
*   RESULT
*	mjd - Date of the date object in MJD format
*
*   EXAMPLE
*	...
*	mjd = d.getmjd();
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	getday(),getmonth(),getyear(),getweek(),getweekday(),getjd(),
*	getscaliger(),Date/JDtoMJD(),Date/HeisToJD()
*
******************************************************************************/

  {
   return(JDtoMJD(HeisToJD(this->day,this->month,this->year)));
  }


 unsigned int date::getscaliger(void) const

/****** DateClass/date/getscaliger() ******************************************
*
*   NAME
*	getscaliger() -- Get year in Scaliger format from date object (V33)
*
*   SYNOPSIS
*	scaliger = (*this).getscaliger();
*
*	unsigned int getscaliger(void) const;
*
*   FUNCTION
*	Get the year of the date object in Scaliger format.
*
*   INPUTS
*	*this - date object
*
*   RESULT
*	scaliger - Year of the date object in Scaliger format
*
*   EXAMPLE
*	...
*	syear = d.getscaliger();
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	getday(),getmonth(),getyear(),getweek(),getweekday(),getjd(),getmjd(),
*	Date/HYearToScaliger()
*
******************************************************************************/

  {
   return(HYearToScaliger(this->year));
  }


 unsigned short date::getmoonage(void) const

/****** DateClass/date/getmoonage() *******************************************
*
*   NAME
*	getmoonage() -- Returns the age of the moon (V33)
*
*   SYNOPSIS
*	ep = (*this).getmoonage();
*
*	unsigned short getmoonage(void) const;
*
*   FUNCTION
*	Returns the age of the moon on a specified date.
*
*   INPUTS
*	*this - date object
*
*   RESULT
*	ep - The age of the moon on the specified date.
*
*   EXAMPLE
*	...
*	ep = d.getmoonage();
*	...
*
*   NOTES
*	Use this only for 1582 to 4100!
*	This is only a experimental version!
*
*   BUGS
*	Unknown
*
*   SEE ALSO
*	date/GregorianMoonAge()
*
******************************************************************************/

  {
   return(GregorianMoonAge(this->day,this->month,this->year));
  }


 date date::getmoonphase(const MoonPhases phase) const

/****** DateClass/date/getmoonphase() *****************************************
*
*   NAME
*	getmoonphase() -- Searches for the next moon phase (V33)
*
*   SYNOPSIS
*	date = (*this).getmoonphase(phase);
*
*	date getmoonphase(const MoonPhases phase) const;
*
*   FUNCTION
*	Returns the next moon phase you are searching for after
*	a specified date.
*
*   INPUTS
*	*this - date object
*
*   RESULT
*	date - The date on which the moon phase was found.
*
*   EXAMPLE
*	...
*	date = d.getmoonphase(FullMoon);
*	...
*
*   NOTES
*	The range of this function is unknown to me!
*	So use it only from 1583 to 2500.
*	This is only an experimental version!
*
*   BUGS
*	Unknown
*
*   SEE ALSO
*	date/GregorianMoonPhase(),date/JDToHeis(),date()
*
******************************************************************************/

  {
   unsigned short day,month;
   int year;

   JDToHeis(GregorianMoonPhase(this->day,this->month,this->year,phase),day,month,year);
   return(date(day,month,year));
  }

 /* ----------------------------------------------------------------------- */

 date Easter(const int year)

/****** DateClass/Easter() ****************************************************
*
*   NAME
*	Easter() -- Returns the date of Easter in a year (V33)
*
*   SYNOPSIS
*	date = Easter(year);
*
*	date Easter(const int year);
*
*   FUNCTION
*	Returns the date of Easter for a specified year.
*
*   INPUTS
*	year - Easter is calculated for this year
*
*   RESULT
*	date - Complete date of Easter Sunday
*
*   EXAMPLE
*	...
*	date = Easter(1995);
*	...
*
*   NOTES
*	Use this only for 31 to 2099!
*
*   BUGS
*	Unknown.
*
*   SEE ALSO
*	date/HeisEaster(),date
*
******************************************************************************/

  {
   unsigned short day,month;

   HeisEaster(year,day,month);
   return(date(day,month,year));
  }

 /* ----------------------------------------------------------------------- */
