/*
   Mike's original comments:

   Sample X-Sharp 3D animation program. Demonstrates ambient and diffuse
   shading, with up to three spotlights and ambient shading of a white ball.
   The ambient light is green, as are two of the spots; given the palette
   set-up, which is optimized for pure primary colors by assigning 64 levels
   to each primary, shading with all green looks very good. The third
   spotlight is blue; when it's on and any other lighting source is on,
   color quantization problems become apparent; because the palette has only
   four levels of each primary for use in mixing, only very rough
   approximations of mixed colors can be displayed.

   All C code tested with Borland C++ 3.0 in C compilation mode and the
   small model.
   

   modified by Bruce Miller to spin our sign
   
   */

#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <dos.h>
#include <string.h>

#include <pr2.h>
#include <mode13.h>
#include <readlbm.h>
#include <fstring.h>
#include <g_io.h>
#include <gui.h>
#include <erase.h>
#include <die.h>
#include <gmalloc.h>
#include <gsound.h>

#include <Xlib_all.h>

#include <polygon.h>
#include "initsign.h"


#define NUM_MOVES_AWAY 256

#define NUM_MOVES_DOWN_TOWARD 300
#define NUM_MOVES_UP_TOWARD 90

/* Contains flags indicating pending ball moves */
short BallEvent = 0;

void DisplayInstructions(void) {
   printf("Control keys:\n");
   printf(" 0, 1, 2: toggle spotlights 0, 1, and 2 on and off\n");
   printf(" A      : move ball away from you\n");
   printf(" B      : toggle ambient (background) light on and off\n");
   printf(" S      : flip the spin axis from X to Y or Y to X\n");
   printf(" T      : move ball toward you\n");
   printf(" arrows : move ball up, down, left, right\n");
   printf(" Esc    : exit\n");
   printf("\nPress any key to begin...\n");
   if (getch() == 0x1B) exit(0);
}

void main(void)
{
int vertIndex = 0;

short Done = 0, i, count;
Object *ObjectPtr;
unsigned long t1, t2;
BYTE far *shape;
event_t event;
short rot_state=0, accn_state=0;
Fixedpoint sin, cos;
short PolySpeed=0;
short movesUpDown = 0;
//   DisplayInstructions();  /* put up opening instruction screen */

   init_exit();
   init_mem_list();
   init_timer();
   init_xmode_video();
   init_events("crshair.cbm");
   gb_auto_repeat=1;

   /* Clip rectangle; clips to the screen */
   PolyClipMinX = 0;
   PolyClipMinY = 0;
   PolyClipMaxX = ScrnLogicalPixelWidth;
   PolyClipMaxY = ScrnLogicalHeight;

   PolyCentreX=ScrnLogicalPixelWidth>>1;
   PolyCentreY=ScrnLogicalHeight>>1;
   PolyScreenWidth=INT_TO_FIXED(-ScrnLogicalPixelWidth);

pr2("init obj");
   InitializeObjectList(); /* set up the initial objects */
pr2("init fixed");
   InitializeFixedPoint(); /* set up fixed-point data */

pr2("load shape");
 shape=far_load("t.m13");
   if ( !shape )
     {
     die("t.m13 not found");
      }
pr2("initballs");
   InitializeBalls(shape);      /* set up the ball(s) and add them to the
                              object list */
   /* set palette */
pr2("loading palette");
   if ( load_palette("title3d.pal", palette) )
      {
      die("error getting palette");
      }

   setvgapalette(palette);

pr2("NumObjects = %d", NumObjects);

   count=100;
   t1=TICKS;

  // initialize start location
  ObjectPtr = ObjectListStart.NextObject;
  for( i= 0; i < NUM_MOVES_AWAY; i++ )
     {
     BallEvent |= MOVE_AWAY;
     BallEvent |= MOVE_AWAY;
     BallEvent |= MOVE_UP;
     RotateAndMoveSign(ObjectPtr);
     }

   /* Keep transforming the objects, drawing them to the undisplayed page,
      and flipping the page to show them */
   do {

      /* For each object, regenerate viewing info, if necessary */
      for (i=0, ObjectPtr = ObjectListStart.NextObject; i<NumObjects;
            i++, ObjectPtr = ObjectPtr->NextObject)
         {
         if (ObjectPtr->RecalcXform || RecalcAllXforms)
            {
            XformAndProjectPObject(ObjectPtr);
            ObjectPtr->RecalcXform = 0;
            }
         }
      RecalcAllXforms = 0;

      x_screen_fill(HiddenPageOffs, 0);

      /* Sort the objects so we can draw them back to front */
      SortObjects();

      /* Draw all objects */
      for (i=0, ObjectPtr = ObjectListStart.NextObject; i<NumObjects;
            i++, ObjectPtr = ObjectPtr->NextObject)
         {
         if ( !((PObject *)ObjectPtr)->not_draw )
            DrawPObject(ObjectPtr);
         }


      /* Let the user control ball location */
///*
     if ( get_event(&event) )
         {
         switch ( event.type )
            {
            case E_B0_DN:
               PolySpeed=0;
               break;
            case E_B1_DN:
               ViewAngle=0;
               break;

            case E_JOY_X_LEFT:
               rot_state=5;
               break;

            case E_JOY_X_CENTRE:
               rot_state=0;
               break;

            case E_JOY_X_RIGHT:
               rot_state=-5;
               break;

            case E_JOY_Y_UP:
               accn_state=-1;
               break;

            case E_JOY_Y_CENTRE:
               accn_state=0;
               break;

            case E_JOY_Y_DOWN:
               accn_state=1;
               break;

            case E_KEY:
               if ( event.sub_type == E_UP )
                  {
                  switch ( event.d2 )
                     {
                     case ESC:
                        Done=1;
                        break;

                     }
                  }
               else
                  {
                  switch ( event.d2 )
                     {
                     case (UP | KM_CTRL_PLUS):
                        BallEvent |= MOVE_UP;
                        break;

                     case (DOWN | KM_CTRL_PLUS):
                        BallEvent |= MOVE_DOWN;
                        break;

                     case UP:
                        BallEvent |= MOVE_TOWARD;
                        break;

                     case DOWN:
                        BallEvent |= MOVE_AWAY;
                        break;

                     case SPACE:
                        BallEvent |= FLIP_SPIN_AXIS;
                        break;

                     case LEFT:
                        BallEvent |= MOVE_LEFT;
                        break;

                     case RIGHT:
                        BallEvent |= MOVE_RIGHT;
                        break;

                     case 'v':  vertIndex--; vertIndex=max(0,vertIndex); break;
                     case 'V':  vertIndex++; vertIndex=min(15,vertIndex); break;

                     case 'x':  Verts[ vertIndex ].X -= 0x10000L; break;
                     case 'X':  Verts[ vertIndex ].X += 0x10000L; break;

                     case 'y':  Verts[ vertIndex ].Y -= 0x10000L; break;
                     case 'Y':  Verts[ vertIndex ].Y += 0x10000L; break;

                     case 'z':  Verts[ vertIndex ].Z -= 0x10000L; break;
                     case 'Z':  Verts[ vertIndex ].Z += 0x10000L; break;

                     case '0':  BallEvent |= RESET_SPIN;  break;
                     case '1':  BallEvent |= SPIN_X_AXIS; break;
                     case '2':  BallEvent |= SPIN_Y_AXIS; break;
                     case '3':  BallEvent |= SPIN_Z_AXIS; break;


                        }

                  }
               break;

            }
         }
//*/

       if ( movesUpDown++ < NUM_MOVES_DOWN_TOWARD )
          {
          BallEvent |= MOVE_DOWN;
          BallEvent |= MOVE_TOWARD;
          }
       else
          if ( movesUpDown++ < NUM_MOVES_DOWN_TOWARD+NUM_MOVES_UP_TOWARD )
             {
             BallEvent |= MOVE_UP;
             BallEvent |= MOVE_TOWARD;
             }
          else
             BallEvent |= MOVE_TOWARD;


      if ( rot_state )
         {
         ViewAngle+=rot_state;
         if ( ViewAngle > 3600 )
            {
            ViewAngle=0;
            }
         else
            {
            if ( ViewAngle < 0 )
               ViewAngle=3600;
            }
         }
      if ( accn_state )
         {
         PolySpeed+=accn_state;
         if ( PolySpeed < -10 )
            PolySpeed=-10;
         else
            {
            if ( PolySpeed > 10 )
               PolySpeed=10;
            }
         }
      if ( PolySpeed )
         {
         CosSin((TAngle)ViewAngle, &cos, &sin);
         WorldCentre.Z+=FixedMul(INT_TO_FIXED(PolySpeed), cos);
         WorldCentre.X+=FixedMul(INT_TO_FIXED(PolySpeed), sin);
         }
      /* Move and reorient each object */
      for (i=0, ObjectPtr = ObjectListStart.NextObject; i<NumObjects;
            i++, ObjectPtr = ObjectPtr->NextObject)
         {
         RotateAndMoveSign(ObjectPtr);
         }

      BallEvent &= ~FLIP_SPIN_AXIS;
      BallEvent &= ~MOVE_LEFT;
      BallEvent &= ~MOVE_RIGHT;
      BallEvent &= ~MOVE_DOWN;
      BallEvent &= ~MOVE_TOWARD;
      BallEvent &= ~MOVE_AWAY;
      BallEvent &= ~MOVE_UP;
      BallEvent &= ~SPIN_X_AXIS;
      BallEvent &= ~SPIN_Y_AXIS;
      BallEvent &= ~SPIN_Z_AXIS;
      BallEvent &= ~RESET_SPIN;


      x_page_flip(0,0);
      page= page ? 0 : 1;

      --count;
      if ( count == 0 )
         {
         t2=TICKS;
         t2-=t1;
         t2=1860 / t2;
         pr2("%lu frames per second t1 %lu", t2, t1);
         count=100;
         t1=TICKS;
         }

   } while (!Done);

   gfree(shape, "bitmap");
   deinit_events();
   deinit_xmode_video();
   deinit_timer();

   exit(1);
}



