/*

    testa.c

    Internet: alexad3@icebox.iceonline.com
    Copyright 1995, April 14 by Alec Russell, ALL rights reserved

    Created - 1993/4/14

    A silly little demo of basic tcmgame stuff
    This pre-dates the anim engine - thats why it isn't used.

    History:
        New file

*/




#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <alloc.h>
#include <dos.h>
#include <time.h>

#include <pr2.h>
#include <palette.h>>
#include <readlbm.h>
#include <fstring.h>
#include <g_io.h>
#include <gui.h>
#include <erase.h>
#include <die.h>
#include <gmalloc.h>

#include <Xlib_all.h>

typedef char far * farptr;


#define NUMSHPS 6

typedef struct
   {
   short width, height;
   short x, y;
   short min_x, max_x, min_y, max_y;
   short dx, dy;
   char far *pbm;
   }
anm_t;

typedef struct
   {
   BYTE width, height;
   short x[2], y[2];
   short min_x, max_x, min_y, max_y;
   short x0, y0;
   short dx, dy;
   }
shift_t;


// move the backgound pic, then draw a black rect to cover the edge
// moved from
/* ---------------------- move_rect() --------------------- June 13,1993 */
void move_rect(shift_t *s)
{
   short dx, dy;

   s->x0+=s->dx;
   s->y0+=s->dy;

   if ( s->x0 < s->min_x )
      {
      s->dx*=-1;
      s->x0=s->min_x;
      }
   else
      {
      if ( s->x0 > s->max_x )
         {
         s->dx*=-1;
         s->x0=s->max_x;
         }
      }

   if ( s->y0 < s->min_y )
      {
      s->dy*=-1;
      s->y0=s->min_y;
      }
   else
      {
      if ( s->y0 > s->max_y )
         {
         s->dy*=-1;
         s->y0=s->max_y;
         }
      }

   x_shift_rect(s->x[page], s->y[page], s->x[page]+s->width,
               s->y[page]+s->height, s->x0, s->y0, HiddenPageOffs);

   dx=s->x0 - s->x[page];
   dy=s->y0 - s->y[page];

   if ( dx > 0 )
      {
      /* moved right */
      if ( dy > 0 )
         {
         /* moved down */
         x_rect_fill(s->x[page], s->y[page],
                     s->x0, s->y[page] + s->height, HiddenPageOffs, 0);
         x_rect_fill(s->x0, s->y[page],
                     s->x[page] + s->width, s->y0 + 1, HiddenPageOffs, 0);
         }
      else
         {
         if ( dy < 0 )
            {
            /* moved up */
            x_rect_fill(s->x[page], s->y[page],
                        s->x[page] + dx, s->y0 + s->height, HiddenPageOffs, 0);
            x_rect_fill(s->x[page], s->y0 + s->height,
                        s->x[page] + s->width, s->y[page] + s->height, HiddenPageOffs, 0);
            }
         else
            {
            /* no y move */
            x_rect_fill(s->x[page], s->y0,
                        s->x[page] + dx, s->y0 + s->height, HiddenPageOffs, 0);
            }
         }
      }
   else
      {
      if ( dx < 0 )
         {
         /* moved left */
         if ( dy > 0 )
            {
            /* moved down */
            x_rect_fill(s->x0 + s->width, s->y[page],
                        s->x[page] + s->width, s->y0 + s->height, HiddenPageOffs, 0);
            x_rect_fill(s->x[page], s->y[page],
                        s->x0 + s->width, s->y0, HiddenPageOffs, 0);
            }
         else
            {
            if ( dy < 0 )
               {
               /* moved up */
               x_rect_fill(s->x0 + s->width, s->y[page],
                           s->x[page] + s->width, s->y[page] + s->height, HiddenPageOffs, 0);
               x_rect_fill(s->x[page], s->y0 + s->height,
                           s->x0 + s->width, s->y[page] + s->height, HiddenPageOffs, 0);
               }
            else
               {
               /* no y move */
               x_rect_fill(s->x0 + s->width, s->y0,
                           s->x[page] + s->width, s->y0 + s->height, HiddenPageOffs, 0);
               }
            }
         }
      else
         {
         /* no x move */
         if ( dy > 0 )
            {
            /* moved down */
            x_rect_fill(s->x0, s->y[page],
                        s->x0 + s->width, s->y0, HiddenPageOffs, 0);
            }
         else
            {
            if ( dy < 0 )
               {
               /* moved up */
               x_rect_fill(s->x0, s->y0 + s->height,
                           s->x0 + s->width, s->y[page] + s->height, HiddenPageOffs, 0);
               }
            }
         }
      }

   s->x[page]=s->x0;
   s->y[page]=s->y0;

}


/* ---------------------- main() ------------------------- April 28,1993 */
void main(void)
{
   int x, y, done, count, single=0, delay=0;
   unsigned int i;
   event_t event;
   shift_t shift;
   unsigned char far *bitmap;
   unsigned long t1, t2, t3, t4;
   anm_t anm[NUMSHPS];
   char temp[20];

   randomize();
   init_xmode_video();
   init_mem_list();
   /* set palette */
pr2("loading palette");
   if ( load_palette("small.pal", palette) )
      {
      die("error getting palette");
      }

   setvgapalette(palette);

   /* draw background */
pr2("load smallneb");
   bitmap=far_load("smallneb.pbm");
   if ( bitmap )
      {
      shift.width=*bitmap;
      shift.width<<=2;         // pbm widths are in bytes not pixels 
      shift.height=*(bitmap+1);
      x=(360 - shift.width) / 2;
      y=(240 - shift.height) / 2;
      shift.x[0]=shift.x[1]=shift.x0=x;
      shift.y[0]=shift.y[1]=shift.y0=y;
      x_put_pbm(x,y, HiddenPageOffs, bitmap);
      x_page_flip(0,0);
      x_put_pbm(x,y, HiddenPageOffs, bitmap);
      x_page_flip(0,0);
      shift.dx=4;
      shift.dy=4;
      shift.min_x=0;
      shift.min_y=0;
      shift.max_x=ScrnLogicalPixelWidth - shift.width;
      shift.max_x|=3;
      shift.max_x-=3;
      shift.max_y=ScrnLogicalHeight - shift.height;

      gfree(bitmap, "bitmap");
      }
   else
      {
      die("error getting small neb");
      }


   /* loads mouse also */
pr2("init events and load mouse");
   init_events("crshair.cbm");  // this must be AFTER init_xmode_video()

   /* init anm shapes */
   for ( i=0; i < NUMSHPS; i++ )
      {
      sprintf(temp, "shp%d.cbm", i);
      bitmap=far_load(temp);
      if ( bitmap == NULL )
         {
         die("ERROR opening %s", temp);
         }

      anm[i].width=*bitmap;
      anm[i].height=*(bitmap+1);

      do
         {
         anm[i].dx=4-random(8);
         anm[i].dy=4-random(8);
         }
      while ( anm[i].dx == 0 && anm[i].dx == 0 );
      anm[i].x=20 + random(150);
      anm[i].y=20 + random(120);
      anm[i].min_x=0;
      anm[i].min_y=0;
      anm[i].max_x=ScrnLogicalPixelWidth - anm[i].width;
      anm[i].max_y=ScrnLogicalHeight - anm[i].height;
      anm[i].pbm=bitmap+2;
      }

   /* set aside mem etc.. for 12 erase rects, not to exceed 9k */
   init_gb_erase(12, 9000);
   page=0;

   x=mouse_x;
   y=mouse_y;


   count=100;
   t1=TICKS;
   done=0;

   while ( !done )
      {
      if ( single )
         {
         while ( !get_event(&event) )
            {
            if ( event.type == E_KEY && event.sub_type == E_UP )
               {
               if ( event.d2 == 27 )
                  done=1;

               if ( event.d2 == 's' )
                  single=1;

               if ( event.d2 == 'c' )
                  single=0;

               if ( event.d2 == '-' )
                  if ( delay )
                     --delay;

               if ( event.d2 == '+' )
                     ++delay;
               }
            }
         }
      else
         {
         if ( get_event(&event) )
            {
            if ( event.type == E_KEY && event.sub_type == E_UP )
               {
               if ( event.d2 == 27 )
                  done=1;

               if ( event.d2 == 's' )
                  single=1;

               if ( event.d2 == 'c' )
                  single=0;

               if ( event.d2 == '-' )
                  if ( delay )
                     --delay;

               if ( event.d2 == '+' )
                     ++delay;
               }
            }
         }

      /* erase old stuff */
      draw_erase_rects(&(gb_h[page]));

      move_rect(&shift); // move the nebula via vmem to vmem memcpys

      /* draw anms */
      for ( i=0; i < NUMSHPS; i++ )
         {
         anm[i].x+=anm[i].dx;
         if ( anm[i].x < anm[i].min_x )
            {
            anm[i].x=anm[i].min_x;
            anm[i].dx*=-1;
            }
         else
            {
            if ( anm[i].x > anm[i].max_x )
               {
               anm[i].x=anm[i].max_x;
               anm[i].dx*=-1;
               }
            }

         anm[i].y+=anm[i].dy;
         if ( anm[i].y < anm[i].min_y )
            {
            anm[i].y=anm[i].min_y;
            anm[i].dy*=-1;
            }
         else
            {
            if ( anm[i].y > anm[i].max_y )
               {
               anm[i].y=anm[i].max_y;
               anm[i].dy*=-1;
               }
            }

         add_erase_rect(&(gb_h[page]), anm[i].x,anm[i].y, anm[i].width,
                        anm[i].height);
         x_put_cbitmap(anm[i].x,anm[i].y, HiddenPageOffs, anm[i].pbm);
         }


      /* draw the mouse */
      gui_draw_mouse();

      x_page_flip(0,0);
      page= page ? 0 : 1;

      if ( delay )
         {
         if ( delay > 300 )
            delay=300;

         t3=TICKS;
         t3+=delay;
         t4=TICKS;
         while ( t4 < t3 )
            {
            t4=TICKS;
            pr2("t3 %lu t4 %lu", t3, t4);
            }
         }

      --count;
      if ( count == 0 )
         {
         t2=TICKS;
         t2-=t1;
         t2=1860 / t2;
         pr2("%lu frames per second t1 %lu", t2, t1);
         count=100;
         t1=TICKS;
         }
      }

   deinit_gb_erase();

   for ( i=0; i < NUMSHPS; i++ )
      gfree(anm[i].pbm-2, "anm");

   deinit_events();

   deinit_xmode_video();
}


/* ------------------------------ EOF -------------------------------- */

