#ifndef DEF_TANK_II
#define DEF_TANK_II 1
/*

    tank_ii.h

    Internet: alexad3@icebox.iceonline.com
    Copyright 1994, September 26 by Alec Russell, ALL rights reserved

    Created - 1994/9/26

    History:
        New file

*/


#include <g_def.h>
#include <polygon.h>

#define MAX_PLAYERS 8

#define PATH_LEN 128
#define DATA_DIR "\\DATA\\"

#define ED_PIC_SIZE 8428u

// std.pal color cycle info
#define CYCLE_TIME 8
#define NUM_BLUE 8
#define NUM_RED 16
#define START_BLUE 64
#define START_RED 80
#define START_ORANGE 72
#define NUM_ORANGE 8


// ---------------------------------------------------------------------
// ---------------------------------------------------------------------
// ---------------------------------------------------------------------
// ---------------------------------------------------------------------
// ---------------------------------------------------------------------

// generic draw stuff


// ---------------------------------------------------------------------
// ---------------------------------------------------------------------
// ---------------------------------------------------------------------
// ---------------------------------------------------------------------
// ---------------------------------------------------------------------

#define NUM_XOBJS 30
#define NUM_POLYS 8
#define MAX_OBJS (NUM_XOBJS+NUM_POLYS)

#define NUM_GRD_TYPES 7

#define MAX_GZ -65536000l

enum DRAW_TYPES
   {
   D_DONT,
   D_XSCALE,
   D_POLY
   };

typedef struct
   {
   short width, height;
   BYTE far *bmap;
   }
grd_obj_t;

typedef struct
   {
   Point3 point;       // where it realy is
   Fixedpoint vz, vx;      // z in view space
   short width, height;// original width and height
   short nw, nh;       // width height to draw at
   short sx, sy;       // screen position to draw at
   short draw;         // is it visible?
   BYTE far *bmap;     // bit map pixels
   }
xscale_t;

typedef struct
   {
   short type;
   Fixedpoint z;
   void far *obj;
   }
qdraw_t;

typedef struct
   {
   short ViewAngle;
   short PolySpeed;
   short hd;
   short rot_state;
   short accn_state;
   short done;
   short num_qdraw;
   qdraw_t qdraw[MAX_OBJS];
   }
play_logic_t;

typedef struct
   {
   BYTE far *sky_pbm;
   BYTE far *shape;
   BYTE far *grd_top;
   BYTE far *grd_bot;
   BYTE far *obj1;
   grd_obj_t far *grd;
   xscale_t far *xobjs;
   }
play_data_t;



// global vars ------------------------------------------
extern play_logic_t pl;
extern play_data_t play_data;
extern char gb_path[PATH_LEN];   // holds path to data dir
extern char gb_utilstr[1034];    // scratch string
extern short player_num;
extern char *mods[];


// proto-types ------------------------------------------
short play(void);
void draw_strip(short x0, short y0, short x1, USHORT off,
                BYTE far *strip, USHORT hd);
void draw_back(USHORT offs);
void init_play_logic(void);
void do_play_logic(void);
void do_play_draw(void);
void deinit_play(void);
void init_play(void);

char *add_path(char *p);
void color_cycle_all(void);

/* ------------------------------ EOF -------------------------------- */
#endif
