/*

    tank.c

    Internet: alexad3@icebox.iceonline.com
    Copyright 1994, September 26 by Alec Russell, ALL rights reserved

    Created - 1994/9/26
   Part of the 3D ball demo

    History:
        New file

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <conio.h>
#include <alloc.h>
#include <dos.h>
#include <time.h>

#include <pr2.h>
#include <mode13.h>
#include <readlbm.h>
#include <fstring.h>
#include <g_io.h>
#include <gui.h>
#include <erase.h>
#include <die.h>
#include <gmalloc.h>

#include <Xlib_all.h>
#include "tank.h"


/* ---------------------- add_path() ------------------ February 10,1995 */
char *add_path(char *p)
{
   static char path[PATH_LEN];

   strcpy(path, gb_path);
   strcat(path, p);

   return(path);
}


/* ---------------------- set_data_path() -------------- February 21,1994 */
void set_data_path(char *p)
{
   strcpy(gb_path, p);
   p=gb_path;
   while ( *p++ )
      ;

   while ( *p != '\\' )
      p--;

   p++;
   *p=0;

   strcat(gb_path, DATA_DIR);

}





/* ---------------------- main() --------------------- September 26,1994 */
void main(int argc, char *argv[])
{
   short code;

clear_pr2();

   if ( argc > 1 )
      {
      pr2("argv[1] = %s", argv[1]);
      }

   init_mem_list();
   init_exit();
   init_timer();

   randomize();

   init_xmode_video();

   // set gb_path
   set_data_path(argv[0]);
   init_events(add_path("crshair.cbm"));

   x_screen_fill(HiddenPageOffs, 0);
   x_screen_fill(VisiblePageOffs, 0);

   /* set palette */
   if ( load_palette(add_path("std.pal"), palette) )
      {
      die("error getting palette");
      }
   setvgapalette(palette);
   
   play();

   deinit_events();
   deinit_xmode_video();
   deinit_timer();

   
}


/* ------------------------------ EOF -------------------------------- */

