/*

    sprdemo.c

    Internet: alexad3@icebox.iceonline.com
    Copyright 1995, April 13 by Bruce Miller, ALL rights reserved


    Created - 1995/4/13

    History:
        New file


    Modified 28April95 by Bruce Miller:

       * Added on-screen instructions

       * Added user control of goodguy's arm position.

       * Changed sprite draw routines to call move_limit_all_banks()
         and draw_all_banks() since sprBank.C now takes care of
         list of sprite banks.

       NOTE: Main files (like this one) need only define pointers to
             each sprite bank.



*/

#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <time.h>

#include <g_io.h>
#include <die.h>
#include <gmalloc.h>
#include <pr2.h>
#include <g_def.h>
#include <gui.h>
#include <gtimer.h>
#include <erase.h>
#include <colors.h>

#include <xlib_all.h>

#include <sprite.h>
#include <sprbank.h>

//------- Constants ---------
#define ENABLE_ERASE 1
#define NO_ERASE 0

#define NUM_GOODGUY_SPRITES 1
#define NUM_BADGUY_SPRITES 3
#define NUM_EXPLOSION_SPRITES 5
#define NUM_BALL_SPRITES 3
#define NUM_MISSILE_SPRITES 8


// clipping rectangle
#define clip_left 40
#define clip_right 312
#define clip_top 10
#define clip_bott 168

enum SpriteBankIDs {GGUY_ID,RBOOTJET_ID, LBOOTJET_ID, BADGUY_ID, EXPLD_ID,
                    BALL_ID, MISSILE_ID};

//--------- Local storage ----------
static int  gameOver = 0;
static USHORT badGuysStarted=0, badGuysHit=0;

sprite_bank_t far *ballBank, far *badGuyBank, far *explodeBank,
              far *missileBank, far *gguyBank,
              far *rBootJetBank, far *lBootJetBank;

static sprite_t far *gguy, far *ball, far *rBootJet, far *lBootJet;
static short paused = 0;
static short gguyArmPos=1;
static short eboltYVel[] = {2,0,-2}; // based on arm position(down,center,up)


/*--- Local Function Prototypes ---*/
static void userControl( void);
static void startNewBadGuy( void );
static void animate(void);
static void updateScreenInfo( void);
static void drawScreen(void);
static void intro( void );

/*---------------------------------------------------------------------------

    main()

---------------------------------------------------------------------------*/
void main( void )
{
char gamePalette[768];

   randomize();

#if 0
   clrscr();
   printf("\n\n\n SPRITE LIBRARY DEMO                          (c) Copyright Bruce Miller 1995\n");
   printf("\n\n <Arrow keys, Joystick = Move Goodguy>  <SpaceBar = Shoot Robots>    \n");
   printf("\n <Mouse just moves cursor arrow>    \n");
   printf("\n\n <P = Pause/SingleStep, Enter = Resume>  <Escape = Exit>   \n");

   printf("\n\n\n\tPress a key to start...  \n");
   getch();
#endif

   clear_pr2();
   pr2("at the top");


   init_exit();

   init_mem_list();

   init_timer();

   init_xmode_video();

   gb_auto_repeat=0;
   want_mouse_moves=0;
   init_events("crshair.cbm");


   load_palette( "bruce.pal", gamePalette);
   setvgapalette(gamePalette);

   drawScreen();

   /* set aside mem etc.. for 64 erase rects, not to exceed 32k */
   init_gb_erase(64, 32767);
   page = 0;

   // Read sprites from files, intialize...
   // NOTE: init order determines which sprites drawn over top of others
   //  ie: first initialized will be first drawn, therefore last initialized
   //  will be drawn over top of others
   init_sprites();
   ballBank= setup_spritebank("stlball.spr", NUM_BALL_SPRITES, BALL_ID,
                           0, ScrnPhysicalPixelWidth, 0, ScrnPhysicalHeight,
                           0, ScrnPhysicalPixelWidth, 0, ScrnPhysicalHeight,
                            ENABLE_ERASE, NUM_BALL_SPRITES);

   badGuyBank= setup_spritebank("robot.spr", NUM_BADGUY_SPRITES, BADGUY_ID,
                           clip_left, clip_right, clip_top, clip_bott,
                           clip_left, clip_right, clip_top, clip_bott,
                           ENABLE_ERASE, NUM_BADGUY_SPRITES);

   explodeBank= setup_spritebank("explode1.spr", NUM_EXPLOSION_SPRITES,EXPLD_ID,
                           clip_left, clip_right, clip_top, clip_bott,
                           clip_left, clip_right, clip_top, clip_bott,
                           ENABLE_ERASE, NUM_EXPLOSION_SPRITES);

   gguyBank= setup_spritebank("batsuit.spr",   NUM_GOODGUY_SPRITES, GGUY_ID,
                           clip_left, clip_right, clip_top, clip_bott,
                           clip_left, clip_right, clip_top, clip_bott,
                           ENABLE_ERASE, NUM_GOODGUY_SPRITES);

   rBootJetBank= setup_spritebank("rBootJet.spr",   NUM_GOODGUY_SPRITES, RBOOTJET_ID,
                           clip_left, clip_right, clip_top, clip_bott,
                           clip_left, clip_right, clip_top, clip_bott,
                           ENABLE_ERASE, NUM_GOODGUY_SPRITES);

   lBootJetBank= setup_spritebank("lBootJet.spr",   NUM_GOODGUY_SPRITES, LBOOTJET_ID,
                           clip_left, clip_right, clip_top, clip_bott,
                           clip_left, clip_right, clip_top, clip_bott,
                           ENABLE_ERASE, NUM_GOODGUY_SPRITES);

   missileBank= setup_spritebank("eball.spr", NUM_MISSILE_SPRITES, MISSILE_ID,
                           clip_left, clip_right, clip_top, clip_bott,
                           clip_left, clip_right, clip_top, clip_bott,
                           ENABLE_ERASE, NUM_MISSILE_SPRITES);

   // start good guy sprite, ball sprite
   // initialize the pointers to the special sprites
   gguy = gguyBank->sprites;
   rBootJet = rBootJetBank->sprites;
   lBootJet = lBootJetBank->sprites;

   start_sprite(gguy, SPR_CHG_STOP, SPR_HOLD_AT_XYLIMIT, clip_left+20, clip_top+20, 0,1);
   start_sprite(rBootJet, SPR_CHG_FORWARD, SPR_HOLD_AT_XYLIMIT, clip_left+20, clip_top+20, 1,1);
   start_sprite(lBootJet, SPR_CHG_FORWARD, SPR_HOLD_AT_XYLIMIT, clip_left+20, clip_top+20, 1,1);
   set_bitmap( gguy, gguyArmPos );

   ball = ballBank->sprites;
   start_sprite(ball, -1, SPR_BOUNCE_AT_XYLIMIT, clip_left+20, clip_top, 1, 1);
   ball = ballBank->sprites+1;
   start_sprite( ball, -1, SPR_BOUNCE_AT_XYLIMIT, clip_left+10, clip_top+50,
               -1, -1 );

   // start 3rd ball, set clip/limit rectangle differently from other 2
   ball = ballBank->sprites+2;
   ball->x_min = clip_left; ball->x_max = clip_right;
   ball->y_min = clip_top; ball->y_max = clip_bott;
   start_sprite(ball, -1, SPR_BOUNCE_AT_XYLIMIT, clip_left+100, clip_top, 1,-1);

   // draw screen, flip pages, draw on other page too
   page = 0;

   intro();

   while(!gameOver)
      {
      startNewBadGuy();  // starts a new bad guy whenever one goes inactive
      userControl();
      animate();
      updateScreenInfo();
      gui_draw_mouse();
      x_page_flip(PhysScrnXOffs,PhysScrnYOffs);
      page= page ? 0 : 1;
      }

   // terminate in the opposite order to the initialize
   deinit_sprites();
   deinit_gb_erase();
   deinit_events();
   deinit_xmode_video();
   deinit_timer();
}

#define SCROLL_PIXELS 4
/*---------------------------------------------------------------------------

    animate()

---------------------------------------------------------------------------*/
static void animate(void)
{
sprite_t far *sPtr;

   /* erase old stuff */
   draw_erase_rects(&(gb_h[page]));

   move_limit_all_banks();

   // locate the boot jet sprites with respect to the goodguy sprite
   // according to the multi-purpose x and y offsets set using sprutil.exe
   rBootJet->x = gguy->x+gguy->x_offs2-rBootJet->prev_cx;
   rBootJet->y = gguy->y+gguy->y_offs2-rBootJet->prev_cy;
   lBootJet->x = gguy->x+gguy->x_offs3-lBootJet->prev_cx;
   lBootJet->y = gguy->y+gguy->y_offs3-lBootJet->prev_cy;

   draw_all_banks();

   //--- check for missiles hitting bad guys
   if( (sPtr = detect_collisions(0, missileBank, badGuyBank) ) != NULL )
    {
    sPtr->change_mode = SPR_CHG_DEAD;
    start_next_in_spritebank(explodeBank,   SPR_CHG_FORW_DIE,
                               SPR_NO_LIMITS, sPtr->x+(sPtr->curr_width>>2),
                               sPtr->y+(sPtr->curr_height>>2), 0, 0);
    badGuysHit++;
    }
}

/*---------------------------------------------------------------------------

    userControl()

---------------------------------------------------------------------------*/
static void userControl( void)
{
event_t event;
short gotEvent = 0;

      if ( paused )
    while( !gotEvent )
       gotEvent = get_event(&event);
      else
    gotEvent = get_event(&event);

      if ( gotEvent )
     {
    switch ( event.type )
            {
            case E_JOY_X_LEFT:
               gguy->dx=-1;
               break;

            case E_JOY_X_CENTRE:
               gguy->dx=0;
               break;

            case E_JOY_X_RIGHT:
               gguy->dx=1;
               break;

            case E_JOY_Y_UP:
               gguy->dy=-1;
               break;

            case E_JOY_Y_CENTRE:
               gguy->dy=0;
               break;

            case E_JOY_Y_DOWN:
               gguy->dy=1;
               break;

            case E_B0_DN:
            case E_B1_DN:
            //--- launch bolt ---
            start_next_in_spritebank( missileBank, SPR_CHG_FORW_HOLD,
                     SPR_DIE_AT_XYLIMIT, gguy->x+gguy->x_offs1,
                   gguy->y+gguy->y_offs1, 7, eboltYVel[gguy->icurr_bitmap] );
               break;

       case E_KEY:
          if ( event.sub_type == E_DOWN )
        {
        switch( event.d2 )
           {
           case ESC:
              gameOver = 1;
              break;

                     case (KM_CTRL_PLUS|UP):
                       gguyArmPos++;
                       if( gguyArmPos > 2)
                         gguyArmPos = 2;
                       set_bitmap( gguy, gguyArmPos );
                       break;
                     case (KM_CTRL_PLUS|DOWN):
                       gguyArmPos--;
                       if( gguyArmPos < 0 )
                         gguyArmPos = 0;
                       set_bitmap( gguy, gguyArmPos );
                       break;

           case UP:     gguy->dy=-1;  break;
           case DOWN:   gguy->dy=1;  break;
           case LEFT:   gguy->dx=-1;  break;
           case RIGHT:  gguy->dx=1;  break;
           case HOME:   gguy->dx = gguy->dy = 0;  break;
           case SPACE:
              //--- launch bolt ---
                        start_next_in_spritebank( missileBank,
                                  SPR_CHG_FORW_HOLD,   SPR_DIE_AT_XYLIMIT,
                                  gguy->x+gguy->x_offs1, gguy->y+gguy->y_offs1,
                                  7, eboltYVel[gguy->icurr_bitmap] );
                        break;

           case 'p':
           case 'P':
             paused = 1;
             break;

           case CR:
              paused = 0;
              break;
           }
          }
             else
               {
           if ( event.sub_type == E_UP )
                  {
                  switch ( event.d2 )
                     {
           case UP:     gguy->dy=0;  break;
           case DOWN:   gguy->dy=0;  break;
           case LEFT:   gguy->dx=0;  break;
           case RIGHT:  gguy->dx=0;  break;
                     }
                  }
               }
          break;
            }

    }
}

#define INTRO_TIME 200
#define ARM_MOVE_TIME 6

/*---------------------------------------------------------------------------

   intro()

---------------------------------------------------------------------------*/
static void intro( void )
{
static long introTime, armMoveTime;
static short armDirUp=1;

   introTime = fast_tick + INTRO_TIME;
   armMoveTime = fast_tick + ARM_MOVE_TIME;
   while( fast_tick < introTime )
      {

      // move ggguy up and down
      if ( gguy->y > 110 && gguy->dy > -1 )
         gguy->dy= -1;
      else
         if ( gguy->y < 20 && gguy->dy < 1 )
            gguy->dy= 1;

      // move good guy's arm, shoot
      if ( fast_tick > armMoveTime )
         {
         // move arm up and down
         if ( armDirUp )
            {
            gguyArmPos++;
            if ( gguyArmPos > 2)
               {
               gguyArmPos = 2;
               armDirUp=0;
               }
            }
         else
            {
            gguyArmPos--;
            if( gguyArmPos < 0 )
              {
              gguyArmPos = 0;
              armDirUp=1;
              }
            }
         set_bitmap( gguy, gguyArmPos );

         // shoot
         start_next_in_spritebank( missileBank,
                                SPR_CHG_FORW_HOLD, SPR_DIE_AT_XYLIMIT,
                                gguy->x+gguy->x_offs1, gguy->y+gguy->y_offs1,
                                7, eboltYVel[gguy->icurr_bitmap] );

         armMoveTime = fast_tick + ARM_MOVE_TIME;
         }
      startNewBadGuy();  // starts a new bad guy whenever one goes inactive
      userControl();
      animate();
      updateScreenInfo();
      gui_draw_mouse();
      x_page_flip(PhysScrnXOffs,PhysScrnYOffs);
      page= page ? 0 : 1;
      }

     // set goodguy's arm position to middle
     gguyArmPos=1;
     set_bitmap( gguy, gguyArmPos );

}

/*---------------------------------------------------------------------------

startNewBadGuy()

---------------------------------------------------------------------------*/
static void startNewBadGuy( void )
{
int i;
sprite_t far *sPtr;

   for(i = 0; i < NUM_BADGUY_SPRITES; i++)
      {
      sPtr = badGuyBank->sprites+i;
      if( sPtr->change_mode == SPR_CHG_DEAD )
         {
         start_scaled_sprite( sPtr, SPR_CHG_FORWARD, SPR_CLIP_DIE_AT_XYLIMIT,
            clip_right-4, (rand()%100)+clip_top+20, -((rand() % 2)+1), ((rand() % 3)-1),
            10, 15, PROPORTIONAL, 1 );    //initial scale factor, dw, dh
         sPtr->h_max = 40;  // maximum height of scaled sprite
         badGuysStarted++;
         break;
         }
      }
}

#define TICKS_PER_SECOND 60

/*---------------------------------------------------------------------------

    updateScreenInfo()

---------------------------------------------------------------------------*/
static void updateScreenInfo( void)
{
static short frameCount, framesPerSecond;
static long frameTimer;

   frameCount++;
   if ( fast_tick < frameTimer )
      return;

   frameTimer = fast_tick + TICKS_PER_SECOND;
   framesPerSecond = frameCount;
   frameCount = 0;

   x_bgprintf(6,205,VisiblePageOffs,EGA_YELLOW,EGA_BLACK,
     (char far *)"Frames/sec:%2d Robots hit:%d Hit/Escaped:%d\%",
     framesPerSecond, badGuysHit, (short)((long)(badGuysHit*100)/badGuysStarted) );

   x_bgprintf(6,205,HiddenPageOffs,EGA_YELLOW,EGA_BLACK,
     (char far *)"Frames/sec:%2d Robots hit:%d Hit/Escaped:%d\%",
     framesPerSecond, badGuysHit, (short)((long)(badGuysHit*100)/badGuysStarted) );

}

/*---------------------------------------------------------------------------

   drawScreen()

---------------------------------------------------------------------------*/
static void drawScreen(void)
{
BYTE far *bck;


   LeftClip= clip_left/4; RightClip= clip_right/4-1;
   TopClip= clip_top;   BottomClip= clip_bott;


   bck=(BYTE far *)far_load("bck.pbm");
   if ( bck )
      {
      x_put_pbm_clipxy(40,10, HiddenPageOffs , bck);
      x_put_pbm_clipxy(40,10, VisiblePageOffs, bck);
      gfree(bck, "bck.pbm");
      }

   // draw clipping rectangle
   x_line(clip_left-1,clip_top-1,clip_right,clip_top-1,EGA_WHITE,VisiblePageOffs);
   x_line(clip_right,clip_top-1,clip_right,clip_bott, EGA_WHITE,VisiblePageOffs);
   x_line(clip_right,clip_bott,clip_left-1,clip_bott,EGA_WHITE,VisiblePageOffs);
   x_line(clip_left-1,clip_bott,clip_left-1,clip_top-1,EGA_WHITE,VisiblePageOffs);

   x_line(clip_left-1,clip_top-1,clip_right,clip_top-1,EGA_WHITE,HiddenPageOffs);
   x_line(clip_right,clip_top-1,clip_right,clip_bott, EGA_WHITE,HiddenPageOffs);
   x_line(clip_right,clip_bott,clip_left-1,clip_bott,EGA_WHITE,HiddenPageOffs);
   x_line(clip_left-1,clip_bott,clip_left-1,clip_top-1,EGA_WHITE,HiddenPageOffs);

   // print instructions
   x_printf(7,221,VisiblePageOffs,EGA_DARKGRAY,
    (char far *)"<ArrowKeys,Joystick=Move><SpaceBar=Shoot>");
   x_printf(6,220,VisiblePageOffs,EGA_RED,
    (char far *)"<ArrowKeys,Joystick=Move><SpaceBar=Shoot>");

   x_printf(7,231,VisiblePageOffs,EGA_DARKGRAY,
    "<Ctrl+Up/Dn=Move Goodguy's arm up/down>");
   x_printf(6,230,VisiblePageOffs,EGA_RED,
    "<Ctrl+Up/Dn=Move Goodguy's arm up/down>");

   x_printf(7,221,HiddenPageOffs,EGA_DARKGRAY,
    (char far *)"<ArrowKeys,Joystick=Move><SpaceBar=Shoot>");
   x_printf(6,220,HiddenPageOffs,EGA_RED,
    (char far *)"<ArrowKeys,Joystick=Move><SpaceBar=Shoot>");
   x_printf(7,231,HiddenPageOffs,EGA_DARKGRAY,
    "<Ctrl+Up/Dn=Move Goodguy's arm up/down>");
   x_printf(6,230,HiddenPageOffs,EGA_RED,
    "<Ctrl+Up/Dn=Move Goodguy's arm up/down>");

}
