/*

    play.c

    Internet: alexad3@icebox.iceonline.com
    Copyright 1994, September 26 by Alec Russell, ALL rights reserved

    Created - 1994/9/26
   Part of the 3D ball demo

    History:
        New file

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <conio.h>
#include <alloc.h>
#include <dos.h>
#include <time.h>

#include <pr2.h>
#include <mode13.h>
#include <readlbm.h>
#include <fstring.h>
#include <g_io.h>
#include <gui.h>
#include <erase.h>
#include <die.h>
#include <gmalloc.h>

#include <Xlib_all.h>
#include <tank-ii.h>


/* ---------------------- play() --------------------- September 26,1994 */
short play(void)
{
   short code=0;
   int count;
   unsigned long t1, t2;
   BYTE far *dbuff;

   // for scaling
   ClipLt=4;    // Left clipping boundry
   ClipRt=283;  // Right clipping boundry
   ClipTp=4;    // Top clipping boundry
   ClipBt=162;  // Bottom clipping boundry


   /* Clip rectangle; clips to the screen for polygons */
   PolyClipMinX = 4;
   PolyClipMinY = 4;
   PolyClipMaxX = 284;
   PolyClipMaxY = 163;

   PolyCentreX=(PolyClipMaxX - PolyClipMinX + 1) >>1;
   PolyCentreY=(PolyClipMaxY - PolyClipMinY + 1) >>1;
   PolyScreenWidth=INT_TO_FIXED(-ScrnLogicalPixelWidth);

   InitializeObjectList(); /* set up the initial objects */
   InitializeFixedPoint(); /* set up fixed-point data */

   init_play_logic();

   init_play();
   dbuff=gmalloc(280*160 + 8, "dark");
   if ( !dbuff )
      die("out of mem - dbuff");

   draw_back(HiddenPageOffs);
   draw_back(VisiblePageOffs);
   page=0;

   // to calc frame rate
   count=100;
   t1=fast_tick;

   while ( !pl.done )
      {
      /* erase old stuff */
      draw_erase_rects(&(gb_h[page]));
      //x_rect_fill(4,65, 284, 163, HiddenPageOffs, 13);  // dirt
      x_put_pbm(4,65, HiddenPageOffs, play_data.grd_top);
      //x_put_pbm(4,65, HiddenPageOffs, play_data.grd_top);
      //x_put_pbm(4,100, HiddenPageOffs, play_data.grd_bot);

      draw_strip(4,4, 283, HiddenPageOffs, play_data.sky_pbm, (USHORT)pl.hd); // sky

      do_play_logic();

      do_play_draw();

      // a test only
      //x_rect_or(54,20, (100/4), 80, HiddenPageOffs, dbuff, 128);
      // x_rect_dark(56, 20, 25, 80, HiddenPageOffs);

      /* draw the mouse */
      gui_draw_mouse();

      x_page_flip(0,0);
      page= page ? 0 : 1;

      --count;
      if ( count == 0 )
         {
         t2=fast_tick;
         t2-=t1;
         t2=7440 / t2;
         pr2("%lu frames per second t1 %lu hd = %u", t2, t1, pl.hd);
         count=100;
         t1=fast_tick;
         }
      }

   gfree(dbuff, "dark");
   deinit_play();

   pr2("about to exit play");
   return(code);
}


/* ------------------------------ EOF -------------------------------- */

