/* Rotates and moves polygon-based objects (only balls, at the moment). */
// this is a slightly modified moveobj.c

#include <polygon.h>

#include "initsign.h"

#define X_BALL_MOVE 65536l
#define Y_BALL_MOVE 65536l
#define Z_BALL_MOVE 0x20000l

#define FifteenK 9830400000l       //(INT_TO_FIXED(15000))
#define MinusFifteenK -9830400000l //(INT_TO_FIXED(-15000))

/* X, Y, Z rotations for balls, in tenths of degrees (angles) */
static RotateControl InitialRotate[] ={ {0,10,0}};

// ALWAYS move everything!!! - if you try to save time by clipping here
// you cause a horrid mess!!!

void RotateAndMoveSign(PObject * ObjectToMove)
{
   /* Change the spin axis from X to Y or Y to X if requested by the user */
   if (BallEvent & FLIP_SPIN_AXIS) {
      if (ObjectToMove->Rotate.RotateX != 0) {
         ObjectToMove->Rotate.RotateX = 0;
         ObjectToMove->Rotate.RotateY = 25; /* 10 degree Y rotations */
      } else if (ObjectToMove->Rotate.RotateY != 0) {
         ObjectToMove->Rotate.RotateY = 0;
         ObjectToMove->Rotate.RotateZ = 12; /* 5 degree Z rotations */
      } else {
         ObjectToMove->Rotate.RotateZ = 0;
         ObjectToMove->Rotate.RotateX = 64; /* 1.6 degree X rotations */
      }
   }

   if (BallEvent & SPIN_X_AXIS)
    {
      ObjectToMove->Rotate = InitialRotate[0];

      ObjectToMove->Rotate.RotateX = 25; /* 1.6 degree X rotations */
      ObjectToMove->Rotate.RotateY = 0;
      ObjectToMove->Rotate.RotateZ = 0;
    }

   if (BallEvent & SPIN_Y_AXIS)
    {
      ObjectToMove->Rotate = InitialRotate[0];

      ObjectToMove->Rotate.RotateX = 0;
      ObjectToMove->Rotate.RotateY = 30; /* 10 degree Y rotations */
      ObjectToMove->Rotate.RotateZ = 0;
    }

   if (BallEvent & SPIN_Z_AXIS)
    {
      ObjectToMove->Rotate = InitialRotate[0];

      ObjectToMove->Rotate.RotateX = 0;
      ObjectToMove->Rotate.RotateY = 0;
      ObjectToMove->Rotate.RotateZ = 12; /* 5 degree Z rotations */
    }

   /* Rotate the ball as needed */
   if (--ObjectToMove->RDelayCount == 0) {   /* rotate */
      ObjectToMove->RDelayCount = ObjectToMove->RDelayCountBase;
      if (ObjectToMove->Rotate.RotateX != 0)
         AppendRotationX(ObjectToMove->XformToWorld,
               ObjectToMove->Rotate.RotateX);
      if (ObjectToMove->Rotate.RotateY != 0)
         AppendRotationY(ObjectToMove->XformToWorld,
               ObjectToMove->Rotate.RotateY);
      if (ObjectToMove->Rotate.RotateZ != 0)
         AppendRotationZ(ObjectToMove->XformToWorld,
               ObjectToMove->Rotate.RotateZ);
      ObjectToMove->RecalcXform = 1;
   }

   /* Move the ball in response to recorded key events */
   if (BallEvent & MOVE_LEFT)
      {
      ObjectToMove->XformToWorld[0][3] -= X_BALL_MOVE;
      ObjectToMove->RecalcXform = 1;
      }
   if (BallEvent & MOVE_RIGHT)
      {
      ObjectToMove->XformToWorld[0][3] += X_BALL_MOVE;
      ObjectToMove->RecalcXform = 1;
      }
   if (BallEvent & MOVE_UP)
      {
      ObjectToMove->XformToWorld[1][3] += Y_BALL_MOVE;
      ObjectToMove->RecalcXform = 1;
      }
   if ( BallEvent & MOVE_DOWN)
      {
      ObjectToMove->XformToWorld[1][3] -= Y_BALL_MOVE;
      ObjectToMove->RecalcXform = 1;
      }
   if (BallEvent & MOVE_TOWARD)
      {
      if (ObjectToMove->XformToWorld[2][3] < MIN_Z)
         {
         ObjectToMove->XformToWorld[2][3] += Z_BALL_MOVE;
         ObjectToMove->RecalcXform = 1;
         }
      }
   if (BallEvent & MOVE_AWAY)
      {
      //if (ObjectToMove->XformToWorld[2][3] > MinusFifteenK)
         {
         ObjectToMove->XformToWorld[2][3] -= Z_BALL_MOVE;
         ObjectToMove->RecalcXform = 1;
         }
      }
}


