/*

    logic.c

    Internet: alexad3@icebox.iceonline.com
    Copyright 1994, September 26 by Alec Russell, ALL rights reserved

    Created - 1994/9/26
   Part of the 3D ball demo

    History:
        New file

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <conio.h>
#include <alloc.h>
#include <dos.h>
#include <time.h>

#include <pr2.h>
#include <palette.h>
#include <readlbm.h>
#include <fstring.h>
#include <g_io.h>
#include <gui.h>
#include <erase.h>
#include <die.h>
#include <gmalloc.h>

#include <Xlib_all.h>
#include "tank.h"

// POLY stuff
/* Contains flags indicating pending ball moves */
short BallEvent = FLIP_SPIN_AXIS;

play_logic_t pl;

/* ---------------------- init_play_logic() ---------- September 26,1994 */
void init_play_logic(void)
{
   pl.ViewAngle=0;
   pl.PolySpeed=30;
   pl.hd=0;
   pl.rot_state=0;
   pl.accn_state=0;
   pl.done=0;

}

#if 0
// this code was for rocks/bushes moving by on the ground
// an experiment

/* ---------------------- project_grdobjs() ------------ September 27,1994 */
void project_grdobjs(void)
{
   short i;
   xscale_t far *xb;
   Fixedpoint cos, sin, x, z, x0;
   Xform XformToView;
   Point3 XformedPoints;

   memset(&XformToView, 0, sizeof(Xform));
   CosSin((TAngle)pl.ViewAngle, &cos, &sin);
   for ( i=0, xb=play_data.grdobjs; i < NUM_GRDOBJS; i++, xb++ )
      {
      // this is a 2d hack that assumes that Y is 0 ----
      x=xb->point.X - WorldCentre.X;  // WorldCentre is where the players tank is at
      z=xb->point.Z - WorldCentre.Z;
      x0=FixedMul(x, cos) - FixedMul(z, sin);
      z= FixedMul(z, cos) + FixedMul(x, sin);
      if ( z > MIN_Z || z < MAX_GZ )
         {
         xb->draw=0;  // its behind us

         // move to infront of us in distance
         if ( pl.PolySpeed <= 0 )
            {
            z=-(random(700) + 300);
            x0=random(1000) - 500;
            x0=INT_TO_FIXED(x0);
            xb->point.Z=WorldCentre.Z+FixedMul(INT_TO_FIXED(z), cos);
            xb->point.X=WorldCentre.X+FixedMul(x0, sin);
            xb->point.X+=INT_TO_FIXED(random(100) - 50);
            }
         else
            {
            z=MIN_Z - INT_TO_FIXED(random(10)) - INT_TO_FIXED(5);
            x0=random(1000) - 500;
            xb->point.Z=WorldCentre.Z+FixedMul(z, cos);
            xb->point.X=WorldCentre.X+FixedMul(INT_TO_FIXED(x0), sin);
            }
         }
      else
         {
         XformToView[0][3]=x0;
         XformToView[2][3]=z;
         xb->draw=1;
         XformVec(&XformToView, (Fixedpoint *)&xb->point,
               (Fixedpoint *)&XformedPoints);
         xb->vz=XformToView[2][3];
         xb->vx=XformToView[0][3];
         x=FixedMul(FixedDiv(XformedPoints.X, XformedPoints.Z), PolyScreenWidth);
         xb->sx=((int) ((x + 32768l) >> 16)) + PolyCentreX;

         // calc size of bitmap
         x=FixedMul(FixedDiv(INT_TO_FIXED(xb->width), XformedPoints.Z), PolyScreenWidth);
         xb->nw=((int) ((x + 32768l) >> 16));
         x=FixedMul(FixedDiv(INT_TO_FIXED(xb->height), XformedPoints.Z), PolyScreenWidth);
         xb->nh=((int) ((x + 32768l) >> 16));


         xb->sy=PolyCentreY;
         xb->sx-=xb->nw>>1;
         xb->sy+=xb->nh;
         }
      }
}
#endif

/* ---------------------- project_xobjs() ------------ September 27,1994 */
void project_xobjs(void)
{
   short i;
   xscale_t far *xb;
   Fixedpoint cos, sin, x, z, x0;
   Xform XformToView;
   Point3 XformedPoints;

   memset(&XformToView, 0, sizeof(Xform));
   CosSin((TAngle)pl.ViewAngle, &cos, &sin);
   for ( i=0, xb=play_data.xobjs; i < NUM_XOBJS; i++, xb++ )
      {
      // this is a 2d hack that assumes that Y is 0 ----
      x=xb->point.X - WorldCentre.X;  // WorldCentre is where the players tank is at
      z=xb->point.Z - WorldCentre.Z;
      x0=FixedMul(x, cos) - FixedMul(z, sin);
      z= FixedMul(z, cos) + FixedMul(x, sin);
      if ( z > MIN_Z )
         {
         xb->draw=0;  // its behind us
         }
      else
         {
         XformToView[0][3]=x0;
         XformToView[2][3]=z;
         xb->draw=1;
         XformVec(&XformToView, (Fixedpoint *)&xb->point,
               (Fixedpoint *)&XformedPoints);
         xb->vz=XformToView[2][3];
         xb->vx=XformToView[0][3];
         x=FixedMul(FixedDiv(XformedPoints.X, XformedPoints.Z), PolyScreenWidth);
         xb->sx=((int) ((x + 32768l) >> 16)) + PolyCentreX;

         // calc size of bitmap
         x=FixedMul(FixedDiv(INT_TO_FIXED(xb->width), XformedPoints.Z), PolyScreenWidth);
         xb->nw=((int) ((x + 32768l) >> 16));
         x=FixedMul(FixedDiv(INT_TO_FIXED(xb->height), XformedPoints.Z), PolyScreenWidth);
         xb->nh=((int) ((x + 32768l) >> 16));


         xb->sy=PolyCentreY;
         xb->sx-=xb->nw>>1;
         xb->sy-=xb->nh>>1;
         }
      }
}



/* ---------------------- do_play_logic() ------------ September 26,1994 */
void do_play_logic(void)
{
   event_t event;
   Fixedpoint sin, cos;
   Object *ObjectPtr;
   short i;

   /* For each object, regenerate viewing info, if necessary */
   ViewAngle=pl.ViewAngle;
   for (i=0, ObjectPtr = ObjectListStart.NextObject; i < NumObjects;
         i++, ObjectPtr = ObjectPtr->NextObject)
      {
      if (ObjectPtr->RecalcXform || RecalcAllXforms)
         {
         XformAndProjectPObject(ObjectPtr);
         ObjectPtr->RecalcXform = 0;
         }
      }
   RecalcAllXforms = 0;


   if ( get_event(&event) )
      {
      switch ( event.type )
         {
         case E_B0_DN:
            pl.PolySpeed=0;
            break;

         case E_JOY_X_LEFT:
            pl.rot_state=5;
            break;

         case E_JOY_X_CENTRE:
            pl.rot_state=0;
            break;

         case E_JOY_X_RIGHT:
            pl.rot_state=-5;
            break;

         case E_JOY_Y_UP:
            pl.accn_state=-1;
            break;

         case E_JOY_Y_CENTRE:
            pl.accn_state=0;
            break;

         case E_JOY_Y_DOWN:
            pl.accn_state=1;
            break;

         case E_KEY:
            if ( event.sub_type == E_UP )
               {
               switch ( event.d2 )
                  {
                  case ESC:
                     pl.done=1;
                     break;


                  case CR:
                     pl.PolySpeed=0;
                     break;

                  case UP:
                     if ( pl.accn_state < 0 )
                        pl.accn_state=0;
                     break;
                  case DOWN:
                     if ( pl.accn_state > 0 )
                        pl.accn_state=0;
                     break;

                  case LEFT:
                     if ( pl.rot_state > 0 )
                        pl.rot_state=0;
                     break;
                  case RIGHT:
                     if ( pl.rot_state < 0 )
                        pl.rot_state=0;
                     break;

                  case 'i':
                     pr2("X %d y %d",
                          FIXED_TO_INT(WorldCentre.X),
                          FIXED_TO_INT(WorldCentre.Z));
                     break;

                  }
               }
            else
               {
               switch ( event.d2 )
                  {
                  case UP:
                     pl.accn_state=-1;
                     break;
                  case DOWN:
                     pl.accn_state=1;
                     break;

                  case LEFT:
                     pl.rot_state=5;
                     break;
                  case RIGHT:
                     pl.rot_state=-5;
                     break;

                  case SPACE:
                     BallEvent |= FLIP_SPIN_AXIS;
                     break;

                  /*
                  case (UP | KM_CTRL_PLUS):
                     BallEvent |= MOVE_UP;
                     break;

                  case (DOWN | KM_CTRL_PLUS):
                     BallEvent |= MOVE_DOWN;
                     break;

                  case UP:
                     BallEvent |= MOVE_TOWARD;
                     break;

                  case DOWN:
                     BallEvent |= MOVE_AWAY;
                     break;

                  case LEFT:
                     BallEvent |= MOVE_LEFT;
                     break;

                  case RIGHT:
                     BallEvent |= MOVE_RIGHT;
                     break;
                  */
                  }
               }
            break;

         }
      }

   if ( pl.rot_state )
      {
      if ( pl.rot_state > 0 )
         {
         pl.hd-=3;
         if ( pl.hd < 0 )
            pl.hd=1020;
         }
      else
         {
         pl.hd+=3;
         if ( pl.hd > 1020 )
            pl.hd=0;
         }

      pl.ViewAngle+=pl.rot_state;
      if ( pl.ViewAngle > 3600 )
         {
         pl.ViewAngle=0;
         }
      else
         {
         if ( pl.ViewAngle < 0 )
            pl.ViewAngle=3600;
         }
      }
   if ( pl.accn_state )
      {
      pl.PolySpeed+=pl.accn_state;
      if ( pl.PolySpeed < -30 )
         pl.PolySpeed=-10;
      else
         {
         if ( pl.PolySpeed > 30 )
            pl.PolySpeed=10;
         }
      }
   else
      {
      if ( pl.PolySpeed > 0 )
         pl.PolySpeed--;
      else
         {
         if ( pl.PolySpeed < 0 )
            pl.PolySpeed++;
         }
      }

   if ( pl.PolySpeed )
      {
      CosSin((TAngle)pl.ViewAngle, &cos, &sin);
      WorldCentre.Z+=FixedMul(INT_TO_FIXED(pl.PolySpeed), cos);
      WorldCentre.X+=FixedMul(INT_TO_FIXED(pl.PolySpeed), sin);
      }

   // calc position of xobjs
   project_xobjs();

   /* Move and reorient each POLYGON object */
   for (i=0, ObjectPtr = ObjectListStart.NextObject; i<NumObjects;
         i++, ObjectPtr = ObjectPtr->NextObject)
      {
      ViewAngle=pl.ViewAngle;
      RotateAndMoveBall(ObjectPtr);
      }
   BallEvent=0;

}


/* ------------------------------ EOF -------------------------------- */

