/*

    iplay.c

    Internet: alexad3@icebox.iceonline.com
    Copyright 1994, September 26 by Alec Russell, ALL rights reserved

    Created - 1994/9/26
   Part of the 3D ball demo

    History:
        New file

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <conio.h>
#include <alloc.h>
#include <dos.h>
#include <time.h>

#include <pr2.h>
#include <palette.h>
#include <readlbm.h>
#include <fstring.h>
#include <g_io.h>
#include <gui.h>
#include <erase.h>
#include <die.h>
#include <gmalloc.h>

#include <Xlib_all.h>
#include "tank.h"

play_data_t play_data;


void deinitballs(void);

/* ---------------------- deinit_play() -------------- September 26,1994 */
void deinit_play(void)
{
   short i;
   BYTE far *bm;
   char temp[90];

   deinitballs();

   for ( i=0; i < NUM_GRD_TYPES; i++ )
      {
      sprintf(temp, "%d grdx", i);
      bm=play_data.grd[i].bmap;
      gfree(bm-4, temp);
      }
   gfree(play_data.grd, "grd");

   gfree(play_data.sky_pbm, "sky");
   gfree(play_data.obj1, "obj1");
   gfree(play_data.grd_top, "grd_top");
   gfree(play_data.grd_bot, "grd_bot");
   gfree(play_data.xobjs, "xobjs");

   // testing
   gfree(play_data.shape, "tshape");

   deinit_gb_erase();

   del_exit(deinit_play, "play");
}


/* ---------------------- init_play() ---------------- September 26,1994 */
void init_play(void)
{
   short i;
   char temp[50];
   xscale_t far *xb;
   BYTE far *bmap;

   init_gb_erase(10, 2048u);

   WorldCentre.X=0;
   WorldCentre.Y=0;
   WorldCentre.Z=0;
   ViewAngle=0;

   play_data.grd=gmalloc(sizeof(grd_obj_t)*NUM_GRD_TYPES, "grd");
   if ( !play_data.grd )
      die("out of mem: grd");
   for ( i=0; i < NUM_GRD_TYPES; i++ )
      {
      sprintf(temp, "data\\g%d.m13", i);
      bmap=far_load(temp);
      if ( !bmap )
         die("can't find %s", temp);
      play_data.grd[i].bmap=bmap + 4;
      _fmemcpy(&play_data.grd[i].width, bmap, 2);
      _fmemcpy(&play_data.grd[i].height, bmap+2, 2);
      }

   play_data.sky_pbm=far_load("data\\allsky.pbm");
   if ( !play_data.sky_pbm )
      die("can't find allsky.pbm");

   play_data.obj1=far_load("data\\ob1.m13");
   if ( !play_data.obj1 )
      die("ob1.m13 not found");

   play_data.grd_top=far_load("data\\ground.pbm");
   // play_data.grd_top=far_load("data\\grd_top.pbm");
   if ( !play_data.grd_top )
      die("ground not found");
   play_data.grd_bot=far_load("data\\grd_bot.pbm");
   if ( !play_data.grd_bot )
      die("ground not found");

   // obstacles -------------------------------------------------
   play_data.xobjs=gmalloc(sizeof(xscale_t)*NUM_XOBJS, "xobjs");
   if ( !play_data.xobjs )
      die("out of mem: xobjs");

   // testing
   for ( i=0, xb=play_data.xobjs; i < NUM_XOBJS; i++, xb++ )
      {
      _fmemcpy(&xb->width, play_data.obj1, 2);
      _fmemcpy(&xb->height, play_data.obj1+2, 2);
      xb->bmap=play_data.obj1 + 4;
      xb->point.X=INT_TO_FIXED(random(20000u) - 10000u);
      xb->point.Y=0;
      xb->point.Z=INT_TO_FIXED(random(20000u) - 10000u);
      }

   // testing only here for polygons    ----------------------------
   play_data.shape=far_load("data\\t.m13");
   if ( !play_data.shape )
      die("t.m13 not found");

   InitializeBalls(play_data.shape); /* set up the ball(s) and add them to the */

   // testing stops only here !!! --------------------------------------------

   add_exit(deinit_play, "play");

}

/* ------------------------------ EOF -------------------------------- */

