/*-----------------------------------------------------------------------
;
; XRECT - header file
;
;
;
; ****** XLIB - Mode X graphics library                ****************
; ******                                               ****************
; ****** Written By Themie Gouthas                     ****************
;
; egg@dstos3.dsto.gov.au
; teg@bart.dsto.gov.au
;
;  Terminology & notes:
;         VRAM ==   Video RAM
;         SRAM ==   System RAM
;         X coordinates are in pixels unless explicitly stated
;
;-----------------------------------------------------------------------*/

#ifndef _XRECT_H_
#define _XRECT_H_


/* FUNCTIONS =========================================================== */


void x_screen_fill(WORD PageBase, WORD color);

extern void x_rect_pattern(      /* draw a pattern filled rectangle      */
         WORD StartX,
         WORD StartY,
         WORD EndX,
         WORD EndY,
         WORD PageBase,
         BYTE far * Pattern);

extern void x_rect_fill(         /* draw a single colour filled rectangle */
         WORD StartX,
         WORD StartY,
         WORD EndX,
         WORD EndY,
         WORD PageBase,
	 WORD color);

// OR a block with any number
void x_rect_or_slow(WORD X, WORD Y, BYTE BMwidth, BYTE BMheight,
               WORD ScrnOffs, BYTE far * Bitmap, BYTE or_val);

// set the high bits in a block, must be a mult of 4 pixels wide
// width in BYTES (4 pixels)
extern void x_rect_or_fast(         /* logical or a single colour filled rectangle */
         WORD StartX,
         WORD StartY,
         WORD EndX,
         WORD EndY,
         WORD PageBase,
	      WORD color);

extern void x_cp_vid_rect(       /* Copy rect region within VRAM          */
         WORD SourceStartX,
         WORD SourceStartY,
         WORD SourceEndX,
         WORD SourceEndY,
         WORD DestStartX,
         WORD DestStartY,
         WORD SourcePageBase,
         WORD DestPageBase,
         WORD SourceBitmapWidth,
         WORD DestBitmapWidth);

/* Copy a rectangular region of a VGA screen, with x coordinates
 rounded to the nearest byte -- source and destination may overlap. */
extern void x_shift_rect (WORD SrcLeft, WORD SrcTop,
			  WORD SrcRight, WORD SrcBottom,
			  WORD DestLeft, WORD DestTop, WORD ScreenOffs);

#endif



