/*-----------------------------------------------------------------------
;
; XPBMCLIP - header file
;
;
;
; ****** XLIB - Mode X graphics library                ****************
; ******                                               ****************
; ****** Written By Themie Gouthas                     ****************
;
; egg@dstos3.dsto.gov.au
; teg@bart.dsto.gov.au
;
;  Terminology & notes:
;         VRAM ==   Video RAM
;         SRAM ==   System RAM
;         X coordinates are in pixels unless explicitly stated
;
;-----------------------------------------------------------------------*/

#ifndef _XPBMCLIP_H_
#define _XPBMCLIP_H_


/* FUNCTIONS =========================================================== */

extern short x_put_masked_pbm_clipx(/* Copy a planar bitmap from SRAM masking */
	      short X,          /* only non zero pixels to VRAM           */
	      short Y,          /* Supports clipping in the X direction   */
	      WORD ScrnOffs,
	      BYTE far * Bitmap);


extern short x_put_masked_pbm_clipy(  /* Copy a planar bitmap from SRAM masking */
	      short X,          /* only non zero pixels to VRAM           */
	      short Y,          /* Supports clipping in the Y direction   */
	      WORD ScrnOffs,
	      BYTE far * Bitmap);

extern short x_put_masked_pbm_clipxy(/* Copy a planar bitmap from SRAM masking */
	      short X,          /* only non zero pixels to VRAM           */
	      short Y,          /* Supports clipping in the Y direction   */
	      WORD ScrnOffs,
	      BYTE far * Bitmap);

extern short x_put_pbm_clipx(   /* Copy a planar bitmap from SRAM masking */
	      short X,          /* Supports clipping in the x direction   */
	      short Y,
	      WORD ScrnOffs,
	      BYTE far * Bitmap);

extern short x_put_pbm_clipy(   /* Copy a planar bitmap from SRAM masking */
	      short X,          /* Supports clipping in the Y direction   */
	      short Y,
	      WORD ScrnOffs,
	      BYTE far * Bitmap);

         // only clips left OR right
extern short x_put_pbm_clipx(   /* Copy a planar bitmap from SRAM masking */
	      short X,          /* Supports clipping in the X direction   */
	      short Y,
	      WORD ScrnOffs,
	      BYTE far * Bitmap);

         // clips LEFT and RIGHT
extern short x_put_pbm_clipx2(   /* Copy a planar bitmap from SRAM masking */
         short dx,            // in bytes
         short dw,            // in bytes
	      short X,          /* Supports clipping in the X direction   */
	      short Y,
	      WORD ScrnOffs,
	      BYTE far * Bitmap);


extern short x_put_pbm_clipxy(   /* Copy a planar bitmap from SRAM masking */
	      short X,          /* Supports clipping in the X&Y directions */
	      short Y,
	      WORD ScrnOffs,
	      BYTE far * Bitmap);


#endif


