/*-----------------------------------------------------------------------
;
; XFILEIO - header file
;
;
;
; ****** XLIB - Mode X graphics library                ****************
; ******                                               ****************
; ****** Written By Themie Gouthas                     ****************
;
; egg@dstos3.dsto.gov.au
; teg@bart.dsto.gov.au
;
;  Terminology & notes:
;         VRAM ==   Video RAM
;         SRAM ==   System RAM
;         X coordinates are in pixels unless explicitly stated
;
;-----------------------------------------------------------------------*/

#ifndef _XFILEIO_H_
#define _XFILEIO_H_

#include <g_def.h>

#define F_RDONLY  0
#define F_WRONLY  1
#define F_RDWR    2

#define SEEK_START 0
#define SEEK_CURR  1
#define SEEK_END   2

#define FILE_ERR -1

/* FUNCTIONS =========================================================== */

extern short f_open(              /* Open a file returning its handle */
	 char * filename,
	 char access);

extern short f_close(             /* Close a file  */
	 short handle);

extern short f_read(              /* Read a block of data from a file */
	 short handle,
	 void far * buffer,
	 USHORT count);

extern short f_write(             /* Write a block of data to a file */
	 short handle,
	 void far * buffer,
	 USHORT count);

extern long f_seek(         /* Position the file pointer */
	 short handle,
	 long position,
	 char method_code);

extern long f_filelength(   /* Return the length of the file */
	 short handle);


extern USHORT load_size;
FARPTR far_load(char *name);
char *near_load(char *name);
char *near_reload(char *name, BYTE *b);
FARPTR far_reload(char *name, FARPTR b);
short global_put_env( char *varName, char *varText );

#endif




       
