/*

   FILE : tilemap.h


   HISTORY:
*/

#ifndef DEF_TILEMAP
#define DEF_TILEMAP 1

#include <sprite.h>


// tile attribute bits

#define  TILE_IMPASSABLE 0x1
#define  TILE_BLASTABLE  0x2
#define  TILE_OPAQUE     0x3
#define  TILE_DOOR       0x4

#define  TILE_MOVE_UP    0x5
#define  TILE_MOVE_DOWN  0x6
#define  TILE_MOVE_LEFT  0x7
#define  TILE_MOVE_RIGHT 0x8


// Miscellaneous
#define PBM_HEADER_SIZE 2
#define NUM_TILE_GROUPS 256
#define FNAMES_SIZE 15

// NOTE !! these must be big enough to hold total of all types that can be placed
//         only max for each sub-type is check, not overall max on map
#define MAX_LODRESS  256  // max number of over dresses on map
#define MAX_HIDRESS  256   // max number of normal/under dresses on the map
#define MAX_ANIM 256

typedef struct
{
short start, end;    // index into bitmap array for group of tiles
} tile_data_t;

typedef struct
{
tile_data_t groups[NUM_TILE_GROUPS];
} ed_info_t;


typedef struct
   {
   short x, y;   // pixel location on the map
   BYTE index;   // index into appropiate lib of data
   BYTE attrib;  // attributes for object (same as tiles)
   }
instance_t;


typedef struct
   {
   // names of files associated with this map
   char tile_name[FNAMES_SIZE];         // tile array file
   char dress_name[FNAMES_SIZE];        // dressings library file
   char anim_name[FNAMES_SIZE];         // sprite files library file
   char edinfo_name[FNAMES_SIZE];       // edit information file (only loaded
                               //  in edit mode)
   // map movement information
   short x, y;           // where the map top left corner should be
   short win_tile_cols, win_tile_rows;
   short actual_x[2];    // screen top left corner on map (pixels - each page)
   short actual_y[2];    // screen top left corner on map (pixels - each page)
   short win_left, win_right;   // min, max for left side of screen in map (pixels)
   short win_top, win_bottom;   // min, max for top of screen in map (pixels)
   short min_map_x, max_map_x;
   short min_map_y, max_map_y;

   // tile information
   BYTE tile_cols, tile_rows;  // size of map in tiles

   BYTE tile_width, tile_height;
   short tile_size;


   // tile arrays
   BYTE far *tile_bitmaps;   // raw tile lib, pbm tiles in array
   BYTE far *tile_inds;       // array of indexes into tile bitmaps
   BYTE far *tile_attribs;    // array of tile attribute bytes
                             // belongs to.
   USHORT num_tile_bitmaps;
   USHORT tilelib_size;

   // dressings and anims, number of each, pointers to array of locations
   // (and pointers to bitmaps in libraries) on map
   short num_low;
   instance_t far *low_dress;  // dressing draw UNDER tanks, eg bases
   short num_high;
   instance_t far *high_dress; // dressing to be drawn OVER tanks etc...
   short num_anims;
   instance_t far *anim;       // anims (sprites)

   BYTE far *dress_lib;   // raw dresslib, has header, followed by var length pbm,s
   BYTE far *anim_lib;     // raw anim lib
   sprite_bank_t far *spr_bank;    // sprite bank for anims

   USHORT dresslib_size;
   USHORT animlib_size;

   ed_info_t far *ed_info;   // edit information structure (only loaded/used
                            //  in edit mode)
   void far *user0;          // misc. pointers for specific implementations
   void far *user2;
   void far *user3;
   void far *user4;
   }
map_t;

// used to update the screen
enum last_moves
   {
   NO_MOVE,
   MOVE_RIGHT,
   MOVE_LEFT,
   MOVE_UP,
   MOVE_DOWN,
   MOVE_UP_RIGHT,
   MOVE_DOWN_RIGHT,
   MOVE_UP_LEFT,
   MOVE_DOWN_LEFT,
   UPDATE_TILES,
   UPDATE_DRESS,
   UPDATE_BOTH
   };

// init new maps
map_t far *new_tile_map(
              char *edInfoFileName,              // edit information file name
              char *tileFileName,                // tile library file name
              char *dressFileName,               // dress library file name
              char *animFileName,                // anim  library file name
              short winLeft, short winRight,
              short winTop, short winBottom,     // screen window
              short tileRows, short tileColumns, // how big is map
              short dfltStartTile, short dfltEndTile );// range of default tiles
                                                 // to be placed randomly
void calc_map(map_t far *map);

// load, save maps
map_t far *load_tile_map( char *fname, short winLeft, short winRight,
                                     short winTop,  short winBottom );
map_t far *load_edit_tile_map( char *fname, char *edInfoFileName, short winLeft, short winRight,
                                   short winTop,  short winBottom );

short save_tile_map(map_t far *map, char *fname );
short save_tile_lib( map_t far *map );
void deinit_tile_map(map_t far *map);


// drawing routines
void update_map_except_high_dressings( map_t far *map );
void draw_map_except_high_dressings( map_t far *map );
void draw_low_dressings(map_t far *map);
void draw_high_dressings(map_t far *map);
void draw_all_tiles( map_t far *map );
void update_tiles(map_t far *map);

// moving routines
void get_mouse_movemap_state(map_t far *map, short *p_move_state);
void move_map_xy( map_t far *map, short dx, short dy );
void move_map_vector( map_t far *map, short scroll_pixels, short vector );

// map anims (sprites) routines
BYTE far *get_lib_ptr(  BYTE far *lib, short index );
void init_map_sprite_instances( map_t far *map  );

// collision with tiles, tile attributes
short get_tile_attrib( map_t far *map, short x, short y );
short will_collide_with_tile( map_t far *map, sprite_t far *s );
void kill_sprites_at_impassable_tiles( map_t far *map, sprite_bank_t far *bank );
void stop_sprites_at_impassable_tiles( map_t far *map, sprite_bank_t far *bank );

#endif
