/*

    sprite.h

    Internet: alexad3@icebox.iceonline.com
    Copyright 1995, April 13 by Bruce Miller, ALL rights reserved

    Created - 1995/4/13

    History:
        New file

    Modified 21Apr95 by Bruce Miller:

     * Moved init_sprite_bank() into sprbank.c from sprite.c, removed
       header from sprite.h, added to sprbank.h

*/

#ifndef DEF_SPRITE
#define DEF_SPRITE 1

#define sprite_header_included 1

// Misc. constants
#define M13_HEADER_SIZE 4
#define PROPORTIONAL 512

// clipping control constants
#define X_CLIP 1
#define Y_CLIP 2
#define XY_CLIP 3

enum sprite_type
	 {
	 SPRITE_PBM,  // standard planed
	 SPRITE_PKB,  // RLE planed (packed)
	 SPRITE_M13,  // LINEAR, LBM usualy means a dpaint format file
	 SPRITE_CBM   // compiled
	 };

// this points to the actual bitmaps
typedef struct
	 {
	 short num_bitmaps;         // number of bitmaps
	 short default_change_delay;// ticks between frames
	 short default_change_mode; // default method of changing bitmaps
	 short default_move_mode;   // default method of movement at limits

	 BYTE far * far *bitmaps;     // array of pointers to bitmaps
	 BYTE far * far *clip_pbm_bitmaps; // array of pointers to .pbm bitmaps
	 }                                 // used for clipping .cbm, .pkb's
sprite_header_t;

// structure containing extra information stored before each bitmap in file
typedef struct
	 {
	 BYTE type;            // type of bitmap
	 short cx, cy;         // location of visual centre, relative to x,y
	 USHORT size; 				 //  (size necessary to packedbitmaps)
	 short pixel_width, pixel_height;

	 // Collision support, used for a smaller rectangle based on shape of
	 //  bitmap, all are offsets from x,y.
	 short collide_left, collide_right;
	 short collide_top,  collide_bottom;

   short x_offs1, y_offs1;   // offsets used to start bullets, missiles,
   short x_offs2, y_offs2;   // attach objects, etc.
   short x_offs3, y_offs3;
   short x_offs4, y_offs4;
	 }
bitmap_info_t;

/* -------------- instances ------------------------------------------ */

// structs etc for intances of a sprite
enum modes
	 {
	 SPR_CHG_DEAD,      // don't display at all
	 SPR_CHG_STOP,      // don't animate, show curr_frame only
	 SPR_CHG_FORWARD,   // inc frame, goto 1st when hit end
	 SPR_CHG_BACKWARD,  // dec frame, goto last when hit end
	 SPR_CHG_PINGPONG,  // inc frame until end, then dec frame etc...
	 SPR_CHG_FORW_HOLD, // inc through set once, then stop
	 SPR_CHG_FORW_DIE   // inc through set once, then die
	 };

enum movement_modes
	 {
	 SPR_NO_LIMITS,              // default, take no action or clip at
										 //      limits if clipping = 1;
	 SPR_HOLD_AT_XLIMIT,         // hold at x limit only
	 SPR_HOLD_AT_YLIMIT,         // hold at y limit only
	 SPR_HOLD_AT_XYLIMIT,        // hold at both limits

	 SPR_CLIP_DIE_AT_XYLIMIT,    // clip, then die when offscreen

	 SPR_DIE_AT_XLIMIT,          // disappear, die at x limits only
	 SPR_DIE_AT_YLIMIT,
	 SPR_DIE_AT_XYLIMIT,

	 SPR_BOUNCE_AT_XLIMIT,
	 SPR_BOUNCE_AT_YLIMIT,
	 SPR_BOUNCE_AT_XYLIMIT
	 };

// many of these can point to the same sp_header
typedef struct
{
BYTE id;                   // unique id number
USHORT attrib;             // attribute word - can be use for attribute bits
sprite_header_t far *sp_header;// points to main sprite header

BYTE far *curr_bitmap;     // points to current frame
short icurr_bitmap;        // index, this lets us set curr_bitmap easily
short curr_bitmap_type;
USHORT curr_bitmap_size;

BYTE change_mode;          // dead, stop, forward, back, ping-pong, etc.
short change_delay;        // ticks between bitmaps
ULONG next_change;         // tick at which we change frames

short d_pong;              // direction when ping-ponging

// x, y movement controls
short x, y;
short x_min, x_max;         // Bounding rectangle for movement - x
short y_min, y_max;         // Bounding rectangle for movement - y

short dx, dy;             // Delta x, delta y.
short prev_cx, prev_cy;   // visual center for previous bitmap
													// - used to adjust x, y when changing bitmaps
short pixel_width, pixel_height;  // in pixels, handy to have it here instead of
																	// buried in bitmap
short move_mode;          // what to do at limits, disappear, hold, bounce.

// Collision support: margin_left, right, etc. = margins to make the
//                collision rectangle smaller than the outer corners.
short collision;          // Collision detected

// Collision support, used for a smaller rectangle based on shape of
//  bitmap, all are offsets from x,y.
short collide_left, collide_right;
short collide_top,  collide_bottom;

// clipping support
short clip_left, clip_right;
short clip_top, clip_bottom;
short clipping;
short erase_enabled;

short x_delay, y_delay;   // delay between moves
ULONG next_x, next_y;     // tick at which next move happens

// scaling support
BYTE is_scaled;  // 0/1
short curr_width, curr_height;    // current width/height in pixels
short w_min, w_max;               // min, max width in pixels
short h_min, h_max;               // min, max height in pixels

short dw, dh;             // change in width/height
short w_delay, h_delay;   // ticks between size changes
ULONG next_w, next_h;     // tick at which next change ocurrs

short x_offs1, y_offs1;   // offsets used to start bullets, missiles,
short x_offs2, y_offs2;   // attach objects, etc.
short x_offs3, y_offs3;
short x_offs4, y_offs4;

void far *user0;          // user defined
void far *user2;
void far *user3;
void far *user4;
}
sprite_t;

typedef struct
	 {
	 short num_sprites;
	 short max_sprites;
	 BYTE  erase_enabled;
	 sprite_t far *sprites;    // list of sprite instances
	 }
sprite_bank_t;



/*------------ Function Prototypes ---------------*/

short collidedWithObj( sprite_t far *s, short objLeft, short objRight,
                       short objTop, short objBottom );

// Note: -1 for change_mode or move_mode sets them to defaults in header
void start_scaled_sprite(sprite_t far *s, short change_mode, short move_mode,
								 short x, short y, short dx, short dy,
								 short init_xscale, short init_yscale, short dw, short dh);
void start_sprite(sprite_t far *s, short change_mode, short move_mode,
						short x, short y, short dx, short dy);

void limit_sprite(sprite_t far *s);
void move_sprite(sprite_t far *s, ULONG frozen_tick);
void scale_sprite(sprite_t far *s, ULONG frozen_tick);

void draw_sprite(sprite_t far *s);
void draw_sprite_offs(sprite_t far *s, short x_offs, short y_offs);

void change_bitmap(sprite_t far *s, ULONG frozen_tick);
void set_bitmap(sprite_t far *s, short i_bitmap);

short add_sprite_instance(sprite_bank_t far *bank, sprite_header_t far *hd,
                          short id,  short clip_left, short clip_right,
                                     short clip_top, short clip_bottom,
                          short x_min, short x_max, short y_min,
                          short y_max, short erase);

short del_sprite_instance( sprite_bank_t far *bank, short id );

sprite_t far *get_sprite_instance(sprite_bank_t far *bank, short id);

BYTE far *init_spr_bmlist( sprite_header_t far *hd );
void deinit_spr_bmlist( sprite_header_t far *hd );

#endif
/* ------------------------------ EOF -------------------------------- */

