/*

    sprbank.h

    Written Bruce Miller

    Internet: alexad3@icebox.iceonline.com
    Copyright 1995, April 13 by Bruce Miller, ALL rights reserved

    Created - 1995/4/13

    History:
        New file


    Modified 21Apr95 by Bruce Miller:

     * Moved init_sprite_bank() into sprbank.c from sprite.c, removed
       header from sprite.h, added to sprbank.h

     * Added global spriteBanks array and MAX_SPRITE_BANKS constant for
       purposes of de-initing memory used by sprite structures.

*/

#ifndef DEF_SPRBANK
#define DEF_SPRBANK


// filename: SprBank.h           ** see end of file for documenation **

//------------ Constants ---------------
#define MAX_SPRITE_BANKS 32
enum collisionMessages  {  CHECK_ONLY = 1   };

//------------ Global Data Declarations --------------------
extern sprite_bank_t far * far spriteBanks[];
extern short numSpriteBanks;


//-------------- Function prototypes -----------------------
void init_sprites( void );
void deinit_sprites( void );
sprite_bank_t far *init_sprite_bank(short max_sprites);
void deinit_sprite_bank( sprite_bank_t far *bank );

sprite_bank_t far *setup_spritebank(char *spriteFileName, short numInstances,
                short id,  short clip_left, short clip_right,
                           short clip_top, short clip_bottom,
                short x_min, short x_max, short y_min, short y_max,
                short erase, short max_instance);

void move_limit_spritebank(sprite_bank_t far *bank_ptr);
void move_limit_all_banks(void);

void draw_spritebank(sprite_bank_t far *bank_ptr);
void draw_spritebank_offs( sprite_bank_t far *bank_ptr, short x_offs,
                           short y_offs );

void draw_all_banks(void);
void offset_draw_all_banks(short xOffs, short yOffs);

sprite_t far *start_next_in_spritebank(sprite_bank_t far *bank,
              short changeMode, short moveMode, short x, short y, short dx,
              short dy);

sprite_t far *detect_collisions(short message, sprite_bank_t far *refBank,
										  sprite_bank_t far *testBank);

/* D
 DOCUMENATION:

------------------------------------------------------------------------------

 init_sprite_bank() - allocates memory, intializes a sprite bank.

 Syntax:
	sprite_bank_t far *init_bank_sprite(short max_sprites);

 Inputs:


 Returns:


 Notes:


------------------------------------------------------------------------------
------------------------------------------------------------------------------

 setupSpriteBank(): reads a sprite file from disk, and intializes it as a
										sprite bank.
 Syntax:
	sprite_bank_t far *setupSpriteBank( char *spriteFileName, short numInstances,
						 short id, short x_min, short x_max, short y_min, short y_max );

 Inputs:
	char *spriteFileName - near pointer to the sprite file name
	short numInstances   - number of instances of the sprite you wish to create
	short id             - id number to identify sprite instances
	short x_min, short x_max, short y_min, short y_max
											 - bounding rectangle for movements
 Returns:
	sprite_bank_t far *  - far pointer to the sprite bank
											 - or NULL if unsuccessful
 Notes:
	- Allocates memory using gmalloc
	- Allocates enough storage for MAX_SPRITES_PER_BANK instances
	- initializes 'numInstances' sprites using add_sprite_instance()
	- File must be standard sprite file

------------------------------------------------------------------------------

 moveDrawAllSprites(): moves sprites, changes bitmaps, limits sprites,
											 adds erase rects, draws bitmaps for a list of
											 sprite banks.

 Syntax:
	void moveDrawAllSprites( sprite_bank_t far * far *spriteBanks,
													 short numBanks );

 Inputs:
	 sprite_bank_t far * far *spriteBanks - list of far pointers to sprite banks
	 short numBanks                       - number of sprite banks in list

 Returns:
	 none

------------------------------------------------------------------------------

 startNextSpriteInBank() - start next available (not already active) sprite
													 in specified bank. Conveniant way to start each
													 sprite, all houskeeping done automatically.

 Syntax:
	 sprite_t far *startNextSpriteInBank( sprite_bank_t far *bank,
		short changeMode, short moveMode, short x, short y, short dx, short dy );

 Inputs:
	 sprite_bank_t far *bank - far pointer to sprite bank
	 short changeMode        - type of bitmap frame changes required
														 -1 = default from sprite header
	 short moveMode          - type of bitmap movement limiting required
														 -1 = default from sprite header
	 short x, short y        - initial x, y position
	 short dx, short dy      - delta x, delta y for the movement

 Returns:
	 sprite_t far *          - far pointer to the sprite instance
														 or NULL if no sprites available

 Notes:

------------------------------------------------------------------------------

------------------------------------------------------------------------------

 detectCollisions() - detects collisions from sprites in the ref bank, with
											sprites in test bank.  Returns when first collision
											detected.
 Syntax:
	 sprite_t far *detectCollisions( short message, sprite_bank_t far *refBank,
																	 sprite_bank_t far *testBank );

 Inputs:
	 short message               - unless set to CHECK_ONLY, test sprite is set to
																	to inactive, test and ref sprite collision
																	flags are set to 1.
	 sprite_bank_t far *refBank  - bank of reference sprites
	 sprite_bank_t far *testBank - bank of test sprites

 Returns:
	 sprite_t far *              - pointer to the test sprite which collided
																 with the ref sprite (both closest to start
																 of list in bank).

 Notes:
	 - normally use with message set to 0, test sprite is set to inactive,
		 next time it is called the now-inactive sprite will be skipped, so will
		 not detect the same collision over and over.

------------------------------------------------------------------------------


*/

/* ------------------------------ EOF -------------------------------- */
#endif
