/*

    readg.h

    Copyright 1994, July 16 by Alec Russell, ALL rights reserved

    Created - 1994//7//16

   Fast buffered file reading from disk and XMS

    History:
        New file

*/

#ifndef DEF_READG
#define DEF_READG 1

#include <xmem.h>

typedef struct
   {
   short xms;   // if true use xp, else use fp
   xms_node_t *xp;
   FILE *fp;
   unsigned char far *buffer, far *b;
   unsigned short buffer_len;
   unsigned short buffer_left;
   }
g_file_t;

#define DEF_GBUFFERLEN 16384u
#define FILL_B_LEN 2048

// show local flags, open resource
#define DOWNLOAD_RES 1
#define USE_PALETTE 2
#define USE_EXE_RESOURCE_PATH 4
#define DEF_RES_FLAGS (DOWNLOAD_RES | USE_EXE_RESOURCE_PATH)

void gclose(g_file_t *gf);
g_file_t *gopen(char *fname, unsigned short buffer_len);
unsigned char g_get_byte(g_file_t *gf);
short g_read_bytes(char far *b, unsigned short n, g_file_t *gf);
short g_skip_bytes(unsigned short n, g_file_t *gf);


#endif
/* ----------------------- EOF ------------------------------------------- */
