/*
   Copyright 1993, Alec Russell, ALL rights reserved

   FILE : qmalloc.h

   vary fast mem allocation - MUCH faster than malloc or gmalloc

   HISTORY:
      created : may 22, 1993
      updates :

*/

#ifndef DEF_QMALLOC
#define DEF_QMALLOC 1

#include <g_def.h>

typedef struct
   {
   USHORT max_mem;
   USHORT mem_left;
   void far *mem;
   void far *tail;
   }
quick_malloc_t;

void init_quick_malloc(quick_malloc_t *q, USHORT max_mem);
void deinit_quick_malloc(quick_malloc_t *q);
void quick_free_all(quick_malloc_t *q);
void far *quick_malloc(quick_malloc_t *q, USHORT size);

#endif

/* ------------------------------ end of file ------------------------- */

