#ifndef INC_POLYGON
#define INC_POYGON 1

#ifndef _XLIB_H_
extern unsigned short ScrnLogicalByteWidth;   /* Virtual screen width in bytes       */
extern unsigned short ScrnLogicalPixelWidth;  /* Virtual screen width in pixels      */
extern unsigned short ScrnLogicalHeight;      /* Virtual screen height in pixels     */
extern short page;
extern unsigned short HiddenPageOffs;
extern unsigned short VisiblePageOffs;
#endif

   
/* POLYGON.H: Header file for filled polygon drawing and 3D animation. */

#define MAX_OBJECTS  100   /* max simultaneous # objects supported */
#define MAX_POLY_LENGTH 4  /* four vertices is the max per poly */

/* Ball movement flags */
#define MOVE_LEFT       0x0001
#define MOVE_RIGHT      0x0002
#define MOVE_UP         0x0004
#define MOVE_DOWN       0x0008
#define MOVE_TOWARD     0x0010
#define MOVE_AWAY       0x0020
#define FLIP_SPIN_AXIS  0x0040


/* Maximum number of simultaneously active spotlights */
#define MAX_SPOTS 3

/* Ratio: distance from viewpoint to projection plane / width of
   projection plane. Defines the width of the field of view. Lower
   absolute values = wider fields of view; higher values = narrower */
#define PROJECTION_RATIO -131072l /* -2 negative because visible Z
                                 coordinates are negative */

/* Draws the polygon described by the point list PointList in color
   Color with all vertices offset by (X,Y) */
#define DRAW_POLYGON(PointList,NumPoints,Color,X,Y)          \
   Polygon.Length = NumPoints; Polygon.PointPtr = PointList; \
   FillConvexPolygon(&Polygon, Color, X, Y);

/* Draws the polygon described by the point list PointList with a bitmap
   texture mapped onto it */
#define DRAW_TEXTURED_POLYGON(PointList,NumPoints,TexVerts,TexMap) \
   Polygon.Length = NumPoints; Polygon.PointPtr = PointList;       \
   DrawTexturedPolygon(&Polygon, TexVerts, TexMap);

#define INT_TO_FIXED(x) (((long)(int)x) << 16)
#define FIXED_TO_INT(FixedVal) ((int) (FixedVal >> 16))

// #define ROUND_FIXED_TO_INT(FixedVal) ((int) ((FixedVal + DOUBLE_TO_FIXED(0.5)) >> 16))
// #define DOUBLE_TO_FIXED(x) ((long) (x * 65536.0 + 0.5))
// #define FIXED_TO_DOUBLE(x) (((double)x) / 65536.0)


#define MIN_Z -3276800l          //(INT_TO_FIXED(-50))

#if 0
/* Sets a color intensity to the specified levels */
#define SET_INTENSITY(IntensityTemp, R, G, B) \
   IntensityTemp.Red = R;       \
   IntensityTemp.Green = G;     \
   IntensityTemp.Blue = B;

/* Converts a color component value between 0 and 1 to an R, G, or B
   value between 0 and 255. Allows expressing color components as fractions
   in the range 0 and 1, although internally (in ModelColor structures)
   they're actually represented as values between 0 and 255 */
//#define CCOMP(Color) ((Color<0) ? 0 : ((Color>=1) ? 255 : ((double)Color*255.0+0.5)))
#endif

/* Calculates dot product */
#define DOT_PRODUCT(V1,V2) \
   (FixedMul(V1.X,V2.X)+FixedMul(V1.Y,V2.Y)+FixedMul(V1.Z,V2.Z))

/* Retrieves the specified pixel from the specified image bitmap of the
   specified width. */
#define GET_IMAGE_PIXEL(TexMapBits, TexMapWidth, X, Y) \
   TexMapBits[(Y * TexMapWidth) + X]

/* Masks to mark shading types in Face structure */
#define NO_SHADING      0x0000
#define AMBIENT_SHADING 0x0001
#define DIFFUSE_SHADING 0x0002
#define TEXTURE_MAPPED_SHADING 0x0004

typedef long Fixedpoint;
typedef unsigned short TAngle;  /* angle in tenths of degrees */
typedef Fixedpoint Xform[3][4];

/* Describes a single 2D point */
typedef struct _Point {
   short X;
   short Y;
} Point;

/* Describes a color in the current color model, the RGB color cube */
typedef struct _ModelColor {
   unsigned char Red;   /* 255 = max red, 0 = no red */
   unsigned char Green; /* 255 = max green, 0 = no green */
   unsigned char Blue;  /* 255 = max blue, 0 = no blue */
} ModelColor;

/* Describes an intensity in the current color model, the RGB color cube */
typedef struct _ModelIntensity {
   Fixedpoint Red;
   Fixedpoint Green;
   Fixedpoint Blue;
} ModelIntensity;

/* Describes a single 3D point in homogeneous coordinates; the W
   coordinate isn't present, though; assumed to be 1 and implied */
typedef struct _Point3 {
   Fixedpoint X;
   Fixedpoint Y;
   Fixedpoint Z;
} Point3;

typedef struct {
   short X;
   short Y;
   short Z;
} IntPoint3;

/* Describes a series of points (used to store a list of vertices that
   describe a polygon; each vertex is assumed to connect to the two
   adjacent vertices; last vertex is assumed to connect to first) */
typedef struct {
   short Length;
   Point * PointPtr;
} PointListHeader;

/* Describes the beginning and ending X coordinates of a single
   horizontal line */
typedef struct {
   short XStart;
   short XEnd;
} HLine;

/* Describes a Length-long series of horizontal lines, all assumed to
   be on contiguous scan lines starting at YStart and proceeding
   downward (used to describe a scan-converted polygon to the
   low-level hardware-dependent drawing code) */
typedef struct {
   short Length;
   short YStart;
   HLine * HLinePtr;
} HLineList;

/* Describes a rectangle */
typedef struct {
   short Left;
   short Top;
   short Right;
   short Bottom;
} Rect;

/* Describes a texture map */
typedef struct {
   short TexMapWidth;  /* texture map width in bytes */
   char far *TexMapBits; /* pointer to texture bitmap */
} TextureMap;

/* Structure describing one face of an object (one polygon) */
typedef struct {
   short * VertNums;   /* pointer to list of indexes of this polygon's
                        vertices in the object's vertex list. The first two
                        indexes must select the end and start points,
                        respectively, of this polygon's unit normal vector.
                        The second point should also be an active polygon
                        vertex */
   short NumVerts;     /* # of verts in face, not including the initial
                        vertex, which must be the end of a unit normal vector
                        that starts at the second index in VertNums */
   short ColorIndex;   /* direct palette index; used only for non-shaded
                        faces */
   short ShadingType;  /* none, ambient, diffuse, texture mapped, etc. */
   TextureMap * TexMap; /* pointer to bitmap for texture mapping, if any */
   Point * TexVerts; /* pointer to list of this polygon's vertices, in
                        TextureMap coordinates. Index n must map to index
                        n + 1 in VertNums, (the + 1 is to skip over the unit
                        normal endpoint in VertNums) */
} Face;

typedef struct { TAngle RotateX, RotateY, RotateZ; } RotateControl;

/* Fields common to every object */
#define BASE_OBJECT                                              \
   struct _Object *NextObject;                                   \
   struct _Object *PreviousObject;                               \
   Point3 CenterInView;    /* coord of center in view space */   \
   short RecalcXform;        /* 1 to indicate need to recalc */    \
/* Basic object */
typedef struct _Object { BASE_OBJECT } Object;
/* Structure describing a polygon-based object */
typedef struct {
   BASE_OBJECT
   short RDelayCount, RDelayCountBase; /* controls rotation speed */
   short MDelayCount, MDelayCountBase; /* controls movement speed */
   Xform XformToWorld;        /* transform from object->world space */
   Xform XformToView;         /* transform from object->view space */
   RotateControl Rotate;      /* controls rotation change over time */
   short NumVerts;              /* # vertices in VertexList */
   short NumRealVerts;          /* # vertices that aren't unit normal
                                 endpoints. Unit normal endpoints must appear
                                 last in VertexList, and aren't transformed
                                 into screen space or screen coordinates */
   Point3 * VertexList;       /* untransformed vertices */
   Point3 * XformedVertexList;   /* transformed into view space */
   Point3 * ProjectedVertexList; /* projected into screen space */
   Point * ScreenVertexList;     /* converted to screen coordinates */
   short NumFaces;              /* # of faces in object */
   Face * FaceList;           /* pointer to face info */
   short not_draw;
} PObject;


/* Describes the current location and stepping, in both the source and
   the destination, of an edge. Mirrors structure in DRAWTEXP.C. */
typedef struct {
   int Direction;    /* through edge list; 1 for a right edge (forward
                        through vertex list), -1 for a left edge (backward
                        through vertex list) */
   int RemainingScans;  /* height left to scan out in dest */
   int CurrentEnd;      /* vertex # of end of current edge */
   Fixedpoint SourceX;     /* current X location in source for this edge */
   Fixedpoint SourceY;     /* current Y location in source for this edge */
   Fixedpoint SourceStepX; /* X step in source for X step in dest of 1 */
   Fixedpoint SourceStepY; /* Y step in source for X step in dest of 1 */
                        /* variables used for all-integer Bresenham's-type
                           Y stepping through the dest, needed for precise
                           pixel placement to avoid gaps */
   int DestY;           /* current Y location in dest for this edge */
   int DestYIntStep;    /* whole part of dest Y step per column X step */
   int DestYDirection;  /* -1 or 1 to indicate which way Y steps
                           (left/right) */
   int DestYErrTerm;    /* current error term for dest Y stepping */
   int DestYAdjUp;      /* amount to add to error term per column move */
   int DestYAdjDown;    /* amount to subtract from error term when the
                           error term turns over */
} EdgeScan;

extern Fixedpoint lsqrt(Fixedpoint r);
extern void XformVec(Xform, Fixedpoint *, Fixedpoint *);
extern void ConcatXforms(Xform, Xform, Xform);
extern short FillConvexPolygon(PointListHeader *, short, short, short);
extern void SetGraphicsMode(void);
extern void ShowPage(unsigned short);
extern void FillRectangleX(short, short, short, short, unsigned short, short);
extern void XformAndProjectPObject(PObject *);
extern void DrawPObject(PObject *);
extern void AppendRotationX(Xform, TAngle);
extern void AppendRotationY(Xform, TAngle);
extern void AppendRotationZ(Xform, TAngle);
extern Fixedpoint FixedMul(Fixedpoint, Fixedpoint);
extern Fixedpoint FixedDiv(Fixedpoint, Fixedpoint);
extern void InitializeFixedPoint(void);
extern void RotateAndMoveBall(PObject *);
extern void InitializeCubes(void);
extern void InitializeBalls(unsigned char far *);
extern void CosSin(TAngle, Fixedpoint *, Fixedpoint *);
extern void AddObject(Object *);
extern void SortObjects(void);
extern void InitializeObjectList(void);

#if 0
extern short ModelColorToColorIndex(ModelColor * Color);
extern void IntensityAdjustColor(ModelColor *, ModelColor *,
   ModelIntensity *);
extern void InitializeLighting(void);
extern void SetAmbientIntensity(ModelIntensity *);
extern ModelIntensity * GetAmbientIntensity(void);
extern void TurnSpotOn(short);
extern void TurnSpotOff(short);
extern void SetSpotDirection(short, Point3 *);
extern void SetSpotIntensity(short, ModelIntensity *);
extern Point3 * GetSpotDirection(short);
extern ModelIntensity * GetSpotIntensity(short);
extern short GetSpotState(short);
extern void TurnAmbientOn(void);
extern void TurnAmbientOff(void);
extern short GetAmbientState(void);
#endif

extern void DrawTexturedPolygon(PointListHeader *, Point *, TextureMap *);
extern void WritePixelX(short, short, short);
extern short RecalcAllXforms;
extern short NumObjects;
extern Object ObjectListStart, ObjectListEnd;
extern Xform WorldViewXform;
extern Object *ObjectList[];
extern short PolyClipMinX, PolyClipMinY, PolyClipMaxX, PolyClipMaxY;

// extern short DisplayedPage, NonDisplayedPage,
// extern Point3 CubeVerts[];
//extern unsigned short CurrentPageBase;
//extern unsigned short PageStartOffsets[2];

#if 0
extern ModelIntensity AmbientIntensity;
extern Point3 SpotDirectionWorld[];
extern Point3 SpotDirectionView[];
extern ModelIntensity SpotIntensity[];
extern short SpotOn[];
extern short AmbientOn;
#endif

extern short BallEvent;

extern void DrawHorizontalLineList(HLineList *, short, unsigned char);
extern void ScanOutLine(EdgeScan *, EdgeScan *, unsigned short Poffs);
extern void ScanEdge(short, short, short, short, short, short, HLine **);
extern Fixedpoint FixedMul(Fixedpoint M1, Fixedpoint M2);
extern Fixedpoint FixedDiv(Fixedpoint Dividend, Fixedpoint Divisor);

extern Point3 WorldCentre;
extern short ViewAngle;
extern short PolyCentreX, PolyCentreY;
extern Fixedpoint PolyScreenWidth;

#endif

