/*

   copyright 1993, Alec Russell, ALL rights reserved

   320x200, 256 color mode routines, BIOS mode 0x13
   All the palette stuff works with modeX.

*/

#ifndef DEF_MODE13
#define DEF_MODE13 1

#include <g_def.h>

typedef struct
   {
   USHORT width, height;
   BYTE far *bitmap;
   }
shape_t;


#define INPUT_STATUS_1  03dah   //Input Status 1 register
#define INPUT_STATUS_0  03dah   //Input status 0 register

extern BYTE palette[768];


void setvgapalette(char *p);
void setvga_part_palette(char *p, short start, short num);
void cycle_palette(short start, short num);
void cycle_palette_reverse(short start, short num);

// fade_..() requires that the timer is inited with init_timer()
void fade_out(short speed);
void fade_in(char *p, short speed);

void save_vid_mode(void);
short set_graph(void);
void restore_vid_mode(void);

void init_xmode_video(void);
void deinit_xmode_video(void);

short load_palette(char *pname, char *pal);

#endif

/* ----------------------- end of file ------------------------------- */

