/*

    line.h

    Copyright 1994, August 22 by Alec Russell, ALL rights reserved

    Created - 1994/8/22

    A slow hi-level line drawing func. Handy to move sprites
    along arbitrary straight line paths.

    History:
        New file

*/

#ifndef DEF_LINE
#define DEF_LINE 1

#include <g_def.h>

enum QUAD
{
   Q_ZERO,
   Q_ONE,
   Q_TWO,
   Q_THREE,
   Q_VERT,
   Q_HORZ,
   Q_SAME
};

typedef struct
   {
   BYTE quad;
   short step;
   short x, y, x1, y1;
   short ai, bi, yi, d, dx, dy;
   }
d_line_t;

void init_dline(short x0, short y0, short x1, short y1, short step, d_line_t *dl);
short next_dline(d_line_t *dl);

#endif

/* ------------------------------ EOF -------------------------------- */

