/*

   copyright 1993, Alec Russell
   all rights reserved


   low level joy stick, mouse and keyboard stuff

*/

#ifndef DEF_G_IO
#define DEF_G_IO 1

#include <gtimer.h>

#include <g_def.h>

#define NUM_KEYS 84
#define KEY_UP   128
#define KEY_MASK 127
extern unsigned char key_stat[NUM_KEYS];

#define MOUSE_MOVE   1
#define MOUSE_L_UP   4
#define MOUSE_L_DN   2
#define MOUSE_R_UP   16
#define MOUSE_R_DN   8

#define EVENT_MASK   31   /* the logical OR of the 5 above vars */

#define MAX_EVENT    25

enum event_types
   {
   E_MOUSE_MOVE,
   E_R_BUTTON_DN,
   E_R_BUTTON_UP,
   E_L_BUTTON_DN,
   E_L_BUTTON_UP,
   E_JOY_X_LEFT,
   E_JOY_X_CENTRE,
   E_JOY_X_RIGHT,
   E_JOY_Y_UP,
   E_JOY_Y_CENTRE,
   E_JOY_Y_DOWN,
   E_B0_UP,
   E_B0_DN,
   E_B1_UP,
   E_B1_DN,
   E_KEY,
   E_GUI,
   E_INVALID
   };

enum event_sub_types
   {
   E_UP,
   E_DOWN
   };

typedef struct
   {
   BYTE type;
   BYTE sub_type;
   short x, y;
   USHORT d1, d2;    /* data, depends on type and sub-type */
   ULONG time;
   }
event_t;

typedef struct 
   {
   BYTE ascii;    /* bottom of key */
   BYTE s_ascii;  /* top of key */
   }
scan_code_t;

/* sortof ascii values for wierd keys : event.d2 */
#define ESC      0x1b
#define BCKSPC   0x08
#define TAB      0x09
#define CR       0x0d
#define SPACE    0x20

#define F1       0xf1
#define F2       0xf2
#define F3       0xf3
#define F4       0xf4
#define F5       0xf5
#define F6       0xf6
#define F7       0xf7
#define F8       0xf8
#define F9       0xf9
#define F10      0xfa

#define HOME       0xd0
#define UP         0xd1
#define PGUP       0xd2

#define LEFT       0xd4
#define CENTRE     0xd5
#define RIGHT      0xd6

#define END        0xd8
#define DOWN       0xd9
#define PGDN       0xda
#define INS        0xdb
#define DEL        0xdc


#define CT_A 1
#define CT_B 2
#define CT_C 3
#define CT_D 4
#define CT_E 5
#define CT_F 6
#define CT_G 7
#define CT_H 8
#define CT_I 9
#define CT_J 10
#define CT_K 11
#define CT_L 12
#define CT_M 13
#define CT_N 14
#define CT_O 15
#define CT_P 16
#define CT_Q 17
#define CT_R 18
#define CT_S 19
#define CT_T 20
#define CT_U 21
#define CT_V 22
#define CT_W 23
#define CT_X 24
#define CT_Y 25
#define CT_Z 26

// scan codes: event.d1
#define SC_ALT 0x38

/* values to mask into key_flags */
#define KM_ALT     0x01
#define KM_SHIFT   0x02
#define KM_CAPS    0x04
#define KM_CTRL    0x08

// values to mask into key pressed value
#define KM_ALT_PLUS   0x100
#define KM_SHIFT_PLUS 0x200
#define KM_CTRL_PLUS  0x400

/* keyboard controller and LED lights stuff */
#define KEYSTATUS 0x64
#define KEYDATA  0x60
#define LEDUPDATE 0xed
#define OB_FULL 1
#define IB_FULL 2
#define KEY_ACK 0xfa
#define NUMLOCK 2
#define CAPLOCK 4


void clear_all_events(void);
void get_key(void);
void mouse_int(void);
void read_joy(void);
void init_events(char *mouse_name);
void deinit_events(void);
short get_event(event_t *event);
short peek_event(event_t *event);
void set_max_mouse(short max_x, short max_y);
void init_keyboard(void);
void deinit_keyboard(void);
void wait_event(event_t *event);
void insert_event(event_t *event);
short send_keycontrol(BYTE v); // send a byte to the keyboard controller

extern void far *far mouse_event_func;
extern event_t gb_events[MAX_EVENT];
extern USHORT gb_e_head, gb_e_tail;
extern short joy_x, joy_y;
extern BYTE b0, b1;
extern short want_mouse_moves;
extern short mouse_present;
extern short mouse_hidden;
extern short mouse_x, mouse_y;
extern short button_stat;
extern BYTE key_flags;
extern BYTE gb_key;
extern BYTE gb_auto_repeat;

#endif

/* ----------------------- end of file ------------------------------- */
