/*
   Copyright 1993, Alec Russell, ALL rights reserved

   FILE : gui.h - defines and structs for gui stuff, also see g_io.h
          for event defines

          Also some simple font tracking stuff

   HISTORY:
      created : may 25, 1993
      updates :

      1995 - increased size of many strings. this was done before the lib
             was released so it won't effect all you users.
             DON'T use any structs with _old_ in the name.

*/

#ifndef DEF_GUI
#define DEF_GUI 1


#include <g_def.h>
#include <palette.h>
#include <g_io.h>

/* NOTE!! all gui structs start off with this struct */

#if 0
typedef struct
   {
   BYTE type;
   BYTE gui_flags;
   BYTE draw_flags;
   BYTE status_flags;
   USHORT id;
   short  x, y, width, height;
   BYTE   light_color, medium_color, dark_color;
   }
gui_t;

#endif



enum gui_types
   {
   GUI_RECT,
   GUI_BUTTON,
   GUI_TEXT,
   GUI_STRING_INPUT,
   GUI_SLIDER,
   GUI_PLIST,
   GUI_RADIO
   };

enum thumb_pos
   {
   NOT_ON_SLIDER,
   ON_THUMB,
   BELOW_THUMB,
   ABOVE_THUMB
   };

#define GUI_MIN_THUMB 10
#define LIST_TEXT_LEN 80

#define GUI_MAX_TEXT_OLD 50     // I increased this before lib release.
#define GUI_MAX_TEXT     90
#define GUI_MAX_BUTT_TEXT 50
#define GUI_MAX_GADGET 50
#define GUI_MAX_STACK  10

/* button draw flags */
#define GUI_HAS_TEXT    1
#define GUI_HAS_BITMAP  2

/* button gui_flags */
#define GUI_TOGGLE      1
#define GUI_TOUCH       2
#define GUI_NORMAL      4


/* text draw flags */
#define GUI_NUMBERS_ONLY 1
#define GUI_TEXT_INVIS   2

/* rect gui_flags */
#define GUI_SAVE_UNDER   1

/* slider draw flags, used for radio button too */
#define GUI_VERT 1       // else HORZ

// plist draw_flags
#define MULTI_SELECT 1  // else single

/* common draw flags */
#define GUI_INVISIBLE   64

#define common gui_flags */
#define GUI_SELECTABLE  64


/* status_flags */
#define GUI_ACTIVE      1
#define GUI_UP          2
#define GUI_DOWN        4
#define GUI_DRAG        8

/* a note on font id's

from xtext.h

#define FONT_8x8  0
#define FONT_8x15 1
#define FONT_USER 2

font ids of 0 and 1 are ROM fonts, ids greater than 1 are user defined

*/

/* only ids of 2 or more are tracked by this, id's 0, and 1 are ROM fonts */
#define GUI_MAX_FONT 4

typedef struct
   {
   BYTE id;        /* must be greater than 1 */
   FARPTR font;
   }
font_list_t;

extern BYTE num_gui_fonts;
extern font_list_t font_list[GUI_MAX_FONT];


// the main rect everything sits on
typedef struct
   {
   BYTE   type;
   BYTE   gui_flags;
   BYTE   draw_flags;
   BYTE   status_flags;
   USHORT id;
   short  x, y, width, height;
   BYTE   light_color, medium_color, dark_color;
   }
gui_rect_t;


/* non-editable text - FOR TITLES etc... */
typedef struct
   {
   BYTE   type;
   BYTE   gui_flags;
   BYTE   draw_flags;
   BYTE   status_flags;
   USHORT id;
   short  x, y, width, height;
   BYTE   light_color, medium_color, dark_color;
   BYTE   text_color;
   BYTE   font_id;
   char   text[GUI_MAX_TEXT+1];
   USHORT txt_x, txt_y;
   }
gui_text_t;

/* non-editable text - FOR TITLES etc... */
typedef struct
   {
   BYTE   type;
   BYTE   gui_flags;
   BYTE   draw_flags;
   BYTE   status_flags;
   USHORT id;
   short  x, y, width, height;
   BYTE   light_color, medium_color, dark_color;
   BYTE   text_color;
   BYTE   font_id;
   char   text[GUI_MAX_TEXT_OLD+1];
   USHORT txt_x, txt_y;
   }
gui_text_old_t;

/* editable 

/* editable text */
typedef struct
   {
   BYTE   type;
   BYTE   gui_flags;
   BYTE   draw_flags;
   BYTE   status_flags;
   USHORT id;
   short  x, y, width, height;
   BYTE   light_color, medium_color, dark_color;
   BYTE   text_color;
   BYTE   font_id;
   char   text[GUI_MAX_TEXT_OLD+1];
   USHORT txt_x, txt_y;
   BYTE   cursor_x;
   BYTE   max_len, curr_len;
   }
gui_input_old_t;


/* editable text */
typedef struct
   {
   BYTE   type;
   BYTE   gui_flags;
   BYTE   draw_flags;
   BYTE   status_flags;
   USHORT id;
   short  x, y, width, height;
   BYTE   light_color, medium_color, dark_color;
   BYTE   text_color;
   BYTE   font_id;
   char   text[GUI_MAX_TEXT+1];
   USHORT txt_x, txt_y;
   BYTE   cursor_x;
   BYTE   max_len, curr_len;
   }
gui_input_t;

// button stuff
typedef struct
   {
   BYTE   text_color;
   BYTE   hot_color;
   BYTE   font_id;
   short  x, y;
   char   text[GUI_MAX_BUTT_TEXT+1];
   }
gui_txt_t;

typedef struct
   {
   short x, y;
   USHORT width, height;
   USHORT size_bitmap;
   BYTE far *bitmap;       /* MUST be pbm type bitmap */
   }
gui_shape_t;

typedef union
   {
   gui_shape_t shape;
   gui_txt_t text;
   }
button_data_u;

typedef struct
   {
   BYTE   type;
   BYTE   gui_flags;
   BYTE   draw_flags;
   BYTE   status_flags;
   USHORT id;
   short  x, y, width, height;
   BYTE   light_color, medium_color, dark_color;
   short  hot_key;
   button_data_u data;
   }
gui_button_t;

typedef struct
   {
   BYTE type;
   BYTE gui_flags;
   BYTE draw_flags;
   BYTE status_flags;
   USHORT id;
   short x, y, width, height;
   BYTE  light_color, medium_color, dark_color;
   short th_size, th_top;   // top means left if horz
   USHORT plist_id;  // 0 if no associated plist
   }
gui_slider_t;

typedef struct
   {
   BYTE type;
   BYTE gui_flags;
   BYTE draw_flags;
   BYTE status_flags;
   USHORT id;
   short x, y, width, height;
   BYTE  light_color, medium_color, dark_color;
   short num_items;    // total number of items in list
   short top_item;     // item at top of visible list
   short cursor_item;  // cursor position
   short page_items;   // number of items that fit in one page
   BYTE  far *curr_items;  // list of item(s) selected
   USHORT slider_id;   // MUST be defined!!!
   char font_id;     // of text in list
   BYTE fore_col, back_col;   // text color of unselected items
   BYTE curs_fore, curs_back; // text color if cursor on it
   BYTE sel_fore, sel_back;    // text color of selected items
   BYTE both_fore, both_back;  // text color of selected items with cursor on it
   char far *items;      // the list, every LIST_TEXT_LEN chars is a text item
   }
gui_plist_t;

typedef struct
   {
   BYTE type;
   BYTE gui_flags;
   BYTE draw_flags;
   BYTE status_flags;
   USHORT id;
   short  x, y, width, height;
   BYTE   light_color, medium_color, dark_color;
   short num_buttons;
   short active_button;
   BYTE active_color, inactive_color;
   }
gui_radio_t;

typedef union
   {
   gui_rect_t     rect;
   gui_text_t     text;
   gui_button_t   button;
   gui_input_t    input;
   gui_slider_t   slider;
   gui_plist_t    plist;
   gui_radio_t    radio;
   }
gui_all_u;

// NOT the pick list, the list of currently loaded gadgets
typedef struct
   {
   BYTE num_gadgets;
   BYTE num;
   short dx, dy, x1, y1;
   gui_all_u *curr_gadget;  /* NULL if no current */
   gui_all_u *gadget[GUI_MAX_GADGET];
   }
gui_list_t;

// default colours, fonts used for runtime creation of gadgets
typedef struct
   {
   BYTE   light_color, medium_color, dark_color;
   BYTE   text_color;
   BYTE   font_id;
   BYTE   hot_color;
   }
gui_default_t;

// used to save/restore gadgets in mem
typedef struct
   {
   short num;
   gui_list_t list[GUI_MAX_STACK];
   }
gui_stack_t;

/* colors - only valid for standard dark palette */
#define BLACK   1
#define BLUE    16
#define GREEN   35
#define YELLOW  47
#define RED     55
#define WHITE   15
#define GREY    8
#define BROWN   56

extern gui_default_t gui_def;
extern gui_list_t gui_list;
extern gui_stack_t gui_stack;

extern short m_width, m_height;
extern char far *mouse;
extern char far *mouse_all;
extern BYTE want_slider_moves;

gui_all_u *get_id_gadget(short id);
short gui_load_font(BYTE id, char *path);
void gui_unload_all_fonts(void);
void change_font(BYTE id);
void gui_draw_rect(short dx, short dy, gui_all_u  *g, short up);
void gui_draw_button(gui_button_t  *b);
void gui_draw_text(gui_text_t  *t);
void gui_edit_string(gui_input_t  *t, short a);
void gui_draw_input(gui_input_t  *t);
void gui_draw_gadget(void);
void gui_unload_gadget(void);
short gui_load_gadget(char *fname, char *font_path);
short gui_do_gadget(event_t *event);
short on_rect(event_t *event);
short on_gadget(gui_all_u *g, event_t *event);
void gui_stack_select(short num);
void gui_push(void);
void gui_pop(void);
void gui_pop_all(void);
void gui_unload_mouse(void);
void gui_load_mouse(char *mouse_name);
void gui_draw_mouse(void);
void gui_hide_mouse(void);
void gui_show_mouse(void);
short gui_select_color(short old_color, char *exe_path);
void mega_clear(void);
void gui_one_button(short dx, short dy, char *button_text, char *s, BYTE hot_key);
short gui_two_button(short dx, short dy, char *yes, char *no,
                    char *s, BYTE hot1, BYTE hot2);
short gui_three_button(short dx, short dy, char *one, char *two, char *three,
                    char *s, BYTE hot1, BYTE hot2, BYTE hot3);
short gui_get_string(short dx, short dy, char *yes, char *no,
                    char *s, BYTE hot1, BYTE hot2, char *in,
                    BYTE max_len, short min_width);
void gui_display_text_file(char *fname, char *path);
void gui_init_plist_file(gui_plist_t *p, char *fname);
void gui_reinit_plist(gui_plist_t *p, char far *list, short num);
void gui_reinit_plist_file(gui_plist_t *p, char *fname);
void gui_init_plist(gui_plist_t *p, char far *list, short num);
void set_gadget_colrs_to_def(short change_font);
void set_gui_def_colors_to_gadget( short id );
void gui_set_id_active(short id);
void gui_set_next_active(void);
void gui_set_prev_active(void);
void centreText( gui_all_u *g );
void setRadioBtnVal( short id, short val );
short getRadioBtnVal( short id );
void setGadgetText(short id, char *str, short n);
void GadgetOnOff( short id, short On );
char *get_gadget_text(short id, char *s, short n, short max);
void set_clip_rect( short xMin, short xMax, short yMin, short yMax );
char *nearFName( char far *farFName );

#endif

/* ------------------------------ end of file ------------------------- */

