/*
   Copyright 1993, Alec Russell, ALL rights reserved

   FILE : gmalloc.h

   HISTORY:
      created :june 20, 1993
      updates :
          5Dec95: by Bruce Miller:  added MAX_GMALLOC_SIZE

*/


#ifndef DEF_GMALLOC
#define DEF_GMALLOC 1

#include <g_def.h>

#define MAX_GMALLOC_SIZE 65520L
#define MAX_MEM_NAME 10
#define MAGIC_COOKIE 0xabc9


typedef struct t_mem
   {
   char name[MAX_MEM_NAME+1];
   USHORT size;
   void huge *b;
   void *bn;
   struct t_mem *next;
   }
mem_t;

typedef struct
   {
   short num;
   mem_t *head, *tail;
   }
mem_list_t;

extern mem_list_t mem_list;

void init_mem_list(void);
void list_mem(void);
void far *gmalloc(USHORT size, char *name);
void gfree(void huge *b, char *name);
void list_heap(void);
void nfree(void *b, char *name);
void *nmalloc(USHORT size, char *name);


#endif

/* ------------------------------ end of file ------------------------- */

