/*
   Copyright 1993, Alec Russell, ALL rights reserved

   FILE : erase.h

   erase rect managment

   HISTORY:
      created : may 22, 1993
      updates :

*/

#ifndef DEF_ERASE
#define DEF_ERASE 1

#include <qmalloc.h>

enum ERASE_TYPE
   {
   ERASE_NORMAL,
   ERASE_PACKED
   };

typedef struct
   {
   short x, y, type;
   void far *blit;
   }
erase_data_t;

typedef struct
   {
   quick_malloc_t q;
   short max;
   short curr;
   erase_data_t *e, *e_curr;
   }
erase_header_t;

extern erase_header_t gb_h[2];
extern short page;


void draw_erase_rects(erase_header_t *h);
void add_erase_rect_pkb(erase_header_t *h, short x, short y,
                    USHORT size, BYTE far *templt);
void add_erase_rect(erase_header_t *h, short x, short y,
                    short width, short height);

void deinit_erase_rects(erase_header_t *h);
void init_erase_rects(erase_header_t *h, short num, USHORT max);

void deinit_gb_erase(void);
void init_gb_erase(short num, USHORT max);

#endif


/* ------------------------------ end of file ------------------------- */
