/*

    dsprc.h

    Internet: alexad3@icebox.iceonline.com
    Copyright 1995, January 21 by Alec Russell, ALL rights reserved


    SP demo

    show simple demo's, title sequences, etc...

    Created - 1995/1/21

    History:
        New file

*/

#ifndef DSPRC_INCLUDE
#define DSPRC_INCLUDE 1

#include <g_def.h>

#define SP_DONE      0x01
#define SP_QUIT      0x02
#define SP_START     0x03
#define SP_BACK      0x04
#define SP_SETSTART  0x05
#define SP_LOAD      0x06
#define SP_X         0x07
#define SP_Y         0x08
#define SP_DX        0x09
#define SP_DY        0x0a
#define SP_SW        0x0b
#define SP_SH        0x0c
#define SP_DW        0x0d
#define SP_DH        0x0e
#define SP_UNTIL     0x0f
#define SP_BEFORE    0x10
#define SP_SETEND    0x11
#define SP_PALETTE   0x12
#define SP_BLACK     0x13
#define SP_FADEIN    0x14
#define SP_FADEOUT   0x15


#define SP_ST_PROC   0x00
#define SP_ST_UNTIL  0x01
#define SP_ST_BEFORE 0x02
#define SP_ST_DONE   0x03

#define SP_TYPE_PBM  0x01
#define SP_TYPE_PKB  0x02
#define SP_TYPE_M13  0x03

#define H_PORPORTIONAL 255

typedef struct dsprc
   {
   BYTE bm_type;
   short ow, oh;
   short x,y;
   short dx, dy, sw, sh, dh, dw;
   ULONG next_tick;  /* before var */
   short nx, ny;     /* until vars */
   BYTE  status;     /* until or before */
   FARPTR code;
   FARPTR c;
   FARPTR bm;
   }
dsprc_t;

typedef struct
   {
   ULONG next_tick;
   dsprc_t far *sp;
   }
sprc_demo_main_t;

short show_dsprc(char *fname, char *path);

#endif

/* ------------------------------ EOF -------------------------------- */
