/*
   Copyright 1993, Alec Russell, ALL rights reserved

   FILE : die.h

   HISTORY:
      created : June 20, 1993
      updates :

*/

#ifndef DEF_DIE
#define DEF_DIE 1

#include <g_def.h>

#define MAX_ON_EXIT 32
#define MAX_DIE_NAME 10

typedef struct
   {
   char name[MAX_DIE_NAME + 1];
   void (*on_death)(void);
   }
die_t;

typedef struct
   {
   BYTE num;
   die_t death_list[MAX_ON_EXIT];
   }
death_t;

extern death_t gb_death;
void do_all_exit(void);
void init_exit(void);
void add_exit(void (*new)(void), char *name);
void del_exit(void (*new)(void), char *name);
void list_all_exit(void);
void die(char *s, ...);

#endif

/* ------------------------------ end of file ------------------------- */

