/*

    dtext.c

    Internet: alexad3@icebox.iceonline.com
    Copyright 1995, August 6 by Alec Russell, ALL rights reserved

    Show text in a pick list - Yup this is all it takes with our lib.

    Created - 1995/8/6

    History:
        New file

*/

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include <conio.h>
#include <alloc.h>
#include <dos.h>
#include <time.h>

#include <pr2.h>
#include <palette.h>
#include <readlbm.h>
#include <fstring.h>
#include <g_io.h>
#include <gui.h>
#include <erase.h>
#include <die.h>
#include <gmalloc.h>
#include <gsound.h>

#include <Xlib_all.h>

/* ---------------------- main() ------------------------- August 6,1995 */
void main(int argc, char *argv[])
{
   event_t event;
   gui_all_u *p;
   short done=0;
   char fname[128];

   if ( argc > 1 )
      strcpy(fname, argv[1]);
   else
      strcpy(fname, "sell.txt");

   clear_pr2();

   /* its important to init_exit() 1st */
   init_exit();
   init_mem_list();
   init_xmode_video();
   init_timer();

   init_events("crshair.cbm");
   init_gb_erase(20, 64000u); // overkill

   // clear the screen to colour zero
   x_screen_fill(HiddenPageOffs, 0);
   x_screen_fill(VisiblePageOffs, 0);

   /* set palette */
   if ( load_palette("demo.pal", palette) )
      die("error getting palette");
   setvgapalette(palette);

   /* -- load gui */
   page=0;
   if ( gui_load_gadget("dtext.gui", "") )
      die("no dtext.gui");
   /* -- init pick list */
   p=get_id_gadget(5);
   if ( p )
      {
      gui_load_font(2, "");
      p->plist.font_id=2;
      gui_init_plist_file((gui_plist_t *)p, fname);
      }
   else
      die("plist (5) not found");

   /* -- display text */

   while ( !done )
      {
      draw_erase_rects(&(gb_h[page]));

      if ( gui_do_gadget(&event) )
         {
         switch ( event.type )
            {
            case E_GUI:
               if ( event.d1 == 4 )
                  done=1;
               break;

            case E_KEY:
               if ( event.d1 == ESC )
                  done=1;
               break;
            }
         }

      /* draw the mouse */
      gui_draw_mouse();

      /* page flip */
      x_page_flip(PhysScrnXOffs, PhysScrnYOffs);
      page= page ? 0 : 1;
      }

   /* -- de-init */
   gui_unload_gadget();
   deinit_gb_erase();
   gui_unload_all_fonts();
   deinit_events();
   deinit_xmode_video();
   deinit_timer();

}


/* ------------------------------ EOF -------------------------------- */

