/*

    draw.c

    Internet: alexad3@icebox.iceonline.com
    Copyright 1994, September 26 by Alec Russell, ALL rights reserved

    Created - 1994/9/26

   Part of the 3D ball demo

    History:
        New file

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <conio.h>
#include <alloc.h>
#include <dos.h>
#include <time.h>

#include <pr2.h>
#include <palette.h>
#include <readlbm.h>
#include <fstring.h>
#include <g_io.h>
#include <gui.h>
#include <erase.h>
#include <die.h>
#include <gtimer.h>
#include <gmalloc.h>

#include <Xlib_all.h>
#include "tank.h"



/* ---------------------- color_cycle_all() ----------- February 10,1995 */
void color_cycle_all(void)
{
   static ULONG next=0l;

   if ( next < fast_tick )
      {
      cycle_palette(START_BLUE, NUM_BLUE);
      cycle_palette_reverse(START_RED, NUM_RED);
      cycle_palette_reverse(START_ORANGE, NUM_ORANGE);

      next=fast_tick + CYCLE_TIME;
      }
}


/* ---------------------- draw_back() ----------------- September 6,1994 */
void draw_back(WORD offs)
{

   BYTE far *b;

   b=far_load("data\\top.pbm");
   if ( b )
      {
      x_put_pbm(0,0, offs, b);
      gfree(b, "top");
      }
   else
      die("top not found");


   b=far_load("data\\bottom.pbm");
   if ( b )
      {
      x_put_pbm(0,120, offs, b);
      gfree(b, "bottom");
      }
   else
      die("bottom not found");


   change_font(0);
   xputs(10, 190, offs, WHITE, "Space Rotate, Arrows move, ESC - bye");

}



#if 0
/*

   ground is a regular arrary of scaled objects
   calc all of visiual positions in relation to players current position
   then DRAW

   this is a pretty pathetic routine >:( . AJR 1995

*/


#define GRD_SCALEX (INT_TO_FIXED(-150))
#define GRD_SCALEY (INT_TO_FIXED(-130))
#define G_SPACE 80    // distance apart
#define G_GRID  16    // number along the squares edge
#define GH_SPACE (G_GRID/2)
#define GY_ADJUST 17
#define MIN_GZ (INT_TO_FIXED(-10))

/* ---------------------- draw_super_ground() ---------- November 5,1994 */
void draw_super_ground(void)
{
   short ix, iy, sx, sy, nw, nh, map_num, start_map_num;
   Fixedpoint dd, cos, sin, x, x0, z, sfx;
   Xform XformToView;
   Point3 XformedPoints, gp;

   dd=INT_TO_FIXED(G_SPACE);
   // get aprox position of start grid
   gp.Z=WorldCentre.Z - FixedMul(INT_TO_FIXED(GH_SPACE), dd);
   gp.X=WorldCentre.X - FixedMul(INT_TO_FIXED(GH_SPACE), dd);

   // place on nearest grid point
   sx=FIXED_TO_INT(gp.Z)/G_SPACE;
   gp.Z=INT_TO_FIXED(sx*G_SPACE);
   sx=FIXED_TO_INT(gp.X)/G_SPACE;
   sfx=INT_TO_FIXED(sx*G_SPACE);

   // calc start bitmap number
   ix=FIXED_TO_INT(sfx);
   iy=ix/NUM_GRD_TYPES;
   nw=iy*NUM_GRD_TYPES;
   start_map_num=map_num=nw - ix;

   memset(&XformToView, 0, sizeof(Xform));
   CosSin((TAngle)pl.ViewAngle, &cos, &sin);
   for ( iy=0; iy < G_GRID; iy++)
      {
      gp.X=sfx;
      for ( ix=0; ix < G_GRID; ix++ )
         {
         x=gp.X - WorldCentre.X;  // WorldCentre is where the players tank is at
         z=gp.Z - WorldCentre.Z;
         x0=FixedMul(x, cos) - FixedMul(z, sin);
         z= FixedMul(z, cos) + FixedMul(x, sin);

         if ( z < MIN_GZ /* && z > MAX_GZ*/ )  // its in front of us
            {
            XformToView[0][3]=x0;
            XformToView[2][3]=z;

            // ConcatXforms(WorldViewXform, tx, XformToView);

            XformVec(&XformToView, (Fixedpoint *)&gp,
                  (Fixedpoint *)&XformedPoints);
            
            x=FixedMul(FixedDiv(XformedPoints.X, XformedPoints.Z), GRD_SCALEX);
            sx=((int) ((x + 32768l) >> 16)) + PolyCentreX;

            // calc size of bitmap
            x=FixedMul(FixedDiv(INT_TO_FIXED(play_data.grd[map_num].width), XformedPoints.Z), GRD_SCALEX);
            nw=((int) ((x + 32768l) >> 16));
            x=FixedMul(FixedDiv(INT_TO_FIXED(play_data.grd[map_num].height), XformedPoints.Z), GRD_SCALEY);
            nh=((int) ((x + 32768l) >> 16));


            sy=PolyCentreY - GY_ADJUST;
            sx-=nw>>1;
            sy+=nh;

            // DRAW it!
            xscale(sx, sy, nw, nh, play_data.grd[map_num].width,
                          play_data.grd[map_num].height,
                          HiddenPageOffs, play_data.grd[map_num].bmap);
            }

         gp.X+=dd;
         ++map_num;
         if ( map_num == NUM_GRD_TYPES )
            map_num=0;
         }

      gp.Z+=dd;
      map_num=start_map_num;
      }

}
#endif



/* ---------------------- draw_ground() ------------------ August 6,1995 */
void draw_ground(void)
{
}


/*

   angle (hd) is in tenths of degrees
   this draws the sky

*/
/* ---------------------- draw_strip() --------------- September 14,1994 */
void draw_strip(short x0, short y0, short x1, USHORT off, BYTE far *strip, USHORT hd)
{
   short dw, w2, dw2;

   w2=0;
   _fmemcpy(&w2, strip, 1);

   dw=(x1 - x0 + 1)>>2;
   hd>>=2;
   if ( hd + dw < w2 )
      x_put_pbm_clipx2(hd, dw, x0, y0, off, strip);
   else
      {
      dw2=w2 - hd;
      dw-=dw2;
      if ( dw2 )
         x_put_pbm_clipx2(hd, dw2, x0, y0, off, strip);
      x0=x0 + (dw2<<2);
      x_put_pbm_clipx2(0, dw, x0, y0, off, strip);
      }

}


/* ---------------------- do_play_draw() ------------- September 26,1994 */
void do_play_draw(void)
{
   short i, n, j;
   Object *ObjectPtr;
   xscale_t far *xb;

   pl.num_qdraw=0;

   // calc and DRAW ground, DON'T add to draw list
   // draw_super_ground();
   draw_ground();


   // add the polygons to qdraw list, nearest at start of list
   for ( i=0, ObjectPtr = ObjectListStart.NextObject; i < NumObjects;
         i++, ObjectPtr = ObjectPtr->NextObject )
      {
      if ( !((PObject *)ObjectPtr)->not_draw )
         {
         n=0;
         while ( n <= pl.num_qdraw )
            {
            if ( n == pl.num_qdraw || ((PObject *)ObjectPtr)->CenterInView.Z < pl.qdraw[n].z )
               {
               // make room at position n
               j=pl.num_qdraw - n;
               if ( j )
                  {
                  _fmemmove(pl.qdraw + n + 1, pl.qdraw + n, j*sizeof(qdraw_t));
                  }
               pl.qdraw[n].type=D_POLY;
               pl.qdraw[n].z=((PObject *)ObjectPtr)->CenterInView.Z;
               pl.qdraw[n].obj=ObjectPtr;
               pl.num_qdraw++;
               break;    // from while loop
               }
            else
               n++;
            }
         }
      }

   // add the xscale objects
   for ( i=0, xb=play_data.xobjs; i < NUM_XOBJS; i++, xb++ )
      {
      if ( xb->draw )
         {
         n=0;
         while ( n <= pl.num_qdraw )
            {
            if ( n == pl.num_qdraw || xb->vz < pl.qdraw[n].z )
               {
               // make room at position n
               j=pl.num_qdraw - n;
               if ( j )
                  {
                  _fmemmove(pl.qdraw + n + 1, pl.qdraw + n, j*sizeof(qdraw_t));
                  }
               pl.qdraw[n].type=D_XSCALE;
               pl.qdraw[n].z=xb->vz;
               pl.qdraw[n].obj=xb;
               pl.num_qdraw++;
               break;    // from while loop
               }
            else
               n++;
            }
         }
      }

   /* Draw all objects */
   for (i=0; i < pl.num_qdraw; i++ )
      {
      switch ( pl.qdraw[i].type )
         {
         case D_POLY:
            DrawPObject((Object *)pl.qdraw[i].obj);
            break;

         case D_XSCALE:
            xb=(xscale_t far *)pl.qdraw[i].obj;
            xscale_masked(xb->sx, xb->sy, xb->nw, xb->nh, xb->width, xb->height,
                   HiddenPageOffs, xb->bmap);
            break;
         }
      }
}


/* ------------------------------ EOF -------------------------------- */

