/*

    demo_mnu.c

    Internet: alexad3@icebox.iceonline.com
    Copyright 1995, August 6 by Alec Russell, ALL rights reserved

    play demo's from a menu

    Created - 1995/8/6

    History:
        New file

   Run file format

   NAME: fname.exe DESC: "text in quotes" PARMS: parm1 parm2 parm3 ...CRNL

*/

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include <conio.h>
#include <alloc.h>
#include <dos.h>
#include <time.h>
#include <process.h>

#include <pr2.h>
#include <palette.h>
#include <readlbm.h>
#include <fstring.h>
#include <g_io.h>
#include <gui.h>
#include <erase.h>
#include <die.h>
#include <gmalloc.h>
#include <gsound.h>

#include <Xlib_all.h>


#define NAME_LEN 20
#define MAX_PARMS 5
#define PARM_LEN 20
#define BUFF_LEN 512

typedef struct
   {
   char name[NAME_LEN];
   char parms[MAX_PARMS][PARM_LEN];
   short num_parms;
   }
run_t;


/* ---------------------- play_demo() -------------------- August 9,1995 */
void play_demo(short num, char *fname)
{
   char buffer[BUFF_LEN], *t1, *t2;
   run_t run;
   FILE *fp;
   short i;

   pr2("play demo #%d", num);
   fp=fopen(fname, "rb");
   if ( fp )
      {
      do
         {
         if ( !fgets(buffer, BUFF_LEN, fp) )
            break;
         }
      while ( num-- );

      t1=strstr(buffer, "NAME:");
      if ( t1 )
         {
         // get exe name
         while ( *t1 && *t1 != ' ' )
            t1++;
         while ( *t1 && *t1 == ' ' )
            t1++;

         t2=run.name;
         while ( *t1 && *t1 != ' ' )
            *t2++=*t1++;
         *t2=0;

         // get parms
         t1=strstr(buffer, "PARMS:");
         run.num_parms=0;
         if ( t1 )
            {
            // skip PARMS:
            while ( *t1 && *t1 != ' ' )
               t1++;
            // get all parms
            do
               {
               while ( *t1 && *t1 == ' ' )
                  t1++;

               t2=run.parms[run.num_parms];
               while ( *t1 && *t1 != ' ' && *t1 != '\r' && *t1 != '\n' )
                  *t2++=*t1++;
               *t2=0;

               run.num_parms++;
               if ( run.num_parms == MAX_PARMS )
                  break;
               }
            while ( *t1 && *t1 != '\r' && *t1 != '\n' );
            }
         else
            {
            *run.parms[0]=0;
            }

         pr2("Run %s num parms %d", run.name, run.num_parms);
         for ( i=0; i < run.num_parms; i++ )
            pr2("PARM #%d = %s", i, run.parms[i]);

         i=spawnv(P_WAIT, run.name, run.parms);
         if ( i == -1 )
            {
            pr2("error running %s", run.name);
            }
         else
            {
            // restore everything your average xmode demo kills on exit
            x_set_mode(X_MODE_360x240, 360);
            x_set_doublebuffer(240);
            /* set palette */
            if ( load_palette("demo.pal", palette) )
               die("error getting palette");
            setvgapalette(palette);
            // enable mouse
            init_mouse();
            }
         }
      else
         die("no name - bad run file");
      }
   else
      die("can't find %s", fname);
}


/* ---------------------- init_plist_demo() -------------- August 9,1995 */
void init_plist_demo(char *fname, gui_all_u *p)
{
   FILE *fp;
   short num=0;
   char buffer[BUFF_LEN], *t1;
   char far *list, far *t2, far *t3;

   fp=fopen(fname, "rb");
   if ( fp )
      {
      // count lines
      while ( fgets(buffer, BUFF_LEN, fp) )
         num++;
      fseek(fp, 0l, SEEK_SET);

      // init plist
      list=gmalloc(num*LIST_TEXT_LEN, "plist data");
      if ( !list )
         die("out of mem: init list");

      t2=list;
      while ( fgets(buffer, BUFF_LEN, fp) )
         {
         *t2=0; // just in case
         t1=strstr(buffer, "DESC:");
         if ( t1 )
            {
            t3=t2;
            while ( *t1 && *t1 != '"' )
               t1++;
            t1++;
            while ( *t1 && *t1 != '"' )
               *t3++=*t1++;
            *t3=0;
            }

         t2+=LIST_TEXT_LEN;
         }

      gui_init_plist(&p->plist, list, num);

      fclose(fp);
      }
   else
      die("run file %s not found", fname);
}


/* ---------------------- main() ------------------------- August 6,1995 */
void main(int argc, char *argv[])
{
   event_t event;
   gui_all_u *p;
   short done=0;
   char fname[128];

   if ( argc > 1 )
      strcpy(fname, argv[1]);
   else
      strcpy(fname, "demo.run");

   clear_pr2();

   /* its important to init_exit() 1st */
   init_exit();
   init_mem_list();
   init_xmode_video();
   init_timer();

   init_events("crshair.cbm");
   init_gb_erase(4, 2000u);

   x_screen_fill(HiddenPageOffs, 0);
   x_screen_fill(VisiblePageOffs, 0);

   /* set palette */
   if ( load_palette("demo.pal", palette) )
      die("error getting palette");
   setvgapalette(palette);

   /* -- load gui */
   page=0;
   if ( gui_load_gadget("demo.gui", "") )
      die("no demo.gui");
   /* -- init pick list */
   p=get_id_gadget(5);
   if ( p )
      {
      gui_load_font(2, "");
      p->plist.font_id=2;
      init_plist_demo(fname, p);
      }
   else
      die("plist (5) not found");

   /* -- display text */

   while ( !done )
      {
      draw_erase_rects(&(gb_h[page]));

      if ( gui_do_gadget(&event) )
         {
         switch ( event.type )
            {
            case E_GUI:
               switch ( event.d1 )
                  {
                  case 2:
                     done=1;
                     break;

                  case 3:
                     play_demo(p->plist.cursor_item, fname);
                     break;
                  }
               break;

            case E_KEY:
               if ( event.d1 == ESC )
                  done=1;
               break;
            }
         }

      /* draw the mouse */
      gui_draw_mouse();

      /* page flip */
      x_page_flip(PhysScrnXOffs, PhysScrnYOffs);
      page= page ? 0 : 1;
      }

   /* -- de-init */
   gui_unload_gadget();
   deinit_gb_erase();
   gui_unload_all_fonts();
   deinit_events();
   deinit_xmode_video();
   deinit_timer();

}


/* ------------------------------ EOF -------------------------------- */


