    /* hyinit.c (customise color file and master batch files) */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dir.h>
#include <dos.h>

static int file_exists (char *filename);
static void set_color_file (void);
static void set_master_batch_files (void);
static int create_hycomp (char *compiler, char *fullname);
static int create_hylib (char *compiler, char *fullname);
static int create_hylink (char *compiler, char *fullname);
static int want_to_reconfigure (char *question);
static void create_hymakein (char *compiler);
static void create_hylibsin (char *compiler);
static void create_color_dat (int type);

void main () {
/* Initialisation of HYCOLOR.DAT for all HYCOM products
   and Master Batch files for HYMAKE (if present) */
  set_color_file ();
  if (file_exists ("HYMAKEGN.EXE")) 
    set_master_batch_files ();}

static void set_color_file (void) {
/* User selects display type, program copies appropriate HYCOLOR.?
   to HYCOLOR.DAT */
  char string[100];  int ans;

  static char dataname[] = "hycolor.dat";

  printf ("Configure COLOURS for your Monitor and Card\n");
  
  if (file_exists (dataname)) {
    printf ("\nColours have already been configured in %s\n", dataname);
    ans = want_to_reconfigure ("Do you want to rebuild colours");
    if (ans == 0) {
      printf ("Leaving colours alone in %s\n", dataname);
      printf ("Type HYCOLOR to fine-tune the display colours\n");
      return;}}
     
  ans = 0;
  while (ans <= 0 || ans > 3) {
    printf ("\nSelect type of monitor-graphics:");
    printf ("\n1. Colour");
    printf ("\n2. Greyscale");
    printf ("\n3. Monochrome");
    printf ("\n    ?");
  
    fgets (string,99, stdin);
    ans = atoi (string);}
  create_color_dat (ans);}
  
static void create_color_dat (int type) {  
FILE *out;
out = fopen ("hycolor.dat", "w");
if (!out) {
  printf  ("Cannot create color.dat:Check write protection\n");
  exit (1);}
if (type == 1) {  /* COLOR */
fprintf (out,
"*Colour Definition* 9-18-1995, 16:39\n"
"&                                      Fore Col. Back Col\n"
"HYPERTEXT_COLORS_____Active_Button:       0          14\n"
"_____________________Inactive_buttons:    0         7\n"
"DATA_EDITING_________Edit_Field:         14          8\n"
"_____________________Other_Data_Fields:   0         11\n"
"_____________________Headings:           15          1\n"
"CUSTOM_DATA_PANEL____Text_Fields:        14          1\n"
"_____________________Data_Fields:        15          1\n"
"_____________________Field_in_edit:      15          0\n"
"MESSAGES_TO_THE_USER_OK_messages:        15          8\n"
"_____________________USER_messages:      15          9\n"
"_____________________SERIOUS_messages:   15         12\n"
"SCREEN_APPEARANCE____Top_line:           15          2\n"
"_____________________Bottom_line:        15          2\n"
"_____________________Function_keys:      15          0\n"
"_____________________Ticker:              5          0\n"
"_____________________Memory_count:        5          0\n"
"SPECIAL_ITEMS________Generated_reports:   0         15\n"
"_____________________External_HT_files:  15          8\n"
"_____________________Pick_Documentation: 15          1\n"
"_____________________Edit_C_function:    14          1\n");
printf ("Colours are set for colour monitor and graphics card\n");}
else if (type == 2) {  /* Grey scale */
fprintf (out,
"*Colour Definition* 9-18-1995, 16:39\n"
"&                                      Fore Col. Back Col\n"
"HYPERTEXT_COLORS_____Active_Button:       0          7\n"
"_____________________Inactive_buttons:    0         11\n"
"DATA_EDITING_________Edit_Field:         14          8\n"
"_____________________Other_Data_Fields:  13          9\n"
"_____________________Headings:           15          1\n"
"CUSTOM_DATA_PANEL____Text_Fields:         7          1\n"
"_____________________Data_Fields:        15          1\n"
"_____________________Field_in_edit:      15          0\n"
"MESSAGES_TO_THE_USER_OK_messages:        15          8\n"
"_____________________USER_messages:      15          9\n"
"_____________________SERIOUS_messages:   15         12\n"
"SCREEN_APPEARANCE____Top_line:            0         11\n"
"_____________________Bottom_line:         0         11\n"
"_____________________Function_keys:      15          0\n"
"_____________________Ticker:              0         11\n"
"_____________________Memory_count:        0         11\n"
"SPECIAL_ITEMS________Generated_reports:  15         12\n"
"_____________________External_HT_files:  15          8\n"
"_____________________Pick_Documentation:  7          0\n"
"_____________________Edit_C_function:     0          11\n");
printf ("Colours are set for grey scale\n");}

else if (type == 3) {  /* Monochrome */
fprintf (out,
"*Colour Definition* 9-18-1995, 16:39\n"
"&                                      Fore Col. Back Col\n"
"HYPERTEXT_COLORS_____Active_Button:      15          0\n"
"_____________________Inactive_buttons:    0         15\n"
"DATA_EDITING_________Edit_Field:          0         15\n"
"_____________________Other_Data_Fields:  15          0\n"
"_____________________Headings:            0         15\n"
"CUSTOM_DATA_PANEL____Text_Fields:        15          0\n"
"_____________________Data_Fields:        15          0\n"
"_____________________Field_in_edit:       0         15\n"
"MESSAGES_TO_THE_USER_OK_messages:        15          0\n"
"_____________________USER_messages:       1          0\n"
"_____________________SERIOUS_messages:    1          0\n"
"SCREEN_APPEARANCE____Top_line:           15          0\n"
"_____________________Bottom_line:        15          0\n"
"_____________________Function_keys:       0         15\n"
"_____________________Ticker:              0         15\n"
"_____________________Memory_count:        0         15\n"
"SPECIAL_ITEMS________Generated_reports:   0         15\n"
"_____________________External_HT_files:   0         15\n"
"_____________________Pick_Documentation: 15          0\n"
"_____________________Edit_C_function:     0         15\n");
printf ("Colours are set for Monochrome (Black and White)\n");}
else {
  printf ("Programming error, type = %d\n", type);
  exit (1);}
fclose (out);}

static void set_master_batch_files () {
/* Configure Master Batch Files (for HYMAKE) */
  char string[100], compiler[4], fullname[25];
  int ans, reconfigure, good_count;

  printf ("\nConfigure Master Batch Files for your Compiler\n");
  
  if (file_exists ("HYCOMP.BAT") && file_exists ("HYLIB.BAT") 
         && file_exists ("HYLINK.BAT")) {
    printf ("Master batch files already exist.\n");
    reconfigure = want_to_reconfigure 
                     ("Do you want to rebuild Master Batch files");
    if (!reconfigure) {
      printf ("Not changing HYCOMP, HYLIB and HYLINK\n");
      return;}}

  ans = 0;
  while (ans <= 0 || ans > 4) {
    printf ("\nSelect name of C compiler that you use");
    printf ("\n1. Turbo C (DOS application)");
    printf ("\n2. Borland C (DOS application)");
    printf ("\n3. Microsoft (DOS application)");
    printf ("\n4. Generic DOS application");
    printf ("\n    ?");
  
    fgets (string,99, stdin);
    ans = atoi (string);}

  if (ans == 1) {
    strcpy (compiler, "tur");
    strcpy (fullname, "Turbo C compiler");}
  else if (ans == 2) {
    strcpy (compiler, "bor");
    strcpy (fullname, "Borland C compiler");}
  else if (ans == 3) {
    strcpy (compiler, "ms");
    strcpy (fullname, "Microsoft C compiler");}
  else if (ans == 4) {
    strcpy (compiler, "ms");
    strcpy (fullname, "Microsoft C compiler");}
      
  good_count = create_hycomp (compiler, fullname) 
                +  create_hylib (compiler, fullname)
                +  create_hylink (compiler, fullname);

  if (good_count != 3) 
    printf ("Errors have occurred, master batch file configuration failed\n");
  else {
    printf ("Master batch files HYCOMP.BAT, HYLIB.BAT and HYLINK.BAT have\n");
    printf ("  been configured for the %s\n", fullname);
    if (ans == 4) 
      printf ("Please modify them for your OTHER compiler\n");
    else 
      printf ("You may edit them to fine-tune options and memory models\n");}
  printf ("See comments in the BAT files for advice\n\n");
  
  create_hymakein (compiler);

  create_hylibsin (compiler);}
  
static void create_hymakein (char *compiler) {
  FILE *out;
  out = fopen ("hymakein", "w");
  if (!out) {
    printf ("ERROR - cant create HYMAKEIN, check write protection\n");
    return;}
  if (!strcmp (compiler, "tur")) {
    fprintf (out, "magic.exe magic.c/C-ml;");
    printf (
       "HYMAKEIN has been set to compile with Turbo large model (-ml)\n");}
  else if (!strcmp (compiler, "bor")) {
    fprintf (out, "magic.exe magic.c/C-ml;");
    printf ("HYMAKEIN has been set to compile with Borland large model (-ml)\n");}
  else if (!strcmp (compiler, "ms")) {
    fprintf (out, "magic.exe magic.c/C-AL;");
    printf ("HYMAKEIN has been set to compile with Microsoft large model (-AL)\n");}
  else {
    printf ("Error - Invalid compiler %s in create_hymakein\n", compiler);
    return;}
  fclose (out);
  printf ("\n");}
    
static void create_hylibsin (char *compiler) {    
  int ans; FILE *out = NULL;
  if (file_exists ("hylibsin")) {
    ans = want_to_reconfigure 
         ("Do you want to rebuild HYLIBSIN for the demo");
    if (!ans) {
      printf ("Leaving HYLIBSIN alone\n"); 
      return;}}

  out = fopen ("hylibsin", "w");
  if (!out) {
    printf ("ERROR - cant create HYLIBSIN, check write protection\n");
    return;}

  if (!strcmp (compiler, "tur")) {
    fprintf (out, "\\tc\\lib\\mathL \\tc\\lib\\EMU \\tc\\lib\\CL\n");
    printf ("HYLIBSIN is made for Turbo, large model, floating point emulation\n");
    printf ("For medium/small model change \"C0L\" to C0M/C0S\n");}
   else if (!strcmp (compiler, "bor")) {
    fprintf (out, "\\borlandc\\lib\\mathL \\borlandc\\lib\\EMU \\borlandc\\lib\\CL\n");
    printf ("HYLIBSIN is made for Borland, large model, floating point emulation\n");
    printf ("For medium/small model change \"C0L\" to C0M/C0S\n");}
   else if (!strcmp (compiler, "ms")) {
    fprintf (out, "llibce\n");
    printf ("HYLIBSIN is made for Microsoft, large model, floating point emulation\n");
    printf ("For medium/small model change \"llib\" to mlib/slib\n");
    printf ("To use 8087 instead of emulation, change \"ce\" to \"c7\"\n");}
  else {
    printf ("Error - Invalid compiler %s in create_hymakein\n", compiler);
    return;}
  fclose (out);
  printf ("\n");}
    
static int create_hycomp (char *compiler, char *fullname) {
  FILE *out; char the_command[150]= "";
  out = fopen ("hycomp.bat", "w");
  if (!out) {
    printf ("ERROR - cant create HYCOMP.BAT, check write protection\n");
    return (0);}
  if (!strcmp (compiler, "tur"))
    strcpy (the_command,"tcc -c -n%4\\obj %6 %7 %8 %9 %4\\%1%2");
  else if (!strcmp (compiler, "bor"))
    strcpy (the_command,"bcc -c -n%4\\obj %6 %7 %8 %9 %4\\%1%2");
  else if (!strcmp (compiler, "ms"))
    strcpy (the_command,"cl -c -Fo%4\\obj\\%1.obj %6 %7 %8 %9 %4\\%1%2");
  else
	  strcpy (the_command, "");
		
  if (!*the_command) {
    printf ("Error - Invalid compiler %s in create_hycomp\n", compiler);
    return (0);}
  fprintf (out, 
     "@echo off\n"
     "REM MASTER COMPILE BATCH for %s compiler\n", fullname);
  fprintf (out,
  "rem %1=C module, %2=extension, %3=TEST/NOTEST, %4=code dir,%5=working, %6+ options\n"
    "if NOT exist %4\\OBJ\\NUL md OBJ\n"
    "if NOT exist %4\\OBJ\\%1.obj goto docomp\n"
    "echo Skipping Compilation of %1%2\n"
    "echo Skipping Compilation of %1%2 >> %5\makeoutg\n"
    "goto goon\n"
    ":docomp\n"
    "echo Compiling %4\\%1%2\n"
    "cd %4 >> NUL\n"
    "REM CHANGE THE THREE LINES BELOW TO MEET YOUR NEEDS\n");

  fprintf (out, "echo %s\n", the_command);
  fprintf (out, "echo %s >> %5\\makeoutg\n", the_command);
  fprintf (out, "%s >> %5\\makeoutg\n", the_command);
  fprintf (out,
    "cd %5>>NUL\n"
    "if exist %4\\OBJ\\%1.obj goto goon\n"
    "echo ************** Compile error in %4\\%1%2 ******ERROR******\n"
    "set HYERR=YES\n"
    "if %3 == NOTEST goto goon\n"
    "pause\n"
    "type %5\\makeoutg\n"
    "echo Press Ctrl-C to ABORT - any other key to continue compiling\n"
    "pause\n"
    ":goon\n"
    "cd %5>>NUL\n"
    "rem end of hycomp");
  fclose (out);
  return  (1);}
  
static int create_hylib (char *compiler, char *fullname) {
  FILE *out; char the_command[150];
  out = fopen ("hylib.bat", "w");
  if (!out) {
    printf ("ERROR - cant create HYLIB.BAT, check write protection\n");
    return (0);}
  if (!strncmp (compiler, "tur", 3))
    strcpy (the_command, "tlib /E %1%2 @%1%2.lbm");
  else if (!strncmp (compiler, "bor", 3))
    strcpy (the_command, "tlib /E %1%2 @%1%2.lbm");
  else if (!strncmp (compiler, "ms", 2))
    strcpy (the_command, "lib %1%2 @%1%2.lbm");
  else {
    printf ("Error - Invalid compiler %s in create_hylib\n", compiler);
    return (0);}
  fprintf (out, "@echo off\n"
    "REM MASTER LIB BATCH FILE FOR %s\n", fullname);
  fprintf (out, "echo Updating %1%2.lib\n");
  fprintf (out, "echo %s\n", the_command);
  fprintf (out, "echo %s >> %3makeoutg\n", the_command);
  fprintf (out, "%s >> %3makeoutg\n", the_command);
  fprintf (out, "echo -- >> %3makeoutg");
  fclose (out);
  return (1);}
  
static int create_hylink (char *compiler, char *fullname) {
  FILE *out; char the_command[150]="";
  out = fopen ("hylink.bat", "w");
  if (!out) {
    printf ("ERROR - cant create HYLINK.BAT, check write protection\n");
    return (0);}
  if (!strncmp (compiler, "tur", 3))
    strcpy(the_command,"\\tc\\tlink /c/m/d \\tc\\lib\\C0L @%1%2.exm ");
  else if (!strncmp (compiler, "bor", 3))
    strcpy(the_command,"\\borlandc\\bin\\tlink /c/m/d \\borlandc\\lib\\C0L @%1%2.exm ");
  else if (!strncmp (compiler, "ms", 2))
    strcpy (the_command, "link /B/NOI/M @%1%2.exm, NUL");
  else 
    strcpy (the_command, "");

  if (!*the_command) {
    printf ("Error - Invalid compiler %s in create_hylink\n", compiler);
    return (0);}
    
  fprintf (out, "@echo off\n"
    "rem %1=exe path, %2=exe name, %3=working dir\n");
  fprintf (out, "REM Master LINK batch file for %s\n", fullname);
  fprintf (out,
    "if %HYERR% == YES goto sklink\n"
    "echo Linking %1%2.exe\n"
    "echo Linking %1%2.exe >> %3makeoutg\n");
  fprintf (out, "echo %s\n", the_command);
  fprintf (out, "echo %s >> %3makeoutg\n", the_command);
  fprintf (out, "REM LINK LINE BELOW has options case sensitive, warn of duplicates\n");
  fprintf (out, "%s >> %3makeoutg\n", the_command);
  fprintf (out, "goto exxit\n"
    ":sklink\n"
    "echo Skipping Link due to Compile errors\n"
    "echo Skipping Link due to Compile errors >> %3makeoutg\n"
    ":exxit\n"
    "rem End of HyLink.bat");
  fclose (out);
  return (1);}

static int file_exists (char *filename) {
/* return 1 if file called filename exists, 0 otherwise */
  struct ffblk ffblk; int ret;
  ret = findfirst (filename, &ffblk, 0);
  if (ret == 0) return (1);
  else          return (0);}

static int want_to_reconfigure (char *question) {
/* Get and return user response to "want to reconfigure?" */
  char string[100];
  while (1) {
    printf ("%s (Y/N)?", question);
    fgets (string, 99, stdin);
    strupr (string);
    if (*string == 'N')
      return (0);
    if (*string == 'Y')
      return (1);}}
