/* tabdec: tab decoder */

#define  MAXLINE  80
#define  YES	  1
#define  NO	  0
#define  TABSP	  8

char  input[] "data";
char  ibuf[518];
int   tabs[MAXLINE];

main()
{
      int   col, *ptab;
      char  c;

      ptab = tabs;
      col = 1;

      settab(ptab);  /* set initial tab stops */
      if (fopen(input, ibuf) < 0) {
	 printf("%s: not found\n", input);
	 exit(8);
      }
      while ((c = getc(ibuf)) != -1) {
	 switch (c) {
	    case '\t': /* TAB */
	       while (tabpos(col) != YES) {
		  putchar(' ');  /* put BLANK */
		  col++;
	       }
	       break;
	    case '\n':  /* NEWLINE */
	       putchar('\n');
	       col = 1;
	       break;
	    default:
	       putchar(c);
	       col++;
	 }
      }
}


tabpos(col) /*tabpos: return YES if col is a tab stop */
int   col;
{
      if (col > MAXLINE)
	 return(YES);
      else
	 return(tabs[col]);
}


settab(tabp)   /* settab: set initial tab stops */
int   *tabp;
{
      int   i;

      for (i = 0; i <= MAXLINE; i++)
	 (i % TABSP) ? (tabs[i] = NO) : (tabs[i] = YES);
{

