/*
 *	Name		PD
 *
 *	Function	Push Directory Utility
 *
 *	Author		Joseph Boykin
 *			47-4 Sheridan Drive
 *			Shresbury, MA	01545
 *			617-845-1074
 *
 *	Version		1.00
 *
 */

#define	PATHSZ	66
char	*stkfile = "f:\dir.stk";	/* Stack file, preferably on a ramdisk */
int	fd;				/* Stack file File Descriptor */
short	int	nrecs;			/* Number of records on stack */
char	name[PATHSZ] = "\\";		/* Current directory */

int	rflg, sflg;			/* Command line flags */

extern	long	_xlseek();

main(argc, argv)
int	argc;
char	*argv[];
{
	char *s;

	/*
	 * Parse the command line and deal with
	 *  command line options.
	 */
	rflg = sflg = 0;
	while(--argc > 0 && (*++argv)[0] == '-') {
		for(s=argv[0]+1; *s ; s++) {
			switch(*s) {

				case 'r':
				case 'R':	rflg++;
						break;

				case 's':
				case 'S':	sflg++;
						break;

				default:	printf("Unknown command: %c\r\n", *s);
						argc = -1;
						break;
			}
		}
	}

	if(_xgetdir(name+1, 0) < 0) {
		cprintf("Can't get current directory.\r\n");
		_xexit(1);
	}

	/*
	 * See if the stack file exists. If so, read the number of records
	 *  currently on the stack, otherwise, try to create and initialize
	 *  the file.
	 */

	if((fd = _xopen(stkfile, 2)) < 0) {
		if((fd = _xcreat(stkfile, 0)) < 0) {
			cprintf("Cannot open/create stack file.\r\n");
			_xexit(1);
		} else {
			nrecs = 0;
			if(_xwrite(fd, (char *)&nrecs, sizeof(short int)) !=
			  sizeof(short int)) {
				cprintf("Unable to initialize stack file.\r\n");
				_xclose(fd);
				_xexit(1);
			}
		}
	} else
		doread(fd, &nrecs, sizeof(short int));

	/*
	 * Deal with the case of the user only wanting to print out 
	 *  the stack contents.  This needs to be done after we
	 *  read/initialize the stack file so if there was a command
	 *  error we went through alot of work for nothing.
	 */

	if(sflg && argc == 0 && !rflg) {
		prstk();
		_xexit(0);
	} else {
		if(argc != 1) {
			cprintf("Usage: pd [-rs] directory.\r\n");
			_xexit(2);
		}
	}

	if(rflg && nrecs) {
		rflg = -1;
		nrecs--;
	}

	/*
	 * Find the right place in the file to store the current
	 *  directory name.
	 */

	if(_xlseek(fd, ((long) PATHSZ*(long) nrecs) + sizeof(short int),0) < 0) {
		cprintf("Seek error on stack file.\r\n");
		_xexit(1);
	}

	if(_xchdir(argv[0]) < 0) {
		cprintf("Couldn't change directories.\r\n");
		_xchdir(name);
		_xexit(1);
	}

	if(_xwrite(fd, name, PATHSZ) != PATHSZ) {
		cprintf("Error writing to stack file.\r\n");
		_xchdir(name);
		_xexit(1);
	}

	nrecs++;
	prstk();
	if(rflg == -1) {
		_xexit(0);
	}

	/*
	 * Update nrecs field in file and quit.
	 */

	if(_xlseek(fd, (long) 0, 0) < 0) {
		cprintf("Seek error on stack file.\r\n");
		_xchdir(name);
		_xexit(1);
	}

	if(_xwrite(fd, (char *)&nrecs, sizeof(short int)) != sizeof(short int)) {
		cprintf("Error writing to stack file.\r\n");
		_xchdir(name);
		_xexit(1);
	}

	_xexit(0);
}

/*
 * Perform a read operation.  Checks for error and
 *  and terminate if got one.
 */

doread(fid, name, sz)
int	fid;
char	*name;
int	sz;
{
	if(_xread(fid, name, sz) != sz) {
		cprintf("Error reading file.\r\n");
		_xexit(0);
	}
}

/*
 * Print out the contents of the directory stack.
 */

prstk()
{
	int	i;
	char	tname[PATHSZ];

	if(sflg) {
		if(nrecs == 0) {
			cprintf("Directory stack is empty.\r\n");
			_xexit(0);
		}
		cprintf("Current Stack:\r\n");
		for(i=0; i < nrecs; i++) {
			_xlseek(fd, ((long)PATHSZ*(long)i)+sizeof(short int),0);
			doread(fd, tname, PATHSZ);
			cprintf("    %s\r\n", tname);
		}
	}
}

