/* -- csort.c  sorting benchmark -- */
/* ---- calls random the number of times specified by MAX to create an
	array of lon integers, then does a quicksort on the array of longs.
	The program does this for the number of times specified by NTIMES.
   ---- */

#include "stdio.h"

#define MAX 1001			/* maximum number of entries */
#define MAXLINE 135			/* longest line expected */
#define NTIMES 10			/* number of times to sort entries */

main() {				/*sort lines in memory */
	int i,j, n, length;
	char buf[MAXLINE], *sort[MAX], *unsorted[MAX], *alloc();

	for (n = 0; n < MAX; n++)
		if ((length = getln(buf, MAXLINE)) == 0) {
			n--;
			break;
		}
		else if ((unsorted[n] = alloc(length + 1)) == NULL) {
			printf("Sort: not enough room\n");
			exit(-1);
		}
		else	strcpy(unsorted[n], buf);

	printf("%d iterations: ", NTIMES);

	for (i = 1; i <= NTIMES; i++) {
		for (j = 0; j <= n; j++)
			sort[j] = unsorted[j];
		quick(0, n, sort);
	}

	printf("%d entries.\n", n + 1);
	exit(0);
}

quick(lo, hi, base)			/* quicksort */

	int lo, hi;
	char *base[];

	{
		int i, j;
		char *pivot, *temp;

		if (lo < hi) {
			for (i = lo, j = hi, pivot = base[hi]; i < j; ) {
				while (i < j && strcmp(base[i], pivot) <= 0)
					i++;
				while (j > i && strcmp(base[j], pivot) >= 0)
					j--;
				if (i < j) {
					temp = base[i];
					base[i] = base[j];
					base[j] = temp;
				}
			}
			temp = base[i];
			base[i] = base[hi];
			base[hi] = temp;
			quick (lo, i - 1, base);
			quick (i + 1, hi, base);
		}
	}

getln(s, n)				/* get a line of up to n characters into s */

	char s[];
	int n;

	{
		int c, i;

		for (i = 0; n > 0; n--, i++)
			if ((c = getchar()) == EOF || c == '\n')
				break;
			else	s[i] = c;
		s[i] ='\0';
		return(i);
	}



















