         WaverlyStreet QuickRef Project Assistant (tm) User's Manual

-----------------------------------------------------------------------------
(If you have not already done so, you may want to print this manual on paper.
Press "P" if viewing it from the QuickRef help utility.)

-----------------------------------------------------------------------------
Setup Options
-----------------------------------------------------------------------------
When you first start QuickRef, please go into the setup area by pressing F10
at the main screen. You will find the following options:

Current User Name: Change this to either your or your company name

Current User Initials: Enter your initials here (don't leave blank!)

Current Passcode: optional

Multiple Users   : If set to "N", then you will never even know that the
                   program can handle multiple "workers". If set to "Y", then 
                   you will need to build a "worker" data file, and data entry 
                   and reporting sections will have one more step in them.

Sub Divisions    : Both time and money records may be tagged with a
                   sub-division label. You may have up to nine divisions for
                   each. Toggle through the four options available.

Change Screen Colors: Hey, have fun!

Main Data Path   : (optional) Enter in a DOS file path where you want QuickRef
                   to keep it's everyday working files. Caution! - do not
                   share a (network) data path with someone else unless it
                   will NEVER be the case that you are both in the program at
                   the same time! (It may seem to work OK, but eventual file
                   corruption is inevitable.)

Scratch File Path: (optional) If you use a RAM drive, identify it here.
                   (Quicker reporting. 1 MB minimum recommended)

Backup/Share Path: (optional) For network use - enter in a DOS file path where
                   you want to "mirror" your records, so that other users on
                   your office LAN may look at them.

Archive Path     : (optional) The directory where old records on closed out
                   projects will be stored.

Please refer to the end of this manual for installation and file details.

-----------------------------------------------------------------------------
Adding Projects
-----------------------------------------------------------------------------
Press the right arrow key, then <INSERT>. Add a name, then a project number.
Duplicate numbers not allowed.
                                                         
-----------------------------------------------------------------------------
Single project screen
-----------------------------------------------------------------------------
When the program first starts, records for ALL projects are shown. To narrow
your view to only those records for a particular project, press the right
arrow, then point to and select a project. The "header" information for that
project is shown at the top of the screen. Press <F3> to change it.

-----------------------------------------------------------------------------
Switch between TIME and MONEY modes
-----------------------------------------------------------------------------
Press <F8> at either the main screen or the single project screen to toggle
between modes. Note the indicator in the bottom right corner of the screen.

-----------------------------------------------------------------------------
Add Records - edit / delete records
-----------------------------------------------------------------------------
Make sure you are in the mode (TIME/MONEY) that you want.

From main screen, press <INSERT>, then select a project. From single project
screen, just press <INSERT>. Press <ENTER> to accept current date, or type in
a new one. (Note - if record is for the current year, then you only need enter
the month and the day and press <ENTER>. If for another year, you must type in
the entire four-digit number - ie: 1997). When correct date is shown, press
<ENTER>. Type in a numeric value to indicate either hours or money, and press
<ENTER>. Type in a note, or use the up and down arrow keys to scroll through
past notes. When the note is as you want it, press <ENTER>. Finally, confirm
the new entry.

To either edit or delete a record, pick it from the screen by pointing to it
and pressing <ENTER>.

-----------------------------------------------------------------------------
"To-Do" items and MACRO utility
-----------------------------------------------------------------------------
If, when making a new entry, you leave the amount field blank (either time or
money), then the entry will appear as a reminder. These will be printed as
"to-do" items on "Snapshot" reports.

You may have the program automatically insert pre-defined lists of "to-do"
items by using the MACRO utility. At the main screen, press <F3>, pick "make a
new macro", and follow instructions.

-----------------------------------------------------------------------------
Reports
-----------------------------------------------------------------------------
QuickRef creates two basic report types, "Snapshot" reports on single
projects, and larger reports that combine projects and compare them to each
other. In either case, note that you may edit the report before printing it.
You may create reports from either your own data, another person's data that
has been placed in a network "Backup/Share" directory, or archived records 
on closed projects.

To generate a "Snapshot", you need to be at a single project screen. Press
<F4>, and answer the prompts that follow.

To generate other reports, you must be at the main screen. Press <F4>. Press
"A" to select all projects, "S" to select only certain projects. If you chose
to select projects, there are more choices to be made:

     Press "W" to select by word. What this does is prompt you for a word, and
     then it searches all the project header information to find it. When a
     match is found, the header is displayed, and you must confirm whether or
     not to include it.

     Press "P" to search by project number. A string of eight stars are
     displayed, which you may edit to look for project numbers that match. For
     example, suppose your numbering system uses a single letter code in the
     third place to identify various types of projects, and you wish to have a
     report on projects of type "t". Change the line of stars to look like
     this -> **t***** and press <ENTER>.

     Finally, you may also simply pick projects from the main list one at a
     time. Press "O" to do this. Scroll through the projects and press <ENTER>
     to select.

     Whichever search method is employed, you are shown a list of selected
     projects. If you wish to add more, press <INSERT>. If you wish to remove
     one, point to it and press <ENTER>. When the list is as you want it,
     press <ESC> to continue.

Once you have selected projects, you must specify a range of dates to include.
Again, press "A" to select all dates, "S" to specify dates.

Next, indicate summary or full report. Full reports include all time and money
line items (and so can get to be rather long).

There are a few more prompts (depending on whether or not you are in
multi-user mode), and then the report is displayed on screen.

-----------------------------------------------------------------------------
Closing out a finished project
-----------------------------------------------------------------------------
Once a project is finished, you will want to transfer it's records from your
main (active) data area to the archive area. First of all, make sure that you
have created an archive directory, and that you have correctly specified it in
SETUP.

To close out a project: Activate the project selection box (right arrow at the
main screen). Press <DEL>. Point to the project you wish to close and press
<ENTER>. Answer the prompts, and it's done. Verify that the records are being
transfered correctly by pressing "F" back at the main screen (see "Network
notes" below).

-----------------------------------------------------------------------------
Completely removing a project
-----------------------------------------------------------------------------
In order to completely remove a project's records from the system, it must
first have been transfered to the archive directory. Change to the archive
directory ("F" at the main screen...), and proceed as if you were closing the
project out. This time, however, the project is completely removed!

Print a report first! THIS IS YOUR LAST CHANCE!!!!!

Note: unless a project is a mistake or a "test" project, don't remove it. Huge
archive files do not hinder normal program operation.

-----------------------------------------------------------------------------
Network notes
-----------------------------------------------------------------------------
Although QuickRef is designed to operate stand-alone, it includes provisions
for sharing data with other users on a LAN. (See the end of this manual for
suggested network directory structure.) Other users may view, but not change
each other's records.

To update you own network data "mirror", press "Q" at the main screen, to run
the Quick Data Backup utility. This simply shells to DOS and copies all your
data to the network directory you specify in setup. ("Laptop" users might
specify a floppy drive for this, then copy the files from the disk to the
server, or upload the files via modem.)

To view someone else's data, press "D" at the main screen. To view archived
records on finished projects, press "F". In either case, then change the
directory shown to the one you are after, and press <ENTER>. The program title
and directory listing on the bottom of the screen will change to the "warning
box" colors, to remind you that you are not in your usual files. You can
browse and generate reports just as if you were in your own data, but all data
entry and editing functions are locked out.

Press "D" or "F" again to return to your normal data directory.

-----------------------------------------------------------------------------
Project list
-----------------------------------------------------------------------------
Print a quick list of all your projects by pressing "P" when the "Select
Projects" window is "on".

-----------------------------------------------------------------------------
The FILE BROWSER & text editors
-----------------------------------------------------------------------------
All reports and project note files are initially sent to a built-in viewer,
for on-screen preview. All viewer control options are shown at the bottom of
the screen. The viewer is capable of displaying huge files (in excess of
32,000 lines in length) with great speed. If you are not satisfied with the
viewer's print output, print to a file instead, and then read that into your
favorite word processor. (Set the word processor margins to handle 78
columns (very wide)). QuickRef does not include it's own text editor. To edit
files, the viewer shells out to an external editor of your choosing. Specify
the text editor on the DOS command line, or in your Windows program item,
properties, command line space, in this format:

     QR [name of editor's executable file]

     (Note the space between QR and the editor name.)

Any DOS text editor that will accept a file name to open on the command line
should work (depending on available memory). An excellent editor for the
purpose is READ by WellsCom. READ can be found at all the major software
archives and on all the major shareware CDs, generally in the DOS editor or
text directory. READ uses very little memory, has a number of nice "word
processor-like" features, and can handle very large files. If no editor is
specified on the command line, QuickRef will attempt to use EDIT. (EDIT works,
but READ is vastly superior.) One other point - the editor needs to be either
in the same directory as Quickref, or in the PATH.

-----------------------------------------------------------------------------
Installation, and "What the heck are all those files?"
-----------------------------------------------------------------------------
It is recommended that the program distribution files be placed in a directory
called C:\QUICKREF (for illustration purposes, let's assume drive C:), and
that a subdirectory of C:\QUICKREF be made for the program data, say
C:\QUICKREF\DATA.

So, here is what that might look like, including files:

Directory of C:\QUICKREF

.            <DIR>
..           <DIR>
DATA         <DIR>
QR       EXE          (the program)
VBDRT10  EXE          (required run-time module)
STATION  INI          (program creates this - contains SETUP information)
STANDARD FRM          (sample/default project note file header)
QUICKREF TXT          (the "about" file called at the help screen)
TEMPLATE MCR          (macro file template with instructions)
QUICKREF MAN          (this file - called from help screen)
MY_NOTES TXT          (user's own help file - called from help screen)
STANDARD MCR          (sample/default macro file)
SWAN     ICO          (nifty WaverlyStreet Windows icon)

Now, if you have made a DATA directory as shown above, and if you have
specified that directory as the Main Data Path in setup, you should have
something like this also (after running the program through all it's paces):

Directory of C:\QUICKREF\DATA

.            <DIR>
..           <DIR>
TIME     DAT          (time records)
PROJECTS DAT          (project header records)
WORKER   DAT          (worker info - only if multi-user set to "Y" in setup)
MONEY    DAT          (money records)
[proj]   REC          (plain text file(s) containing your project notes where
                         [PROJ] is your project's number)
TIME     SDV          (time sub division labels)
MONEY    SDV          (money sub division labels)

After a while, you may want to create an archive directory to store records on
closed projects. (If you are connected to a LAN, then I highly recommend
placing it on the server.) Wherever you put it, it will contain these files:

[proj]   REC          (same as above)
PROJECTS DAT          (same as above)
TIME     DAT          (same as above)
MONEY    DAT          (same as above)

Note: In the archive directory, the records of all QuickRef users on a LAN are
combined together in single .DAT files. I strongly suggest printing a final
full report on paper before sending a project to the archives.

Also note that the worker data and the subdivision data do not carry over to
the archives! Reports from the archives include totals only - no worker or
subdivision breakdowns. The reason for this is that worker information (rates,
for instance) will change over time, and various users may have different
subdivisions set up. With all this information changing over time, the
breakdowns would soon become distorted and misleading. If you wish to preserve
the labor costs and subdivision breakdowns, do this before placing records in
the archives: Print a report showing the information. Make a single MONEY
entry for the entire labor cost. Type the subdivision breakdown information
you wish to preserve into the project note (.REC) file. *Now* save to the
archives. (Since there is no worker rate information in the archives for
QuickRef to reference, reports from the archives will not show the double cost
that you might expect.) 

If you are connected to a LAN, and wish for other QuickRef users to be able to
view your records, create a directory on the server, and specify it as your
Backup/Share path in setup. When you press "Q" at the main screen, the Quick
Backup utility will copy all the files from your data directory to this spot.

Suggested network server directory structure (assuming drive "F"):

     F:\QRDATA - Have all users specify this as their archive path.
           |
          F:\QRDATA\[user's initials] - A sub directory for each user. Have
                                        each user specify this as their
                                        Backup/Share path.

(Obviously, the users need full rights to the server directories)

Finally, the program creates and removes numerous temporary "scratch" files
during the course of normal operation. These files have several different
names, and are used in any or all of three different places: The main QUICKREF
directory, the DATA directory, and the place specified as the Scratch File
Path (in setup). They all have the extension ".@@@". Under certain
circumstances (power failures, insufficient space in the scratch file path),
the program may fail to delete these files, and you might get some odd results
such as "extra" information pasted onto reports. Once the problem
circumstances are corrected, the program should clear the stray scratch
files on it's own. At any time, however, you are safe to delete any files with
the .@@@ extension from the QuickRef file structure.

-----------------------------------------------------------------------------
SWAN.ICO (Windows Icon)
-----------------------------------------------------------------------------
Who says DOS programs can't have Windows Icons? Windows won't find it without
your help, but you can specify it anyway with File, Properties..., Change 
Icon..., Browse..., C:\QUICKREF\SWAN.ICO (assuming you have installed QuickRef
in C:\QUICKREF).

-----------------------------------------------------------------------------
Limitations
-----------------------------------------------------------------------------
I believe QuickRef is set up to handle more than large enough numbers of this
and that for normal usage, but just so you know, here are some limits:

The maximum number of active line items in either the TIME or the MONEY data
files is 32,767 (each may have that many). The program will warn you that you
are approaching the limit at 20,000, and again (more urgently) at 30,000. In
general, the smaller the data files, the faster the operation. Closed projects
should be retired if the data files are getting too large. (I have tested all
functions of the program with computer-generated test data files over 32,000
entries. No problems except that it gets rather slow!)

Note: If archive records are approching the limit, make another archive
directory and change everyone's SETUP to show it as the default. (There can be
as many as you need)

The maximum number of projects and workers is also 32,767.

Individual line item values for money should not exceed six places to the left
of the decimal point ($ 999,999.99). For time, four places (9999.99 hours).

Project subtotals for money should not exceed eight places to the left of the
decimal point ($ 99,999,999.99). For time, six places (999,999.99 hours)

Grand totals for money (all records in the system) should not exceed nine
places to the left of the decimal point ($ 999,999,999.99). For time, seven
places (9,999,999.99 hours).

(Actually, the program can handle the math required for fifteen places to the
left of the decimal, but it seems a little silly to accomodate that in the
screen and report layouts. If you are dealing with numbers that large, go buy
an accounting firm!)

The maximum number of text lines (largest report) that the file browser can
handle is also the magical 32,767.

QuickRef makes extensive use of temporary disk files. Depending on what you
are doing, the free disk space required in the "scratch file" area can be
several times larger than the data file in use. If you are using a RAM drive,
and are having strange problems, try switching to the hard drive instead. If
that fixes the problem, make the RAM drive bigger (or use the disk instead).

-----------------------------------------------------------------------------
      Please report bugs & make suggestions to:  dgjess@infinet.com
----------------------------------------------------------------------------
QuickRef (tm) Project Assistant - (C) 1997 WaverlyStreet. All Rights Reserved
----------------------------------------------------------------------------- 

