
#   ************************************************************************
#   *				  standard.mak				   *
#   ************************************************************************

#   This is an NMAKE include file for projects containing assembler and C.

#   Pre-defined inference rules present some problem when compiling C source
#   files with the /Fa option to generate assembly listings. Once the .ASM
#   file exists, NMAKE assembles the old listing rather than compile the new
#   C source even if the inference rule contains an explicit .C dependence.
#   Fix this by reversing the order of .ASM and .C in a new .SUFFIXES list.

.SUFFIXES :
.SUFFIXES : .c .asm

#   Utilities not known to NMAKE by default:

LIBRARIAN = lib
LINKER = link
MAPSYM = mapsym
EXE2BIN = exe2bin

#   Favoured switches for the assembler, compiler and linker:

ASWITCHES = /Cp
CSWITCHES = /Gs /Oas /W3 /Zp1
LSWITCHES = /noi

#   Generate listings unless "LISTING=OFF" is given on the NMAKE command
#   line or precedes the inclusion of this file.

!IFNDEF LISTING
LISTING = OFF
!ENDIF
!IF "$(LISTING)" == "ON"
ALIST = /Fl /Sg
CLIST = /Fa
LLIST = /m
!ENDIF

#   Direct the linker to create a .COM file if "PROGRAM=COM" is given on
#   the NMAKE command line or precedes the inclusion of this file.

!IF "$(PROGRAM)" == "COM"
LPROG = /noe /nof /t crtcom.lib+
!ELSE
PROGRAM = EXE
!ENDIF

AFLAGS = $(ASWITCHES) $(ALIST)
CFLAGS = $(CSWITCHES) $(CLIST)
LFLAGS = $(LSWITCHES) $(LLIST) $(LPROG)

ASSEMBLE = $(AS) /c $(AFLAGS)
COMPILE = $(CC) /c $(CFLAGS)
LINK = $(LINKER) $(LFLAGS)

#   Pseudo-targets:

ALL : CLEAR TARGETS

#   The first pseudo-target is a possibly over-cautious insistence on
#   clearing flags passed to the assembler, compiler or linker through
#   environment variables.

CLEAR :
  set $(AS)=
  set $(CC)=
  set $(LINKER)=

#   ************************************************************************

