
;   ************************************************************************
;   *				   spawn.asm				   *
;   ************************************************************************

.MODEL			TINY
.DOSSEG

			EXTERN	_end:BYTE

.NOLIST
  INCLUDE		ascii.inc
  INCLUDE		driver.inc
.LIST

;   ========================================================================

.CODE

Entry:

;   Device driver header - this must be located at the very beginning of
;   the device driver:

DriverHeader		DRIVER_HEADER	{ \
					0FFFFFFFFh,
					IS_CHAR_DEVICE,
					OFFSET strategy,
					OFFSET interrupt,
					{"        "} \
					}

;   ========================================================================

.DATA

;   Storage variable for the request header's address:

lpRequestHeader 	dd	?

;   ========================================================================

.CODE
			EXTERN	RunProgram:NEAR

strategy		PROC	FAR PRIVATE

;   Save the address of the request header.

			mov	word ptr cs:[lpRequestHeader],bx
			mov	word ptr cs:[lpRequestHeader + 02h],es

			ret

strategy		ENDP

;   ------------------------------------------------------------------------

interrupt		PROC	FAR PRIVATE USES es ds bp di si dx cx bx ax
			ASSUME	bx:PTR REQUEST_HEADER

			push	cs
			pop	ds
			ASSUME	ds:DGROUP

			les	bx,[lpRequestHeader]
			cmp	es:[bx].cCommand,D_INIT
			jnz	badcmd

			push	bx
			mov	ax,3306h
			xor	bx,bx
			int	21h
			mov	dx,OFFSET BadVersion
			cmp	bl,05h
			pop	bx
			jb	error

			mov	ax,word ptr es:[bx].lpEndOfMemory
			mov	cl,04h
			shr	ax,cl
			mov	dx,word ptr es:[bx].lpEndOfMemory + 02h
			add	dx,ax

			mov	ax,OFFSET _end
			add	ax,000Fh
			rcr	ax,1
			shr	ax,1
                        shr     ax,1
                        shr     ax,1
			mov	cx,ds
			add	cx,ax

			sub	dx,cx
			jnb	@f

			mov	dx,OFFSET OutOfMemory

error:
			mov	ah,09h
			int	21h

			jmp	fail

@@:
			les	bx,es:[bx].lpCommandLine
			call	RunProgram

fail:
			push	cs
			pop	ds
			les	bx,[lpRequestHeader]

		mov	es:[bx].wStatus,D_ERROR OR D_DONE OR D_GENERAL_FAILURE

			mov	word ptr es:[bx].lpEndOfMemory,0000h
			mov	word ptr es:[bx].lpEndOfMemory + 02h,cs

			jmp	done

badcmd:

		mov	es:[bx].wStatus,D_ERROR OR D_DONE OR D_BAD_COMMAND
done:
			ret

interrupt		ENDP

;   ========================================================================

.CONST

BadVersion		db	CR, LF,
				"SPAWN: Requires DOS 5 or higher.",
				CR, LF, "$"

OutOfMemory		db	CR, LF,
				"SPAWN: Insufficient memory for driver.",
				CR, LF, "$"

;   ************************************************************************

END			Entry

