
;   ************************************************************************
;   *				  runprgm.asm				   *
;   ************************************************************************

.MODEL			TINY

.NOLIST
  INCLUDE		ascii.inc
  INCLUDE		exec.inc
  INCLUDE		sft.inc
  INCLUDE		sysvars.inc
.LIST

;   ========================================================================

.CODE
			EXTERN	MakeHole:NEAR
			EXTERN	RepairHole:NEAR

RunProgram		PROC	NEAR PUBLIC

			push	dx
			push	cx
			call	GetProgramDetails
			pop	cx
			pop	dx
			jnc	@f

			mov	dx,OFFSET syntax_error
			mov	ah,09h
			int	21h

			jmp	done

@@:
			call	MakeHole
			jnc	@f

			push	cs
			pop	ds
			mov	dx,OFFSET mem_error
			mov	ah,09h
			int	21h

			jmp	done

@@:
			push	es
			push	ds
			push	si
			push	dx
			push	cx
			push	ax

			push	cs
			pop	ds
			ASSUME	ds:DGROUP

			call	SetFCBSFT

			mov	ah,2Fh
			int	21h

			mov	word ptr [lpOrgDTA],bx
			mov	word ptr [lpOrgDTA + 02h],es

			mov	ah,19h
			int	21h
			mov	[cDefaultDrive],al

			call	Exec
			jnc	@f

			mov	dx,OFFSET exec_error
			mov	ah,09h
			int	21h

@@:
			xor	dl,dl
			mov	ax,3301h
			int	21h

			mov	dl,[cDefaultDrive]
			mov	ah,0Eh
			int	21h

			push	ds
			lds	dx,[lpOrgDTA]
			mov	ah,1Ah
			int	21h
			pop	ds

			call	ClearFCBSFT

			pop	ax
			pop	cx
			pop	dx
			pop	si
			pop	ds
			pop	es

			call	RepairHole
			jz	done

			push	cs
			pop	ds
			mov	dx,OFFSET tsr_error
			mov	ah,09h
			int	21h
			jmp	$

done:
			ret

RunProgram		ENDP

;   ========================================================================

GetProgramDetails	PROC	NEAR PRIVATE

			push	es
			pop	ds
			mov	si,bx

;   The LF-terminated string now addressed by ds:si begins with the name of
;   this driver.  Advance past the first separator.

@@:
			lodsb
			cmp	al,LF
			jz	fail
			call	IsSeparator
			jnz	@b

;   Advance past further separators.

@@:
			lodsb
			cmp	al,LF
			jz	fail
			call	IsSeparator
			jz	@b

			dec	si

;   After that break should come the name of the program to be executed.
;   Copy all characters to the progname buffer until encountering a
;   separator.

			push	cs
			pop	es
			mov	di,OFFSET progname
			mov	cx,SIZEOF progname

@@:
			lodsb
			cmp	al,LF
			jz	fail
			call	IsSeparator
			jz	@f
			dec	cx
			jz	fail
			stosb
			jmp	@b

@@:
			xor	al,al
			stosb

;   Copy the remaining characters to the cmdline buffer.

			mov	di,OFFSET cmdline + 0001h

@@:
			lodsb
			cmp	al,LF
			jz	@f
			cmp	di,OFFSET cmdline + SIZEOF cmdline - 0001h
			jnb	@f
			stosb
			jmp	@b

@@:
			push	es
			pop	ds
			mov	byte ptr [di],CR
			mov	ax,OFFSET cmdline + 0001h
			xchg	ax,di
			sub	ax,di
			dec	di
			mov	[di],al

			clc
			jmp	done

fail:
			stc
done:
			ret

GetProgramDetails	ENDP

;   ------------------------------------------------------------------------

IsSeparator		PROC	NEAR PRIVATE

  FOR			separator, <NULL, TAB, CR, ' ', ',', '/', ';', '='>
			cmp	al,separator
			jz	@f
  ENDM

@@:
			ret

IsSeparator		ENDP

;   ========================================================================

Exec			PROC	NEAR PRIVATE

			push	ds
			pop	es
			mov	bx,OFFSET execblock
			ASSUME	bx:PTR EXECBLOCK

			mov	[bx].spEnvironment,0000h
			mov	word ptr [bx].lpCommandLine,OFFSET cmdline
			mov	word ptr [bx].lpCommandLine + 02h,cs
			mov	word ptr [bx].lpFCB1,OFFSET fcb
			mov	word ptr [bx].lpFCB1 + 02h,cs
			mov	word ptr [bx].lpFCB2,OFFSET fcb
			mov	word ptr [bx].lpFCB2 + 02h,cs

			mov	dx,OFFSET progname
			mov	ax,4B00h
			int	21h

			ret

Exec			ENDP

;   ========================================================================

SetFCBSFT		PROC	NEAR PRIVATE

			mov	ah,52h
			int	21h

                        ASSUME  bx:PTR SYSVARS
			mov	ax,word ptr es:[bx].lpFCBSFTs
			or	ax,word ptr es:[bx].lpFCBSFTs + 02h
			jnz	done

			mov	word ptr es:[bx].lpFCBSFTs,OFFSET FakeFCBSFT
			mov	word ptr es:[bx].lpFCBSFTs + 02h,ds

done:
			ret

SetFCBSFT		ENDP

;   ------------------------------------------------------------------------

ClearFCBSFT		PROC	NEAR PRIVATE

			mov	ah,52h
			int	21h

			mov	ax,ds
			cmp	word ptr es:[bx].lpFCBSFTs + 02h,ax
			jnz	done

			xor	ax,ax
			mov	word ptr es:[bx].lpFCBSFTs,ax
			mov	word ptr es:[bx].lpFCBSFTs + 02h,ax

done:
			ret

ClearFCBSFT		ENDP

;   ========================================================================

.CONST

syntax_error		db	CR, LF,
				"SPAWN: Requires name of program to run.",
				CR, LF, "$"

mem_error		db	CR, LF,
				"SPAWN: Internal memory error.",
				CR, LF, "$"

exec_error		db	CR, LF,
				"SPAWN: Error running program.",
				CR, LF, "$"

tsr_error		db	CR, LF,
				"SPAWN: Program stayed resident ",
				"in fake region of free memory.",
				CR, LF,
				"Continuation is unsafe. System halted.",
				"$"

;   ========================================================================

.DATA

fcb			db	00h, 0Bh DUP (" ")

FakeFCBSFT		dd	0FFFFFFFFh
			dw	0001h
			SFT	{}

;   ========================================================================

.DATA?

execblock		EXECBLOCK	{}

lpOrgDTA		dd	?

cDefaultDrive		db	?

progname		db	80h DUP (?)

cmdline 		db	80h DUP (?)

;   ************************************************************************

END

