
;   ************************************************************************
;   *				  memhole.asm				   *
;   ************************************************************************

.MODEL			TINY

.NOLIST
  INCLUDE		arena.inc
.LIST

;   ========================================================================

.CODE

MakeHole		PROC	NEAR PUBLIC

;   Requires

;	CX = segment address of hole to make
;	DX = size of hole in paragraphs

;   Returns

;	cf = NC if hole created
;	ds:si = address of arena header for memory block in which hole is made
;	al = original arena header signature
;	dx = orginal size of block
;	es:si = address of arena header for hole
;	cx = size of hole

;   It is assumed that conditions are known to support the creation of free
;   space inside an allocated memory block.

;   Begin by finding the first memory arena header.

			mov	ah,52h
			int	21h
			mov	ax,es:[bx - 02h]
			mov	ds,ax

			xor	si,si
			ASSUME	si:PTR ARENA_HEADER

;   Advance to the arena header for the block containing the designated
;   segment (currently in CX).

			cli
			jmp	getblock

getnextblock:
			cmp	[si].cSignature,ARENA_LAST
			jz	toofar

			mov	ax,ds
			inc	ax
			add	ax,[si].wParagraphs
			mov	ds,ax

getblock:

;   Check that ds is not implausible as the address of an arena header.

			cmp	[si].cSignature,ARENA_LAST
			jz	@f
			cmp	[si].cSignature,ARENA_IN_CHAIN
			jnz	badblock
@@:

;   It's no good if CX is not inside a memory block, but is instead the
;   segment address of an arena header.

			cmp	ax,cx
			jz	badinput

;   Check whether the current block starts below segment CX.  If it doesn't,
;   then we've gone too far (somehow).

			inc	ax
			jz	badblock
			cmp	ax,cx
			jnb	toofar

;   Check whether the current block extends at least to segment CX.  If it
;   doesn't, then try the next memory block.

			add	ax,[si].wParagraphs
			jc	badblock
			cmp	ax,cx
			jb	getnextblock

;   If the current block ends inside the range described by CX and DX, then
;   this is a problem.	We really want the range to lie wholly within a
;   memory block.

			mov	bx,cx
			add	bx,dx
			jc	badinput
			sub	ax,bx
			jnb	gotblock

badblock:
badinput:
toofar:
			stc
			jmp	done

gotblock:

;   Build an arena header at the top of the available space.

			dec	bx
			mov	es,bx
			mov	es:[si].wParagraphs,ax
			mov	al,[si].cSignature
			mov	es:[si].cSignature,al
			mov	bx,[si].spOwner
			mov	es:[si].spOwner,bx

;   Build another at the bottom of the available space.

			mov	es,cx
			mov	es:[si].cSignature,ARENA_IN_CHAIN
			mov	es:[si].spOwner,0000h
			mov	ax,dx
			sub	ax,0002h
			mov	es:[si].wParagraphs,ax

;    Modify the original.

			xchg	ax,cx
			mov	bx,ds
			inc	bx
			sub	ax,bx
			xchg	ax,[si].wParagraphs
			mov	dx,ax
			mov	al,ARENA_IN_CHAIN
			xchg	al,[si].cSignature

			clc

done:
			sti
			ret

MakeHole		ENDP

;   ------------------------------------------------------------------------

RepairHole		PROC	NEAR PUBLIC
			ASSUME	si:PTR ARENA_HEADER

			push	bx
			push	ax
			mov	bx,0FFFFh
			mov	ah,48h
			int	21h
			pop	ax
			pop	bx

			cmp	es:[si].spOwner,0000h
			jnz	@f
			cmp	es:[si].wParagraphs,cx
@@:

			cli
			mov	[si].cSignature,al
			mov	[si].wParagraphs,dx
			sti

			ret

RepairHole		ENDP

;   ************************************************************************

END

