
;   ************************************************************************
;   *				   driver.inc				   *
;   ************************************************************************

;   Device driver header
 
DRIVER_HEADER		STRUCT
  lpNext		dd	0FFFFFFFFh
  wAttribute		dw	0000h
  pStrategy		dw	0000h
  pInterrupt		dw	0000h
  UNION
    cName		db	"        "
    cUnitsSupported	db	?
  ENDS
DRIVER_HEADER		ENDS

;   Attribute values

IS_STDIN		EQU	0001h
IS_STDOUT		EQU	0002h
IS_HUGE_BLOCK		EQU	0002h
IS_NUL			EQU	0004h
IS_CLOCK		EQU	0008h
INT29H_OK		EQU	0010h
GIOCTL_OK		EQU	0040h
GIOCTL_QUERY_OK 	EQU	0080h
OCRM_OK 		EQU	0800h
OTB_OK			EQU	2000h
FAT_REQUIRED		EQU	2000h
IOCTL_OK		EQU	4000h
IS_CHAR_DEVICE		EQU	8000h

;   Device driver commands - these do not follow the upper case convention
;   because they are used to generate the names of the procedures for each
;   driver command.

D_INIT			EQU	00h
D_MEDIA_CHECK		EQU	01h
D_BUILD_BPB		EQU	02h
D_IOCTL_READ		EQU	03h
D_READ			EQU	04h
D_NONDESTRUCTIVE_READ	EQU	05h
D_INPUT_STATUS		EQU	06h
D_INPUT_FLUSH		EQU	07h
D_WRITE 		EQU	08h
D_WRITE_WITH_VERIFY	EQU	09h
D_OUTPUT_STATUS 	EQU	0Ah
D_OUTPUT_FLUSH		EQU	0Bh
D_IOCTL_WRITE		EQU	0Ch
D_OPEN_DEVICE		EQU	0Dh
D_CLOSE_DEVICE		EQU	0Eh
D_REMOVABLE_MEDIA	EQU	0Fh
D_OUTPUT_UNTIL_BUSY	EQU	10h
D_GENERIC_IOCTL 	EQU	13h
D_GET_LOGICAL_DEVICE	EQU	17h
D_SET_LOGICAL_DEVICE	EQU	18h
D_IOCTL_QUERY		EQU	19h

MAX_DRIVER_COMMAND	EQU	19h

;   Driver status values

D_DONE			EQU	0100h
D_BUSY			EQU	0200h
D_ERROR 		EQU	8000h

;   Driver error values

D_WRITE_PROTECTED	EQU	00h
D_BAD_UNIT		EQU	01h
D_NOT_READY		EQU	02h
D_BAD_COMMAND		EQU	03h
D_BAD_CRC		EQU	04h
D_BAD_HEADER		EQU	05h
D_SEEK_FAILURE		EQU	06h
D_BAD_MEDIA		EQU	07h
D_SECTOR_NOT_FOUND	EQU	08h
D_NO_PAPER		EQU	09h
D_WRITE_ERROR		EQU	0Ah
D_READ_ERROR		EQU	0Bh
D_GENERAL_FAILURE	EQU	0Ch
D_BAD_DISK_CHANGE	EQU	0Fh

;   Request Header structure

REQUEST_HEADER			STRUCT
  cHeaderLength 		db	?
  cUnit 			db	?
  cCommand			db	?
  wStatus			dw	?
  cReserved			db	08h DUP (?)
  UNION
    STRUCT
      cUnitsSupported		db	?
      lpEndOfMemory		dd	?
      UNION
	lpCommandLine		dd	?
	lpBPBTable		dd	?
      ENDS
      cDrive			db	?
      wMessageFlag		dw	?
    ENDS
    STRUCT
      cMediaDescriptor		db	?
      UNION
	STRUCT
	  cChangeStatus 	db	?
	  lpVolumeIDForCheck	dd	?
	ENDS
	STRUCT
	  lpFATSector		dd	?
	  lpBPB 		dd	?
	ENDS
	STRUCT
	  lpBuffer		dd	?
	  wCount		dw	?
	  wStart		dw	?
	  lpVolumeIDForIO	dd	?
	  dwHugeStart		dd	?
	ENDS
      ENDS
    ENDS
    cCharWaiting		db	?
    STRUCT
      cCategory 		db	?
      cMinorCode		db	?
      wGIOCTLReserved		dw	?
      lpData			dd	?
    ENDS
  ENDS
REQUEST_HEADER			ENDS

;   ************************************************************************

