#include "copyleft.h"

/*
    GEPASI - a simulator of metabolic pathways and other dynamical systems
    Copyright (C) 1989, 1992, 1993  Pedro Mendes
*/

/*************************************/
/*                                   */
/*         GWSIM - Simulation        */
/*        MS-WINDOWS front end       */
/*                                   */
/*          Simulation window        */
/*                                   */
/*           QuickC/WIN 1.0          */
/*                                   */
/*   (include here compilers that    */
/*   compiled GWSIM successfully)    */
/*                                   */
/*************************************/


/*
  be sure that IOTOP.C is recompiled and that
  iotop.obj from a GWTOP compilation is not
  being used now. To be sure, delete iotop.obj
*/

#include <windows.h>
#include <string.h>
#include <direct.h>
#include "commdlg.h"
#include "toolhelp.h"
#include "basic.h"						/* basic windows function prototypes	*/
#include "defines.h"					/* symbols also used in .DLG files		*/
#include "globals.h"					/* gepasi's own symbols					*/
#include "gwsim.h"						/* macros, function prototypes, etc.	*/
#include "gep2.h"						/* gepasi's variables					*/
#include "strtbl.h"						/* symbols for the string table			*/
#include "iosim.h"
#include "iotop.h"

#define HELP_PARTIALKEY   0x0105

/* Struct pointed to by WM_GETMINMAXINFO lParam
typedef struct tagMINMAXINFO
{
 POINT ptReserved;
 POINT ptMaxSize;
 POINT ptMaxPosition;
 POINT ptMinTrackSize;
 POINT ptMaxTrackSize;
} MINMAXINFO;                                   */

/* global variables	*/
char 			szString[256];			/* variable to load resource strings	*/
char			szHelpFile[] =
				"GEPASI.HLP";			/* help file name						*/
char			szAppName[20];			/* class name for the window			*/
HCURSOR			hHourGlass;				/* handle for the wait cursor			*/
WORD			lbWidth;				/* width of largest string in list box	*/
HANDLE			hInst;                  /* handle to this instance of the appl.	*/
HWND			hWndMain;				/* handle to the main window			*/
HWND			hButton1;				/* handle to push button				*/
HWND			hButton2;				/* handle to push button				*/
HMENU			hMenu;					/* handle to the menu					*/
GLOBALHANDLE	hPrm;					/* handle to memory block with prm		*/
GLOBALHANDLE	hOel;					/* handle to memory block w/ oel		*/
GLOBALHANDLE	hScp;					/* handle to memory block w/ scp		*/
double huge		*prm[MAX_STEP];			/* mirror of params						*/
struct	ou huge *oel;					/* mirror of outpel						*/
struct	sp huge *scp;					/* mirror of spar						*/
double			x[MAX_MET];				/* initial concentrations 				*/
int 			notsaved;				/* 1 if file has not been saved			*/
int				eqefl;					/* for compatibility with IOTOP.C		*/
int				lno;					/* number of link to edit				*/
int 			nlks;					/* mirror of nlinks						*/
char			GepasiIni[256];			/* GEPASI's INI file with full path		*/
char			GnuplotExe[256];		/* name of gnuplot.exe with full path	*/
char			CommandLine[1024];
char			FileName[256];			/* filename of sim file with full path	*/
char			FileTitle[13];			/* filename of sim file  w/o full path	*/
char			TopFile[256];			/* filename of top file with full path	*/
char			TopTitle[13];			/* filename of top file w/o full path	*/
char			DatName[256];			/* filename of dat file with full path	*/
char			DatTitle[13];			/* filename of dat file w/o full path	*/
char			LogFile[256];			/* filename of log file with full path	*/
FARPROC			fpCheckSimEng;			/* MakeProcInstance of callback			*/
char			TempFile[256];			/* filename of temporary file			*/
int				TimerId;				/* identifies the timer					*/
int				running;				/* set when simulation engine is active	*/

#pragma alloc_text( CODE0, WinMain, clear_all, WndProc, RegisterClasses, DeleteTmp, CleanUp )


int PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInstance, LPSTR lpszCmdLine, int nCmdShow)
{
 /***********************************************************************/
 /* HANDLE hInstance;       handle for this instance                    */
 /* HANDLE hPrevInstance;   handle for possible previous instances      */
 /* LPSTR  lpszCmdLine;     long pointer to exec command line           */
 /* int    nCmdShow;        Show code for main window display           */
 /***********************************************************************/

 MSG        msg;           /* MSG structure to store your messages        */
 int        nRc;           /* return value from Register Classes          */
 char       *ptr;
 LPSTR		lp;
 OFSTRUCT	OfStruct;
 HANDLE		hAcc;

 strcpy(szAppName, "GWSIM");
 hInst = hInstance;
 if(!hPrevInstance)
   {
    /* register window classes if first instance of application         */
    if ((nRc = RegisterClasses()) == -1)
      {
       /* registering one of the windows failed                         */
       LoadString(hInst, IDS_ERR_REGISTER_CLASS, szString, sizeof(szString));
       MessageBeep( MB_ICONHAND );
       MessageBox(NULL, szString, NULL, MB_ICONEXCLAMATION);
       return nRc;
      }
   }

 /* setup the device independent screen units	*/
 InitScrScale();

 /* load the wait cursor												*/
 hHourGlass = LoadCursor(NULL, IDC_WAIT);

 /* load the accelerators table	*/
 hAcc = LoadAccelerators( hInst, (LPSTR) "ACCTABLE" );

 if( InitGepasiVar() != 0 )					/* initialize GEPASI's vars */
 {
  LoadString(hInst, IDS_ERR_OUT_OF_MEM, szString, sizeof(szString));
  MessageBeep( MB_ICONHAND );
  MessageBox(NULL, szString, NULL, MB_ICONSTOP);
  if(!hPrevInstance) UnregisterClass(szAppName, hInst);
  return IDS_ERR_OUT_OF_MEM;
 }

 /* get the path of GEPASI's binary files directory	*/
 GetModuleFileName( hInst, (LPSTR) GepasiIni, sizeof( GepasiIni ) );
 ptr = strrchr( GepasiIni, '\\' );
 *(ptr+1) = '\0';
 /* append the filename of the INI file	*/
 lstrcat( (LPSTR) GepasiIni, (LPSTR) "GEPASI.INI" );

 /* create application's Main window                                    */
 hWndMain = CreateWindow(
                szAppName,               /* Window class name           */
                "GEPASI - Simulation",   /* Window's title              */
                WS_CAPTION      |        /* Title and Min/Max           */
                WS_SYSMENU      |        /* Add system menu box         */
                WS_MINIMIZEBOX  |        /* Add minimize box            */
                WS_CLIPCHILDREN |        /* don't draw in child windows areas */
                WS_OVERLAPPED,
                CW_USEDEFAULT, 0,        /* Use default X, Y            */
				ScrX(180), ScrY(90),
                NULL,                    /* Parent window's handle      */
                NULL,                    /* Default to Class Menu       */
                hInst,                   /* Instance of window          */
                NULL);                   /* Create struct for WM_CREATE */

 if(hWndMain == NULL)
 {
  LoadString(hInst, IDS_ERR_CREATE_WINDOW, szString, sizeof(szString));
  MessageBeep( MB_ICONEXCLAMATION );
  MessageBox(NULL, szString, NULL, MB_ICONEXCLAMATION);
  TidyGepasiVar();
  return IDS_ERR_CREATE_WINDOW;
 }

 InitTxtMetrics( hWndMain );

 /* create the button controls */
 hButton1 = CreateWindow( "Button", "&Top",
                          WS_CHILD | WS_VISIBLE | WS_TABSTOP,
                          ScrX(114), ScrY(40),
                          ScrX(30),  ScrY(24),
                          hWndMain,  IDC_BUTTON1, hInst, NULL );
 if(hButton1 == NULL)
 {
  LoadString(hInst, IDS_ERR_CREATE_WINDOW, szString, sizeof(szString));
  MessageBeep( MB_ICONHAND );
  MessageBox(NULL, szString, NULL, MB_ICONSTOP);
  CleanUp( hWndMain, hPrevInstance );
  return IDS_ERR_CREATE_WINDOW;
 }
 hButton2 = CreateWindow( "Button", "&Run!",
                          WS_CHILD | WS_VISIBLE | WS_TABSTOP,
                          ScrX(145), ScrY(40),
                          ScrX(30),  ScrY(24),
                          hWndMain,  IDC_BUTTON2, hInst, NULL );
 if(hButton2 == NULL)
 {
  LoadString(hInst, IDS_ERR_CREATE_WINDOW, szString, sizeof(szString));
  MessageBeep( MB_ICONHAND );
  MessageBox(NULL, szString, NULL, MB_ICONSTOP);
  CleanUp( hWndMain, hPrevInstance );
  return IDS_ERR_CREATE_WINDOW;
 }

 /* store the pointer to the timer callback function				*/
 fpCheckSimEng = MakeProcInstance(CheckSimEng, hInst);

 /* get options from GEPASI.INI file								*/
 /* get the complete filename path of wgnuplot.exe					*/
 GetPrivateProfileString( (LPSTR) "Gnuplot",
                          (LPSTR) "Path",
                          (LPSTR) "\0",
                          (LPSTR) GnuplotExe,
                          sizeof( GnuplotExe ),
                          (LPSTR) GepasiIni
                        );
 /* test if the file really exists */
 nRc = OpenFile( (LPSTR) GnuplotExe, &OfStruct, OF_READ );
 if( nRc==-1 ) *GnuplotExe = '\0';
 else _lclose( nRc );

 ShowWindow(hWndMain, nCmdShow);        /* display main window      */

 /* if called with a .sim filename argument, store it in FileName	*/
 FileName[0] = '\0';
 if( *lpszCmdLine)
 {
  lp = _fstrchr( lpszCmdLine, ' ' );
  if( lp != NULL ) *lp = '\0';
  lstrcat( (LPSTR) FileName, lpszCmdLine );
  SendMessage( hWndMain, WM_USER+1, 0, (DWORD) 0 );
 }

 while(GetMessage(&msg, NULL, 0, 0))    /* Until WM_QUIT message    */
 {
  if( !TranslateAccelerator( hWndMain, hAcc, &msg ) )
  {
   TranslateMessage(&msg);
   DispatchMessage(&msg);
  }
 }

 /* clean up before exiting from the application					*/
 CleanUp(hWndMain, hPrevInstance);

 return msg.wParam;
} /*  End of WinMain                                                */

void clear_all( HWND hWnd )
{
 int i;

 totmet = nsteps = nscanpar = totsel =
 totscan = nloops = noutpel = nlinks =
 nudf = 0;
 nrateq = MAX_TYP;
 notsaved = 0;
 FileName[0] = FileTitle[0] = '\0';
 for( i=0; i<MAX_MET; i++ ) xu[i] = 0;
 get_dfts();
 SendMessage( hWnd, WM_CREATE, 0, 0 );
}


LONG FAR PASCAL WndProc(HWND hWnd, WORD Message, WORD wParam, LONG lParam)
{
 HDC        hDC;	            /* handle for the display device		*/
 MINMAXINFO FAR* lpmmi;			/* pointer to minmaxinfo structure		*/
 PAINTSTRUCT	ps;             /* holds PAINT information				*/
 FARPROC		lpfnProc;		/* pointer to dialog procedures			*/
 int			nRc=0;          /* return code							*/
 char			szASTR[128];
 char			tmpFile[256];
 int			i, j, dim;
 unsigned long	perm;
 char			*ptr;

 switch (Message)
 {
  case WM_CREATE:
   hMenu = GetMenu( hWnd );
   EnableMenuItem( hMenu, IDM_F_SAVE, MF_GRAYED );
   EnableMenuItem( hMenu, IDM_F_SAVEAS, MF_GRAYED );
   EnableMenuItem( hMenu, IDM_E_METABOLITES, MF_GRAYED );
   EnableMenuItem( hMenu, IDM_E_KINETICS, MF_GRAYED );
   EnableMenuItem( hMenu, IDM_O_TASKS, MF_GRAYED );
   EnableMenuItem( hMenu, IDM_O_UNITS, MF_GRAYED );
   EnableMenuItem( hMenu, IDM_O_OUTPUT, MF_GRAYED );
   EnableMenuItem( hMenu, IDM_O_REPORT, MF_GRAYED );
   EnableMenuItem( hMenu, IDM_GO, MF_GRAYED );
   EnableMenuItem( hMenu, IDM_PLOT, MF_GRAYED );
   EnableWindow( hButton2, FALSE );
   SendMessage( hWnd, WM_COMMAND, IDM_S_NONE, 0 );
   DrawMenuBar( hWnd );
   break;       /*  End of WM_CREATE									*/

  case WM_CLOSE:  /* close the window                                 */
   if( notsaved )
    AskAboutSave( hWnd, hInst, FileName, MB_ICONQUESTION | MB_YESNO );
   /* tell WinHelp we're closing								*/
   WinHelp( hWnd, (LPSTR) szHelpFile, HELP_QUIT, 0 );
   /* kill the timer (it will fail if one is not active)		*/
   KillTimer( hWnd, TimerId );
   DestroyWindow(hWnd);
   if (hWnd == hWndMain)
    PostQuitMessage(0);  /* Quit the application                */
   break;

  case WM_QUERYENDSESSION:
   /* windows is about to shut-down...							*/
   if( notsaved )
   {
    nRc = AskAboutSave( hWnd, hInst, FileName, MB_ICONQUESTION | MB_YESNOCANCEL );
    if ( nRc != IDCANCEL ) return 1;
    else return 0;
   }
   return 1;

  case WM_COMPACTING:
   /* windows is taking a lot of time compacting memory: FULL!	*/
   LoadString(hInst, IDS_ERR_OUT_OF_MEM, szString, sizeof(szString));
   MessageBeep( MB_ICONEXCLAMATION );
   MessageBox(NULL, szString, NULL, MB_ICONEXCLAMATION);
   return 1;

  case WM_PAINT:
   /* Obtain a handle to the device context                       */
   memset( &ps, 0x00, sizeof( PAINTSTRUCT ) );
   /* BeginPaint will sends WM_ERASEBKGND if appropriate          */
   hDC = BeginPaint(hWnd, &ps);
   /* Included in case the background is not a pure color         */
   SetBkMode( hDC, TRANSPARENT );
   i=0;
   if( FileName[0] != '\0' )
    wsprintf( szASTR, "%s", (LPSTR) FileName );
   else
    wsprintf( szASTR, "<untitled>");
   TextOut( hDC, TxtX(0), TxtY(i++), szASTR, strlen( szASTR ) );
   wsprintf( szASTR, "%i metabolites", totmet );
   TextOut( hDC, TxtX(0), TxtY(i++), szASTR, strlen( szASTR ) );
   wsprintf( szASTR, "%i steps", nsteps );
   TextOut( hDC, TxtX(0), TxtY(i++), szASTR, strlen( szASTR ) );
   if( options.scan )
   {
    /* count the number of dimensions and permutations */
    for( j=dim=0, perm=1; j<nscanpar; j++ )
     if( spar[j].idx!=0 )
     {
      dim++;
      perm *= spar[j].dens+1;
     }
    if( options.scan == 1 )
     wsprintf( szASTR, "%dD regular grid", dim );
    else
    {
     wsprintf( szASTR, "%dD random fill", dim );
     perm = options.scandens;
    }
    TextOut( hDC, TxtX(0), TxtY(i++), szASTR, strlen( szASTR ) );
    wsprintf( szASTR, "%lu iterations", perm );
    TextOut( hDC, TxtX(0), TxtY(i++), szASTR, strlen( szASTR ) );
    wsprintf( szASTR, "%i links", nlinks );
    TextOut( hDC, TxtX(0), TxtY(i++), szASTR, strlen( szASTR ) );
   }
   EndPaint( hWnd, &ps );
   break;       /*  End of WM_PAINT                               */

  case WM_USER+1:
   if( !(nRc = ReadSim( FileName ) ) )
   {
    /* kill the timer (it will fail if one is not active)		*/
    KillTimer( hWnd, TimerId );
    GetFileTitle( (LPSTR) FileName, (LPSTR) FileTitle, sizeof(FileTitle) );
    GetFileTitle( (LPSTR) DatName, (LPSTR) DatTitle, sizeof(DatTitle) );
    EnableMenuItem( hMenu, IDM_F_SAVE , MF_ENABLED );
    EnableMenuItem( hMenu, IDM_F_SAVEAS , MF_ENABLED );
    EnableMenuItem( hMenu, IDM_E_METABOLITES , MF_ENABLED );
    EnableMenuItem( hMenu, IDM_E_KINETICS , MF_ENABLED );
    EnableMenuItem( hMenu, IDM_E_OPTIONS , MF_ENABLED );
    EnableMenuItem( hMenu, IDM_O_TASKS, MF_ENABLED );
    EnableMenuItem( hMenu, IDM_O_UNITS, MF_ENABLED );
    EnableMenuItem( hMenu, IDM_GO, MF_ENABLED );
    EnableMenuItem( hMenu, IDM_PLOT, MF_ENABLED );
    EnableWindow( hButton2, TRUE );
    if( options.dat ) EnableMenuItem( hMenu, IDM_O_OUTPUT, MF_ENABLED );
    if( options.txt ) EnableMenuItem( hMenu, IDM_O_REPORT, MF_ENABLED );
    if( !(options.dyn || options.ss) )
    {
     EnableMenuItem( hMenu, IDM_O_OUTPUT, MF_GRAYED );
     EnableMenuItem( hMenu, IDM_O_REPORT, MF_GRAYED );
     EnableMenuItem( hMenu, IDM_GO, MF_GRAYED );
     EnableWindow( hButton2, FALSE );
    }
    switch( options.scan )
    {
     case 0: SendMessage( hWnd, WM_COMMAND, IDM_S_NONE, 0 ); break;
     case 1: SendMessage( hWnd, WM_COMMAND, IDM_S_GRID, 0 ); break;
     case 2: SendMessage( hWnd, WM_COMMAND, IDM_S_FILL, 0 ); break;
    }
    wsprintf( (LPSTR) szASTR, "GEPASI - %s", (LPSTR) FileTitle );
    SendMessage( hWnd, WM_SETTEXT, 0, (DWORD) (LPSTR) szASTR );
    InvalidateRect( hWnd, NULL, TRUE );
    DrawMenuBar( hWnd );
    notsaved = 0;
   }
   else
   {
    LoadString(hInst, nRc, szString, sizeof(szString));
    wsprintf( (LPSTR) szASTR, "GEPASI - Simulation" );
    SendMessage( hWnd, WM_SETTEXT, 0, (DWORD) (LPSTR) szASTR );
    MessageBeep( MB_ICONEXCLAMATION );
    MessageBox(NULL, szString, NULL, MB_ICONEXCLAMATION);
    InvalidateRect( hWnd, NULL, TRUE );
    clear_all( hWnd );
    /* SEND MESSAGE TO CLEAR_ALL!!!!!*/
   }
   break;

  case WM_USER+2:
   SimEnd();
   break;

  case WM_COMMAND:
   switch (wParam)
   {
    case IDA_F1HELP:
    case IDM_H_CONTENTS:
   	 WinHelp( hWnd, (LPSTR) szHelpFile, HELP_INDEX, 0 );
   	 break;

    case IDM_H_SEARCH:
   	 WinHelp( hWnd, (LPSTR) szHelpFile, HELP_PARTIALKEY, (DWORD) (LPSTR) "" );
   	 break;

    case IDM_H_HELPONHELP:
   	 WinHelp( hWnd, (LPSTR) szHelpFile, HELP_HELPONHELP, 0 );
   	 break;

    case IDM_H_ABOUT:
     lpfnProc = MakeProcInstance((FARPROC)AboutBox, hInst);
     DialogBox(hInst, (LPSTR)"ABOUTBOX", hWnd, lpfnProc);
     FreeProcInstance(lpfnProc);
     break;

    case IDC_BUTTON1:
     GetModuleFileName( hInst, (LPSTR) szASTR, sizeof( szASTR ) );
     ptr = strrchr( szASTR, '\\' );
     *(ptr+1) = '\0';
     strcat( szASTR, "GWTOP.EXE" );
   	 nRc = WinExec( (LPSTR) szASTR, SW_SHOWNORMAL );
   	 ErrorHandler( hInst, nRc );
     break;

    case IDM_F_OPEN:
     if( notsaved )
      AskAboutSave( hWnd, hInst, FileName, MB_ICONQUESTION | MB_YESNO );
     if( GetOFileName( hWnd,
       				  (LPSTR) FileName, 256,
      				  (LPSTR) "Load Simulation File",
       				  (LPSTR) "simulation (*.SIM)\0*.SIM\0" ) )
	  SendMessage( hWnd, WM_USER+1, 0, (DWORD) 0 );
     break;

    case IDM_F_CLOSE:
     SendMessage( hWnd, WM_CLOSE, 0, 0 );
     break;

    case IDM_F_SAVE:
     WriteSim( FileName );
     notsaved = 0;
     break;

    case IDM_F_SAVEAS:
     _fstrcpy( (LPSTR) tmpFile, (LPSTR) FileName );
     if( GetSFileName( hWnd,
       				  (LPSTR) tmpFile, sizeof( tmpFile ),
      				  (LPSTR) "Save Simulation File",
       				  (LPSTR) "simulation (*.SIM)\0*.SIM\0" ) )
     {
      _fstrcpy( (LPSTR) FileName, (LPSTR) tmpFile );
      if( !(nRc = WriteSim( FileName ) ) )
      {
       GetFileTitle( (LPSTR) FileName, (LPSTR) FileTitle, sizeof(FileTitle) );
       EnableMenuItem( hMenu, IDM_GO, MF_ENABLED );
       EnableWindow( hButton2, TRUE );
       EnableMenuItem( hMenu, IDM_F_SAVE , MF_ENABLED );
       DrawMenuBar( hWnd );
       wsprintf( (LPSTR) szASTR, "GEPASI - %s", (LPSTR) FileTitle );
       SendMessage( hWnd, WM_SETTEXT, 0, (DWORD) (LPSTR) szASTR );
       notsaved = 0;
       InvalidateRect( hWnd, NULL, TRUE );
      }
     }
     break;

    case IDM_F_NEW:
     if( notsaved )
      nRc = AskAboutSave( hWnd, hInst, FileName, MB_ICONQUESTION | MB_YESNOCANCEL );
     if( nRc == IDCANCEL ) return TRUE;
     if( GetOFileName( hWnd,
       				  (LPSTR) TopFile, sizeof( TopFile ),
      				  (LPSTR) "Load Topology File",
       				  (LPSTR) "topology (*.TOP)\0*.TOP\0" ) )
     {
      clear_all( hWnd );
      FileName[0] = '\0';
      FileTitle[0] = '\0';
      DatName[0] = '\0';
      DatTitle[0] = '\0';
      if( nRc = TopIn( TopFile ) )
      {
       /* kill the timer (it will fail if one is not active)		*/
       KillTimer( hWnd, TimerId );
       clear_all( hWnd );
       LoadString(hInst, nRc, szString, sizeof(szString));
       MessageBeep( MB_ICONEXCLAMATION );
       MessageBox(NULL, szString, NULL, MB_ICONEXCLAMATION);
       InvalidateRect( hWnd, NULL, TRUE );
       break;
      }
      else
      {
       notsaved = 0;
       /* get the filename without the path						*/
       GetFileTitle( (LPSTR) TopFile, (LPSTR) TopTitle, sizeof(FileTitle) );
       /* setup the filename for the dat file			*/
       _getcwd( DatName, sizeof(DatName) );
       lstrcat( (LPSTR) DatName, (LPSTR) "\\RESULTS.DAT" );
       GetFileTitle( (LPSTR) DatName, (LPSTR) DatTitle, sizeof(DatTitle) );
       EnableMenuItem( hMenu, IDM_F_SAVE , MF_GRAYED );
       EnableMenuItem( hMenu, IDM_F_SAVEAS , MF_ENABLED );
       EnableMenuItem( hMenu, IDM_E_METABOLITES , MF_ENABLED );
       EnableMenuItem( hMenu, IDM_E_KINETICS , MF_ENABLED );
       EnableMenuItem( hMenu, IDM_O_TASKS, MF_ENABLED );
       EnableMenuItem( hMenu, IDM_O_UNITS, MF_ENABLED );
       EnableMenuItem( hMenu, IDM_GO, MF_ENABLED );
       EnableMenuItem( hMenu, IDM_PLOT, MF_ENABLED );
       EnableWindow( hButton2, TRUE );
       wsprintf( (LPSTR) szASTR, "GEPASI - Simulation" );
       SendMessage( hWnd, WM_SETTEXT, 0, (DWORD) (LPSTR) szASTR );
       if( options.dat ) EnableMenuItem( hMenu, IDM_O_OUTPUT, MF_ENABLED );
       if( options.txt ) EnableMenuItem( hMenu, IDM_O_REPORT, MF_ENABLED );
       switch( options.scan )
       {
        case 0: SendMessage( hWnd, WM_COMMAND, IDM_S_NONE, 0 ); break;
        case 1: SendMessage( hWnd, WM_COMMAND, IDM_S_GRID, 0 ); break;
        case 2: SendMessage( hWnd, WM_COMMAND, IDM_S_FILL, 0 ); break;
       }
       DrawMenuBar( hWnd );
       InvalidateRect( hWnd, NULL, TRUE );
       break;
      }
     }
     break;

    case IDM_E_METABOLITES:
     lpfnProc = MakeProcInstance((FARPROC)EdConc, hInst);
     DialogBox(hInst, (LPSTR)"ED_CONC", hWnd, lpfnProc);
     FreeProcInstance(lpfnProc);
     InvalidateRect( hWnd, NULL, TRUE );
     break;

    case IDM_E_KINETICS:
     lpfnProc = MakeProcInstance((FARPROC) EdKConst, hInst);
     DialogBox(hInst, (LPSTR)"ED_CONST", hWnd, lpfnProc);
     FreeProcInstance(lpfnProc);
     InvalidateRect( hWnd, NULL, TRUE );
     break;

    case IDM_E_CLEAR:
     conc_dft();
     InvalidateRect( hWnd, NULL, TRUE );
     break;

    case IDM_O_TASKS:
     lpfnProc = MakeProcInstance((FARPROC) EdOTask, hInst);
     DialogBox(hInst, (LPSTR)"TASK_OPT", hWnd, lpfnProc);
     FreeProcInstance(lpfnProc);
     if( options.dat ) EnableMenuItem( hMenu, IDM_O_OUTPUT, MF_ENABLED );
     else EnableMenuItem( hMenu, IDM_O_OUTPUT, MF_GRAYED );
     if( options.txt ) EnableMenuItem( hMenu, IDM_O_REPORT, MF_ENABLED );
     else EnableMenuItem( hMenu, IDM_O_REPORT, MF_GRAYED );
     if( !(options.dyn || options.ss) )
     {
      EnableMenuItem( hMenu, IDM_O_OUTPUT, MF_GRAYED );
      EnableMenuItem( hMenu, IDM_O_REPORT, MF_GRAYED );
      EnableMenuItem( hMenu, IDM_GO, MF_GRAYED );
      EnableWindow( hButton2, FALSE );
     }
     DrawMenuBar( hWnd );
     InvalidateRect( hWnd, NULL, TRUE );
     break;

    case IDM_O_UNITS:
     lpfnProc = MakeProcInstance((FARPROC) EdOUnits, hInst);
     DialogBox(hInst, (LPSTR)"ED_UNITS", hWnd, lpfnProc);
     FreeProcInstance(lpfnProc);
     InvalidateRect( hWnd, NULL, TRUE );
     break;

    case IDM_O_REPORT:
     lpfnProc = MakeProcInstance((FARPROC) EdReport, hInst);
     DialogBox(hInst, (LPSTR)"REP_OPT", hWnd, lpfnProc);
     FreeProcInstance(lpfnProc);
     InvalidateRect( hWnd, NULL, TRUE );
     break;

    case IDM_O_OUTPUT:
     lpfnProc = MakeProcInstance((FARPROC) EdDat, hInst);
     nRc = DialogBox(hInst, (LPSTR)"DAT_OPT", hWnd, lpfnProc);
     FreeProcInstance(lpfnProc);
     if( nRc == IDOK )
      /* kill the timer (it will fail if one is not active)		*/
      KillTimer( hWnd, TimerId );
     InvalidateRect( hWnd, NULL, TRUE );
     break;

    case IDM_O_METHODS:
     lpfnProc = MakeProcInstance((FARPROC) EdNumer, hInst);
     DialogBox(hInst, (LPSTR)"NUM_OPT", hWnd, lpfnProc);
     FreeProcInstance(lpfnProc);
     InvalidateRect( hWnd, NULL, TRUE );
     break;

    case IDM_S_LINKS:
     lpfnProc = MakeProcInstance((FARPROC) Links, hInst);
     DialogBox(hInst, (LPSTR)"LINKS", hWnd, lpfnProc);
     FreeProcInstance(lpfnProc);
     InvalidateRect( hWnd, NULL, TRUE );
     break;

    case IDM_S_PARAM:
     lpfnProc = MakeProcInstance((FARPROC) EdScanP, hInst);
     DialogBox(hInst, (LPSTR)"ED_SCANP", hWnd, lpfnProc);
     FreeProcInstance(lpfnProc);
     InvalidateRect( hWnd, NULL, TRUE );
     break;

    case IDM_S_BOUND:
     lpfnProc = MakeProcInstance((FARPROC) EdScanB, hInst);
     DialogBox(hInst, (LPSTR)"ED_SCANB", hWnd, lpfnProc);
     FreeProcInstance(lpfnProc);
     InvalidateRect( hWnd, NULL, TRUE );
     break;

    case IDM_S_NONE:
     CheckMenuItem( hMenu, IDM_S_NONE, MF_CHECKED );
     CheckMenuItem( hMenu, IDM_S_GRID, MF_UNCHECKED );
     CheckMenuItem( hMenu, IDM_S_FILL, MF_UNCHECKED );
     EnableMenuItem( hMenu, IDM_S_PARAM, MF_GRAYED );
     EnableMenuItem( hMenu, IDM_S_BOUND, MF_GRAYED );
     EnableMenuItem( hMenu, IDM_S_LINKS, MF_GRAYED );
     DrawMenuBar( hWnd );
     options.scan = 0;
     notsaved = 0;
     InvalidateRect( hWnd, NULL, TRUE );
     break;

    case IDM_S_GRID:
     CheckMenuItem( hMenu, IDM_S_NONE, MF_UNCHECKED );
     CheckMenuItem( hMenu, IDM_S_GRID, MF_CHECKED );
     CheckMenuItem( hMenu, IDM_S_FILL, MF_UNCHECKED );
     EnableMenuItem( hMenu, IDM_S_PARAM, MF_ENABLED );
     EnableMenuItem( hMenu, IDM_S_BOUND, MF_ENABLED );
     EnableMenuItem( hMenu, IDM_S_LINKS, MF_ENABLED );
     DrawMenuBar( hWnd );
     options.scan = 1;
     notsaved = 0;
     InvalidateRect( hWnd, NULL, TRUE );
     break;

    case IDM_S_FILL:
     CheckMenuItem( hMenu, IDM_S_NONE, MF_UNCHECKED );
     CheckMenuItem( hMenu, IDM_S_GRID, MF_UNCHECKED );
     CheckMenuItem( hMenu, IDM_S_FILL, MF_CHECKED );
     EnableMenuItem( hMenu, IDM_S_PARAM, MF_ENABLED );
     EnableMenuItem( hMenu, IDM_S_BOUND, MF_ENABLED );
     EnableMenuItem( hMenu, IDM_S_LINKS, MF_ENABLED );
     DrawMenuBar( hWnd );
     options.scan = 2;
     notsaved = 0;
     InvalidateRect( hWnd, NULL, TRUE );
     break;

    case IDM_PLOT:
     if(*GnuplotExe)
     {
      lpfnProc = MakeProcInstance((FARPROC) Plot, hInst);
      nRc = DialogBox(hInst, (LPSTR)"ED_PLOT", hWnd, lpfnProc);
      FreeProcInstance(lpfnProc);
      if( nRc==IDOK ) GnuPlot( hWnd );
/*      else
       if( nRc!=IDCANCEL )
       {
        LoadString(hInst, IDS_ERR_NO_GNUPLOT, szString, sizeof(szString));
        MessageBeep( MB_ICONEXCLAMATION );
        MessageBox( hWnd, szString, (LPSTR) "Error", MB_ICONEXCLAMATION );
       }*/
     }
     else
     {
      LoadString(hInst, IDS_INF_GNUPLOT, szString, sizeof(szString));
      MessageBeep( MB_ICONQUESTION );
      nRc = MessageBox( hWnd, szString, (LPSTR) "Link GNUPLOT with GEPASI", MB_ICONINFORMATION | MB_OKCANCEL );
      if( nRc==IDOK )
      if( GetOFileName( hWnd,
       				    (LPSTR) GnuplotExe, sizeof( GnuplotExe ),
      				    (LPSTR) "Gnuplot Path",
       				    (LPSTR) "executable (*.exe)\0*.exe\0"
       				  )
        )
       WritePrivateProfileString( (LPSTR) "Gnuplot",
                                  (LPSTR) "Path",
                                  (LPSTR) GnuplotExe,
                                  (LPSTR) GepasiIni
                                );
     }
     break;

    case IDC_BUTTON2:
    case IDM_GO:
     if( notsaved )
      SendMessage( hWnd, WM_COMMAND, FileName[0] ? IDM_F_SAVE : IDM_F_SAVEAS, 0 );
     Execute( hWnd, hInst );
     break;

    default:
     return DefWindowProc(hWnd, Message, wParam, lParam);
   }
   break;        /* End of WM_COMMAND                             */

  default:
   return DefWindowProc(hWnd, Message, wParam, lParam);
 }
 return 0L;
}     /* End of WndProc                                         */


/*
  ABOUTMsgProc - About dialog box procedure
*/

BOOL FAR PASCAL AboutBox(HWND hWndDlg, WORD Message, WORD wParam, LONG lParam)
{
 switch(Message)
 {
  case WM_INITDIALOG:
   SendDlgItemMessage( hWndDlg, IDSTAT_2, WM_SETTEXT, 0, (DWORD) (LPSTR) VERSION );
   break;

  case WM_CLOSE:
   /* Closing the Dialog behaves the same as Cancel               */
   PostMessage(hWndDlg, WM_COMMAND, IDCANCEL, 0L);
   break;

  case WM_COMMAND:
   if( wParam == IDOK || wParam == IDCANCEL )
   EndDialog(hWndDlg, FALSE);
   break;

  default:
   return FALSE;
 }
 return TRUE;
}


/************************************************************************/
/*                                                                      */
/* RegisterClasses Function                                          */
/*                                                                      */
/* The following function registers all the classes of all the windows  */
/* associated with this application. The function returns an error code */
/* if unsuccessful, otherwise it returns 0.                             */
/*                                                                      */
/************************************************************************/

int RegisterClasses(void)
{
 WNDCLASS   wndclass;    /* struct to define a window class             */

 memset(&wndclass, 0x00, sizeof(WNDCLASS));
 /* load WNDCLASS with window's characteristics                         */
 wndclass.style = CS_HREDRAW | CS_VREDRAW | CS_BYTEALIGNWINDOW;
 wndclass.lpfnWndProc = WndProc;
 /* Extra storage for Class and Window objects                          */
 wndclass.cbClsExtra = 0;
 wndclass.cbWndExtra = 0;
 wndclass.hInstance = hInst;
 wndclass.hIcon = LoadIcon(hInst,"GWSIM");
 wndclass.hCursor = LoadCursor(NULL, IDC_ARROW);
 /* Create brush for erasing background                                 */
 wndclass.hbrBackground = (HBRUSH) (COLOR_WINDOW+1);
 wndclass.lpszMenuName = szAppName;   /* Menu Name is App Name			*/
 wndclass.lpszClassName = szAppName;  /* Class Name is App Name			*/
 if(!RegisterClass(&wndclass))
   return -1;
 return(0);
} /* End of RegisterClasses                      	                    */

void DeleteTmp( void )
{
 OFSTRUCT OfStruct;
 LPSTR p1, p2;

 p1 = TmpFiles;
 for(;;)
 {
  p2 = _fstrchr( p1, '+' );
  if( p2==NULL ) return;
  *p2 = '\0';
  OpenFile( p1, &OfStruct, OF_DELETE );
  p1 = p2+1;
 }
}

void CleanUp( HWND hWnd, HANDLE hPrevInstance )
{
 if(!hPrevInstance) UnregisterClass(szAppName, hInst);
 DeleteTmp();
 TidyGepasiVar();
}